/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.oauth.mockserver.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.PayloadTransformer;
import io.confluent.security.auth.oauth.mockserver.common.LogUtil;
import io.confluent.security.auth.oauth.mockserver.common.NimbusPayloadTransformer;
import io.confluent.security.auth.oauth.mockserver.common.PrincipalExtractor;
import io.confluent.security.auth.oauth.mockserver.common.TokenInfo;
import io.confluent.security.auth.oauth.mockserver.common.ValidationException;

public class TokenIntrospection {
    private static final NimbusPayloadTransformer TRANSFORMER = new NimbusPayloadTransformer();

    public static TokenInfo introspectAccessToken(String token, PrincipalExtractor principalExtractor) {
        JWSObject jws;
        try {
            jws = JWSObject.parse((String)token);
        }
        catch (Exception e) {
            throw new ValidationException("Failed to parse JWT token: " + LogUtil.mask(token));
        }
        try {
            String principal;
            JsonNode parsed = (JsonNode)jws.getPayload().toType((PayloadTransformer)TRANSFORMER);
            if (principalExtractor == null) {
                principalExtractor = new PrincipalExtractor();
            }
            if ((principal = principalExtractor.getPrincipal(parsed)) == null) {
                principal = principalExtractor.getSub(parsed);
            }
            return new TokenInfo(parsed, token, principal);
        }
        catch (Exception e) {
            throw new ValidationException("Failed to read payload from JWT access token", e);
        }
    }
}

