/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.interpreter;

import com.google.api.expr.v1alpha1.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.agrona.collections.IntHashSet;
import org.projectnessie.cel.common.ULong;
import org.projectnessie.cel.common.containers.Container;
import org.projectnessie.cel.common.types.UnknownT;
import org.projectnessie.cel.common.types.ref.TypeAdapter;
import org.projectnessie.cel.common.types.ref.TypeProvider;
import org.projectnessie.cel.interpreter.Activation;
import org.projectnessie.cel.interpreter.AttributeFactory;
import org.projectnessie.cel.interpreter.Interpretable;

public final class AttributePattern {
    private final String variable;
    private final List<AttributeQualifierPattern> qualifierPatterns;

    AttributePattern(String variable, List<AttributeQualifierPattern> qualifierPatterns) {
        this.variable = variable;
        this.qualifierPatterns = qualifierPatterns;
    }

    public static AttributePattern newAttributePattern(String variable) {
        return new AttributePattern(variable, new ArrayList<AttributeQualifierPattern>());
    }

    public AttributePattern qualString(String pattern) {
        this.qualifierPatterns.add(AttributeQualifierPattern.forValue(pattern));
        return this;
    }

    public AttributePattern qualInt(long pattern) {
        this.qualifierPatterns.add(AttributeQualifierPattern.forValue(pattern));
        return this;
    }

    public AttributePattern qualUint(long pattern) {
        this.qualifierPatterns.add(AttributeQualifierPattern.forValue(ULong.valueOf(pattern)));
        return this;
    }

    public AttributePattern qualBool(boolean pattern) {
        this.qualifierPatterns.add(AttributeQualifierPattern.forValue(pattern));
        return this;
    }

    public AttributePattern wildcard() {
        this.qualifierPatterns.add(AttributeQualifierPattern.wildcard());
        return this;
    }

    public boolean variableMatches(String variable) {
        return this.variable.equals(variable);
    }

    public List<AttributeQualifierPattern> qualifierPatterns() {
        return this.qualifierPatterns;
    }

    public String toString() {
        return "AttributePattern{variable='" + this.variable + '\'' + ", qualifierPatterns=" + this.qualifierPatterns.stream().map(Object::toString).collect(Collectors.joining(",\n    ")) + '}';
    }

    public static AttributeFactory newPartialAttributeFactory(Container container, TypeAdapter adapter, TypeProvider provider) {
        AttributeFactory fac = AttributeFactory.newAttributeFactory(container, adapter, provider);
        return new PartialAttributeFactory(fac, container, adapter, provider);
    }

    static final class AttributeMatcher
    implements AttributeFactory.NamespacedAttribute {
        private final AttributeFactory.NamespacedAttribute attr;
        private final PartialAttributeFactory fac;
        private final List<AttributeFactory.Qualifier> qualifiers;

        AttributeMatcher(PartialAttributeFactory fac, AttributeFactory.NamespacedAttribute attr, List<AttributeFactory.Qualifier> qualifiers) {
            this.fac = fac;
            this.attr = attr;
            this.qualifiers = qualifiers;
        }

        @Override
        public long id() {
            return this.attr.id();
        }

        @Override
        public String[] candidateVariableNames() {
            return this.attr.candidateVariableNames();
        }

        @Override
        public List<AttributeFactory.Qualifier> qualifiers() {
            return this.attr.qualifiers();
        }

        @Override
        public AttributeFactory.Attribute addQualifier(AttributeFactory.Qualifier qual) {
            this.attr.addQualifier(qual);
            this.qualifiers.add(qual);
            return this;
        }

        @Override
        public Object resolve(Activation vars) {
            return this.tryResolve(vars);
        }

        @Override
        public Object tryResolve(Activation vars) {
            Activation.PartialActivation partial;
            Object unk;
            long id = this.attr.id();
            if (vars instanceof Activation.PartialActivation && (unk = this.fac.matchesUnknownPatterns(partial = (Activation.PartialActivation)vars, id, this.candidateVariableNames(), this.qualifiers)) != null) {
                return unk;
            }
            return this.attr.tryResolve(vars);
        }

        @Override
        public Object qualify(Activation vars, Object obj) {
            Object val = this.resolve(vars);
            if (UnknownT.isUnknown(val)) {
                return val;
            }
            AttributeFactory.Qualifier qual = this.fac.newQualifier(null, this.id(), val);
            return qual.qualify(vars, obj);
        }

        public String toString() {
            return "AttributeMatcher{attr=" + this.attr + ", fac=" + this.fac + ", qualifiers=" + this.qualifiers.stream().map(Object::toString).collect(Collectors.joining(",\n    ")) + '}';
        }
    }

    static final class PartialAttributeFactory
    implements AttributeFactory {
        private final AttributeFactory fac;
        private final Container container;
        private final TypeAdapter adapter;
        private final TypeProvider provider;

        PartialAttributeFactory(AttributeFactory fac, Container container, TypeAdapter adapter, TypeProvider provider) {
            this.fac = fac;
            this.container = container;
            this.adapter = adapter;
            this.provider = provider;
        }

        @Override
        public AttributeFactory.Attribute conditionalAttribute(long id, Interpretable expr, AttributeFactory.Attribute t, AttributeFactory.Attribute f) {
            return this.fac.conditionalAttribute(id, expr, t, f);
        }

        @Override
        public AttributeFactory.Attribute relativeAttribute(long id, Interpretable operand) {
            return this.fac.relativeAttribute(id, operand);
        }

        @Override
        public AttributeFactory.Qualifier newQualifier(Type objType, long qualID, Object val) {
            return this.fac.newQualifier(objType, qualID, val);
        }

        @Override
        public AttributeFactory.NamespacedAttribute absoluteAttribute(long id, String ... names) {
            AttributeFactory.NamespacedAttribute attr = this.fac.absoluteAttribute(id, names);
            return new AttributeMatcher(this, attr, new ArrayList<AttributeFactory.Qualifier>());
        }

        @Override
        public AttributeFactory.Attribute maybeAttribute(long id, String name) {
            ArrayList<AttributeFactory.NamespacedAttribute> attrs = new ArrayList<AttributeFactory.NamespacedAttribute>();
            attrs.add(this.absoluteAttribute(id, this.container.resolveCandidateNames(name)));
            return new AttributeFactory.MaybeAttribute(id, attrs, this.adapter, this.provider, this);
        }

        Object matchesUnknownPatterns(Activation.PartialActivation vars, long attrID, String[] variableNames, List<AttributeFactory.Qualifier> qualifiers) {
            AttributePattern[] patterns = vars.unknownAttributePatterns();
            IntHashSet candidateIndices = new IntHashSet();
            for (String variable : variableNames) {
                for (int i = 0; i < patterns.length; ++i) {
                    AttributePattern pat = patterns[i];
                    if (!pat.variableMatches(variable)) continue;
                    candidateIndices.add(i);
                }
            }
            if (candidateIndices.isEmpty()) {
                return null;
            }
            if (qualifiers.isEmpty()) {
                return UnknownT.unknownOf(attrID);
            }
            AttributeFactory.Qualifier[] newQuals = new AttributeFactory.Qualifier[qualifiers.size()];
            for (int i = 0; i < qualifiers.size(); ++i) {
                AttributeFactory.Qualifier qual = qualifiers.get(i);
                if (qual instanceof AttributeFactory.Attribute) {
                    Object val = ((AttributeFactory.Attribute)qual).resolve(vars);
                    if (UnknownT.isUnknown(val)) {
                        return val;
                    }
                    qual = this.fac.newQualifier(null, qual.id(), val);
                }
                newQuals[i] = qual;
            }
            IntHashSet.IntIterator patIter = candidateIndices.iterator();
            while (patIter.hasNext()) {
                int patIdx = patIter.nextValue();
                AttributePattern pat = patterns[patIdx];
                boolean isUnk = true;
                long matchExprID = attrID;
                List<AttributeQualifierPattern> qualPats = pat.qualifierPatterns();
                for (int i = 0; i < newQuals.length; ++i) {
                    AttributeFactory.Qualifier qual = newQuals[i];
                    if (i >= qualPats.size()) break;
                    matchExprID = qual.id();
                    AttributeQualifierPattern qualPat = qualPats.get(i);
                    if (qualPat.matches(qual)) continue;
                    isUnk = false;
                    break;
                }
                if (!isUnk) continue;
                return UnknownT.unknownOf(matchExprID);
            }
            return null;
        }
    }

    static interface QualifierValueEquator {
        public boolean qualifierValueEquals(Object var1);
    }

    static final class AttributeQualifierPattern {
        private final boolean wildcard;
        private final Object value;

        private AttributeQualifierPattern(boolean wildcard, Object value) {
            this.wildcard = wildcard;
            this.value = value;
        }

        static AttributeQualifierPattern wildcard() {
            return new AttributeQualifierPattern(true, null);
        }

        static AttributeQualifierPattern forValue(Object value) {
            return new AttributeQualifierPattern(false, value);
        }

        public boolean matches(AttributeFactory.Qualifier q) {
            if (this.wildcard) {
                return true;
            }
            if (q instanceof QualifierValueEquator) {
                QualifierValueEquator qve = (QualifierValueEquator)((Object)q);
                return qve.qualifierValueEquals(this.value);
            }
            return false;
        }

        public String toString() {
            return "AttributeQualifierPattern{wildcard=" + this.wildcard + ", value=" + this.value + '}';
        }
    }
}

