/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.conflux.concurrent;

import io.confluent.conflux.concurrent.CxCompletionStage;
import io.confluent.conflux.concurrent.CxEventExecutor;
import io.confluent.conflux.concurrent.CxPromise;
import io.confluent.conflux.concurrent.SemiCompletionStage;
import java.time.Duration;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

abstract class CompletedStage<T>
implements SemiCompletionStage<T> {
    CompletedStage() {
    }

    static <T> SemiCompletionStage<T> completedStage(T result) {
        return new SuccessStage<T>(result);
    }

    static <T> SemiCompletionStage<T> failedStage(Throwable error) {
        return new FailedStage(error);
    }

    @Override
    public <U> CxCompletionStage<U> thenApplyAsync(Function<? super T, ? extends U> fn, CxEventExecutor executor) {
        return this.bind(executor).thenApply(fn);
    }

    @Override
    public <U> CxCompletionStage<U> thenComposeAsync(Function<? super T, ? extends SemiCompletionStage<U>> fn, CxEventExecutor executor) {
        return this.bind(executor).thenCompose(fn);
    }

    @Override
    public <U> CxCompletionStage<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, CxEventExecutor executor) {
        return this.bind(executor).handle(fn);
    }

    @Override
    public CxCompletionStage<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, CxEventExecutor executor) {
        return this.bind(executor).whenComplete(action);
    }

    @Override
    public CxCompletionStage<Void> thenAcceptAsync(Consumer<? super T> action, CxEventExecutor executor) {
        return this.bind(executor).thenAccept(action);
    }

    static final class FailedStage<T>
    extends CompletedStage<T> {
        private final Throwable error;

        FailedStage(Throwable throwable) {
            this.error = throwable;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public CxCompletionStage<T> bind(CxEventExecutor ex) {
            CxPromise promise = ex.newPromise();
            promise.error(this.error);
            return promise.toFuture();
        }

        @Override
        public T block(Duration timeout) {
            if (this.error instanceof RuntimeException) {
                throw (RuntimeException)this.error;
            }
            throw new CompletionException(this.error);
        }

        @Override
        public void whenCompleteAsyncRaw(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
            executor.execute(() -> action.accept(null, this.error));
        }
    }

    static final class SuccessStage<T>
    extends CompletedStage<T> {
        private final T inner;

        SuccessStage(T inner) {
            this.inner = inner;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public CxCompletionStage<T> bind(CxEventExecutor ex) {
            CxPromise<T> promise = ex.newPromise();
            promise.complete(this.inner);
            return promise.toFuture();
        }

        @Override
        public T block(Duration timeout) {
            return this.inner;
        }

        @Override
        public void whenCompleteAsyncRaw(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
            executor.execute(() -> action.accept((T)this.inner, (Throwable)null));
        }
    }
}

