/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.client.config.provider;

import io.confluent.kafka.secretregistry.client.CachedSecretRegistryClient;
import io.confluent.kafka.secretregistry.client.SecretMetadata;
import io.confluent.kafka.secretregistry.client.SecretRegistryClient;
import io.confluent.kafka.secretregistry.client.config.provider.SecretConfigProviderConfig;
import io.confluent.kafka.secretregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigData;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretConfigProvider
implements ConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(SecretConfigProvider.class);
    private SecretRegistryClient secretRegistry;

    public void configure(Map<String, ?> configs) {
        SecretConfigProviderConfig providerConfig = new SecretConfigProviderConfig(configs);
        if (this.secretRegistry == null) {
            this.secretRegistry = new CachedSecretRegistryClient(providerConfig.getSecretRegistryUrls(), Integer.MAX_VALUE, configs, providerConfig.requestHeaders());
        }
    }

    public ConfigData get(String path) {
        try {
            Map<String, String> data = this.secretRegistry.getAllLatest(path).stream().collect(Collectors.toMap(SecretMetadata::getKey, SecretMetadata::getSecret));
            return new ConfigData(data);
        }
        catch (RestClientException | IOException e) {
            log.error("Could not obtain config data", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ConfigData get(String path, Set<String> keys) {
        try {
            Map<String, String> data = this.secretRegistry.getAllLatest(path).stream().filter(s -> keys.contains(s.getKey())).collect(Collectors.toMap(SecretMetadata::getKey, SecretMetadata::getSecret));
            return new ConfigData(data);
        }
        catch (RestClientException | IOException e) {
            log.error("Could not obtain config data", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this.secretRegistry.reset();
    }
}

