/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.client.config.provider;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class SecretConfigProviderConfig
extends AbstractConfig {
    public static final String REQUEST_HEADER_PREFIX = "request.header.";
    public static final String SECRET_REGISTRY_URL_CONFIG = "secret.registry.url";
    public static final String SECRET_REGISTRY_URL_DOC = "Comma-separated list of URLs for secret registry instances that can be used to register or look up secrets.";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE = "basic.auth.credentials.source";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_DEFAULT = "URL";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_DOC = "Specify how to pick the credentials for Basic Auth header. The supported values are URL, USER_INFO and SASL_INHERIT";
    public static final String USER_INFO_CONFIG = "basic.auth.user.info";
    public static final String USER_INFO_DEFAULT = "";
    public static final String USER_INFO_DOC = "Specify the user info for Basic Auth in the form of {username}:{password}";

    public static ConfigDef baseConfigDef() {
        return new ConfigDef().define(SECRET_REGISTRY_URL_CONFIG, ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, SECRET_REGISTRY_URL_DOC).define(BASIC_AUTH_CREDENTIALS_SOURCE, ConfigDef.Type.STRING, (Object)BASIC_AUTH_CREDENTIALS_SOURCE_DEFAULT, ConfigDef.Importance.MEDIUM, BASIC_AUTH_CREDENTIALS_SOURCE_DOC).define(USER_INFO_CONFIG, ConfigDef.Type.PASSWORD, (Object)USER_INFO_DEFAULT, ConfigDef.Importance.MEDIUM, USER_INFO_DOC);
    }

    public SecretConfigProviderConfig(Map<?, ?> props) {
        super(SecretConfigProviderConfig.baseConfigDef(), props);
    }

    public List<String> getSecretRegistryUrls() {
        return this.getList(SECRET_REGISTRY_URL_CONFIG);
    }

    public Map<String, String> requestHeaders() {
        return this.originalsWithPrefix(REQUEST_HEADER_PREFIX).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Objects.toString(entry.getValue())));
    }

    public String basicAuthUserInfo() {
        return this.getString(USER_INFO_CONFIG);
    }
}

