/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.rest.datapreview.extension;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.connect.rest.datapreview.extension.resources.ConnectorDataPreviewsResource;
import io.confluent.connect.rest.datapreview.extension.service.ConnectorDataPreviewConfig;
import io.confluent.connect.rest.datapreview.extension.service.ConnectorDataPreviewService;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.rest.ConnectRestExtension;
import org.apache.kafka.connect.rest.ConnectRestExtensionContext;
import org.apache.kafka.connect.runtime.rest.resources.ConnectorPluginsResource;
import org.apache.kafka.connect.runtime.rest.resources.ConnectorsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorDataPreviewRestExtension
implements ConnectRestExtension {
    private static final Logger log = LoggerFactory.getLogger(ConnectorDataPreviewRestExtension.class);
    private Map<String, Object> configs;

    public void register(ConnectRestExtensionContext restPluginContext) {
        log.info("Registering connector data preview rest extension.");
        try {
            ConnectorDataPreviewConfig connectorDataPreviewConfig = new ConnectorDataPreviewConfig(this.configs);
            ConnectorDataPreviewService dataPreviewService = this.buildConnectorDataPreviewService(restPluginContext, connectorDataPreviewConfig.originals());
            restPluginContext.configurable().register((Object)new ConnectorDataPreviewsResource(dataPreviewService));
            log.info("Finished registering connector data preview rest extension.");
        }
        catch (ConfigException e) {
            log.error("Could not register connector data preview rest extension due to failure in validation of configurations. ", (Throwable)e);
        }
        catch (IllegalStateException e) {
            log.error("Could not register connector data preview rest extension.", (Throwable)e);
        }
    }

    public void close() {
    }

    @VisibleForTesting
    ConnectorDataPreviewService buildConnectorDataPreviewService(ConnectRestExtensionContext restPluginContext, Map<String, Object> configs) {
        Object connectorsResource = null;
        Object connectorPluginsResource = null;
        for (Object resource : restPluginContext.configurable().getConfiguration().getInstances()) {
            if (resource instanceof ConnectorsResource) {
                connectorsResource = resource;
                continue;
            }
            if (!(resource instanceof ConnectorPluginsResource)) continue;
            connectorPluginsResource = resource;
        }
        if (connectorsResource != null && connectorPluginsResource != null) {
            return new ConnectorDataPreviewService(connectorsResource, connectorPluginsResource, configs);
        }
        throw new IllegalStateException("Connector data preview rest extension cannot be started because ConnectorsResource and ConnectorPluginsResource are not added yet.");
    }

    public void configure(Map<String, ?> configs) {
        this.configs = new HashMap(configs);
    }

    public String version() {
        return AppInfoParser.getVersion();
    }
}

