/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.filters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import io.confluent.rest.entities.ErrorMessage;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreMatching
@Priority(value=4000)
public class ContextFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(ContextFilter.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String path = requestContext.getUriInfo().getPath(false);
        if (path.startsWith("contexts/")) {
            try {
                UriBuilder builder = requestContext.getUriInfo().getRequestUriBuilder();
                MultivaluedMap queryParams = requestContext.getUriInfo().getQueryParameters(false);
                URI uri = this.modifyUri(builder, path, (MultivaluedMap<String, String>)queryParams);
                requestContext.setRequestUri(uri);
            }
            catch (IllegalArgumentException e) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ContextFilter.getErrorResponse(Response.Status.BAD_REQUEST, e.getMessage())).build());
            }
        }
    }

    @VisibleForTesting
    URI modifyUri(UriBuilder builder, String path, MultivaluedMap<String, String> queryParams) {
        ContextAndPath contextAndPath = this.modifyUriPath(path);
        builder.replacePath(contextAndPath.path);
        this.replaceQueryParams(builder, contextAndPath, queryParams);
        return builder.build(new Object[0]);
    }

    @VisibleForTesting
    ContextAndPath modifyUriPath(String path) {
        boolean contextPathFound = false;
        String context = ".";
        boolean configOrModeFound = false;
        boolean subjectPathFound = false;
        StringBuilder modifiedPath = new StringBuilder();
        boolean isFirst = true;
        String[] stringArray = path.split("/");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String uriPathStr;
            String modifiedUriPathStr = uriPathStr = stringArray[i];
            if (contextPathFound) {
                context = uriPathStr;
                contextPathFound = false;
                continue;
            }
            if (uriPathStr.equals("contexts")) {
                contextPathFound = true;
                continue;
            }
            if (subjectPathFound) {
                if (!uriPathStr.startsWith(":.") && !uriPathStr.startsWith(":*:")) {
                    modifiedUriPathStr = QualifiedSubject.normalizeContext((String)context) + uriPathStr;
                }
                subjectPathFound = false;
            }
            boolean isRootConfigOrMode = this.isRootConfigOrMode(isFirst, uriPathStr);
            if (uriPathStr.equals("subjects") || uriPathStr.equals("deks") || isRootConfigOrMode) {
                subjectPathFound = true;
                if (isRootConfigOrMode) {
                    configOrModeFound = true;
                }
            }
            modifiedPath.append(modifiedUriPathStr).append("/");
            if (!isFirst || uriPathStr.isEmpty()) continue;
            isFirst = false;
        }
        if (configOrModeFound && subjectPathFound) {
            String normalizedContext = QualifiedSubject.normalizeContext((String)context);
            if (!normalizedContext.isEmpty()) {
                modifiedPath.append(normalizedContext).append("/");
            }
        } else if (contextPathFound) {
            modifiedPath.append("contexts").append("/");
        }
        return new ContextAndPath(context, modifiedPath.toString());
    }

    private boolean isRootConfigOrMode(boolean isFirst, String uriPathStr) {
        return isFirst && (uriPathStr.equals("config") || uriPathStr.equals("mode"));
    }

    private void replaceQueryParams(UriBuilder builder, ContextAndPath contextAndPath, MultivaluedMap<String, String> queryParams) {
        String context = contextAndPath.getContext();
        String path = contextAndPath.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.startsWith("schemas/ids")) {
            String subject = (String)queryParams.getFirst((Object)"subject");
            if (subject == null) {
                subject = "";
            }
            if (!subject.startsWith(":.") && !subject.startsWith(":*:")) {
                subject = QualifiedSubject.normalizeContext((String)context) + subject;
                builder.replaceQueryParam("subject", new Object[]{subject});
            }
        } else if (path.equals("schemas") || path.equals("subjects") || path.startsWith("keks")) {
            List<String> subjectPrefixes = (List<String>)queryParams.get((Object)"subjectPrefix");
            if (subjectPrefixes == null || subjectPrefixes.isEmpty()) {
                subjectPrefixes = Collections.singletonList("");
            }
            Object[] newSubjectPrefixes = subjectPrefixes.stream().map(prefix -> {
                if (!prefix.startsWith(":.") && !prefix.startsWith(":*:")) {
                    return QualifiedSubject.normalizeContext((String)context) + prefix;
                }
                return prefix;
            }).toArray();
            builder.replaceQueryParam("subjectPrefix", newSubjectPrefixes);
        }
    }

    public static String getErrorResponse(Response.Status status, String message) {
        try {
            ErrorMessage errorMessage = new ErrorMessage(status.getStatusCode(), message);
            return MAPPER.writeValueAsString((Object)errorMessage);
        }
        catch (JsonProcessingException ex) {
            log.error("Could not format response error message. {}", (Object)ex.toString());
            return message;
        }
    }

    static class ContextAndPath {
        private final String context;
        private final String path;

        public ContextAndPath(String context, String path) {
            this.context = context;
            this.path = path;
        }

        public String getContext() {
            return this.context;
        }

        public String getPath() {
            return this.path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContextAndPath that = (ContextAndPath)o;
            return Objects.equals(this.context, that.context) && Objects.equals(this.path, that.path);
        }

        public int hashCode() {
            return Objects.hash(this.context, this.path);
        }

        public String toString() {
            return "ContextAndPath{context='" + this.context + '\'' + ", path='" + this.path + '\'' + '}';
        }
    }
}

