/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKeyType;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"keytype", "tenant", "context"})
public class ContextKey
extends SchemaRegistryKey {
    private String tenant;
    private String context;

    public ContextKey(@JsonProperty(value="tenant") String tenant, @JsonProperty(value="context") String context) {
        super(SchemaRegistryKeyType.CONTEXT);
        this.tenant = tenant;
        this.context = context;
    }

    @JsonProperty(value="tenant")
    public String getTenant() {
        return this.tenant;
    }

    @JsonProperty(value="tenant")
    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    @JsonProperty(value="context")
    public String getContext() {
        return this.context;
    }

    @JsonProperty(value="context")
    public void setContext(String context) {
        this.context = context;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ContextKey that = (ContextKey)o;
        return Objects.equals(this.tenant, that.tenant) && Objects.equals(this.context, that.context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.context, this.tenant);
    }

    @Override
    public int compareTo(SchemaRegistryKey o) {
        int compare = super.compareTo(o);
        if (compare == 0) {
            ContextKey that = (ContextKey)o;
            if (this.getTenant() != null || that.getTenant() != null) {
                if (this.getTenant() == null) {
                    return -1;
                }
                if (that.getTenant() == null) {
                    return 1;
                }
                int tenantComparison = this.getTenant().compareTo(that.getTenant());
                if (tenantComparison != 0) {
                    return tenantComparison < 0 ? -1 : 1;
                }
            }
            if (this.getContext() == null && that.getContext() == null) {
                return 0;
            }
            if (this.getContext() == null) {
                return -1;
            }
            if (that.getContext() == null) {
                return 1;
            }
            return this.getContext().compareTo(that.getContext());
        }
        return compare;
    }
}

