/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PemUtils {
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    private static final Logger log = LoggerFactory.getLogger(PemUtils.class);

    public static PublicKey loadPublicKey(InputStream inputStream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, US_ASCII);){
            PEMParser pemParser = new PEMParser((Reader)new BufferedReader(reader));
            SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance((Object)pemParser.readObject());
            PublicKey publicKey = new JcaPEMKeyConverter().getPublicKey(keyInfo);
            return publicKey;
        }
    }

    public static void writePublicKey(OutputStream out, PublicKey key) throws IOException {
        try (PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter(out, "utf8"));){
            pemWriter.writeObject((PemObjectGenerator)new JcaMiscPEMGenerator((Object)key));
        }
    }

    public static KeyPair loadKeyPair(InputStream inputStream) throws IOException {
        Throwable throwable = null;
        try (InputStreamReader reader = new InputStreamReader(inputStream, US_ASCII);){
            PEMParser pemParser = new PEMParser((Reader)new BufferedReader(reader));
            Object pemKeypairObject = pemParser.readObject();
            if (pemKeypairObject instanceof PEMKeyPair) {
                PEMKeyPair pemKeyPair = (PEMKeyPair)pemKeypairObject;
                log.info("Loading key pair of type PKCS#1 from PEM file");
                KeyPair keyPair = new JcaPEMKeyConverter().getKeyPair(pemKeyPair);
                return keyPair;
            }
            if (pemKeypairObject instanceof PrivateKeyInfo) {
                PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)pemKeypairObject;
                PrivateKey privateKey = new JcaPEMKeyConverter().getPrivateKey(privateKeyInfo);
                PublicKey publicKey = PemUtils.getPublicKeyFromPrivateKeyInfo(privateKeyInfo);
                log.info("Loading key pair of type PKCS#8 from PEM file");
                KeyPair keyPair = new KeyPair(publicKey, privateKey);
                return keyPair;
            }
            try {
                throw new IOException("Unsupported PEM object type: " + pemKeypairObject.getClass());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static KeyPair loadKeyPair(InputStream inputStream, String password) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static PublicKey getPublicKeyFromPrivateKeyInfo(PrivateKeyInfo privateKeyInfo) throws IOException {
        PrivateKey privateKey = new JcaPEMKeyConverter().getPrivateKey(privateKeyInfo);
        PemObject oldPemObject = new JcaMiscPEMGenerator((Object)privateKey, null).generate();
        StringWriter writer = new StringWriter();
        PemWriter pemWriter = new PemWriter((Writer)writer);
        pemWriter.writeObject((PemObjectGenerator)oldPemObject);
        pemWriter.close();
        Object pair = new PEMParser((Reader)new StringReader(writer.toString())).readObject();
        return new JcaPEMKeyConverter().getKeyPair((PEMKeyPair)pair).getPublic();
    }

    public static void writeKeyPair(OutputStream out, KeyPair keyPair) throws IOException {
        try (PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter(out, "utf8"));){
            pemWriter.writeObject((PemObjectGenerator)new JcaMiscPEMGenerator((Object)keyPair));
        }
    }
}

