/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.auth.plain;

import io.confluent.kafka.security.auth.plain.DynamicPlainCredential;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.kafka.common.security.plain.internals.PlainSaslServerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicPlainLoginModule
implements LoginModule {
    private static final Logger log = LoggerFactory.getLogger(DynamicPlainLoginModule.class);
    private Subject subject;
    private CallbackHandler loginCallbackHandler;
    private volatile LoginState loginState = LoginState.NOT_INITIALIZED;
    private volatile DynamicPlainCredential currentCredential;
    private volatile DynamicPlainCredential oldCredential;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        log.debug("Initialize login, current state {}", (Object)this.loginState);
        this.ensureLoginState(LoginState.NOT_INITIALIZED);
        this.subject = subject;
        this.loginCallbackHandler = callbackHandler;
        this.loginState = LoginState.INITIALIZED;
    }

    @Override
    public boolean login() throws LoginException {
        log.debug("Logging in, current state {}", (Object)this.loginState);
        this.ensureLoginState(LoginState.INITIALIZED);
        NameCallback nameCallback = new NameCallback("username");
        PasswordCallback passwordCallback = new PasswordCallback("password", false);
        try {
            this.loginCallbackHandler.handle(new Callback[]{nameCallback, passwordCallback});
            this.currentCredential = new DynamicPlainCredential(nameCallback.getName(), passwordCallback.getPassword());
            this.loginState = LoginState.LOGGED_IN;
        }
        catch (IOException | UnsupportedCallbackException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new LoginException("Credentials could not be retrieved using the configured login callback handler");
        }
        return true;
    }

    @Override
    public boolean logout() {
        log.debug("Logging out, current state {}", (Object)this.loginState);
        switch (this.loginState) {
            case NOT_INITIALIZED: 
            case INITIALIZED: 
            case LOGGED_IN: {
                break;
            }
            case COMMITTED: {
                this.oldCredential = this.currentCredential;
                this.currentCredential = null;
                this.loginState = LoginState.INITIALIZED;
            }
        }
        return true;
    }

    @Override
    public boolean commit() {
        log.debug("Committing login, current state {}", (Object)this.loginState);
        this.ensureLoginState(LoginState.LOGGED_IN);
        if (this.currentCredential != null) {
            this.subject.getPrivateCredentials().add(this.currentCredential);
            if (this.oldCredential != null && !this.oldCredential.equals(this.currentCredential)) {
                this.subject.getPrivateCredentials().remove(this.oldCredential);
            }
            this.oldCredential = null;
            this.loginState = LoginState.COMMITTED;
        }
        return true;
    }

    @Override
    public boolean abort() {
        log.debug("Abort login, current state {}", (Object)this.loginState);
        if (this.loginState == LoginState.LOGGED_IN) {
            this.currentCredential = null;
            this.loginState = LoginState.INITIALIZED;
        }
        return true;
    }

    private void ensureLoginState(LoginState expectedLoginState) {
        if (this.loginState != expectedLoginState) {
            throw new IllegalStateException("Expected login state " + (Object)((Object)expectedLoginState) + ", but was " + (Object)((Object)this.loginState));
        }
    }

    static {
        PlainSaslServerProvider.initialize();
    }

    private static enum LoginState {
        NOT_INITIALIZED,
        INITIALIZED,
        LOGGED_IN,
        COMMITTED;

    }
}

