/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.oauthbearer;

import io.confluent.kafka.security.oauthbearer.ClientAssertion;
import io.confluent.kafka.security.oauthbearer.ClientAssertionHttpRequestFormatter;
import io.confluent.kafka.security.oauthbearer.ClientSecretHttpRequestFormatter;
import io.confluent.kafka.security.oauthbearer.FileBasedClientAssertion;
import io.confluent.kafka.security.oauthbearer.HttpRequestFormatter;
import io.confluent.kafka.security.oauthbearer.PrivateKeyClientAssertion;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestFormatterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequestFormatterFactory.class);
    private static final String CLIENT_ID_CONFIG = "clientId";
    private static final String CLIENT_SECRET_CONFIG = "clientSecret";

    public static HttpRequestFormatter create(ConfigurationUtils cu, JaasOptionsUtils jou) {
        String clientAssertionIssuer = (String)cu.get("sasl.oauthbearer.clientassertion.issuer");
        String clientAssertionLocation = (String)cu.get("sasl.oauthbearer.clientassertion.location");
        if (clientAssertionIssuer != null || clientAssertionLocation != null) {
            ClientAssertion clientAssertion = null;
            if (clientAssertionLocation != null) {
                LOG.info("Configuring File based client assertion using file: {}", (Object)clientAssertionLocation);
                clientAssertion = new FileBasedClientAssertion(clientAssertionLocation);
            } else {
                LOG.info("Configuring local client assertion creation");
                clientAssertion = new PrivateKeyClientAssertion(cu.validateString("sasl.oauthbearer.clientassertion.issuer"), cu.validateString("sasl.oauthbearer.clientassertion.audience"), cu.validateString("sasl.oauthbearer.clientassertion.subject"), cu.validateInteger("sasl.oauthbearer.clientassertion.expiration", false, 1), (Boolean)cu.get("sasl.oauthbearer.clientassertion.include.nbf.claim"), (Boolean)cu.get("sasl.oauthbearer.clientassertion.include.jti.claim"), cu.validateString("sasl.oauthbearer.clientassertion.private.key"), cu.validateString("sasl.oauthbearer.clientassertion.private.key.passphrase", false));
            }
            return new ClientAssertionHttpRequestFormatter(clientAssertion, jou.validateString(CLIENT_ID_CONFIG, false));
        }
        return new ClientSecretHttpRequestFormatter(jou.validateString(CLIENT_ID_CONFIG), jou.validateString(CLIENT_SECRET_CONFIG));
    }
}

