/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import io.confluent.kafka.clients.AlterCellMigrationOptions;
import io.confluent.kafka.clients.AlterCellMigrationResult;
import io.confluent.kafka.clients.AlterCellOptions;
import io.confluent.kafka.clients.AlterCellResult;
import io.confluent.kafka.clients.AssignBrokersToCellOptions;
import io.confluent.kafka.clients.AssignBrokersToCellResult;
import io.confluent.kafka.clients.AssignTenantsToCellOptions;
import io.confluent.kafka.clients.AssignTenantsToCellResult;
import io.confluent.kafka.clients.CellLoadResult;
import io.confluent.kafka.clients.CloudAdmin;
import io.confluent.kafka.clients.CreateCellOptions;
import io.confluent.kafka.clients.CreateCellResult;
import io.confluent.kafka.clients.DeleteCellOptions;
import io.confluent.kafka.clients.DeleteCellResult;
import io.confluent.kafka.clients.DeleteTenantsOptions;
import io.confluent.kafka.clients.DeleteTenantsResult;
import io.confluent.kafka.clients.DescribeCellLoadOptions;
import io.confluent.kafka.clients.DescribeCellMigrationOptions;
import io.confluent.kafka.clients.DescribeCellMigrationResult;
import io.confluent.kafka.clients.DescribeCellsOptions;
import io.confluent.kafka.clients.DescribeCellsResult;
import io.confluent.kafka.clients.DescribeNetworkOptions;
import io.confluent.kafka.clients.DescribeNetworkResult;
import io.confluent.kafka.clients.DescribeTenantsOptions;
import io.confluent.kafka.clients.DescribeTenantsResult;
import io.confluent.kafka.clients.UnassignBrokersFromCellOptions;
import io.confluent.kafka.clients.UnassignBrokersFromCellResult;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.clients.HostResolver;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.LeastLoadedNode;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.StaleMetadataException;
import org.apache.kafka.clients.admin.AbortTransactionOptions;
import org.apache.kafka.clients.admin.AbortTransactionResult;
import org.apache.kafka.clients.admin.AbortTransactionSpec;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterBrokerHealthOptions;
import org.apache.kafka.clients.admin.AlterBrokerHealthResult;
import org.apache.kafka.clients.admin.AlterBrokerHealthSpec;
import org.apache.kafka.clients.admin.AlterBrokerReplicaExclusionsOptions;
import org.apache.kafka.clients.admin.AlterBrokerReplicaExclusionsResult;
import org.apache.kafka.clients.admin.AlterClientQuotasOptions;
import org.apache.kafka.clients.admin.AlterClientQuotasResult;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.AlterLeadershipPriorityOptions;
import org.apache.kafka.clients.admin.AlterLeadershipPriorityResult;
import org.apache.kafka.clients.admin.AlterLeadershipPrioritySpec;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.AlterPartitionReassignmentsOptions;
import org.apache.kafka.clients.admin.AlterPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsResult;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsOptions;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsResult;
import org.apache.kafka.clients.admin.BalancerOperationError;
import org.apache.kafka.clients.admin.BalancerOperationStatus;
import org.apache.kafka.clients.admin.BalancerSelfHealMode;
import org.apache.kafka.clients.admin.BalancerStatus;
import org.apache.kafka.clients.admin.BalancerStatusDescription;
import org.apache.kafka.clients.admin.BrokerAdditionDescription;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.BrokerHealthStatusResult;
import org.apache.kafka.clients.admin.BrokerLeadershipPriorityResult;
import org.apache.kafka.clients.admin.BrokerRemovalDescription;
import org.apache.kafka.clients.admin.BrokerRemovalError;
import org.apache.kafka.clients.admin.BrokerReplicaExclusionStatus;
import org.apache.kafka.clients.admin.BrokerShutdownStatus;
import org.apache.kafka.clients.admin.ClientMetricsResourceListing;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.ComponentHealthStatus;
import org.apache.kafka.clients.admin.ComputeEvenClusterLoadPlanOptions;
import org.apache.kafka.clients.admin.ComputeEvenClusterLoadPlanResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.CreateAclsOptions;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.CreateClusterLinksOptions;
import org.apache.kafka.clients.admin.CreateClusterLinksResult;
import org.apache.kafka.clients.admin.CreateDelegationTokenOptions;
import org.apache.kafka.clients.admin.CreateDelegationTokenResult;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DegradedBroker;
import org.apache.kafka.clients.admin.DeleteAclsOptions;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteClusterLinksOptions;
import org.apache.kafka.clients.admin.DeleteClusterLinksResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsResult;
import org.apache.kafka.clients.admin.DeleteRecordsOptions;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeleteTopicsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.DemotedBroker;
import org.apache.kafka.clients.admin.DescribeAclsOptions;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.clients.admin.DescribeBalancerStatusOptions;
import org.apache.kafka.clients.admin.DescribeBalancerStatusResult;
import org.apache.kafka.clients.admin.DescribeBrokerAdditionsOptions;
import org.apache.kafka.clients.admin.DescribeBrokerAdditionsResult;
import org.apache.kafka.clients.admin.DescribeBrokerHealthOptions;
import org.apache.kafka.clients.admin.DescribeBrokerHealthResult;
import org.apache.kafka.clients.admin.DescribeBrokerRemovalsOptions;
import org.apache.kafka.clients.admin.DescribeBrokerRemovalsResult;
import org.apache.kafka.clients.admin.DescribeBrokerReplicaExclusionsOptions;
import org.apache.kafka.clients.admin.DescribeBrokerReplicaExclusionsResult;
import org.apache.kafka.clients.admin.DescribeClientQuotasOptions;
import org.apache.kafka.clients.admin.DescribeClientQuotasResult;
import org.apache.kafka.clients.admin.DescribeClusterLinksOptions;
import org.apache.kafka.clients.admin.DescribeClusterLinksResult;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeDelegationTokenOptions;
import org.apache.kafka.clients.admin.DescribeDelegationTokenResult;
import org.apache.kafka.clients.admin.DescribeEvenClusterLoadStatusOptions;
import org.apache.kafka.clients.admin.DescribeEvenClusterLoadStatusResult;
import org.apache.kafka.clients.admin.DescribeFeaturesOptions;
import org.apache.kafka.clients.admin.DescribeFeaturesResult;
import org.apache.kafka.clients.admin.DescribeLeadershipPriorityOptions;
import org.apache.kafka.clients.admin.DescribeLeadershipPriorityResult;
import org.apache.kafka.clients.admin.DescribeLogDirsOptions;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.clients.admin.DescribeMetadataQuorumOptions;
import org.apache.kafka.clients.admin.DescribeMetadataQuorumResult;
import org.apache.kafka.clients.admin.DescribeMirrorsOptions;
import org.apache.kafka.clients.admin.DescribeMirrorsResult;
import org.apache.kafka.clients.admin.DescribeProducersOptions;
import org.apache.kafka.clients.admin.DescribeProducersResult;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.DescribeTransactionsOptions;
import org.apache.kafka.clients.admin.DescribeTransactionsResult;
import org.apache.kafka.clients.admin.DescribeUserScramCredentialsOptions;
import org.apache.kafka.clients.admin.DescribeUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ElectLeadersOptions;
import org.apache.kafka.clients.admin.ElectLeadersResult;
import org.apache.kafka.clients.admin.EndpointType;
import org.apache.kafka.clients.admin.EvenClusterLoadPlan;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanBrokerRelatedStats;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanBrokerStats;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanClusterRelatedStats;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanDetailedClusterBalanceStats;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanGoalRelatedStats;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanGoalStats;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanGoalStatsOverview;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanGoalStatsOverviewRejectingGoal;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanGoalStatsResources;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanReplicaMovementStats;
import org.apache.kafka.clients.admin.EvenClusterLoadStatus;
import org.apache.kafka.clients.admin.EvenClusterLoadStatusDescription;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.clients.admin.ExclusionOpResult;
import org.apache.kafka.clients.admin.ExclusionOperationError;
import org.apache.kafka.clients.admin.ExpireDelegationTokenOptions;
import org.apache.kafka.clients.admin.ExpireDelegationTokenResult;
import org.apache.kafka.clients.admin.FeatureMetadata;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.FenceProducersOptions;
import org.apache.kafka.clients.admin.FenceProducersResult;
import org.apache.kafka.clients.admin.FinalizedVersionRange;
import org.apache.kafka.clients.admin.ListClientMetricsResourcesOptions;
import org.apache.kafka.clients.admin.ListClientMetricsResourcesResult;
import org.apache.kafka.clients.admin.ListClusterLinksOptions;
import org.apache.kafka.clients.admin.ListClusterLinksResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.ListMirrorsOptions;
import org.apache.kafka.clients.admin.ListMirrorsResult;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsOptions;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.ListTransactionsOptions;
import org.apache.kafka.clients.admin.ListTransactionsResult;
import org.apache.kafka.clients.admin.LogDirDescription;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.PartitionReassignmentsStatus;
import org.apache.kafka.clients.admin.QuorumInfo;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.RemoveBrokersOptions;
import org.apache.kafka.clients.admin.RemoveBrokersResult;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupOptions;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupResult;
import org.apache.kafka.clients.admin.RenewDelegationTokenOptions;
import org.apache.kafka.clients.admin.RenewDelegationTokenResult;
import org.apache.kafka.clients.admin.ReplicaInfo;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.clients.admin.SupportedVersionRange;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.clients.admin.TransactionDescription;
import org.apache.kafka.clients.admin.TransactionListing;
import org.apache.kafka.clients.admin.TriggerEvenClusterLoadOptions;
import org.apache.kafka.clients.admin.TriggerEvenClusterLoadResult;
import org.apache.kafka.clients.admin.UnregisterBrokerOptions;
import org.apache.kafka.clients.admin.UnregisterBrokerResult;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.clients.admin.UpdateFeaturesResult;
import org.apache.kafka.clients.admin.UserScramCredentialAlteration;
import org.apache.kafka.clients.admin.UserScramCredentialDeletion;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.clients.admin.internals.AbortTransactionHandler;
import org.apache.kafka.clients.admin.internals.AdminApiDriver;
import org.apache.kafka.clients.admin.internals.AdminApiFuture;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.AdminBootstrapAddresses;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.clients.admin.internals.AdminRequestInterceptor;
import org.apache.kafka.clients.admin.internals.AllBrokersStrategy;
import org.apache.kafka.clients.admin.internals.AlterConsumerGroupOffsetsHandler;
import org.apache.kafka.clients.admin.internals.ClusterLink;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.admin.internals.DeleteConsumerGroupOffsetsHandler;
import org.apache.kafka.clients.admin.internals.DeleteConsumerGroupsHandler;
import org.apache.kafka.clients.admin.internals.DeleteRecordsHandler;
import org.apache.kafka.clients.admin.internals.DescribeConsumerGroupsHandler;
import org.apache.kafka.clients.admin.internals.DescribeProducersHandler;
import org.apache.kafka.clients.admin.internals.DescribeTransactionsHandler;
import org.apache.kafka.clients.admin.internals.ExclusionRequestUtils;
import org.apache.kafka.clients.admin.internals.FenceProducersHandler;
import org.apache.kafka.clients.admin.internals.ListConsumerGroupOffsetsHandler;
import org.apache.kafka.clients.admin.internals.ListOffsetsHandler;
import org.apache.kafka.clients.admin.internals.ListTransactionsHandler;
import org.apache.kafka.clients.admin.internals.OffsetForLeaderEpochOptions;
import org.apache.kafka.clients.admin.internals.OffsetForLeaderEpochResult;
import org.apache.kafka.clients.admin.internals.RemoveMembersFromConsumerGroupHandler;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.CellMigrationState;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Confluent;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.GroupType;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicCollection;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.errors.InvalidBrokerRemovalException;
import org.apache.kafka.common.errors.InvalidBrokerReplicaExclusionException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.MismatchedEndpointTypeException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.ThrottlingQuotaExceededException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnacceptableCredentialException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnknownTopicIdException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnrepresentableBrokerIdException;
import org.apache.kafka.common.errors.UnsupportedEndpointTypeException;
import org.apache.kafka.common.errors.UnsupportedSaslMechanismException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.AlterBrokerHealthRequestData;
import org.apache.kafka.common.message.AlterBrokerReplicaExclusionsResponseData;
import org.apache.kafka.common.message.AlterCellMigrationRequestData;
import org.apache.kafka.common.message.AlterCellRequestData;
import org.apache.kafka.common.message.AlterMirrorsRequestData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.AlterReplicaLogDirsRequestData;
import org.apache.kafka.common.message.AlterReplicaLogDirsResponseData;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.AssignBrokersToCellRequestData;
import org.apache.kafka.common.message.AssignTenantsToCellRequestData;
import org.apache.kafka.common.message.AssignTenantsToCellResponseData;
import org.apache.kafka.common.message.ComputeEvenClusterLoadPlanResponseData;
import org.apache.kafka.common.message.CreateAclsRequestData;
import org.apache.kafka.common.message.CreateAclsResponseData;
import org.apache.kafka.common.message.CreateCellRequestData;
import org.apache.kafka.common.message.CreateClusterLinksRequestData;
import org.apache.kafka.common.message.CreateDelegationTokenRequestData;
import org.apache.kafka.common.message.CreateDelegationTokenResponseData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteAclsRequestData;
import org.apache.kafka.common.message.DeleteAclsResponseData;
import org.apache.kafka.common.message.DeleteCellRequestData;
import org.apache.kafka.common.message.DeleteTenantsRequestData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DescribeBalancerStatusResponseData;
import org.apache.kafka.common.message.DescribeBrokerReplicaExclusionsRequestData;
import org.apache.kafka.common.message.DescribeCellLoadRequestData;
import org.apache.kafka.common.message.DescribeCellLoadResponseData;
import org.apache.kafka.common.message.DescribeCellMigrationRequestData;
import org.apache.kafka.common.message.DescribeCellMigrationResponseData;
import org.apache.kafka.common.message.DescribeCellsRequestData;
import org.apache.kafka.common.message.DescribeCellsResponseData;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.message.DescribeClusterResponseData;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.message.DescribeEvenClusterLoadStatusResponseData;
import org.apache.kafka.common.message.DescribeLogDirsRequestData;
import org.apache.kafka.common.message.DescribeLogDirsResponseData;
import org.apache.kafka.common.message.DescribeNetworkRequestData;
import org.apache.kafka.common.message.DescribeNetworkResponseData;
import org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.kafka.common.message.DescribeTenantsRequestData;
import org.apache.kafka.common.message.DescribeTenantsResponseData;
import org.apache.kafka.common.message.DescribeTopicPartitionsRequestData;
import org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.ExpireDelegationTokenRequestData;
import org.apache.kafka.common.message.GetTelemetrySubscriptionsRequestData;
import org.apache.kafka.common.message.InitiateReverseConnectionsRequestData;
import org.apache.kafka.common.message.InitiateReverseConnectionsResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.ListClientMetricsResourcesRequestData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.RemoveBrokersRequestData;
import org.apache.kafka.common.message.RemoveBrokersResponseData;
import org.apache.kafka.common.message.RenewDelegationTokenRequestData;
import org.apache.kafka.common.message.TriggerEvenClusterLoadResponseData;
import org.apache.kafka.common.message.UnAssignBrokersFromCellRequestData;
import org.apache.kafka.common.message.UnregisterBrokerRequestData;
import org.apache.kafka.common.message.UpdateFeaturesRequestData;
import org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ProxyProtocolEngineFactory;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterBrokerHealthRequest;
import org.apache.kafka.common.requests.AlterBrokerHealthResponse;
import org.apache.kafka.common.requests.AlterBrokerReplicaExclusionsRequest;
import org.apache.kafka.common.requests.AlterBrokerReplicaExclusionsResponse;
import org.apache.kafka.common.requests.AlterCellMigrationRequest;
import org.apache.kafka.common.requests.AlterCellMigrationResponse;
import org.apache.kafka.common.requests.AlterCellRequest;
import org.apache.kafka.common.requests.AlterCellResponse;
import org.apache.kafka.common.requests.AlterClientQuotasRequest;
import org.apache.kafka.common.requests.AlterClientQuotasResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.AlterMirrorsRequest;
import org.apache.kafka.common.requests.AlterMirrorsResponse;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.AlterReplicaLogDirsRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsResponse;
import org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.AssignBrokersToCellRequest;
import org.apache.kafka.common.requests.AssignBrokersToCellResponse;
import org.apache.kafka.common.requests.AssignTenantsToCellRequest;
import org.apache.kafka.common.requests.AssignTenantsToCellResponse;
import org.apache.kafka.common.requests.ComputeEvenClusterLoadPlanRequest;
import org.apache.kafka.common.requests.ComputeEvenClusterLoadPlanResponse;
import org.apache.kafka.common.requests.CreateAclsRequest;
import org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.kafka.common.requests.CreateCellRequest;
import org.apache.kafka.common.requests.CreateCellResponse;
import org.apache.kafka.common.requests.CreateClusterLinksRequest;
import org.apache.kafka.common.requests.CreateClusterLinksResponse;
import org.apache.kafka.common.requests.CreateDelegationTokenRequest;
import org.apache.kafka.common.requests.CreateDelegationTokenResponse;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteAclsRequest;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.requests.DeleteCellRequest;
import org.apache.kafka.common.requests.DeleteCellResponse;
import org.apache.kafka.common.requests.DeleteClusterLinksRequest;
import org.apache.kafka.common.requests.DeleteClusterLinksResponse;
import org.apache.kafka.common.requests.DeleteTenantsRequest;
import org.apache.kafka.common.requests.DeleteTenantsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeAclsRequest;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.requests.DescribeBalancerStatusRequest;
import org.apache.kafka.common.requests.DescribeBalancerStatusResponse;
import org.apache.kafka.common.requests.DescribeBrokerAdditionsRequest;
import org.apache.kafka.common.requests.DescribeBrokerAdditionsResponse;
import org.apache.kafka.common.requests.DescribeBrokerHealthRequest;
import org.apache.kafka.common.requests.DescribeBrokerHealthResponse;
import org.apache.kafka.common.requests.DescribeBrokerRemovalsRequest;
import org.apache.kafka.common.requests.DescribeBrokerRemovalsResponse;
import org.apache.kafka.common.requests.DescribeBrokerReplicaExclusionsRequest;
import org.apache.kafka.common.requests.DescribeBrokerReplicaExclusionsResponse;
import org.apache.kafka.common.requests.DescribeCellLoadRequest;
import org.apache.kafka.common.requests.DescribeCellLoadResponse;
import org.apache.kafka.common.requests.DescribeCellMigrationRequest;
import org.apache.kafka.common.requests.DescribeCellMigrationResponse;
import org.apache.kafka.common.requests.DescribeCellsRequest;
import org.apache.kafka.common.requests.DescribeCellsResponse;
import org.apache.kafka.common.requests.DescribeClientQuotasRequest;
import org.apache.kafka.common.requests.DescribeClientQuotasResponse;
import org.apache.kafka.common.requests.DescribeClusterLinksRequest;
import org.apache.kafka.common.requests.DescribeClusterLinksResponse;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeClusterResponse;
import org.apache.kafka.common.requests.DescribeConfigsRequest;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.requests.DescribeDelegationTokenRequest;
import org.apache.kafka.common.requests.DescribeDelegationTokenResponse;
import org.apache.kafka.common.requests.DescribeEvenClusterLoadStatusRequest;
import org.apache.kafka.common.requests.DescribeEvenClusterLoadStatusResponse;
import org.apache.kafka.common.requests.DescribeLogDirsRequest;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.apache.kafka.common.requests.DescribeMirrorsRequest;
import org.apache.kafka.common.requests.DescribeMirrorsResponse;
import org.apache.kafka.common.requests.DescribeNetworkRequest;
import org.apache.kafka.common.requests.DescribeNetworkResponse;
import org.apache.kafka.common.requests.DescribeQuorumRequest;
import org.apache.kafka.common.requests.DescribeQuorumResponse;
import org.apache.kafka.common.requests.DescribeTenantsRequest;
import org.apache.kafka.common.requests.DescribeTenantsResponse;
import org.apache.kafka.common.requests.DescribeTopicPartitionsRequest;
import org.apache.kafka.common.requests.DescribeTopicPartitionsResponse;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsResponse;
import org.apache.kafka.common.requests.ElectLeadersRequest;
import org.apache.kafka.common.requests.ElectLeadersResponse;
import org.apache.kafka.common.requests.ExpireDelegationTokenRequest;
import org.apache.kafka.common.requests.ExpireDelegationTokenResponse;
import org.apache.kafka.common.requests.GetTelemetrySubscriptionsRequest;
import org.apache.kafka.common.requests.GetTelemetrySubscriptionsResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.InitiateReverseConnectionsRequest;
import org.apache.kafka.common.requests.InitiateReverseConnectionsResponse;
import org.apache.kafka.common.requests.ListClientMetricsResourcesRequest;
import org.apache.kafka.common.requests.ListClientMetricsResourcesResponse;
import org.apache.kafka.common.requests.ListClusterLinksRequest;
import org.apache.kafka.common.requests.ListClusterLinksResponse;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListMirrorsRequest;
import org.apache.kafka.common.requests.ListMirrorsResponse;
import org.apache.kafka.common.requests.ListPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.ListPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.requests.RemoveBrokersRequest;
import org.apache.kafka.common.requests.RemoveBrokersResponse;
import org.apache.kafka.common.requests.RenewDelegationTokenRequest;
import org.apache.kafka.common.requests.RenewDelegationTokenResponse;
import org.apache.kafka.common.requests.ReplicaStatusRequest;
import org.apache.kafka.common.requests.ReplicaStatusResponse;
import org.apache.kafka.common.requests.TriggerEvenClusterLoadRequest;
import org.apache.kafka.common.requests.TriggerEvenClusterLoadResponse;
import org.apache.kafka.common.requests.UnAssignBrokersFromCellRequest;
import org.apache.kafka.common.requests.UnAssignBrokersFromCellResponse;
import org.apache.kafka.common.requests.UnregisterBrokerRequest;
import org.apache.kafka.common.requests.UnregisterBrokerResponse;
import org.apache.kafka.common.requests.UpdateFeaturesRequest;
import org.apache.kafka.common.requests.UpdateFeaturesResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.ConfigUtils;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.ProducerIdAndEpoch;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;

@InterfaceStability.Evolving
public class KafkaAdminClient
extends AdminClient
implements CloudAdmin {
    private static final AtomicInteger ADMIN_CLIENT_ID_SEQUENCE = new AtomicInteger(1);
    private static final String JMX_PREFIX = "kafka.admin.client";
    private static final long INVALID_SHUTDOWN_TIME = -1L;
    static final String DEFAULT_LEAVE_GROUP_REASON = "member was removed by an admin";
    static final String NETWORK_THREAD_PREFIX = "kafka-admin-client-thread";
    private final Logger log;
    private final LogContext logContext;
    private final int defaultApiTimeoutMs;
    private final int requestTimeoutMs;
    private final String clientId;
    private final Time time;
    private final AdminMetadataManager metadataManager;
    final Metrics metrics;
    private final KafkaClient client;
    private final AdminClientRunnable runnable;
    private final Thread thread;
    private final AtomicLong hardShutdownTimeMs = new AtomicLong(-1L);
    private final TimeoutProcessorFactory timeoutProcessorFactory;
    private final int maxRetries;
    private final long retryBackoffMs;
    private final long retryBackoffMaxMs;
    private final ExponentialBackoff retryBackoff;
    private final boolean clientTelemetryEnabled;
    private final MetadataRecoveryStrategy metadataRecoveryStrategy;
    private Uuid clientInstanceId;
    private final AdminRequestInterceptor.Factory interceptorFactory;

    static <K, V> List<V> getOrCreateListValue(Map<K, List<V>> map, K key) {
        return map.computeIfAbsent(key, k -> new LinkedList());
    }

    private static <T> void completeAllExceptionally(Collection<KafkaFutureImpl<T>> futures, Throwable exc) {
        KafkaAdminClient.completeAllExceptionally(futures.stream(), exc);
    }

    private static <T> void completeAllExceptionally(Stream<KafkaFutureImpl<T>> futures, Throwable exc) {
        futures.forEach(future -> future.completeExceptionally(exc));
    }

    static int calcTimeoutMsRemainingAsInt(long now, long deadlineMs) {
        long deltaMs = deadlineMs - now;
        if (deltaMs > Integer.MAX_VALUE) {
            deltaMs = Integer.MAX_VALUE;
        } else if (deltaMs < Integer.MIN_VALUE) {
            deltaMs = Integer.MIN_VALUE;
        }
        return (int)deltaMs;
    }

    static String generateClientId(AdminClientConfig config) {
        String clientId = config.getString("client.id");
        if (!clientId.isEmpty()) {
            return clientId;
        }
        return "adminclient-" + ADMIN_CLIENT_ID_SEQUENCE.getAndIncrement();
    }

    String getClientId() {
        return this.clientId;
    }

    private long calcDeadlineMs(long now, Integer optionTimeoutMs) {
        if (optionTimeoutMs != null) {
            return now + (long)Math.max(0, optionTimeoutMs);
        }
        return now + (long)this.defaultApiTimeoutMs;
    }

    static String prettyPrintException(Throwable throwable) {
        if (throwable == null) {
            return "Null exception.";
        }
        if (throwable.getMessage() != null) {
            return throwable.getClass().getSimpleName() + ": " + throwable.getMessage();
        }
        return throwable.getClass().getSimpleName();
    }

    static KafkaAdminClient createInternal(AdminClientConfig config, TimeoutProcessorFactory timeoutProcessorFactory) {
        return KafkaAdminClient.createInternal(config, timeoutProcessorFactory, null);
    }

    static KafkaAdminClient createInternal(AdminClientConfig config, TimeoutProcessorFactory timeoutProcessorFactory, HostResolver hostResolver) {
        return KafkaAdminClient.createInternal(config, timeoutProcessorFactory, hostResolver, null, null);
    }

    static KafkaAdminClient createInternalWithCallback(AdminClientConfig config, RequestCallback requestCallback, ProxyProtocolEngineFactory proxyProtocolEngineFactory) {
        return KafkaAdminClient.createInternal(config, null, null, requestCallback, proxyProtocolEngineFactory);
    }

    static KafkaAdminClient createInternal(AdminClientConfig config, TimeoutProcessorFactory timeoutProcessorFactory, HostResolver hostResolver, RequestCallback requestCallback, ProxyProtocolEngineFactory proxyProtocolEngineFactory) {
        Metrics metrics = null;
        NetworkClient networkClient = null;
        Time time = Time.SYSTEM;
        ChannelBuilder channelBuilder = null;
        Selector selector = null;
        String clientId = KafkaAdminClient.generateClientId(config);
        ApiVersions apiVersions = new ApiVersions();
        LogContext logContext = KafkaAdminClient.createLogContext(clientId);
        try {
            AdminBootstrapAddresses adminAddresses = AdminBootstrapAddresses.fromConfig(config);
            AdminMetadataManager metadataManager = new AdminMetadataManager(logContext, config.getLong("retry.backoff.ms"), config.getLong("metadata.max.age.ms"), adminAddresses.usingBootstrapControllers());
            metadataManager.update(Cluster.bootstrap(adminAddresses.addresses()), time.milliseconds());
            List<MetricsReporter> reporters = CommonClientConfigs.metricsReporters(clientId, (AbstractConfig)config);
            Map<String, String> metricTags = Collections.singletonMap("client-id", clientId);
            MetricConfig metricConfig = new MetricConfig().samples(config.getInt("metrics.num.samples")).timeWindow(config.getLong("metrics.sample.window.ms"), TimeUnit.MILLISECONDS).recordLevel(Sensor.RecordingLevel.forName(config.getString("metrics.recording.level"))).tags(metricTags);
            KafkaMetricsContext metricsContext = new KafkaMetricsContext(JMX_PREFIX, config.originalsWithPrefix("metrics.context."));
            metrics = new Metrics(metricConfig, reporters, time, metricsContext);
            String metricGrpPrefix = "admin-client";
            channelBuilder = ClientUtils.createChannelBuilder(config, time, logContext, requestCallback, proxyProtocolEngineFactory);
            selector = new Selector(config.getLong("connections.max.idle.ms"), metrics, time, metricGrpPrefix, channelBuilder, logContext);
            HostResolver defaultHostResolver = (HostResolver)config.getClass("host.resolver.class").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            MetadataRecoveryStrategy metadataRecoveryStrategy = MetadataRecoveryStrategy.forName(config.getString("metadata.recovery.strategy"));
            networkClient = new NetworkClient(metadataManager.updater(), null, selector, clientId, 1, config.getLong("reconnect.backoff.ms"), config.getLong("reconnect.backoff.max.ms"), config.getInt("send.buffer.bytes"), config.getInt("receive.buffer.bytes"), (int)TimeUnit.HOURS.toMillis(1L), config.getLong("socket.connection.setup.timeout.ms"), config.getLong("socket.connection.setup.timeout.max.ms"), time, true, apiVersions, null, logContext, hostResolver == null ? defaultHostResolver : hostResolver, null, metadataRecoveryStrategy);
            return new KafkaAdminClient(config, clientId, time, metadataManager, metrics, networkClient, timeoutProcessorFactory, logContext, null);
        }
        catch (Throwable exc) {
            Utils.closeQuietly(channelBuilder, "channelBuilder");
            Utils.closeQuietly(selector, "selector");
            Utils.closeQuietly(metrics, "Metrics");
            Utils.closeQuietly(networkClient, "NetworkClient");
            throw new KafkaException("Failed to create new KafkaAdminClient", exc);
        }
    }

    static KafkaAdminClient createInternal(AdminClientConfig config, AdminMetadataManager metadataManager, KafkaClient client, Time time, AdminRequestInterceptor.Factory interceptorFactory) {
        Metrics metrics = null;
        String clientId = KafkaAdminClient.generateClientId(config);
        try {
            metrics = new Metrics(new MetricConfig(), new LinkedList<MetricsReporter>(), time);
            LogContext logContext = KafkaAdminClient.createLogContext(clientId);
            return new KafkaAdminClient(config, clientId, time, metadataManager, metrics, client, null, logContext, interceptorFactory);
        }
        catch (Throwable exc) {
            Utils.closeQuietly(metrics, "Metrics");
            throw new KafkaException("Failed to create new KafkaAdminClient", exc);
        }
    }

    static LogContext createLogContext(String clientId) {
        return new LogContext("[AdminClient clientId=" + clientId + "] ");
    }

    private KafkaAdminClient(AdminClientConfig config, String clientId, Time time, AdminMetadataManager metadataManager, Metrics metrics, KafkaClient client, TimeoutProcessorFactory timeoutProcessorFactory, LogContext logContext, AdminRequestInterceptor.Factory interceptorFactory) {
        this.clientId = clientId;
        this.log = logContext.logger(KafkaAdminClient.class);
        this.logContext = logContext;
        this.requestTimeoutMs = config.getInt("request.timeout.ms");
        this.defaultApiTimeoutMs = this.configureDefaultApiTimeoutMs(config);
        this.time = time;
        this.metadataManager = metadataManager;
        this.metrics = metrics;
        this.client = client;
        this.interceptorFactory = interceptorFactory != null ? interceptorFactory : AdminRequestInterceptor.Factory.DEFAULT_INTERCEPTOR_FACTORY;
        this.runnable = new AdminClientRunnable();
        String threadName = "kafka-admin-client-thread | " + clientId;
        this.thread = new KafkaThread(threadName, (Runnable)this.runnable, true);
        this.timeoutProcessorFactory = timeoutProcessorFactory == null ? new TimeoutProcessorFactory() : timeoutProcessorFactory;
        this.maxRetries = config.getInt("retries");
        this.retryBackoffMs = config.getLong("retry.backoff.ms");
        this.retryBackoffMaxMs = config.getLong("retry.backoff.max.ms");
        this.retryBackoff = new ExponentialBackoff(this.retryBackoffMs, 2, this.retryBackoffMaxMs, 0.2);
        this.clientTelemetryEnabled = config.getBoolean("enable.metrics.push");
        this.metadataRecoveryStrategy = MetadataRecoveryStrategy.forName(config.getString("metadata.recovery.strategy"));
        config.logUnused();
        AppInfoParser.registerAppInfo(JMX_PREFIX, clientId, metrics, time.milliseconds(), ConfigUtils.getDoLog(config));
        this.log.debug("Kafka admin client initialized");
        this.thread.start();
    }

    private int configureDefaultApiTimeoutMs(AdminClientConfig config) {
        int requestTimeoutMs = config.getInt("request.timeout.ms");
        int defaultApiTimeoutMs = config.getInt("default.api.timeout.ms");
        if (defaultApiTimeoutMs < requestTimeoutMs) {
            if (config.originals().containsKey("default.api.timeout.ms")) {
                throw new ConfigException("The specified value of default.api.timeout.ms must be no smaller than the value of request.timeout.ms.");
            }
            this.log.warn("Overriding the default value for {} ({}) with the explicitly configured request timeout {}", new Object[]{"default.api.timeout.ms", this.defaultApiTimeoutMs, requestTimeoutMs});
            return requestTimeoutMs;
        }
        return defaultApiTimeoutMs;
    }

    @Override
    public void close(Duration timeout) {
        long newHardShutdownTimeMs;
        long waitTimeMs;
        block8: {
            waitTimeMs = timeout.toMillis();
            if (waitTimeMs < 0L) {
                throw new IllegalArgumentException("The timeout cannot be negative.");
            }
            waitTimeMs = Math.min(TimeUnit.DAYS.toMillis(365L), waitTimeMs);
            long now = this.time.milliseconds();
            newHardShutdownTimeMs = now + waitTimeMs;
            long prev = -1L;
            do {
                if (!this.hardShutdownTimeMs.compareAndSet(prev, newHardShutdownTimeMs)) continue;
                if (prev == -1L) {
                    this.log.debug("Initiating close operation.");
                } else {
                    this.log.debug("Moving hard shutdown time forward.");
                }
                this.client.wakeup();
                break block8;
            } while ((prev = this.hardShutdownTimeMs.get()) >= newHardShutdownTimeMs);
            this.log.debug("Hard shutdown time is already earlier than requested.");
            newHardShutdownTimeMs = prev;
        }
        if (this.log.isDebugEnabled()) {
            long deltaMs = Math.max(0L, newHardShutdownTimeMs - this.time.milliseconds());
            this.log.debug("Waiting for the I/O thread to exit. Hard shutdown in {} ms.", (Object)deltaMs);
        }
        try {
            if (Thread.currentThread() != this.thread) {
                this.thread.join(waitTimeMs);
            }
            this.log.debug("Kafka admin client closed.");
        }
        catch (InterruptedException e) {
            this.log.debug("Interrupted while joining I/O thread", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    static Cluster parseDescribeClusterResponse(DescribeClusterResponseData response) {
        ApiError apiError = new ApiError(response.errorCode(), response.errorMessage());
        if (apiError.isFailure()) {
            throw apiError.exception();
        }
        if (response.endpointType() != EndpointType.CONTROLLER.id()) {
            throw new MismatchedEndpointTypeException("Expected response from CONTROLLER endpoint, but got response from endpoint type " + response.endpointType());
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        Node controllerNode = null;
        for (DescribeClusterResponseData.DescribeClusterBroker node : response.brokers()) {
            Node newNode = new Node(node.brokerId(), node.host(), node.port(), node.rack());
            nodes.add(newNode);
            if (node.brokerId() != response.controllerId()) continue;
            controllerNode = newNode;
        }
        return new Cluster(response.clusterId(), nodes, Collections.emptyList(), Collections.emptySet(), Collections.emptySet(), controllerNode);
    }

    private static boolean topicNameIsUnrepresentable(String topicName) {
        return topicName == null || topicName.isEmpty();
    }

    private static boolean topicIdIsUnrepresentable(Uuid topicId) {
        return topicId == null || topicId.equals(Uuid.ZERO_UUID);
    }

    int numPendingCalls() {
        return this.runnable.pendingCalls.size();
    }

    private static <K, V> void completeUnrealizedFutures(Stream<Map.Entry<K, KafkaFutureImpl<V>>> futures, Function<K, String> messageFormatter) {
        futures.filter(entry -> !((KafkaFutureImpl)entry.getValue()).isDone()).forEach(entry -> ((KafkaFutureImpl)entry.getValue()).completeExceptionally(new ApiException((String)messageFormatter.apply(entry.getKey()))));
    }

    private static <K, V> void maybeCompleteQuotaExceededException(boolean shouldRetryOnQuotaViolation, Throwable throwable, Map<K, KafkaFutureImpl<V>> futures, Map<K, ThrottlingQuotaExceededException> quotaExceededExceptions, int throttleTimeDelta) {
        if (shouldRetryOnQuotaViolation && throwable instanceof TimeoutException) {
            quotaExceededExceptions.forEach((key, value) -> ((KafkaFutureImpl)futures.get(key)).completeExceptionally(new ThrottlingQuotaExceededException(Math.max(0, value.throttleTimeMs() - throttleTimeDelta), value.getMessage())));
        }
    }

    @Override
    public CreateTopicsResult createTopics(Collection<NewTopic> newTopics, CreateTopicsOptions options) {
        HashMap<String, KafkaFutureImpl<CreateTopicsResult.TopicMetadataAndConfig>> topicFutures = new HashMap<String, KafkaFutureImpl<CreateTopicsResult.TopicMetadataAndConfig>>(newTopics.size());
        CreateTopicsRequestData.CreatableTopicCollection topics = new CreateTopicsRequestData.CreatableTopicCollection();
        for (NewTopic newTopic : newTopics) {
            if (KafkaAdminClient.topicNameIsUnrepresentable(newTopic.name())) {
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally(new InvalidTopicException("The given topic name '" + newTopic.name() + "' cannot be represented in a request."));
                topicFutures.put(newTopic.name(), future);
                continue;
            }
            if (topicFutures.containsKey(newTopic.name())) continue;
            topicFutures.put(newTopic.name(), new KafkaFutureImpl());
            topics.add(newTopic.convertToCreatableTopic());
        }
        if (!topics.isEmpty()) {
            long now = this.time.milliseconds();
            long deadline = this.calcDeadlineMs(now, options.timeoutMs());
            Call call = this.getCreateTopicsCall(options, topicFutures, topics, Collections.emptyMap(), now, deadline);
            this.runnable.call(call, now);
        }
        return new CreateTopicsResult(new HashMap<String, KafkaFuture<CreateTopicsResult.TopicMetadataAndConfig>>(topicFutures));
    }

    private Call getCreateTopicsCall(final CreateTopicsOptions options, final Map<String, KafkaFutureImpl<CreateTopicsResult.TopicMetadataAndConfig>> futures, final CreateTopicsRequestData.CreatableTopicCollection topics, final Map<String, ThrottlingQuotaExceededException> quotaExceededExceptions, final long now, final long deadline) {
        return new Call("createTopics", deadline, new ControllerNodeProvider()){

            public CreateTopicsRequest.Builder createRequest(int timeoutMs) {
                return new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTopics(topics).setTimeoutMs(timeoutMs).setValidateOnly(options.shouldValidateOnly()));
            }

            @Override
            public void handleResponse(AbstractResponse abstractResponse) {
                KafkaAdminClient.this.handleNotControllerError(abstractResponse);
                CreateTopicsResponse response = (CreateTopicsResponse)abstractResponse;
                CreateTopicsRequestData.CreatableTopicCollection retryTopics = new CreateTopicsRequestData.CreatableTopicCollection();
                HashMap<String, ThrottlingQuotaExceededException> retryTopicQuotaExceededExceptions = new HashMap<String, ThrottlingQuotaExceededException>();
                for (CreateTopicsResponseData.CreatableTopicResult result : response.data().topics()) {
                    CreateTopicsResult.TopicMetadataAndConfig topicMetadataAndConfig;
                    KafkaFutureImpl future = (KafkaFutureImpl)futures.get(result.name());
                    if (future == null) {
                        KafkaAdminClient.this.log.warn("Server response mentioned unknown topic {}", (Object)result.name());
                        continue;
                    }
                    ApiError error = new ApiError(result.errorCode(), result.errorMessage());
                    if (error.isFailure()) {
                        if (error.is(Errors.THROTTLING_QUOTA_EXCEEDED)) {
                            ThrottlingQuotaExceededException quotaExceededException = new ThrottlingQuotaExceededException(response.throttleTimeMs(), error.messageWithFallback());
                            if (options.shouldRetryOnQuotaViolation()) {
                                retryTopics.add(topics.find(result.name()).duplicate());
                                retryTopicQuotaExceededExceptions.put(result.name(), quotaExceededException);
                                continue;
                            }
                            future.completeExceptionally(quotaExceededException);
                            continue;
                        }
                        future.completeExceptionally(error.exception());
                        continue;
                    }
                    if (result.topicConfigErrorCode() != Errors.NONE.code()) {
                        topicMetadataAndConfig = new CreateTopicsResult.TopicMetadataAndConfig(Errors.forCode(result.topicConfigErrorCode()).exception());
                    } else if (result.numPartitions() == -1) {
                        topicMetadataAndConfig = new CreateTopicsResult.TopicMetadataAndConfig(new UnsupportedVersionException("Topic metadata and configs in CreateTopics response not supported"));
                    } else {
                        List<CreateTopicsResponseData.CreatableTopicConfigs> configs = result.configs();
                        Config topicConfig = new Config(configs.stream().map(this::configEntry).collect(Collectors.toSet()));
                        topicMetadataAndConfig = new CreateTopicsResult.TopicMetadataAndConfig(result.topicId(), result.numPartitions(), result.replicationFactor(), topicConfig);
                    }
                    future.complete(topicMetadataAndConfig);
                }
                if (retryTopics.isEmpty()) {
                    KafkaAdminClient.completeUnrealizedFutures(futures.entrySet().stream(), topic -> "The controller response did not contain a result for topic " + topic);
                } else {
                    long now2 = KafkaAdminClient.this.time.milliseconds();
                    Call call = KafkaAdminClient.this.getCreateTopicsCall(options, futures, retryTopics, retryTopicQuotaExceededExceptions, now2, deadline);
                    KafkaAdminClient.this.runnable.call(call, now2);
                }
            }

            private ConfigEntry configEntry(CreateTopicsResponseData.CreatableTopicConfigs config) {
                return new ConfigEntry(config.configName(), config.value(), KafkaAdminClient.this.configSource(DescribeConfigsResponse.ConfigSource.forId(config.configSource())), config.isSensitive(), config.readOnly(), Collections.emptyList(), null, null);
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.maybeCompleteQuotaExceededException(options.shouldRetryOnQuotaViolation(), throwable, futures, quotaExceededExceptions, (int)(KafkaAdminClient.this.time.milliseconds() - now));
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        };
    }

    @Override
    public DeleteTopicsResult deleteTopics(TopicCollection topics, DeleteTopicsOptions options) {
        if (topics instanceof TopicCollection.TopicIdCollection) {
            return DeleteTopicsResult.ofTopicIds(this.handleDeleteTopicsUsingIds(((TopicCollection.TopicIdCollection)topics).topicIds(), options));
        }
        if (topics instanceof TopicCollection.TopicNameCollection) {
            return DeleteTopicsResult.ofTopicNames(this.handleDeleteTopicsUsingNames(((TopicCollection.TopicNameCollection)topics).topicNames(), options));
        }
        throw new IllegalArgumentException("The TopicCollection: " + topics + " provided did not match any supported classes for deleteTopics.");
    }

    private Map<String, KafkaFuture<Void>> handleDeleteTopicsUsingNames(Collection<String> topicNames, DeleteTopicsOptions options) {
        HashMap<String, KafkaFutureImpl<Void>> topicFutures = new HashMap<String, KafkaFutureImpl<Void>>(topicNames.size());
        ArrayList<String> validTopicNames = new ArrayList<String>(topicNames.size());
        for (String topicName : topicNames) {
            if (KafkaAdminClient.topicNameIsUnrepresentable(topicName)) {
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally(new InvalidTopicException("The given topic name '" + topicName + "' cannot be represented in a request."));
                topicFutures.put(topicName, future);
                continue;
            }
            if (topicFutures.containsKey(topicName)) continue;
            topicFutures.put(topicName, new KafkaFutureImpl());
            validTopicNames.add(topicName);
        }
        if (!validTopicNames.isEmpty()) {
            long now = this.time.milliseconds();
            long deadline = this.calcDeadlineMs(now, options.timeoutMs());
            Call call = this.getDeleteTopicsCall(options, topicFutures, validTopicNames, Collections.emptyMap(), now, deadline);
            this.runnable.call(call, now);
        }
        return new HashMap<String, KafkaFuture<Void>>(topicFutures);
    }

    private Map<Uuid, KafkaFuture<Void>> handleDeleteTopicsUsingIds(Collection<Uuid> topicIds, DeleteTopicsOptions options) {
        HashMap<Uuid, KafkaFutureImpl<Void>> topicFutures = new HashMap<Uuid, KafkaFutureImpl<Void>>(topicIds.size());
        ArrayList<Uuid> validTopicIds = new ArrayList<Uuid>(topicIds.size());
        for (Uuid topicId : topicIds) {
            if (topicId.equals(Uuid.ZERO_UUID)) {
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally(new InvalidTopicException("The given topic ID '" + topicId + "' cannot be represented in a request."));
                topicFutures.put(topicId, future);
                continue;
            }
            if (topicFutures.containsKey(topicId)) continue;
            topicFutures.put(topicId, new KafkaFutureImpl());
            validTopicIds.add(topicId);
        }
        if (!validTopicIds.isEmpty()) {
            long now = this.time.milliseconds();
            long deadline = this.calcDeadlineMs(now, options.timeoutMs());
            Call call = this.getDeleteTopicsWithIdsCall(options, topicFutures, validTopicIds, Collections.emptyMap(), now, deadline);
            this.runnable.call(call, now);
        }
        return new HashMap<Uuid, KafkaFuture<Void>>(topicFutures);
    }

    private Call getDeleteTopicsCall(final DeleteTopicsOptions options, final Map<String, KafkaFutureImpl<Void>> futures, final List<String> topics, final Map<String, ThrottlingQuotaExceededException> quotaExceededExceptions, final long now, final long deadline) {
        return new Call("deleteTopics", deadline, new ControllerNodeProvider()){

            DeleteTopicsRequest.Builder createRequest(int timeoutMs) {
                return new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(topics).setTimeoutMs(timeoutMs));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                KafkaAdminClient.this.handleNotControllerError(abstractResponse);
                DeleteTopicsResponse response = (DeleteTopicsResponse)abstractResponse;
                ArrayList<String> retryTopics = new ArrayList<String>();
                HashMap<String, ThrottlingQuotaExceededException> retryTopicQuotaExceededExceptions = new HashMap<String, ThrottlingQuotaExceededException>();
                for (DeleteTopicsResponseData.DeletableTopicResult result : response.data().responses()) {
                    KafkaFutureImpl future = (KafkaFutureImpl)futures.get(result.name());
                    if (future == null) {
                        KafkaAdminClient.this.log.warn("Server response mentioned unknown topic {}", (Object)result.name());
                        continue;
                    }
                    ApiError error = new ApiError(result.errorCode(), result.errorMessage());
                    if (error.isFailure()) {
                        if (error.is(Errors.THROTTLING_QUOTA_EXCEEDED)) {
                            ThrottlingQuotaExceededException quotaExceededException = new ThrottlingQuotaExceededException(response.throttleTimeMs(), error.messageWithFallback());
                            if (options.shouldRetryOnQuotaViolation()) {
                                retryTopics.add(result.name());
                                retryTopicQuotaExceededExceptions.put(result.name(), quotaExceededException);
                                continue;
                            }
                            future.completeExceptionally(quotaExceededException);
                            continue;
                        }
                        future.completeExceptionally(error.exception());
                        continue;
                    }
                    future.complete(null);
                }
                if (retryTopics.isEmpty()) {
                    KafkaAdminClient.completeUnrealizedFutures(futures.entrySet().stream(), topic -> "The controller response did not contain a result for topic " + topic);
                } else {
                    long now2 = KafkaAdminClient.this.time.milliseconds();
                    Call call = KafkaAdminClient.this.getDeleteTopicsCall(options, futures, retryTopics, retryTopicQuotaExceededExceptions, now2, deadline);
                    KafkaAdminClient.this.runnable.call(call, now2);
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.maybeCompleteQuotaExceededException(options.shouldRetryOnQuotaViolation(), throwable, futures, quotaExceededExceptions, (int)(KafkaAdminClient.this.time.milliseconds() - now));
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        };
    }

    private Call getDeleteTopicsWithIdsCall(final DeleteTopicsOptions options, final Map<Uuid, KafkaFutureImpl<Void>> futures, final List<Uuid> topicIds, final Map<Uuid, ThrottlingQuotaExceededException> quotaExceededExceptions, final long now, final long deadline) {
        return new Call("deleteTopics", deadline, new ControllerNodeProvider()){

            DeleteTopicsRequest.Builder createRequest(int timeoutMs) {
                return new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopics(topicIds.stream().map(topic -> new DeleteTopicsRequestData.DeleteTopicState().setTopicId((Uuid)topic)).collect(Collectors.toList())).setTimeoutMs(timeoutMs));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                KafkaAdminClient.this.handleNotControllerError(abstractResponse);
                DeleteTopicsResponse response = (DeleteTopicsResponse)abstractResponse;
                ArrayList<Uuid> retryTopics = new ArrayList<Uuid>();
                HashMap<Uuid, ThrottlingQuotaExceededException> retryTopicQuotaExceededExceptions = new HashMap<Uuid, ThrottlingQuotaExceededException>();
                for (DeleteTopicsResponseData.DeletableTopicResult result : response.data().responses()) {
                    KafkaFutureImpl future = (KafkaFutureImpl)futures.get(result.topicId());
                    if (future == null) {
                        KafkaAdminClient.this.log.warn("Server response mentioned unknown topic ID {}", (Object)result.topicId());
                        continue;
                    }
                    ApiError error = new ApiError(result.errorCode(), result.errorMessage());
                    if (error.isFailure()) {
                        if (error.is(Errors.THROTTLING_QUOTA_EXCEEDED)) {
                            ThrottlingQuotaExceededException quotaExceededException = new ThrottlingQuotaExceededException(response.throttleTimeMs(), error.messageWithFallback());
                            if (options.shouldRetryOnQuotaViolation()) {
                                retryTopics.add(result.topicId());
                                retryTopicQuotaExceededExceptions.put(result.topicId(), quotaExceededException);
                                continue;
                            }
                            future.completeExceptionally(quotaExceededException);
                            continue;
                        }
                        future.completeExceptionally(error.exception());
                        continue;
                    }
                    future.complete(null);
                }
                if (retryTopics.isEmpty()) {
                    KafkaAdminClient.completeUnrealizedFutures(futures.entrySet().stream(), topic -> "The controller response did not contain a result for topic " + topic);
                } else {
                    long now2 = KafkaAdminClient.this.time.milliseconds();
                    Call call = KafkaAdminClient.this.getDeleteTopicsWithIdsCall(options, futures, retryTopics, retryTopicQuotaExceededExceptions, now2, deadline);
                    KafkaAdminClient.this.runnable.call(call, now2);
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.maybeCompleteQuotaExceededException(options.shouldRetryOnQuotaViolation(), throwable, futures, quotaExceededExceptions, (int)(KafkaAdminClient.this.time.milliseconds() - now));
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        };
    }

    @Override
    public ListTopicsResult listTopics(final ListTopicsOptions options) {
        final KafkaFutureImpl<Map<String, TopicListing>> topicListingFuture = new KafkaFutureImpl<Map<String, TopicListing>>();
        long now = this.time.milliseconds();
        this.runnable.call(new Call("listTopics", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            MetadataRequest.Builder createRequest(int timeoutMs) {
                return MetadataRequest.Builder.allTopics();
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                MetadataResponse response = (MetadataResponse)abstractResponse;
                HashMap<String, TopicListing> topicListing = new HashMap<String, TopicListing>();
                for (MetadataResponse.TopicMetadata topicMetadata : response.topicMetadata()) {
                    String topicName = topicMetadata.topic();
                    boolean isInternal = topicMetadata.isInternal();
                    if (topicMetadata.isInternal() && !options.shouldListInternal()) continue;
                    topicListing.put(topicName, new TopicListing(topicName, topicMetadata.topicId(), isInternal, topicMetadata.topicType()));
                }
                topicListingFuture.complete(topicListing);
            }

            @Override
            void handleFailure(Throwable throwable) {
                topicListingFuture.completeExceptionally(throwable);
            }
        }, now);
        return new ListTopicsResult(topicListingFuture);
    }

    @Override
    public DescribeTopicsResult describeTopics(TopicCollection topics, DescribeTopicsOptions options) {
        if (topics instanceof TopicCollection.TopicIdCollection) {
            return DescribeTopicsResult.ofTopicIds(this.handleDescribeTopicsByIds(((TopicCollection.TopicIdCollection)topics).topicIds(), options));
        }
        if (topics instanceof TopicCollection.TopicNameCollection) {
            return DescribeTopicsResult.ofTopicNames(this.handleDescribeTopicsByNamesWithDescribeTopicPartitionsApi(((TopicCollection.TopicNameCollection)topics).topicNames(), options));
        }
        throw new IllegalArgumentException("The TopicCollection: " + topics + " provided did not match any supported classes for describeTopics.");
    }

    private Call generateDescribeTopicsCallWithMetadataApi(final List<String> topicNamesList, final Map<String, KafkaFutureImpl<TopicDescription>> topicFutures, final DescribeTopicsOptions options, long now) {
        return new Call("describeTopics", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){
            private boolean supportsDisablingTopicCreation;
            {
                super(callName, deadlineMs, nodeProvider);
                this.supportsDisablingTopicCreation = true;
            }

            MetadataRequest.Builder createRequest(int timeoutMs) {
                if (this.supportsDisablingTopicCreation) {
                    return new MetadataRequest.Builder(new MetadataRequestData().setTopics(MetadataRequest.convertToMetadataRequestTopic(topicNamesList)).setAllowAutoTopicCreation(false).setIncludeTopicAuthorizedOperations(options.includeAuthorizedOperations()));
                }
                return MetadataRequest.Builder.allTopics();
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                MetadataResponse response = (MetadataResponse)abstractResponse;
                Cluster cluster = response.buildCluster();
                Map<String, Errors> errors = response.errors();
                for (Map.Entry entry : topicFutures.entrySet()) {
                    String topicName = (String)entry.getKey();
                    KafkaFutureImpl future = (KafkaFutureImpl)entry.getValue();
                    Errors topicError = errors.get(topicName);
                    if (topicError != null) {
                        future.completeExceptionally(topicError.exception());
                        continue;
                    }
                    if (!cluster.topics().contains(topicName)) {
                        future.completeExceptionally(new UnknownTopicOrPartitionException("Topic " + topicName + " not found."));
                        continue;
                    }
                    Uuid topicId = cluster.topicId(topicName);
                    Integer authorizedOperations = response.topicAuthorizedOperations(topicName).get();
                    TopicDescription topicDescription = KafkaAdminClient.this.getTopicDescriptionFromCluster(cluster, topicName, topicId, authorizedOperations);
                    future.complete(topicDescription);
                }
            }

            @Override
            boolean handleUnsupportedVersionException(UnsupportedVersionException exception) {
                if (this.supportsDisablingTopicCreation) {
                    this.supportsDisablingTopicCreation = false;
                    return true;
                }
                return false;
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(topicFutures.values(), throwable);
            }
        };
    }

    private Call generateDescribeTopicsCallWithDescribeTopicPartitionsApi(final List<String> topicNamesList, final Map<String, KafkaFutureImpl<TopicDescription>> topicFutures, final Map<Integer, Node> nodes, final DescribeTopicsOptions options, long now) {
        final LinkedHashMap topicsRequests = new LinkedHashMap();
        topicNamesList.stream().sorted().forEach(topic -> topicsRequests.put(topic, new DescribeTopicPartitionsRequestData.TopicRequest().setName((String)topic)));
        return new Call("describeTopicPartitions", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){
            TopicDescription partiallyFinishedTopicDescription;
            {
                super(callName, deadlineMs, nodeProvider);
                this.partiallyFinishedTopicDescription = null;
            }

            DescribeTopicPartitionsRequest.Builder createRequest(int timeoutMs) {
                DescribeTopicPartitionsRequestData request = new DescribeTopicPartitionsRequestData().setTopics(new ArrayList<DescribeTopicPartitionsRequestData.TopicRequest>(topicsRequests.values())).setResponsePartitionLimit(options.partitionSizeLimitPerResponse());
                if (this.partiallyFinishedTopicDescription != null) {
                    request.setCursor(new DescribeTopicPartitionsRequestData.Cursor().setTopicName(this.partiallyFinishedTopicDescription.name()).setPartitionIndex(this.partiallyFinishedTopicDescription.partitions().size()));
                }
                return new DescribeTopicPartitionsRequest.Builder(request);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DescribeTopicPartitionsResponse response = (DescribeTopicPartitionsResponse)abstractResponse;
                DescribeTopicPartitionsResponseData.Cursor responseCursor = response.data().nextCursor();
                TopicDescription nextTopicDescription = null;
                for (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic topic : response.data().topics()) {
                    String topicName = topic.name();
                    Errors error = Errors.forCode(topic.errorCode());
                    KafkaFutureImpl future = (KafkaFutureImpl)topicFutures.get(topicName);
                    if (error != Errors.NONE) {
                        future.completeExceptionally(error.exception());
                        topicsRequests.remove(topicName);
                        if (responseCursor == null || !responseCursor.topicName().equals(topicName)) continue;
                        responseCursor = null;
                        continue;
                    }
                    TopicDescription currentTopicDescription = KafkaAdminClient.this.getTopicDescriptionFromDescribeTopicsResponseTopic(topic, nodes, options.includeAuthorizedOperations());
                    if (this.partiallyFinishedTopicDescription != null && this.partiallyFinishedTopicDescription.name().equals(topicName)) {
                        this.partiallyFinishedTopicDescription.partitions().addAll(currentTopicDescription.partitions());
                        continue;
                    }
                    if (responseCursor != null && responseCursor.topicName().equals(topicName)) {
                        nextTopicDescription = currentTopicDescription;
                        continue;
                    }
                    topicsRequests.remove(topicName);
                    future.complete(currentTopicDescription);
                }
                if (!(this.partiallyFinishedTopicDescription == null || responseCursor != null && responseCursor.topicName().equals(this.partiallyFinishedTopicDescription.name()))) {
                    String topicName = this.partiallyFinishedTopicDescription.name();
                    ((KafkaFutureImpl)topicFutures.get(topicName)).complete(this.partiallyFinishedTopicDescription);
                    topicsRequests.remove(topicName);
                    this.partiallyFinishedTopicDescription = null;
                }
                if (nextTopicDescription != null) {
                    this.partiallyFinishedTopicDescription = nextTopicDescription;
                }
                if (!topicsRequests.isEmpty()) {
                    KafkaAdminClient.this.runnable.call(this, KafkaAdminClient.this.time.milliseconds());
                }
            }

            @Override
            boolean handleUnsupportedVersionException(UnsupportedVersionException exception) {
                long now = KafkaAdminClient.this.time.milliseconds();
                KafkaAdminClient.this.log.info("The DescribeTopicPartitions API is not supported, using Metadata API to describe topics.");
                KafkaAdminClient.this.runnable.call(KafkaAdminClient.this.generateDescribeTopicsCallWithMetadataApi(topicNamesList, topicFutures, options, now), now);
                return false;
            }

            @Override
            void handleFailure(Throwable throwable) {
                if (!(throwable instanceof UnsupportedVersionException)) {
                    KafkaAdminClient.completeAllExceptionally(topicFutures.values(), throwable);
                }
            }
        };
    }

    private Map<String, KafkaFuture<TopicDescription>> handleDescribeTopicsByNamesWithDescribeTopicPartitionsApi(Collection<String> topicNames, DescribeTopicsOptions options) {
        HashMap topicFutures = new HashMap(topicNames.size());
        ArrayList<String> topicNamesList = new ArrayList<String>();
        for (String topicName : topicNames) {
            if (KafkaAdminClient.topicNameIsUnrepresentable(topicName)) {
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally(new InvalidTopicException("The given topic name '" + topicName + "' cannot be represented in a request."));
                topicFutures.put(topicName, future);
                continue;
            }
            if (topicFutures.containsKey(topicName)) continue;
            topicFutures.put(topicName, new KafkaFutureImpl());
            topicNamesList.add(topicName);
        }
        if (topicNamesList.isEmpty()) {
            return Collections.unmodifiableMap(topicFutures);
        }
        DescribeClusterResult clusterResult = this.describeCluster();
        clusterResult.nodes().whenComplete((nodes, exception) -> {
            if (exception != null) {
                KafkaAdminClient.completeAllExceptionally(topicFutures.values(), exception);
                return;
            }
            long now = this.time.milliseconds();
            Map<Integer, Node> nodeIdMap = nodes.stream().collect(Collectors.toMap(Node::id, node -> node));
            this.runnable.call(this.generateDescribeTopicsCallWithDescribeTopicPartitionsApi(topicNamesList, topicFutures, nodeIdMap, options, now), now);
        });
        return Collections.unmodifiableMap(topicFutures);
    }

    private Map<Uuid, KafkaFuture<TopicDescription>> handleDescribeTopicsByIds(Collection<Uuid> topicIds, final DescribeTopicsOptions options) {
        final HashMap topicFutures = new HashMap(topicIds.size());
        final ArrayList<Uuid> topicIdsList = new ArrayList<Uuid>();
        for (Uuid topicId : topicIds) {
            if (KafkaAdminClient.topicIdIsUnrepresentable(topicId)) {
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally(new InvalidTopicException("The given topic id '" + topicId + "' cannot be represented in a request."));
                topicFutures.put(topicId, future);
                continue;
            }
            if (topicFutures.containsKey(topicId)) continue;
            topicFutures.put(topicId, new KafkaFutureImpl());
            topicIdsList.add(topicId);
        }
        long now = this.time.milliseconds();
        Call call = new Call("describeTopicsWithIds", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            MetadataRequest.Builder createRequest(int timeoutMs) {
                return new MetadataRequest.Builder(new MetadataRequestData().setTopics(MetadataRequest.convertTopicIdsToMetadataRequestTopic(topicIdsList)).setAllowAutoTopicCreation(false).setIncludeTopicAuthorizedOperations(options.includeAuthorizedOperations()));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                MetadataResponse response = (MetadataResponse)abstractResponse;
                Cluster cluster = response.buildCluster();
                Map<Uuid, Errors> errors = response.errorsByTopicId();
                for (Map.Entry entry : topicFutures.entrySet()) {
                    Uuid topicId = (Uuid)entry.getKey();
                    KafkaFutureImpl future = (KafkaFutureImpl)entry.getValue();
                    String topicName = cluster.topicName(topicId);
                    if (topicName == null) {
                        future.completeExceptionally(new UnknownTopicIdException("TopicId " + topicId + " not found."));
                        continue;
                    }
                    Errors topicError = errors.get(topicId);
                    if (topicError != null) {
                        future.completeExceptionally(topicError.exception());
                        continue;
                    }
                    Integer authorizedOperations = response.topicAuthorizedOperations(topicName).get();
                    TopicDescription topicDescription = KafkaAdminClient.this.getTopicDescriptionFromCluster(cluster, topicName, topicId, authorizedOperations);
                    future.complete(topicDescription);
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(topicFutures.values(), throwable);
            }
        };
        if (!topicIdsList.isEmpty()) {
            this.runnable.call(call, now);
        }
        return new HashMap<Uuid, KafkaFuture<TopicDescription>>(topicFutures);
    }

    private TopicDescription getTopicDescriptionFromDescribeTopicsResponseTopic(DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic topic, Map<Integer, Node> nodes, boolean includeAuthorizedOperations) {
        List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition> partitionInfos = topic.partitions();
        ArrayList<TopicPartitionInfo> partitions = new ArrayList<TopicPartitionInfo>(partitionInfos.size());
        for (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition partitionInfo : partitionInfos) {
            partitions.add(DescribeTopicPartitionsResponse.partitionToTopicPartitionInfo(partitionInfo, nodes));
        }
        Set<AclOperation> authorisedOperations = includeAuthorizedOperations ? this.validAclOperations(topic.topicAuthorizedOperations()) : null;
        return new TopicDescription(topic.name(), topic.isInternal(), partitions, authorisedOperations, topic.topicId());
    }

    private TopicDescription getTopicDescriptionFromCluster(Cluster cluster, String topicName, Uuid topicId, Integer authorizedOperations) {
        boolean isInternal = cluster.internalTopics().contains(topicName);
        List<PartitionInfo> partitionInfos = cluster.partitionsForTopic(topicName);
        ArrayList<TopicPartitionInfo> partitions = new ArrayList<TopicPartitionInfo>(partitionInfos.size());
        for (PartitionInfo partitionInfo : partitionInfos) {
            TopicPartitionInfo topicPartitionInfo = TopicPartitionInfo.ofReplicasAndObservers(partitionInfo.partition(), this.leader(partitionInfo), Arrays.asList(partitionInfo.replicas()), Arrays.asList(partitionInfo.observers()), Arrays.asList(partitionInfo.inSyncReplicas()));
            partitions.add(topicPartitionInfo);
        }
        partitions.sort(Comparator.comparingInt(TopicPartitionInfo::partition));
        return new TopicDescription(topicName, isInternal, partitions, this.validAclOperations(authorizedOperations), topicId, cluster.topicType(topicName));
    }

    private Node leader(PartitionInfo partitionInfo) {
        if (partitionInfo.leader() == null || partitionInfo.leader().id() == Node.noNode().id()) {
            return null;
        }
        return partitionInfo.leader();
    }

    @Override
    public DescribeClusterResult describeCluster(final DescribeClusterOptions options) {
        final KafkaFutureImpl<Collection<Node>> describeClusterFuture = new KafkaFutureImpl<Collection<Node>>();
        final KafkaFutureImpl<Node> controllerFuture = new KafkaFutureImpl<Node>();
        final KafkaFutureImpl<String> clusterIdFuture = new KafkaFutureImpl<String>();
        final KafkaFutureImpl<Set<AclOperation>> authorizedOperationsFuture = new KafkaFutureImpl<Set<AclOperation>>();
        long now = this.time.milliseconds();
        this.runnable.call(new Call("listNodes", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedBrokerOrActiveKController()){
            private boolean useMetadataRequest;
            {
                super(callName, deadlineMs, nodeProvider);
                this.useMetadataRequest = false;
            }

            AbstractRequest.Builder createRequest(int timeoutMs) {
                if (!this.useMetadataRequest) {
                    return new DescribeClusterRequest.Builder(new DescribeClusterRequestData().setIncludeClusterAuthorizedOperations(options.includeAuthorizedOperations()).setEndpointType(KafkaAdminClient.this.metadataManager.usingBootstrapControllers() ? EndpointType.CONTROLLER.id() : EndpointType.BROKER.id()));
                }
                return new MetadataRequest.Builder(new MetadataRequestData().setTopics(Collections.emptyList()).setAllowAutoTopicCreation(true).setIncludeClusterAuthorizedOperations(options.includeAuthorizedOperations()));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                if (!this.useMetadataRequest) {
                    DescribeClusterResponse response = (DescribeClusterResponse)abstractResponse;
                    Errors error = Errors.forCode(response.data().errorCode());
                    if (error != Errors.NONE) {
                        ApiError apiError = new ApiError(error, response.data().errorMessage());
                        this.handleFailure(apiError.exception());
                        return;
                    }
                    Map<Integer, Node> nodes = response.nodes();
                    describeClusterFuture.complete(nodes.values());
                    controllerFuture.complete(nodes.get(response.data().controllerId()));
                    clusterIdFuture.complete(response.data().clusterId());
                    authorizedOperationsFuture.complete(KafkaAdminClient.this.validAclOperations(response.data().clusterAuthorizedOperations()));
                } else {
                    MetadataResponse response = (MetadataResponse)abstractResponse;
                    describeClusterFuture.complete(response.brokers());
                    controllerFuture.complete(this.controller(response));
                    clusterIdFuture.complete(response.clusterId());
                    authorizedOperationsFuture.complete(KafkaAdminClient.this.validAclOperations(response.clusterAuthorizedOperations()));
                }
            }

            private Node controller(MetadataResponse response) {
                if (response.controller() == null || response.controller().id() == -1) {
                    return null;
                }
                return response.controller();
            }

            @Override
            void handleFailure(Throwable throwable) {
                describeClusterFuture.completeExceptionally(throwable);
                controllerFuture.completeExceptionally(throwable);
                clusterIdFuture.completeExceptionally(throwable);
                authorizedOperationsFuture.completeExceptionally(throwable);
            }

            @Override
            boolean handleUnsupportedVersionException(UnsupportedVersionException exception) {
                if (KafkaAdminClient.this.metadataManager.usingBootstrapControllers()) {
                    return false;
                }
                if (this.useMetadataRequest) {
                    return false;
                }
                this.useMetadataRequest = true;
                return true;
            }
        }, now);
        return new DescribeClusterResult(describeClusterFuture, controllerFuture, clusterIdFuture, authorizedOperationsFuture);
    }

    @Override
    public DescribeAclsResult describeAcls(AclBindingFilter filter, DescribeAclsOptions options) {
        return this.describeAcls(filter, options, AclState.ACTIVE);
    }

    @Override
    public CreateAclsResult createAcls(Collection<AclBinding> acls, CreateAclsOptions options) {
        return this.createCentralizedAcls(acls, options, null, Node.noNode().id());
    }

    @Override
    @Confluent
    public CreateAclsResult createCentralizedAcls(Collection<AclBinding> acls, CreateAclsOptions options, final String clusterId, int writerBrokerId) {
        long now = this.time.milliseconds();
        final HashMap futures = new HashMap();
        ArrayList<CreateAclsRequestData.AclCreation> aclCreations = new ArrayList<CreateAclsRequestData.AclCreation>();
        final ArrayList<AclBinding> aclBindingsSent = new ArrayList<AclBinding>();
        for (AclBinding acl : acls) {
            if (futures.get(acl) != null) continue;
            KafkaFutureImpl future = new KafkaFutureImpl();
            futures.put(acl, future);
            String indefinite = acl.toFilter().findIndefiniteField();
            if (indefinite == null) {
                aclCreations.add(CreateAclsRequest.aclCreation(acl));
                aclBindingsSent.add(acl);
                continue;
            }
            future.completeExceptionally(new InvalidRequestException("Invalid ACL creation: " + indefinite));
        }
        final CreateAclsRequestData data = new CreateAclsRequestData().setCreations(aclCreations);
        NodeProvider nodeProvider = writerBrokerId == Node.noNode().id() ? new LeastLoadedNodeProvider() : new ConstantNodeIdProvider(writerBrokerId);
        this.runnable.call(new Call("createAcls", this.calcDeadlineMs(now, options.timeoutMs()), nodeProvider){

            CreateAclsRequest.Builder createRequest(int timeoutMs) {
                CreateAclsRequest.Builder builder = new CreateAclsRequest.Builder(data);
                if (clusterId != null) {
                    return builder.setClusterId(clusterId);
                }
                return builder;
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                CreateAclsResponse response = (CreateAclsResponse)abstractResponse;
                List<CreateAclsResponseData.AclCreationResult> responses = response.results();
                Iterator<CreateAclsResponseData.AclCreationResult> iter = responses.iterator();
                for (AclBinding aclBinding : aclBindingsSent) {
                    KafkaFutureImpl future = (KafkaFutureImpl)futures.get(aclBinding);
                    if (!iter.hasNext()) {
                        future.completeExceptionally(new UnknownServerException("The broker reported no creation result for the given ACL: " + aclBinding));
                        continue;
                    }
                    CreateAclsResponseData.AclCreationResult creation = iter.next();
                    Errors error = Errors.forCode(creation.errorCode());
                    ApiError apiError = new ApiError(error, creation.errorMessage());
                    if (apiError.isFailure()) {
                        future.completeExceptionally(apiError.exception());
                        continue;
                    }
                    future.complete(null);
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        }, now);
        return new CreateAclsResult(new HashMap<AclBinding, KafkaFuture<Void>>(futures));
    }

    @Override
    public DeleteAclsResult deleteAcls(Collection<AclBindingFilter> filters, DeleteAclsOptions options) {
        return this.deleteCentralizedAcls(filters, options, null, Node.noNode().id());
    }

    @Override
    @Confluent
    public DeleteAclsResult deleteCentralizedAcls(Collection<AclBindingFilter> filters, DeleteAclsOptions options, String clusterId, int writerBrokerId) {
        return this.deleteAclsInternal(filters, options, clusterId, writerBrokerId, AclState.ANY);
    }

    @Override
    public DescribeConfigsResult describeConfigs(Collection<ConfigResource> configResources, final DescribeConfigsOptions options) {
        HashMap<Integer, Map> nodeFutures = new HashMap<Integer, Map>(configResources.size());
        for (ConfigResource resource : configResources) {
            Integer broker = this.nodeFor(resource);
            nodeFutures.compute(broker, (key, value) -> {
                if (value == null) {
                    value = new HashMap();
                }
                value.put(resource, new KafkaFutureImpl());
                return value;
            });
        }
        long now = this.time.milliseconds();
        for (Map.Entry entry : nodeFutures.entrySet()) {
            final Integer node = (Integer)entry.getKey();
            final Map unified = (Map)entry.getValue();
            this.runnable.call(new Call("describeConfigs", this.calcDeadlineMs(now, options.timeoutMs()), node != null ? new ConstantNodeIdProvider(node, true) : new LeastLoadedBrokerOrActiveKController()){

                DescribeConfigsRequest.Builder createRequest(int timeoutMs) {
                    return new DescribeConfigsRequest.Builder(new DescribeConfigsRequestData().setResources(unified.keySet().stream().map(config -> new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(config.name()).setResourceType(config.type().id()).setConfigurationKeys(null)).collect(Collectors.toList())).setIncludeSynonyms(options.includeSynonyms()).setIncludeDocumentation(options.includeDocumentation()));
                }

                @Override
                void handleResponse(AbstractResponse abstractResponse) {
                    DescribeConfigsResponse response = (DescribeConfigsResponse)abstractResponse;
                    for (Map.Entry<ConfigResource, DescribeConfigsResponseData.DescribeConfigsResult> entry : response.resultMap().entrySet()) {
                        ConfigResource configResource2 = entry.getKey();
                        DescribeConfigsResponseData.DescribeConfigsResult describeConfigsResult = entry.getValue();
                        KafkaFutureImpl future = (KafkaFutureImpl)unified.get(configResource2);
                        if (future == null) {
                            if (node != null) {
                                KafkaAdminClient.this.log.warn("The config {} in the response from node {} is not in the request", (Object)configResource2, (Object)node);
                                continue;
                            }
                            KafkaAdminClient.this.log.warn("The config {} in the response from the least loaded broker is not in the request", (Object)configResource2);
                            continue;
                        }
                        if (describeConfigsResult.errorCode() != Errors.NONE.code()) {
                            future.completeExceptionally(Errors.forCode(describeConfigsResult.errorCode()).exception(describeConfigsResult.errorMessage()));
                            continue;
                        }
                        future.complete(KafkaAdminClient.this.describeConfigResult(describeConfigsResult));
                    }
                    KafkaAdminClient.completeUnrealizedFutures(unified.entrySet().stream(), configResource -> "The node response did not contain a result for config resource " + configResource);
                }

                @Override
                void handleFailure(Throwable throwable) {
                    KafkaAdminClient.completeAllExceptionally(unified.values(), throwable);
                }
            }, now);
        }
        return new DescribeConfigsResult(new HashMap<ConfigResource, KafkaFuture<Config>>(nodeFutures.entrySet().stream().flatMap(x -> ((Map)x.getValue()).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
    }

    private Config describeConfigResult(DescribeConfigsResponseData.DescribeConfigsResult describeConfigsResult) {
        return new Config(describeConfigsResult.configs().stream().map(config -> new ConfigEntry(config.name(), config.value(), DescribeConfigsResponse.ConfigSource.forId(config.configSource()).source(), config.isSensitive(), config.readOnly(), config.synonyms().stream().map(synonym -> new ConfigEntry.ConfigSynonym(synonym.name(), synonym.value(), DescribeConfigsResponse.ConfigSource.forId(synonym.source()).source())).collect(Collectors.toList()), DescribeConfigsResponse.ConfigType.forId(config.configType()).type(), config.documentation())).collect(Collectors.toList()));
    }

    private ConfigEntry.ConfigSource configSource(DescribeConfigsResponse.ConfigSource source) {
        ConfigEntry.ConfigSource configSource;
        switch (source) {
            case CLUSTER_LINK_CONFIG: {
                configSource = ConfigEntry.ConfigSource.DYNAMIC_CLUSTER_LINK_CONFIG;
                break;
            }
            case TOPIC_CONFIG: {
                configSource = ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG;
                break;
            }
            case DYNAMIC_BROKER_CONFIG: {
                configSource = ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG;
                break;
            }
            case DYNAMIC_DEFAULT_BROKER_CONFIG: {
                configSource = ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG;
                break;
            }
            case STATIC_BROKER_CONFIG: {
                configSource = ConfigEntry.ConfigSource.STATIC_BROKER_CONFIG;
                break;
            }
            case DYNAMIC_BROKER_LOGGER_CONFIG: {
                configSource = ConfigEntry.ConfigSource.DYNAMIC_BROKER_LOGGER_CONFIG;
                break;
            }
            case DEFAULT_CONFIG: {
                configSource = ConfigEntry.ConfigSource.DEFAULT_CONFIG;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected config source " + (Object)((Object)source));
            }
        }
        return configSource;
    }

    @Override
    @Deprecated
    public AlterConfigsResult alterConfigs(Map<ConfigResource, Config> configs, AlterConfigsOptions options) {
        HashMap<ConfigResource, KafkaFutureImpl<Void>> allFutures = new HashMap<ConfigResource, KafkaFutureImpl<Void>>();
        ArrayList<ConfigResource> unifiedRequestResources = new ArrayList<ConfigResource>();
        for (ConfigResource resource : configs.keySet()) {
            Integer node = this.nodeFor(resource);
            if (node != null) {
                ConstantNodeIdProvider nodeProvider = new ConstantNodeIdProvider(node, true);
                allFutures.putAll(this.alterConfigs(configs, options, Collections.singleton(resource), nodeProvider));
                continue;
            }
            unifiedRequestResources.add(resource);
        }
        if (!unifiedRequestResources.isEmpty()) {
            allFutures.putAll(this.alterConfigs(configs, options, unifiedRequestResources, new LeastLoadedBrokerOrActiveKController()));
        }
        return new AlterConfigsResult(new HashMap<ConfigResource, KafkaFuture<Void>>(allFutures));
    }

    private Map<ConfigResource, KafkaFutureImpl<Void>> alterConfigs(Map<ConfigResource, Config> configs, final AlterConfigsOptions options, Collection<ConfigResource> resources, NodeProvider nodeProvider) {
        final HashMap<ConfigResource, KafkaFutureImpl<Void>> futures = new HashMap<ConfigResource, KafkaFutureImpl<Void>>();
        final HashMap<ConfigResource, AlterConfigsRequest.Config> requestMap = new HashMap<ConfigResource, AlterConfigsRequest.Config>(resources.size());
        for (ConfigResource resource : resources) {
            ArrayList<AlterConfigsRequest.ConfigEntry> configEntries = new ArrayList<AlterConfigsRequest.ConfigEntry>();
            for (ConfigEntry configEntry : configs.get(resource).entries()) {
                configEntries.add(new AlterConfigsRequest.ConfigEntry(configEntry.name(), configEntry.value()));
            }
            requestMap.put(resource, new AlterConfigsRequest.Config(configEntries));
            futures.put(resource, new KafkaFutureImpl());
        }
        long now = this.time.milliseconds();
        this.runnable.call(new Call("alterConfigs", this.calcDeadlineMs(now, options.timeoutMs()), nodeProvider){

            public AlterConfigsRequest.Builder createRequest(int timeoutMs) {
                return new AlterConfigsRequest.Builder(requestMap, options.shouldValidateOnly());
            }

            @Override
            public void handleResponse(AbstractResponse abstractResponse) {
                AlterConfigsResponse response = (AlterConfigsResponse)abstractResponse;
                for (Map.Entry entry : futures.entrySet()) {
                    KafkaFutureImpl future = (KafkaFutureImpl)entry.getValue();
                    ApiException exception = response.errors().get(entry.getKey()).exception();
                    if (exception != null) {
                        future.completeExceptionally(exception);
                        continue;
                    }
                    future.complete(null);
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        }, now);
        return futures;
    }

    @Override
    public AlterConfigsResult incrementalAlterConfigs(Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
        HashMap<ConfigResource, KafkaFutureImpl<Void>> allFutures = new HashMap<ConfigResource, KafkaFutureImpl<Void>>();
        ArrayList<ConfigResource> unifiedRequestResources = new ArrayList<ConfigResource>();
        for (ConfigResource resource : configs.keySet()) {
            Integer node = this.nodeFor(resource);
            if (this.metadataManager.usingBootstrapControllers() && !resource.type().equals((Object)ConfigResource.Type.BROKER_LOGGER)) {
                node = null;
            }
            if (node != null) {
                ConstantNodeIdProvider nodeProvider = new ConstantNodeIdProvider(node, true);
                allFutures.putAll(this.incrementalAlterConfigs(configs, options, Collections.singleton(resource), nodeProvider));
                continue;
            }
            unifiedRequestResources.add(resource);
        }
        if (!unifiedRequestResources.isEmpty()) {
            allFutures.putAll(this.incrementalAlterConfigs(configs, options, unifiedRequestResources, new LeastLoadedBrokerOrActiveKController()));
        }
        return new AlterConfigsResult(new HashMap<ConfigResource, KafkaFuture<Void>>(allFutures));
    }

    private Map<ConfigResource, KafkaFutureImpl<Void>> incrementalAlterConfigs(final Map<ConfigResource, Collection<AlterConfigOp>> configs, final AlterConfigsOptions options, final Collection<ConfigResource> resources, NodeProvider nodeProvider) {
        final HashMap<ConfigResource, KafkaFutureImpl<Void>> futures = new HashMap<ConfigResource, KafkaFutureImpl<Void>>();
        for (ConfigResource resource : resources) {
            futures.put(resource, new KafkaFutureImpl());
        }
        long now = this.time.milliseconds();
        this.runnable.call(new Call("incrementalAlterConfigs", this.calcDeadlineMs(now, options.timeoutMs()), nodeProvider){

            public IncrementalAlterConfigsRequest.Builder createRequest(int timeoutMs) {
                return new IncrementalAlterConfigsRequest.Builder(resources, configs, options.shouldValidateOnly(), options.shouldSkipMirrorTopicConfigValidation());
            }

            @Override
            public void handleResponse(AbstractResponse abstractResponse) {
                IncrementalAlterConfigsResponse response = (IncrementalAlterConfigsResponse)abstractResponse;
                Map<ConfigResource, ApiError> errors = IncrementalAlterConfigsResponse.fromResponseData(response.data());
                for (Map.Entry entry : futures.entrySet()) {
                    KafkaFutureImpl future = (KafkaFutureImpl)entry.getValue();
                    ApiException exception = errors.get(entry.getKey()).exception();
                    if (exception != null) {
                        future.completeExceptionally(exception);
                        continue;
                    }
                    future.complete(null);
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        }, now);
        return futures;
    }

    @Override
    public AlterReplicaLogDirsResult alterReplicaLogDirs(Map<TopicPartitionReplica, String> replicaAssignment, AlterReplicaLogDirsOptions options) {
        int brokerId;
        final HashMap futures = new HashMap(replicaAssignment.size());
        for (TopicPartitionReplica topicPartitionReplica : replicaAssignment.keySet()) {
            futures.put(topicPartitionReplica, new KafkaFutureImpl());
        }
        HashMap<Integer, AlterReplicaLogDirsRequestData> replicaAssignmentByBroker = new HashMap<Integer, AlterReplicaLogDirsRequestData>();
        for (Map.Entry<TopicPartitionReplica, String> entry : replicaAssignment.entrySet()) {
            AlterReplicaLogDirsRequestData.AlterReplicaLogDirTopic alterReplicaLogDirTopic;
            TopicPartitionReplica replica = entry.getKey();
            String logDir = entry.getValue();
            brokerId = replica.brokerId();
            AlterReplicaLogDirsRequestData value = replicaAssignmentByBroker.computeIfAbsent(brokerId, key -> new AlterReplicaLogDirsRequestData());
            AlterReplicaLogDirsRequestData.AlterReplicaLogDir alterReplicaLogDir = value.dirs().find(logDir);
            if (alterReplicaLogDir == null) {
                alterReplicaLogDir = new AlterReplicaLogDirsRequestData.AlterReplicaLogDir();
                alterReplicaLogDir.setPath(logDir);
                value.dirs().add(alterReplicaLogDir);
            }
            if ((alterReplicaLogDirTopic = alterReplicaLogDir.topics().find(replica.topic())) == null) {
                alterReplicaLogDirTopic = new AlterReplicaLogDirsRequestData.AlterReplicaLogDirTopic().setName(replica.topic());
                alterReplicaLogDir.topics().add(alterReplicaLogDirTopic);
            }
            alterReplicaLogDirTopic.partitions().add(replica.partition());
        }
        long l = this.time.milliseconds();
        for (Map.Entry entry : replicaAssignmentByBroker.entrySet()) {
            brokerId = (Integer)entry.getKey();
            final AlterReplicaLogDirsRequestData assignment = (AlterReplicaLogDirsRequestData)entry.getValue();
            this.runnable.call(new Call("alterReplicaLogDirs", this.calcDeadlineMs(l, options.timeoutMs()), new ConstantNodeIdProvider(brokerId)){

                public AlterReplicaLogDirsRequest.Builder createRequest(int timeoutMs) {
                    return new AlterReplicaLogDirsRequest.Builder(assignment);
                }

                @Override
                public void handleResponse(AbstractResponse abstractResponse) {
                    AlterReplicaLogDirsResponse response = (AlterReplicaLogDirsResponse)abstractResponse;
                    for (AlterReplicaLogDirsResponseData.AlterReplicaLogDirTopicResult topicResult : response.data().results()) {
                        for (AlterReplicaLogDirsResponseData.AlterReplicaLogDirPartitionResult partitionResult : topicResult.partitions()) {
                            TopicPartitionReplica replica2 = new TopicPartitionReplica(topicResult.topicName(), partitionResult.partitionIndex(), brokerId);
                            KafkaFutureImpl future = (KafkaFutureImpl)futures.get(replica2);
                            if (future == null) {
                                KafkaAdminClient.this.log.warn("The partition {} in the response from broker {} is not in the request", (Object)new TopicPartition(topicResult.topicName(), partitionResult.partitionIndex()), (Object)brokerId);
                                continue;
                            }
                            if (partitionResult.errorCode() == Errors.NONE.code()) {
                                future.complete(null);
                                continue;
                            }
                            future.completeExceptionally(Errors.forCode(partitionResult.errorCode()).exception());
                        }
                    }
                    KafkaAdminClient.completeUnrealizedFutures(futures.entrySet().stream().filter(entry -> ((TopicPartitionReplica)entry.getKey()).brokerId() == brokerId), replica -> "The response from broker " + brokerId + " did not contain a result for replica " + replica);
                }

                @Override
                void handleFailure(Throwable throwable) {
                    KafkaAdminClient.completeAllExceptionally(futures.entrySet().stream().filter(entry -> ((TopicPartitionReplica)entry.getKey()).brokerId() == brokerId).map(Map.Entry::getValue), throwable);
                }
            }, l);
        }
        return new AlterReplicaLogDirsResult(new HashMap<TopicPartitionReplica, KafkaFuture<Void>>(futures));
    }

    @Override
    public DescribeLogDirsResult describeLogDirs(Collection<Integer> brokers, DescribeLogDirsOptions options) {
        HashMap futures = new HashMap(brokers.size());
        long now = this.time.milliseconds();
        for (Integer brokerId : brokers) {
            final KafkaFutureImpl future = new KafkaFutureImpl();
            futures.put(brokerId, future);
            this.runnable.call(new Call("describeLogDirs", this.calcDeadlineMs(now, options.timeoutMs()), new ConstantNodeIdProvider(brokerId)){

                public DescribeLogDirsRequest.Builder createRequest(int timeoutMs) {
                    return new DescribeLogDirsRequest.Builder(new DescribeLogDirsRequestData().setTopics(null));
                }

                @Override
                public void handleResponse(AbstractResponse abstractResponse) {
                    DescribeLogDirsResponse response = (DescribeLogDirsResponse)abstractResponse;
                    Map descriptions = KafkaAdminClient.logDirDescriptions(response);
                    if (descriptions.size() > 0) {
                        future.complete(descriptions);
                    } else {
                        Errors error = response.data().errorCode() == Errors.NONE.code() ? Errors.CLUSTER_AUTHORIZATION_FAILED : Errors.forCode(response.data().errorCode());
                        future.completeExceptionally(error.exception());
                    }
                }

                @Override
                void handleFailure(Throwable throwable) {
                    future.completeExceptionally(throwable);
                }
            }, now);
        }
        return new DescribeLogDirsResult(new HashMap<Integer, KafkaFuture<Map<String, LogDirDescription>>>(futures));
    }

    private static Map<String, LogDirDescription> logDirDescriptions(DescribeLogDirsResponse response) {
        HashMap<String, LogDirDescription> result = new HashMap<String, LogDirDescription>(response.data().results().size());
        for (DescribeLogDirsResponseData.DescribeLogDirsResult logDirResult : response.data().results()) {
            HashMap<TopicPartition, ReplicaInfo> replicaInfoMap = new HashMap<TopicPartition, ReplicaInfo>();
            for (DescribeLogDirsResponseData.DescribeLogDirsTopic t : logDirResult.topics()) {
                for (DescribeLogDirsResponseData.DescribeLogDirsPartition p : t.partitions()) {
                    replicaInfoMap.put(new TopicPartition(t.name(), p.partitionIndex()), new ReplicaInfo(p.partitionSize(), p.offsetLag(), p.isFutureKey()));
                }
            }
            result.put(logDirResult.logDir(), new LogDirDescription(Errors.forCode(logDirResult.errorCode()).exception(), replicaInfoMap, logDirResult.totalBytes(), logDirResult.usableBytes()));
        }
        return result;
    }

    @Override
    public DescribeReplicaLogDirsResult describeReplicaLogDirs(Collection<TopicPartitionReplica> replicas, DescribeReplicaLogDirsOptions options) {
        final HashMap futures = new HashMap(replicas.size());
        for (TopicPartitionReplica topicPartitionReplica : replicas) {
            futures.put(topicPartitionReplica, new KafkaFutureImpl());
        }
        HashMap<Integer, DescribeLogDirsRequestData> partitionsByBroker = new HashMap<Integer, DescribeLogDirsRequestData>();
        for (TopicPartitionReplica replica : replicas) {
            DescribeLogDirsRequestData requestData = partitionsByBroker.computeIfAbsent(replica.brokerId(), brokerId -> new DescribeLogDirsRequestData());
            DescribeLogDirsRequestData.DescribableLogDirTopic describableLogDirTopic = requestData.topics().find(replica.topic());
            if (describableLogDirTopic == null) {
                ArrayList<Integer> partitions = new ArrayList<Integer>();
                partitions.add(replica.partition());
                describableLogDirTopic = new DescribeLogDirsRequestData.DescribableLogDirTopic().setTopic(replica.topic()).setPartitions(partitions);
                requestData.topics().add(describableLogDirTopic);
                continue;
            }
            describableLogDirTopic.partitions().add(replica.partition());
        }
        long l = this.time.milliseconds();
        for (Map.Entry entry : partitionsByBroker.entrySet()) {
            final int brokerId2 = (Integer)entry.getKey();
            final DescribeLogDirsRequestData topicPartitions = (DescribeLogDirsRequestData)entry.getValue();
            final HashMap<TopicPartition, DescribeReplicaLogDirsResult.ReplicaLogDirInfo> replicaDirInfoByPartition = new HashMap<TopicPartition, DescribeReplicaLogDirsResult.ReplicaLogDirInfo>();
            for (DescribeLogDirsRequestData.DescribableLogDirTopic topicPartition : topicPartitions.topics()) {
                for (Integer partitionId : topicPartition.partitions()) {
                    replicaDirInfoByPartition.put(new TopicPartition(topicPartition.topic(), partitionId), new DescribeReplicaLogDirsResult.ReplicaLogDirInfo());
                }
            }
            this.runnable.call(new Call("describeReplicaLogDirs", this.calcDeadlineMs(l, options.timeoutMs()), new ConstantNodeIdProvider(brokerId2)){

                public DescribeLogDirsRequest.Builder createRequest(int timeoutMs) {
                    return new DescribeLogDirsRequest.Builder(topicPartitions);
                }

                @Override
                public void handleResponse(AbstractResponse abstractResponse) {
                    DescribeLogDirsResponse response = (DescribeLogDirsResponse)abstractResponse;
                    for (Map.Entry responseEntry : KafkaAdminClient.logDirDescriptions(response).entrySet()) {
                        String logDir = (String)responseEntry.getKey();
                        LogDirDescription logDirInfo = (LogDirDescription)responseEntry.getValue();
                        if (logDirInfo.error() instanceof KafkaStorageException) continue;
                        if (logDirInfo.error() != null) {
                            this.handleFailure(new IllegalStateException("The error " + logDirInfo.error().getClass().getName() + " for log directory " + logDir + " in the response from broker " + brokerId2 + " is illegal"));
                        }
                        for (Map.Entry<TopicPartition, ReplicaInfo> replicaInfoEntry : logDirInfo.replicaInfos().entrySet()) {
                            TopicPartition tp = replicaInfoEntry.getKey();
                            ReplicaInfo replicaInfo = replicaInfoEntry.getValue();
                            DescribeReplicaLogDirsResult.ReplicaLogDirInfo replicaLogDirInfo = (DescribeReplicaLogDirsResult.ReplicaLogDirInfo)replicaDirInfoByPartition.get(tp);
                            if (replicaLogDirInfo == null) {
                                KafkaAdminClient.this.log.warn("Server response from broker {} mentioned unknown partition {}", (Object)brokerId2, (Object)tp);
                                continue;
                            }
                            if (replicaInfo.isFuture()) {
                                replicaDirInfoByPartition.put(tp, new DescribeReplicaLogDirsResult.ReplicaLogDirInfo(replicaLogDirInfo.getCurrentReplicaLogDir(), replicaLogDirInfo.getCurrentReplicaOffsetLag(), logDir, replicaInfo.offsetLag()));
                                continue;
                            }
                            replicaDirInfoByPartition.put(tp, new DescribeReplicaLogDirsResult.ReplicaLogDirInfo(logDir, replicaInfo.offsetLag(), replicaLogDirInfo.getFutureReplicaLogDir(), replicaLogDirInfo.getFutureReplicaOffsetLag()));
                        }
                    }
                    for (Map.Entry entry : replicaDirInfoByPartition.entrySet()) {
                        TopicPartition tp = (TopicPartition)entry.getKey();
                        KafkaFutureImpl future = (KafkaFutureImpl)futures.get(new TopicPartitionReplica(tp.topic(), tp.partition(), brokerId2));
                        future.complete(entry.getValue());
                    }
                }

                @Override
                void handleFailure(Throwable throwable) {
                    KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
                }
            }, l);
        }
        return new DescribeReplicaLogDirsResult(new HashMap<TopicPartitionReplica, KafkaFuture<DescribeReplicaLogDirsResult.ReplicaLogDirInfo>>(futures));
    }

    @Override
    public CreatePartitionsResult createPartitions(Map<String, NewPartitions> newPartitions, CreatePartitionsOptions options) {
        HashMap<String, KafkaFutureImpl<Void>> futures = new HashMap<String, KafkaFutureImpl<Void>>(newPartitions.size());
        CreatePartitionsRequestData.CreatePartitionsTopicCollection topics = new CreatePartitionsRequestData.CreatePartitionsTopicCollection(newPartitions.size());
        for (Map.Entry<String, NewPartitions> entry : newPartitions.entrySet()) {
            String topic = entry.getKey();
            NewPartitions newPartition = entry.getValue();
            List<List<Integer>> newAssignments = newPartition.assignments();
            List<CreatePartitionsRequestData.CreatePartitionsAssignment> assignments = newAssignments == null ? null : newAssignments.stream().map(brokerIds -> new CreatePartitionsRequestData.CreatePartitionsAssignment().setBrokerIds((List<Integer>)brokerIds)).collect(Collectors.toList());
            topics.add(new CreatePartitionsRequestData.CreatePartitionsTopic().setName(topic).setCount(newPartition.totalCount()).setAssignments(assignments));
            futures.put(topic, new KafkaFutureImpl());
        }
        if (!topics.isEmpty()) {
            long now = this.time.milliseconds();
            long deadline = this.calcDeadlineMs(now, options.timeoutMs());
            Call call = this.getCreatePartitionsCall(options, futures, topics, Collections.emptyMap(), now, deadline);
            this.runnable.call(call, now);
        }
        return new CreatePartitionsResult(new HashMap<String, KafkaFuture<Void>>(futures));
    }

    private Call getCreatePartitionsCall(final CreatePartitionsOptions options, final Map<String, KafkaFutureImpl<Void>> futures, final CreatePartitionsRequestData.CreatePartitionsTopicCollection topics, final Map<String, ThrottlingQuotaExceededException> quotaExceededExceptions, final long now, final long deadline) {
        return new Call("createPartitions", deadline, new ControllerNodeProvider()){

            public CreatePartitionsRequest.Builder createRequest(int timeoutMs) {
                return new CreatePartitionsRequest.Builder(new CreatePartitionsRequestData().setTopics(topics).setValidateOnly(options.validateOnly()).setTimeoutMs(timeoutMs));
            }

            @Override
            public void handleResponse(AbstractResponse abstractResponse) {
                KafkaAdminClient.this.handleNotControllerError(abstractResponse);
                CreatePartitionsResponse response = (CreatePartitionsResponse)abstractResponse;
                CreatePartitionsRequestData.CreatePartitionsTopicCollection retryTopics = new CreatePartitionsRequestData.CreatePartitionsTopicCollection();
                HashMap<String, ThrottlingQuotaExceededException> retryTopicQuotaExceededExceptions = new HashMap<String, ThrottlingQuotaExceededException>();
                for (CreatePartitionsResponseData.CreatePartitionsTopicResult result : response.data().results()) {
                    KafkaFutureImpl future = (KafkaFutureImpl)futures.get(result.name());
                    if (future == null) {
                        KafkaAdminClient.this.log.warn("Server response mentioned unknown topic {}", (Object)result.name());
                        continue;
                    }
                    ApiError error = new ApiError(result.errorCode(), result.errorMessage());
                    if (error.isFailure()) {
                        if (error.is(Errors.THROTTLING_QUOTA_EXCEEDED)) {
                            ThrottlingQuotaExceededException quotaExceededException = new ThrottlingQuotaExceededException(response.throttleTimeMs(), error.messageWithFallback());
                            if (options.shouldRetryOnQuotaViolation()) {
                                retryTopics.add(topics.find(result.name()).duplicate());
                                retryTopicQuotaExceededExceptions.put(result.name(), quotaExceededException);
                                continue;
                            }
                            future.completeExceptionally(quotaExceededException);
                            continue;
                        }
                        future.completeExceptionally(error.exception());
                        continue;
                    }
                    future.complete(null);
                }
                if (retryTopics.isEmpty()) {
                    KafkaAdminClient.completeUnrealizedFutures(futures.entrySet().stream(), topic -> "The controller response did not contain a result for topic " + topic);
                } else {
                    long now2 = KafkaAdminClient.this.time.milliseconds();
                    Call call = KafkaAdminClient.this.getCreatePartitionsCall(options, futures, retryTopics, retryTopicQuotaExceededExceptions, now2, deadline);
                    KafkaAdminClient.this.runnable.call(call, now2);
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.maybeCompleteQuotaExceededException(options.shouldRetryOnQuotaViolation(), throwable, futures, quotaExceededExceptions, (int)(KafkaAdminClient.this.time.milliseconds() - now));
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        };
    }

    @Override
    public DeleteRecordsResult deleteRecords(Map<TopicPartition, RecordsToDelete> recordsToDelete, DeleteRecordsOptions options) {
        AdminApiFuture.SimpleAdminApiFuture<TopicPartition, DeletedRecords> future = DeleteRecordsHandler.newFuture(recordsToDelete.keySet());
        int timeoutMs = this.defaultApiTimeoutMs;
        if (options.timeoutMs() != null) {
            timeoutMs = options.timeoutMs();
        }
        DeleteRecordsHandler handler = new DeleteRecordsHandler(recordsToDelete, this.logContext, timeoutMs);
        this.invokeDriver(handler, future, options.timeoutMs);
        return new DeleteRecordsResult(future.all());
    }

    @Override
    public CreateDelegationTokenResult createDelegationToken(final CreateDelegationTokenOptions options) {
        final KafkaFutureImpl<DelegationToken> delegationTokenFuture = new KafkaFutureImpl<DelegationToken>();
        long now = this.time.milliseconds();
        final ArrayList<CreateDelegationTokenRequestData.CreatableRenewers> renewers = new ArrayList<CreateDelegationTokenRequestData.CreatableRenewers>();
        for (KafkaPrincipal principal : options.renewers()) {
            renewers.add(new CreateDelegationTokenRequestData.CreatableRenewers().setPrincipalName(principal.getName()).setPrincipalType(principal.getPrincipalType()));
        }
        this.runnable.call(new Call("createDelegationToken", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            CreateDelegationTokenRequest.Builder createRequest(int timeoutMs) {
                CreateDelegationTokenRequestData data = new CreateDelegationTokenRequestData().setRenewers(renewers).setMaxLifetimeMs(options.maxlifeTimeMs());
                if (options.owner().isPresent()) {
                    data.setOwnerPrincipalName(options.owner().get().getName());
                    data.setOwnerPrincipalType(options.owner().get().getPrincipalType());
                }
                return new CreateDelegationTokenRequest.Builder(data);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                CreateDelegationTokenResponse response = (CreateDelegationTokenResponse)abstractResponse;
                if (response.hasError()) {
                    delegationTokenFuture.completeExceptionally(response.error().exception());
                } else {
                    CreateDelegationTokenResponseData data = response.data();
                    TokenInformation tokenInfo = new TokenInformation(data.tokenId(), new KafkaPrincipal(data.principalType(), data.principalName()), new KafkaPrincipal(data.tokenRequesterPrincipalType(), data.tokenRequesterPrincipalName()), options.renewers(), data.issueTimestampMs(), data.maxTimestampMs(), data.expiryTimestampMs());
                    DelegationToken token = new DelegationToken(tokenInfo, data.hmac());
                    delegationTokenFuture.complete(token);
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                delegationTokenFuture.completeExceptionally(throwable);
            }
        }, now);
        return new CreateDelegationTokenResult(delegationTokenFuture);
    }

    @Override
    public RenewDelegationTokenResult renewDelegationToken(final byte[] hmac, final RenewDelegationTokenOptions options) {
        final KafkaFutureImpl<Long> expiryTimeFuture = new KafkaFutureImpl<Long>();
        long now = this.time.milliseconds();
        this.runnable.call(new Call("renewDelegationToken", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            RenewDelegationTokenRequest.Builder createRequest(int timeoutMs) {
                return new RenewDelegationTokenRequest.Builder(new RenewDelegationTokenRequestData().setHmac(hmac).setRenewPeriodMs(options.renewTimePeriodMs()));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                RenewDelegationTokenResponse response = (RenewDelegationTokenResponse)abstractResponse;
                if (response.hasError()) {
                    expiryTimeFuture.completeExceptionally(response.error().exception());
                } else {
                    expiryTimeFuture.complete(response.expiryTimestamp());
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                expiryTimeFuture.completeExceptionally(throwable);
            }
        }, now);
        return new RenewDelegationTokenResult(expiryTimeFuture);
    }

    @Override
    public ExpireDelegationTokenResult expireDelegationToken(final byte[] hmac, final ExpireDelegationTokenOptions options) {
        final KafkaFutureImpl<Long> expiryTimeFuture = new KafkaFutureImpl<Long>();
        long now = this.time.milliseconds();
        this.runnable.call(new Call("expireDelegationToken", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            ExpireDelegationTokenRequest.Builder createRequest(int timeoutMs) {
                return new ExpireDelegationTokenRequest.Builder(new ExpireDelegationTokenRequestData().setHmac(hmac).setExpiryTimePeriodMs(options.expiryTimePeriodMs()));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                ExpireDelegationTokenResponse response = (ExpireDelegationTokenResponse)abstractResponse;
                if (response.hasError()) {
                    expiryTimeFuture.completeExceptionally(response.error().exception());
                } else {
                    expiryTimeFuture.complete(response.expiryTimestamp());
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                expiryTimeFuture.completeExceptionally(throwable);
            }
        }, now);
        return new ExpireDelegationTokenResult(expiryTimeFuture);
    }

    @Override
    public DescribeDelegationTokenResult describeDelegationToken(final DescribeDelegationTokenOptions options) {
        final KafkaFutureImpl<List<DelegationToken>> tokensFuture = new KafkaFutureImpl<List<DelegationToken>>();
        long now = this.time.milliseconds();
        this.runnable.call(new Call("describeDelegationToken", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            DescribeDelegationTokenRequest.Builder createRequest(int timeoutMs) {
                return new DescribeDelegationTokenRequest.Builder(options.owners());
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DescribeDelegationTokenResponse response = (DescribeDelegationTokenResponse)abstractResponse;
                if (response.hasError()) {
                    tokensFuture.completeExceptionally(response.error().exception());
                } else {
                    tokensFuture.complete(response.tokens());
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                tokensFuture.completeExceptionally(throwable);
            }
        }, now);
        return new DescribeDelegationTokenResult(tokensFuture);
    }

    @Override
    public DescribeConsumerGroupsResult describeConsumerGroups(Collection<String> groupIds, DescribeConsumerGroupsOptions options) {
        AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, ConsumerGroupDescription> future = DescribeConsumerGroupsHandler.newFuture(groupIds);
        DescribeConsumerGroupsHandler handler = new DescribeConsumerGroupsHandler(options.includeAuthorizedOperations(), this.logContext);
        this.invokeDriver(handler, future, options.timeoutMs);
        return new DescribeConsumerGroupsResult(future.all().entrySet().stream().collect(Collectors.toMap(entry -> ((CoordinatorKey)entry.getKey()).idValue, Map.Entry::getValue)));
    }

    private Set<AclOperation> validAclOperations(int authorizedOperations) {
        if (authorizedOperations == Integer.MIN_VALUE) {
            return null;
        }
        return Utils.from32BitField(authorizedOperations).stream().map(AclOperation::fromCode).filter(operation -> operation != AclOperation.UNKNOWN && operation != AclOperation.ALL && operation != AclOperation.ANY).collect(Collectors.toSet());
    }

    @Override
    public ListConsumerGroupsResult listConsumerGroups(final ListConsumerGroupsOptions options) {
        final KafkaFutureImpl<Collection<Object>> all = new KafkaFutureImpl<Collection<Object>>();
        long nowMetadata = this.time.milliseconds();
        final long deadline = this.calcDeadlineMs(nowMetadata, options.timeoutMs());
        this.runnable.call(new Call("findAllBrokers", deadline, new LeastLoadedNodeProvider()){

            MetadataRequest.Builder createRequest(int timeoutMs) {
                return new MetadataRequest.Builder(new MetadataRequestData().setTopics(Collections.emptyList()).setAllowAutoTopicCreation(true));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                MetadataResponse metadataResponse = (MetadataResponse)abstractResponse;
                Collection<Node> nodes = metadataResponse.brokers();
                if (nodes.isEmpty()) {
                    throw new StaleMetadataException("Metadata fetch failed due to missing broker list");
                }
                HashSet<Node> allNodes = new HashSet<Node>(nodes);
                final ListConsumerGroupsResults results = new ListConsumerGroupsResults(allNodes, all);
                for (final Node node : allNodes) {
                    long nowList = KafkaAdminClient.this.time.milliseconds();
                    KafkaAdminClient.this.runnable.call(new Call("listConsumerGroups", deadline, new ConstantNodeIdProvider(node.id())){

                        ListGroupsRequest.Builder createRequest(int timeoutMs) {
                            List<String> states = options.states().stream().map(ConsumerGroupState::toString).collect(Collectors.toList());
                            List<String> groupTypes = options.types().stream().map(GroupType::toString).collect(Collectors.toList());
                            return new ListGroupsRequest.Builder(new ListGroupsRequestData().setStatesFilter(states).setTypesFilter(groupTypes));
                        }

                        private void maybeAddConsumerGroup(ListGroupsResponseData.ListedGroup group) {
                            String protocolType = group.protocolType();
                            if (protocolType.equals("consumer") || protocolType.isEmpty()) {
                                String groupId = group.groupId();
                                Optional<ConsumerGroupState> state = group.groupState().equals("") ? Optional.empty() : Optional.of(ConsumerGroupState.parse(group.groupState()));
                                Optional<GroupType> type = group.groupType().equals("") ? Optional.empty() : Optional.of(GroupType.parse(group.groupType()));
                                ConsumerGroupListing groupListing = new ConsumerGroupListing(groupId, protocolType.isEmpty(), state, type);
                                results.addListing(groupListing);
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        void handleResponse(AbstractResponse abstractResponse) {
                            ListGroupsResponse response = (ListGroupsResponse)abstractResponse;
                            ListConsumerGroupsResults listConsumerGroupsResults = results;
                            synchronized (listConsumerGroupsResults) {
                                Errors error = Errors.forCode(response.data().errorCode());
                                if (error == Errors.COORDINATOR_LOAD_IN_PROGRESS || error == Errors.COORDINATOR_NOT_AVAILABLE) {
                                    throw error.exception();
                                }
                                if (error != Errors.NONE) {
                                    results.addError(error.exception(), node);
                                } else {
                                    for (ListGroupsResponseData.ListedGroup group : response.data().groups()) {
                                        this.maybeAddConsumerGroup(group);
                                    }
                                }
                                results.tryComplete(node);
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        void handleFailure(Throwable throwable) {
                            ListConsumerGroupsResults listConsumerGroupsResults = results;
                            synchronized (listConsumerGroupsResults) {
                                results.addError(throwable, node);
                                results.tryComplete(node);
                            }
                        }
                    }, nowList);
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaException exception = new KafkaException("Failed to find brokers to send ListGroups", throwable);
                all.complete(Collections.singletonList(exception));
            }
        }, nowMetadata);
        return new ListConsumerGroupsResult(all);
    }

    @Override
    public ListConsumerGroupOffsetsResult listConsumerGroupOffsets(Map<String, ListConsumerGroupOffsetsSpec> groupSpecs, ListConsumerGroupOffsetsOptions options) {
        AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> future = ListConsumerGroupOffsetsHandler.newFuture(groupSpecs.keySet());
        ListConsumerGroupOffsetsHandler handler = new ListConsumerGroupOffsetsHandler(groupSpecs, options.requireStable(), this.logContext);
        this.invokeDriver(handler, future, options.timeoutMs);
        return new ListConsumerGroupOffsetsResult(future.all());
    }

    @Override
    public DeleteConsumerGroupsResult deleteConsumerGroups(Collection<String> groupIds, DeleteConsumerGroupsOptions options) {
        AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, Void> future = DeleteConsumerGroupsHandler.newFuture(groupIds);
        DeleteConsumerGroupsHandler handler = new DeleteConsumerGroupsHandler(this.logContext);
        this.invokeDriver(handler, future, options.timeoutMs);
        return new DeleteConsumerGroupsResult(future.all().entrySet().stream().collect(Collectors.toMap(entry -> ((CoordinatorKey)entry.getKey()).idValue, Map.Entry::getValue)));
    }

    @Override
    public DeleteConsumerGroupOffsetsResult deleteConsumerGroupOffsets(String groupId, Set<TopicPartition> partitions, DeleteConsumerGroupOffsetsOptions options) {
        AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, Map<TopicPartition, Errors>> future = DeleteConsumerGroupOffsetsHandler.newFuture(groupId);
        DeleteConsumerGroupOffsetsHandler handler = new DeleteConsumerGroupOffsetsHandler(groupId, partitions, this.logContext);
        this.invokeDriver(handler, future, options.timeoutMs);
        return new DeleteConsumerGroupOffsetsResult(future.get(CoordinatorKey.byGroupId(groupId)), partitions);
    }

    @Override
    public Map<MetricName, ? extends Metric> metrics() {
        return Collections.unmodifiableMap(this.metrics.metrics());
    }

    @Override
    @Confluent
    public DescribeCellsResult describeCells(final Collection<Integer> cellIds, DescribeCellsOptions options) {
        final KafkaFutureImpl<DescribeCellsResponseData> future = new KafkaFutureImpl<DescribeCellsResponseData>();
        long now = this.time.milliseconds();
        String apiName = ApiKeys.DESCRIBE_CELLS.name();
        Call cellsRequest = new Call(apiName, this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            DescribeCellsRequest.Builder createRequest(int timeoutMs) {
                return new DescribeCellsRequest.Builder(new DescribeCellsRequestData().setCellIds(new ArrayList<Integer>(cellIds)));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DescribeCellsResponse response = (DescribeCellsResponse)abstractResponse;
                Errors error = Errors.forCode(response.data().errorCode());
                if (error == Errors.NONE) {
                    future.complete(response.data());
                } else if (error == Errors.NOT_CONTROLLER) {
                    KafkaAdminClient.this.handleNotControllerError(error);
                } else {
                    future.completeExceptionally(error.exception(response.data().errorMessage()));
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        };
        this.runnable.call(cellsRequest, now);
        return new DescribeCellsResult(future);
    }

    @Override
    @Confluent
    public DescribeNetworkResult describeNetwork(String tenant, String listenerName, Collection<String> ipAddresses, Collection<String> clientApiKeyList, Collection<Integer> brokerIds, DescribeNetworkOptions options) {
        ArrayList<KafkaFuture<DescribeNetworkResponseData>> futureList = new ArrayList<KafkaFuture<DescribeNetworkResponseData>>();
        brokerIds.forEach(broker -> {
            KafkaFuture<DescribeNetworkResponseData> future = this.createDescribeNetworkRequest((int)broker, tenant, listenerName, ipAddresses, clientApiKeyList, options);
            futureList.add(future);
        });
        return new DescribeNetworkResult(futureList);
    }

    private KafkaFuture<DescribeNetworkResponseData> createDescribeNetworkRequest(final int brokerId, final String tenant, final String listenerName, final Collection<String> ipAddresses, final Collection<String> clientApiKeyList, DescribeNetworkOptions options) {
        final KafkaFutureImpl<DescribeNetworkResponseData> future = new KafkaFutureImpl<DescribeNetworkResponseData>();
        long now = this.time.milliseconds();
        String apiName = ApiKeys.DESCRIBE_NETWORK.name();
        Call request = new Call(apiName, this.calcDeadlineMs(now, options.timeoutMs()), new ConstantNodeIdProvider(brokerId)){

            DescribeNetworkRequest.Builder createRequest(int timeoutMs) {
                if (listenerName == null || listenerName.isEmpty()) {
                    throw new IllegalArgumentException("listener name argument can not be empty");
                }
                DescribeNetworkRequestData data = new DescribeNetworkRequestData();
                data.setListenerName(listenerName);
                if (tenant != null && !tenant.isEmpty()) {
                    data.setTenantId(tenant);
                }
                if (ipAddresses != null && !ipAddresses.isEmpty()) {
                    data.setIpAddresses(new ArrayList<String>(ipAddresses));
                }
                if (clientApiKeyList != null && !clientApiKeyList.isEmpty()) {
                    data.setClientApiKeys(new ArrayList<String>(clientApiKeyList));
                }
                return new DescribeNetworkRequest.Builder(data);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DescribeNetworkResponse response = (DescribeNetworkResponse)abstractResponse;
                Errors error = Errors.forCode(response.data().errorCode());
                if (error == Errors.NONE) {
                    future.complete(response.data());
                } else {
                    future.completeExceptionally(error.exception(String.format("Error from the broker: %d, error: %s", brokerId, response.data().errorMessage())));
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(new ApiException("Error from the broker: " + brokerId, throwable));
            }
        };
        this.runnable.call(request, now);
        return future;
    }

    @Override
    @Confluent
    public CellLoadResult describeCellLoad(final Collection<Integer> cellIds, DescribeCellLoadOptions options) {
        final KafkaFutureImpl<List<DescribeCellLoadResponseData.CellLoad>> future = new KafkaFutureImpl<List<DescribeCellLoadResponseData.CellLoad>>();
        long now = this.time.milliseconds();
        String apiName = ApiKeys.DESCRIBE_CELL_LOAD.name();
        Call cellLoadReq = new Call(apiName, this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            DescribeCellLoadRequest.Builder createRequest(int timeoutMs) {
                DescribeCellLoadRequestData data = new DescribeCellLoadRequestData();
                if (cellIds != null && !cellIds.isEmpty()) {
                    data.setCellIds(new ArrayList<Integer>(cellIds));
                }
                return new DescribeCellLoadRequest.Builder(data);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DescribeCellLoadResponse response = (DescribeCellLoadResponse)abstractResponse;
                Errors error = Errors.forCode(response.data().errorCode());
                if (error == Errors.NONE) {
                    future.complete(response.cellsLoad());
                } else if (error == Errors.NOT_CONTROLLER) {
                    KafkaAdminClient.this.handleNotControllerError(error);
                } else {
                    future.completeExceptionally(error.exception(response.data().errorMessage()));
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        };
        this.runnable.call(cellLoadReq, now);
        return new CellLoadResult(future);
    }

    @Override
    @Confluent
    public DeleteCellResult deleteCell(final int cellId, DeleteCellOptions options) {
        final KafkaFutureImpl<Void> future = new KafkaFutureImpl<Void>();
        long now = this.time.milliseconds();
        String apiName = ApiKeys.DELETE_CELL.name();
        Call cellsRequest = new Call(apiName, this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            DeleteCellRequest.Builder createRequest(int timeoutMs) {
                return new DeleteCellRequest.Builder(new DeleteCellRequestData().setCellId(cellId));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DeleteCellResponse response = (DeleteCellResponse)abstractResponse;
                Errors error = Errors.forCode(response.data().errorCode());
                if (error == Errors.NONE) {
                    future.complete(null);
                } else if (error == Errors.NOT_CONTROLLER) {
                    KafkaAdminClient.this.handleNotControllerError(error);
                } else {
                    future.completeExceptionally(error.exception(response.data().errorMessage()));
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        };
        this.runnable.call(cellsRequest, now);
        return new DeleteCellResult(future);
    }

    @Override
    @Confluent
    public CreateCellResult createCell(final int cellId, final CellState state, CreateCellOptions options) {
        final KafkaFutureImpl<Void> future = new KafkaFutureImpl<Void>();
        long now = this.time.milliseconds();
        String apiName = ApiKeys.CREATE_CELL.name();
        Call cellsRequest = new Call(apiName, this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            CreateCellRequest.Builder createRequest(int timeoutMs) {
                return new CreateCellRequest.Builder(new CreateCellRequestData().setCellId(cellId).setState(state.code()));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                CreateCellResponse response = (CreateCellResponse)abstractResponse;
                Errors error = Errors.forCode(response.data().errorCode());
                if (error == Errors.NONE) {
                    future.complete(null);
                } else if (error == Errors.NOT_CONTROLLER) {
                    KafkaAdminClient.this.handleNotControllerError(error);
                } else {
                    future.completeExceptionally(error.exception(response.data().errorMessage()));
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        };
        this.runnable.call(cellsRequest, now);
        return new CreateCellResult(future);
    }

    @Override
    @Confluent
    public AlterCellResult alterCell(final int cellId, final CellState state, AlterCellOptions options) {
        final KafkaFutureImpl<Void> future = new KafkaFutureImpl<Void>();
        long now = this.time.milliseconds();
        String apiName = ApiKeys.ALTER_CELL.name();
        Call cellsRequest = new Call(apiName, this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            AlterCellRequest.Builder createRequest(int timeoutMs) {
                return new AlterCellRequest.Builder(new AlterCellRequestData().setCellId(cellId).setState(state.code()));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                AlterCellResponse response = (AlterCellResponse)abstractResponse;
                Errors error = Errors.forCode(response.data().errorCode());
                if (error == Errors.NONE) {
                    future.complete(null);
                } else if (error == Errors.NOT_CONTROLLER) {
                    KafkaAdminClient.this.handleNotControllerError(error);
                } else {
                    future.completeExceptionally(error.exception(response.data().errorMessage()));
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        };
        this.runnable.call(cellsRequest, now);
        return new AlterCellResult(future);
    }

    @Override
    @Confluent
    public AssignBrokersToCellResult assignBrokersToCell(final Collection<Integer> brokers, final int cellId, final boolean force, AssignBrokersToCellOptions options) {
        final KafkaFutureImpl<Void> future = new KafkaFutureImpl<Void>();
        long now = this.time.milliseconds();
        String apiName = ApiKeys.ASSIGN_BROKERS_TO_CELL.name();
        Call cellsRequest = new Call(apiName, this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            AssignBrokersToCellRequest.Builder createRequest(int timeoutMs) {
                AssignBrokersToCellRequestData data = new AssignBrokersToCellRequestData().setCellId(cellId).setBrokerIds(new ArrayList<Integer>(brokers)).setForce(force);
                return new AssignBrokersToCellRequest.Builder(data);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                AssignBrokersToCellResponse response = (AssignBrokersToCellResponse)abstractResponse;
                Errors error = Errors.forCode(response.data().errorCode());
                if (error == Errors.NONE) {
                    future.complete(null);
                } else if (error == Errors.NOT_CONTROLLER) {
                    KafkaAdminClient.this.handleNotControllerError(error);
                } else {
                    future.completeExceptionally(error.exception(response.data().errorMessage()));
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        };
        this.runnable.call(cellsRequest, now);
        return new AssignBrokersToCellResult(future);
    }

    @Override
    @Confluent
    public UnassignBrokersFromCellResult unassignBrokersFromCell(final Collection<Integer> brokers, UnassignBrokersFromCellOptions options) {
        final KafkaFutureImpl<Void> future = new KafkaFutureImpl<Void>();
        long now = this.time.milliseconds();
        String apiName = ApiKeys.UN_ASSIGN_BROKERS_FROM_CELL.name();
        Call cellsRequest = new Call(apiName, this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            UnAssignBrokersFromCellRequest.Builder createRequest(int timeoutMs) {
                UnAssignBrokersFromCellRequestData data = new UnAssignBrokersFromCellRequestData().setBrokerIds(new ArrayList<Integer>(brokers));
                return new UnAssignBrokersFromCellRequest.Builder(data);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                UnAssignBrokersFromCellResponse response = (UnAssignBrokersFromCellResponse)abstractResponse;
                Errors error = Errors.forCode(response.data().errorCode());
                if (error == Errors.NONE) {
                    future.complete(null);
                } else if (error == Errors.NOT_CONTROLLER) {
                    KafkaAdminClient.this.handleNotControllerError(error);
                } else {
                    future.completeExceptionally(error.exception(response.data().errorMessage()));
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        };
        this.runnable.call(cellsRequest, now);
        return new UnassignBrokersFromCellResult(future);
    }

    @Override
    @Confluent
    public DescribeTenantsResult describeTenants(final Collection<String> tenantIds, DescribeTenantsOptions options) {
        final KafkaFutureImpl<List<DescribeTenantsResponseData.TenantDescription>> future = new KafkaFutureImpl<List<DescribeTenantsResponseData.TenantDescription>>();
        long now = this.time.milliseconds();
        String apiName = ApiKeys.DESCRIBE_TENANTS.name();
        Call tenantRequest = new Call(apiName, this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            DescribeTenantsRequest.Builder createRequest(int timeoutMs) {
                return new DescribeTenantsRequest.Builder(new DescribeTenantsRequestData().setTenantIds(new ArrayList<String>(tenantIds)));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DescribeTenantsResponse response = (DescribeTenantsResponse)abstractResponse;
                Errors error = Errors.forCode(response.data().errorCode());
                if (error == Errors.NONE) {
                    future.complete(response.data().tenantDescriptions());
                } else if (error == Errors.NOT_CONTROLLER) {
                    KafkaAdminClient.this.handleNotControllerError(error);
                } else {
                    future.completeExceptionally(error.exception(response.data().errorMessage()));
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        };
        this.runnable.call(tenantRequest, now);
        return new DescribeTenantsResult(future);
    }

    @Override
    @Confluent
    public DeleteTenantsResult deleteTenants(final Collection<String> tenantIds, DeleteTenantsOptions options) {
        final KafkaFutureImpl<List<String>> future = new KafkaFutureImpl<List<String>>();
        long now = this.time.milliseconds();
        String apiName = ApiKeys.DELETE_TENANTS.name();
        Call deleteRequest = new Call(apiName, this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            DeleteTenantsRequest.Builder createRequest(int timeoutMs) {
                return new DeleteTenantsRequest.Builder(new DeleteTenantsRequestData().setTenants(new ArrayList<String>(tenantIds)));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DeleteTenantsResponse response = (DeleteTenantsResponse)abstractResponse;
                Errors error = Errors.forCode(response.data().errorCode());
                if (error == Errors.NONE) {
                    future.complete(response.data().failedTenants());
                } else if (error == Errors.NOT_CONTROLLER) {
                    KafkaAdminClient.this.handleNotControllerError(error);
                } else {
                    future.completeExceptionally(error.exception(response.data().errorMessage()));
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        };
        this.runnable.call(deleteRequest, now);
        return new DeleteTenantsResult(future);
    }

    @Override
    @Confluent
    public AssignTenantsToCellResult assignTenantsToCell(final Collection<AssignTenantsToCellRequestData.TenantToCellAssignment> assignments, AssignTenantsToCellOptions options) {
        final KafkaFutureImpl<List<AssignTenantsToCellResponseData.TenantAssignmentErrors>> future = new KafkaFutureImpl<List<AssignTenantsToCellResponseData.TenantAssignmentErrors>>();
        long now = this.time.milliseconds();
        String apiName = ApiKeys.ASSIGN_TENANTS_TO_CELL.name();
        Call assignRequest = new Call(apiName, this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            AssignTenantsToCellRequest.Builder createRequest(int timeoutMs) {
                return new AssignTenantsToCellRequest.Builder(new AssignTenantsToCellRequestData().setTenantsToAssign(new ArrayList<AssignTenantsToCellRequestData.TenantToCellAssignment>(assignments)));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                AssignTenantsToCellResponse response = (AssignTenantsToCellResponse)abstractResponse;
                Errors error = Errors.forCode(response.data().errorCode());
                if (error == Errors.NONE) {
                    future.complete(response.data().failedTenants());
                } else if (error == Errors.NOT_CONTROLLER) {
                    KafkaAdminClient.this.handleNotControllerError(error);
                } else {
                    future.completeExceptionally(error.exception(response.data().errorMessage()));
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        };
        this.runnable.call(assignRequest, now);
        return new AssignTenantsToCellResult(future);
    }

    @Override
    @Confluent
    public AlterCellMigrationResult alterCellMigration(final CellMigrationState state, AlterCellMigrationOptions options) {
        final KafkaFutureImpl<Void> future = new KafkaFutureImpl<Void>();
        long now = this.time.milliseconds();
        String apiName = ApiKeys.ALTER_CELL_MIGRATION.name();
        Call cellsRequest = new Call(apiName, this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            AlterCellMigrationRequest.Builder createRequest(int timeoutMs) {
                return new AlterCellMigrationRequest.Builder(new AlterCellMigrationRequestData().setState(state.code()));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                AlterCellMigrationResponse response = (AlterCellMigrationResponse)abstractResponse;
                Errors error = Errors.forCode(response.data().errorCode());
                if (error == Errors.NONE) {
                    future.complete(null);
                } else if (error == Errors.NOT_CONTROLLER) {
                    KafkaAdminClient.this.handleNotControllerError(error);
                } else {
                    future.completeExceptionally(error.exception(response.data().errorMessage()));
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        };
        this.runnable.call(cellsRequest, now);
        return new AlterCellMigrationResult(future);
    }

    @Override
    @Confluent
    public DescribeCellMigrationResult describeCellMigration(DescribeCellMigrationOptions options) {
        final KafkaFutureImpl<DescribeCellMigrationResponseData> future = new KafkaFutureImpl<DescribeCellMigrationResponseData>();
        long now = this.time.milliseconds();
        String apiName = ApiKeys.DESCRIBE_CELL_MIGRATION.name();
        Call cellsRequest = new Call(apiName, this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            DescribeCellMigrationRequest.Builder createRequest(int timeoutMs) {
                return new DescribeCellMigrationRequest.Builder(new DescribeCellMigrationRequestData());
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DescribeCellMigrationResponse response = (DescribeCellMigrationResponse)abstractResponse;
                Errors error = Errors.forCode(response.data().errorCode());
                if (error == Errors.NONE) {
                    future.complete(response.data());
                } else if (error == Errors.NOT_CONTROLLER) {
                    KafkaAdminClient.this.handleNotControllerError(error);
                } else {
                    future.completeExceptionally(error.exception(response.data().errorMessage()));
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        };
        this.runnable.call(cellsRequest, now);
        return new DescribeCellMigrationResult(future);
    }

    @Override
    public CellLoadResult describeCellLoad(Collection<Integer> cellIds) {
        return this.describeCellLoad(cellIds, new DescribeCellLoadOptions());
    }

    @Override
    public ElectLeadersResult electLeaders(final ElectionType electionType, final Set<TopicPartition> topicPartitions, ElectLeadersOptions options) {
        final KafkaFutureImpl<Map<TopicPartition, Optional<Throwable>>> electionFuture = new KafkaFutureImpl<Map<TopicPartition, Optional<Throwable>>>();
        long now = this.time.milliseconds();
        this.runnable.call(new Call("electLeaders", this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            public ElectLeadersRequest.Builder createRequest(int timeoutMs) {
                return new ElectLeadersRequest.Builder(electionType, topicPartitions, timeoutMs);
            }

            @Override
            public void handleResponse(AbstractResponse abstractResponse) {
                ElectLeadersResponse response = (ElectLeadersResponse)abstractResponse;
                Map<TopicPartition, Optional<Throwable>> result = ElectLeadersResponse.electLeadersResult(response.data());
                Errors error = Errors.forCode(response.data().errorCode());
                if (error != Errors.NONE) {
                    electionFuture.completeExceptionally(error.exception());
                    return;
                }
                electionFuture.complete(result);
            }

            @Override
            void handleFailure(Throwable throwable) {
                electionFuture.completeExceptionally(throwable);
            }
        }, now);
        return new ElectLeadersResult(electionFuture);
    }

    @Override
    public AlterPartitionReassignmentsResult alterPartitionReassignments(Map<TopicPartition, Optional<NewPartitionReassignment>> reassignments, AlterPartitionReassignmentsOptions options) {
        final HashMap futures = new HashMap();
        final TreeMap<String, TreeMap<Integer, Optional<NewPartitionReassignment>>> topicsToReassignments = new TreeMap<String, TreeMap<Integer, Optional<NewPartitionReassignment>>>();
        for (Map.Entry<TopicPartition, Optional<NewPartitionReassignment>> entry : reassignments.entrySet()) {
            String topic = entry.getKey().topic();
            int partition = entry.getKey().partition();
            TopicPartition topicPartition = new TopicPartition(topic, partition);
            Optional<NewPartitionReassignment> reassignment = entry.getValue();
            KafkaFutureImpl future = new KafkaFutureImpl();
            futures.put(topicPartition, future);
            if (KafkaAdminClient.topicNameIsUnrepresentable(topic)) {
                future.completeExceptionally(new InvalidTopicException("The given topic name '" + topic + "' cannot be represented in a request."));
                continue;
            }
            if (topicPartition.partition() < 0) {
                future.completeExceptionally(new InvalidTopicException("The given partition index " + topicPartition.partition() + " is not valid."));
                continue;
            }
            TreeMap<Integer, Optional<NewPartitionReassignment>> partitionReassignments = (TreeMap<Integer, Optional<NewPartitionReassignment>>)topicsToReassignments.get(topicPartition.topic());
            if (partitionReassignments == null) {
                partitionReassignments = new TreeMap<Integer, Optional<NewPartitionReassignment>>();
                topicsToReassignments.put(topic, partitionReassignments);
            }
            partitionReassignments.put(partition, reassignment);
        }
        long now = this.time.milliseconds();
        Call call = new Call("alterPartitionReassignments", this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            public AlterPartitionReassignmentsRequest.Builder createRequest(int timeoutMs) {
                AlterPartitionReassignmentsRequestData data = new AlterPartitionReassignmentsRequestData();
                for (Map.Entry entry : topicsToReassignments.entrySet()) {
                    String topicName = (String)entry.getKey();
                    Map partitionsToReassignments = (Map)entry.getValue();
                    ArrayList<AlterPartitionReassignmentsRequestData.ReassignablePartition> reassignablePartitions = new ArrayList<AlterPartitionReassignmentsRequestData.ReassignablePartition>();
                    for (Map.Entry partitionEntry : partitionsToReassignments.entrySet()) {
                        int partitionIndex = (Integer)partitionEntry.getKey();
                        Optional reassignment = (Optional)partitionEntry.getValue();
                        AlterPartitionReassignmentsRequestData.ReassignablePartition reassignablePartition = new AlterPartitionReassignmentsRequestData.ReassignablePartition().setPartitionIndex(partitionIndex).setReplicas(reassignment.map(NewPartitionReassignment::targetReplicas).orElse(null)).setObservers(reassignment.map(NewPartitionReassignment::targetObservers).orElse(Collections.emptyList()));
                        reassignablePartitions.add(reassignablePartition);
                    }
                    AlterPartitionReassignmentsRequestData.ReassignableTopic reassignableTopic = new AlterPartitionReassignmentsRequestData.ReassignableTopic().setName(topicName).setPartitions(reassignablePartitions);
                    data.topics().add(reassignableTopic);
                }
                data.setTimeoutMs(timeoutMs);
                return new AlterPartitionReassignmentsRequest.Builder(data);
            }

            @Override
            public void handleResponse(AbstractResponse abstractResponse) {
                AlterPartitionReassignmentsResponse response = (AlterPartitionReassignmentsResponse)abstractResponse;
                HashMap<TopicPartition, ApiException> errors = new HashMap<TopicPartition, ApiException>();
                int receivedResponsesCount = 0;
                Errors topLevelError = Errors.forCode(response.data().errorCode());
                switch (topLevelError) {
                    case NONE: {
                        receivedResponsesCount += this.validateTopicResponses(response.data().responses(), errors);
                        break;
                    }
                    case NOT_CONTROLLER: {
                        KafkaAdminClient.this.handleNotControllerError(topLevelError);
                        break;
                    }
                    default: {
                        for (AlterPartitionReassignmentsResponseData.ReassignableTopicResponse reassignableTopicResponse : response.data().responses()) {
                            String topicName = reassignableTopicResponse.name();
                            for (AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse partition : reassignableTopicResponse.partitions()) {
                                errors.put(new TopicPartition(topicName, partition.partitionIndex()), new ApiError(topLevelError, response.data().errorMessage()).exception());
                                ++receivedResponsesCount;
                            }
                        }
                    }
                }
                this.assertResponseCountMatch(errors, receivedResponsesCount);
                for (Map.Entry entry : errors.entrySet()) {
                    ApiException exception = (ApiException)entry.getValue();
                    if (exception == null) {
                        ((KafkaFutureImpl)futures.get(entry.getKey())).complete(null);
                        continue;
                    }
                    ((KafkaFutureImpl)futures.get(entry.getKey())).completeExceptionally(exception);
                }
            }

            private void assertResponseCountMatch(Map<TopicPartition, ApiException> errors, int receivedResponsesCount) {
                int expectedResponsesCount = topicsToReassignments.values().stream().mapToInt(Map::size).sum();
                if (errors.values().stream().noneMatch(Objects::nonNull) && receivedResponsesCount != expectedResponsesCount) {
                    String quantifier = receivedResponsesCount > expectedResponsesCount ? "many" : "less";
                    throw new UnknownServerException("The server returned too " + quantifier + " results.Expected " + expectedResponsesCount + " but received " + receivedResponsesCount);
                }
            }

            private int validateTopicResponses(List<AlterPartitionReassignmentsResponseData.ReassignableTopicResponse> topicResponses, Map<TopicPartition, ApiException> errors) {
                int receivedResponsesCount = 0;
                for (AlterPartitionReassignmentsResponseData.ReassignableTopicResponse topicResponse : topicResponses) {
                    String topicName = topicResponse.name();
                    for (AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse partResponse : topicResponse.partitions()) {
                        Errors partitionError = Errors.forCode(partResponse.errorCode());
                        TopicPartition tp = new TopicPartition(topicName, partResponse.partitionIndex());
                        if (partitionError == Errors.NONE) {
                            errors.put(tp, null);
                        } else {
                            errors.put(tp, new ApiError(partitionError, partResponse.errorMessage()).exception());
                        }
                        ++receivedResponsesCount;
                    }
                }
                return receivedResponsesCount;
            }

            @Override
            void handleFailure(Throwable throwable) {
                for (KafkaFutureImpl future : futures.values()) {
                    future.completeExceptionally(throwable);
                }
            }
        };
        if (!topicsToReassignments.isEmpty()) {
            this.runnable.call(call, now);
        }
        return new AlterPartitionReassignmentsResult(new HashMap<TopicPartition, KafkaFuture<Void>>(futures));
    }

    @Override
    public ListPartitionReassignmentsResult listPartitionReassignments(final Optional<Set<TopicPartition>> partitions, ListPartitionReassignmentsOptions options) {
        final KafkaFutureImpl<Map<TopicPartition, PartitionReassignment>> partitionReassignmentsFuture = new KafkaFutureImpl<Map<TopicPartition, PartitionReassignment>>();
        if (partitions.isPresent()) {
            for (TopicPartition tp : partitions.get()) {
                String topic = tp.topic();
                int partition = tp.partition();
                if (KafkaAdminClient.topicNameIsUnrepresentable(topic)) {
                    partitionReassignmentsFuture.completeExceptionally(new InvalidTopicException("The given topic name '" + topic + "' cannot be represented in a request."));
                } else if (partition < 0) {
                    partitionReassignmentsFuture.completeExceptionally(new InvalidTopicException("The given partition index " + partition + " is not valid."));
                }
                if (!partitionReassignmentsFuture.isCompletedExceptionally()) continue;
                return new ListPartitionReassignmentsResult(partitionReassignmentsFuture);
            }
        }
        long now = this.time.milliseconds();
        this.runnable.call(new Call("listPartitionReassignments", this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            ListPartitionReassignmentsRequest.Builder createRequest(int timeoutMs) {
                ListPartitionReassignmentsRequestData listData = new ListPartitionReassignmentsRequestData();
                listData.setTimeoutMs(timeoutMs);
                if (partitions.isPresent()) {
                    HashMap<String, ListPartitionReassignmentsRequestData.ListPartitionReassignmentsTopics> reassignmentTopicByTopicName = new HashMap<String, ListPartitionReassignmentsRequestData.ListPartitionReassignmentsTopics>();
                    for (TopicPartition tp : (Set)partitions.get()) {
                        if (!reassignmentTopicByTopicName.containsKey(tp.topic())) {
                            reassignmentTopicByTopicName.put(tp.topic(), new ListPartitionReassignmentsRequestData.ListPartitionReassignmentsTopics().setName(tp.topic()));
                        }
                        ((ListPartitionReassignmentsRequestData.ListPartitionReassignmentsTopics)reassignmentTopicByTopicName.get(tp.topic())).partitionIndexes().add(tp.partition());
                    }
                    listData.setTopics(new ArrayList<ListPartitionReassignmentsRequestData.ListPartitionReassignmentsTopics>(reassignmentTopicByTopicName.values()));
                }
                return new ListPartitionReassignmentsRequest.Builder(listData);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                ListPartitionReassignmentsResponse response = (ListPartitionReassignmentsResponse)abstractResponse;
                Errors error = Errors.forCode(response.data().errorCode());
                switch (error) {
                    case NONE: {
                        break;
                    }
                    case NOT_CONTROLLER: {
                        KafkaAdminClient.this.handleNotControllerError(error);
                        break;
                    }
                    default: {
                        partitionReassignmentsFuture.completeExceptionally(new ApiError(error, response.data().errorMessage()).exception());
                    }
                }
                HashMap<TopicPartition, PartitionReassignment> reassignmentMap = new HashMap<TopicPartition, PartitionReassignment>();
                for (ListPartitionReassignmentsResponseData.OngoingTopicReassignment topicReassignment : response.data().topics()) {
                    String topicName = topicReassignment.name();
                    for (ListPartitionReassignmentsResponseData.OngoingPartitionReassignment partitionReassignment : topicReassignment.partitions()) {
                        reassignmentMap.put(new TopicPartition(topicName, partitionReassignment.partitionIndex()), new PartitionReassignment(partitionReassignment.replicas(), partitionReassignment.observers(), partitionReassignment.addingReplicas(), partitionReassignment.removingReplicas()));
                    }
                }
                partitionReassignmentsFuture.complete(reassignmentMap);
            }

            @Override
            void handleFailure(Throwable throwable) {
                partitionReassignmentsFuture.completeExceptionally(throwable);
            }
        }, now);
        return new ListPartitionReassignmentsResult(partitionReassignmentsFuture);
    }

    @Override
    @Confluent
    public ReplicaStatusResult replicaStatus(Set<TopicPartition> partitions, final ReplicaStatusOptions options) {
        final HashMap result = new HashMap();
        if (partitions.isEmpty()) {
            return new ReplicaStatusResult(Collections.unmodifiableMap(result));
        }
        final HashSet<String> topics = new HashSet<String>();
        for (TopicPartition partition : partitions) {
            topics.add(partition.topic());
            result.put(partition, new KafkaFutureImpl());
        }
        long nowMetadata = this.time.milliseconds();
        final long deadline = this.calcDeadlineMs(nowMetadata, options.timeoutMs());
        this.runnable.call(new Call("topicsMetadata", deadline, new LeastLoadedNodeProvider()){

            AbstractRequest.Builder createRequest(int timeoutMs) {
                return new MetadataRequest.Builder(new MetadataRequestData().setTopics(MetadataRequest.convertToMetadataRequestTopic(topics)).setAllowAutoTopicCreation(false));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                MetadataResponse response = (MetadataResponse)abstractResponse;
                Map<String, Errors> errors = response.errors();
                Cluster cluster = response.buildCluster();
                HashMap<Node, Set> leaderPartitions = new HashMap<Node, Set>();
                for (final Map.Entry entry : result.entrySet()) {
                    Errors error = errors.get(((TopicPartition)entry.getKey()).topic());
                    if (error != null) {
                        ((KafkaFutureImpl)entry.getValue()).completeExceptionally(error.exception());
                        continue;
                    }
                    PartitionInfo partitionInfo = cluster.partition((TopicPartition)entry.getKey());
                    if (partitionInfo == null) {
                        ((KafkaFutureImpl)entry.getValue()).completeExceptionally(new UnknownTopicOrPartitionException("Partition " + entry.getKey() + " not found."));
                        continue;
                    }
                    if (partitionInfo.leader() == null) {
                        ((KafkaFutureImpl)entry.getValue()).completeExceptionally(new LeaderNotAvailableException("Leader for partition " + entry.getKey() + " not found."));
                        continue;
                    }
                    leaderPartitions.computeIfAbsent(partitionInfo.leader(), k -> new HashSet()).add(entry.getKey());
                }
                for (final Map.Entry entry : leaderPartitions.entrySet()) {
                    final HashMap resultSubset = new HashMap();
                    for (TopicPartition partition : (Set)entry.getValue()) {
                        resultSubset.put(partition, result.get(partition));
                    }
                    long nowStatus = KafkaAdminClient.this.time.milliseconds();
                    KafkaAdminClient.this.runnable.call(new Call("replicaStatus", deadline, new ConstantNodeIdProvider(((Node)entry.getKey()).id())){

                        AbstractRequest.Builder createRequest(int timeoutMs) {
                            return new ReplicaStatusRequest.Builder((Set)entry.getValue(), options.includeLinkedReplicas());
                        }

                        @Override
                        void handleResponse(AbstractResponse abstractResponse) {
                            ReplicaStatusResponse response = (ReplicaStatusResponse)abstractResponse;
                            response.complete(resultSubset);
                        }

                        @Override
                        void handleFailure(Throwable throwable) {
                            KafkaAdminClient.completeAllExceptionally(resultSubset.values(), throwable);
                        }
                    }, nowStatus);
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(result.values(), throwable);
            }
        }, nowMetadata);
        return new ReplicaStatusResult(Collections.unmodifiableMap(result));
    }

    private void handleNotControllerError(AbstractResponse response) throws ApiException {
        if (response.errorCounts().containsKey((Object)Errors.NOT_CONTROLLER)) {
            this.handleNotControllerError(Errors.NOT_CONTROLLER);
        }
    }

    private void handleNotControllerError(Errors error) throws ApiException {
        this.metadataManager.clearController();
        this.metadataManager.requestUpdate();
        throw error.exception();
    }

    private Integer nodeFor(ConfigResource resource) {
        if (resource.type() == ConfigResource.Type.BROKER && !resource.isDefault() || resource.type() == ConfigResource.Type.BROKER_LOGGER) {
            return Integer.valueOf(resource.name());
        }
        return null;
    }

    private List<LeaveGroupRequestData.MemberIdentity> getMembersFromGroup(String groupId, String reason) {
        Collection<MemberDescription> members;
        try {
            members = this.describeConsumerGroups(Collections.singleton(groupId)).describedGroups().get(groupId).get().members();
        }
        catch (Exception ex) {
            throw new KafkaException("Encounter exception when trying to get members from group: " + groupId, ex);
        }
        ArrayList<LeaveGroupRequestData.MemberIdentity> membersToRemove = new ArrayList<LeaveGroupRequestData.MemberIdentity>();
        for (MemberDescription member : members) {
            LeaveGroupRequestData.MemberIdentity memberIdentity = new LeaveGroupRequestData.MemberIdentity().setReason(reason);
            if (member.groupInstanceId().isPresent()) {
                memberIdentity.setGroupInstanceId(member.groupInstanceId().get());
            } else {
                memberIdentity.setMemberId(member.consumerId());
            }
            membersToRemove.add(memberIdentity);
        }
        return membersToRemove;
    }

    @Override
    public RemoveMembersFromConsumerGroupResult removeMembersFromConsumerGroup(String groupId, RemoveMembersFromConsumerGroupOptions options) {
        String reason = options.reason() == null || options.reason().isEmpty() ? DEFAULT_LEAVE_GROUP_REASON : options.reason();
        List<LeaveGroupRequestData.MemberIdentity> members = options.removeAll() ? this.getMembersFromGroup(groupId, reason) : options.members().stream().map(m -> m.toMemberIdentity().setReason(reason)).collect(Collectors.toList());
        AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, Map<LeaveGroupRequestData.MemberIdentity, Errors>> future = RemoveMembersFromConsumerGroupHandler.newFuture(groupId);
        RemoveMembersFromConsumerGroupHandler handler = new RemoveMembersFromConsumerGroupHandler(groupId, members, this.logContext);
        this.invokeDriver(handler, future, options.timeoutMs);
        return new RemoveMembersFromConsumerGroupResult(future.get(CoordinatorKey.byGroupId(groupId)), options.members());
    }

    @Override
    public AlterConsumerGroupOffsetsResult alterConsumerGroupOffsets(String groupId, Map<TopicPartition, OffsetAndMetadata> offsets, AlterConsumerGroupOffsetsOptions options) {
        AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, Map<TopicPartition, Errors>> future = AlterConsumerGroupOffsetsHandler.newFuture(groupId);
        AlterConsumerGroupOffsetsHandler handler = new AlterConsumerGroupOffsetsHandler(groupId, offsets, this.logContext);
        this.invokeDriver(handler, future, options.timeoutMs);
        return new AlterConsumerGroupOffsetsResult(future.get(CoordinatorKey.byGroupId(groupId)));
    }

    @Override
    public ListOffsetsResult listOffsets(Map<TopicPartition, OffsetSpec> topicPartitionOffsets, ListOffsetsOptions options) {
        AdminApiFuture.SimpleAdminApiFuture<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> future = ListOffsetsHandler.newFuture(topicPartitionOffsets.keySet());
        Map<TopicPartition, Long> offsetQueriesByPartition = topicPartitionOffsets.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> KafkaAdminClient.getOffsetFromSpec((OffsetSpec)e.getValue())));
        ListOffsetsHandler handler = new ListOffsetsHandler(offsetQueriesByPartition, options, this.logContext);
        this.invokeDriver(handler, future, options.timeoutMs);
        return new ListOffsetsResult(future.all());
    }

    @Override
    public DescribeClientQuotasResult describeClientQuotas(final ClientQuotaFilter filter, DescribeClientQuotasOptions options) {
        final KafkaFutureImpl<Map<ClientQuotaEntity, Map<String, Double>>> future = new KafkaFutureImpl<Map<ClientQuotaEntity, Map<String, Double>>>();
        long now = this.time.milliseconds();
        this.runnable.call(new Call("describeClientQuotas", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            DescribeClientQuotasRequest.Builder createRequest(int timeoutMs) {
                return new DescribeClientQuotasRequest.Builder(filter);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DescribeClientQuotasResponse response = (DescribeClientQuotasResponse)abstractResponse;
                response.complete(future);
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        }, now);
        return new DescribeClientQuotasResult(future);
    }

    @Override
    public AlterClientQuotasResult alterClientQuotas(final Collection<ClientQuotaAlteration> entries, final AlterClientQuotasOptions options) {
        final HashMap futures = new HashMap(entries.size());
        for (ClientQuotaAlteration entry : entries) {
            futures.put(entry.entity(), new KafkaFutureImpl());
        }
        long now = this.time.milliseconds();
        this.runnable.call(new Call("alterClientQuotas", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            AlterClientQuotasRequest.Builder createRequest(int timeoutMs) {
                return new AlterClientQuotasRequest.Builder(entries, options.validateOnly());
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                AlterClientQuotasResponse response = (AlterClientQuotasResponse)abstractResponse;
                response.complete(futures);
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        }, now);
        return new AlterClientQuotasResult(Collections.unmodifiableMap(futures));
    }

    @Override
    public DescribeUserScramCredentialsResult describeUserScramCredentials(final List<String> users, DescribeUserScramCredentialsOptions options) {
        final KafkaFutureImpl<DescribeUserScramCredentialsResponseData> dataFuture = new KafkaFutureImpl<DescribeUserScramCredentialsResponseData>();
        long now = this.time.milliseconds();
        Call call = new Call("describeUserScramCredentials", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            public DescribeUserScramCredentialsRequest.Builder createRequest(int timeoutMs) {
                DescribeUserScramCredentialsRequestData requestData = new DescribeUserScramCredentialsRequestData();
                if (users != null && !users.isEmpty()) {
                    ArrayList<DescribeUserScramCredentialsRequestData.UserName> userNames = new ArrayList<DescribeUserScramCredentialsRequestData.UserName>(users.size());
                    for (String user : users) {
                        if (user == null) continue;
                        userNames.add(new DescribeUserScramCredentialsRequestData.UserName().setName(user));
                    }
                    requestData.setUsers(userNames);
                }
                return new DescribeUserScramCredentialsRequest.Builder(requestData);
            }

            @Override
            public void handleResponse(AbstractResponse abstractResponse) {
                DescribeUserScramCredentialsResponse response = (DescribeUserScramCredentialsResponse)abstractResponse;
                DescribeUserScramCredentialsResponseData data = response.data();
                short messageLevelErrorCode = data.errorCode();
                if (messageLevelErrorCode != Errors.NONE.code()) {
                    dataFuture.completeExceptionally(Errors.forCode(messageLevelErrorCode).exception(data.errorMessage()));
                } else {
                    dataFuture.complete(data);
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                dataFuture.completeExceptionally(throwable);
            }
        };
        this.runnable.call(call, now);
        return new DescribeUserScramCredentialsResult(dataFuture);
    }

    @Override
    public AlterUserScramCredentialsResult alterUserScramCredentials(final List<UserScramCredentialAlteration> alterations, AlterUserScramCredentialsOptions options) {
        long now = this.time.milliseconds();
        final HashMap futures = new HashMap();
        for (UserScramCredentialAlteration alteration2 : alterations) {
            futures.put(alteration2.user(), new KafkaFutureImpl());
        }
        final HashMap userIllegalAlterationExceptions = new HashMap();
        String usernameMustNotBeEmptyMsg = "Username must not be empty";
        String passwordMustNotBeEmptyMsg = "Password must not be empty";
        String unknownScramMechanismMsg = "Unknown SCRAM mechanism";
        alterations.stream().filter(a -> a instanceof UserScramCredentialDeletion).forEach(alteration -> {
            String user = alteration.user();
            if (user == null || user.isEmpty()) {
                userIllegalAlterationExceptions.put(alteration.user(), new UnacceptableCredentialException("Username must not be empty"));
            } else {
                UserScramCredentialDeletion deletion = (UserScramCredentialDeletion)alteration;
                ScramMechanism mechanism = deletion.mechanism();
                if (mechanism == null || mechanism == ScramMechanism.UNKNOWN) {
                    userIllegalAlterationExceptions.put(user, new UnsupportedSaslMechanismException("Unknown SCRAM mechanism"));
                }
            }
        });
        final HashMap userInsertions = new HashMap();
        alterations.stream().filter(a -> a instanceof UserScramCredentialUpsertion).filter(alteration -> !userIllegalAlterationExceptions.containsKey(alteration.user())).forEach(alteration -> {
            String user = alteration.user();
            if (user == null || user.isEmpty()) {
                userIllegalAlterationExceptions.put(alteration.user(), new UnacceptableCredentialException("Username must not be empty"));
            } else {
                UserScramCredentialUpsertion upsertion = (UserScramCredentialUpsertion)alteration;
                try {
                    byte[] password = upsertion.password();
                    if (password == null || password.length == 0) {
                        userIllegalAlterationExceptions.put(user, new UnacceptableCredentialException(passwordMustNotBeEmptyMsg));
                    } else {
                        ScramMechanism mechanism = upsertion.credentialInfo().mechanism();
                        if (mechanism == null || mechanism == ScramMechanism.UNKNOWN) {
                            userIllegalAlterationExceptions.put(user, new UnsupportedSaslMechanismException("Unknown SCRAM mechanism"));
                        } else {
                            userInsertions.putIfAbsent(user, new HashMap());
                            ((Map)userInsertions.get(user)).put(mechanism, KafkaAdminClient.getScramCredentialUpsertion(upsertion));
                        }
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    userIllegalAlterationExceptions.put(user, new UnsupportedSaslMechanismException("Unknown SCRAM mechanism"));
                }
                catch (InvalidKeyException e) {
                    userIllegalAlterationExceptions.put(user, new UnacceptableCredentialException(e.getMessage(), e));
                }
            }
        });
        Call call = new Call("alterUserScramCredentials", this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            public AlterUserScramCredentialsRequest.Builder createRequest(int timeoutMs) {
                return new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setUpsertions(alterations.stream().filter(a -> a instanceof UserScramCredentialUpsertion).filter(a -> !userIllegalAlterationExceptions.containsKey(a.user())).map(a -> (AlterUserScramCredentialsRequestData.ScramCredentialUpsertion)((Map)userInsertions.get(a.user())).get((Object)((UserScramCredentialUpsertion)a).credentialInfo().mechanism())).collect(Collectors.toList())).setDeletions(alterations.stream().filter(a -> a instanceof UserScramCredentialDeletion).filter(a -> !userIllegalAlterationExceptions.containsKey(a.user())).map(d -> KafkaAdminClient.getScramCredentialDeletion((UserScramCredentialDeletion)d)).collect(Collectors.toList())));
            }

            @Override
            public void handleResponse(AbstractResponse abstractResponse) {
                AlterUserScramCredentialsResponse response = (AlterUserScramCredentialsResponse)abstractResponse;
                for (Errors error : response.errorCounts().keySet()) {
                    if (error != Errors.NOT_CONTROLLER) continue;
                    KafkaAdminClient.this.handleNotControllerError(error);
                }
                userIllegalAlterationExceptions.entrySet().stream().forEach(entry -> ((KafkaFutureImpl)futures.get(entry.getKey())).completeExceptionally((Throwable)entry.getValue()));
                response.data().results().forEach(result -> {
                    KafkaFutureImpl future = (KafkaFutureImpl)futures.get(result.user());
                    if (future == null) {
                        KafkaAdminClient.this.log.warn("Server response mentioned unknown user {}", (Object)result.user());
                    } else {
                        Errors error = Errors.forCode(result.errorCode());
                        if (error != Errors.NONE) {
                            future.completeExceptionally(error.exception(result.errorMessage()));
                        } else {
                            future.complete(null);
                        }
                    }
                });
                KafkaAdminClient.completeUnrealizedFutures(futures.entrySet().stream(), user -> "The broker response did not contain a result for user " + user);
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        };
        this.runnable.call(call, now);
        return new AlterUserScramCredentialsResult(new HashMap<String, KafkaFuture<Void>>(futures));
    }

    private static AlterUserScramCredentialsRequestData.ScramCredentialUpsertion getScramCredentialUpsertion(UserScramCredentialUpsertion u) throws InvalidKeyException, NoSuchAlgorithmException {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion retval = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion();
        return retval.setName(u.user()).setMechanism(u.credentialInfo().mechanism().type()).setIterations(u.credentialInfo().iterations()).setSalt(u.salt()).setSaltedPassword(KafkaAdminClient.getSaltedPassword(u.credentialInfo().mechanism(), u.password(), u.salt(), u.credentialInfo().iterations()));
    }

    private static AlterUserScramCredentialsRequestData.ScramCredentialDeletion getScramCredentialDeletion(UserScramCredentialDeletion d) {
        return new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(d.user()).setMechanism(d.mechanism().type());
    }

    private static byte[] getSaltedPassword(ScramMechanism publicScramMechanism, byte[] password, byte[] salt, int iterations) throws NoSuchAlgorithmException, InvalidKeyException {
        return new ScramFormatter(org.apache.kafka.common.security.scram.internals.ScramMechanism.forMechanismName(publicScramMechanism.mechanismName())).hi(password, salt, iterations);
    }

    private boolean brokerIdIsUnrepresentable(Integer brokerId) {
        return brokerId < 0;
    }

    @Override
    @Confluent
    public AlterBrokerReplicaExclusionsResult alterBrokerReplicaExclusions(final Map<Integer, ExclusionOp> operations, AlterBrokerReplicaExclusionsOptions options) {
        final KafkaFutureImpl<AlterBrokerReplicaExclusionsResult.ExclusionsResult> future = new KafkaFutureImpl<AlterBrokerReplicaExclusionsResult.ExclusionsResult>();
        if (operations.isEmpty()) {
            future.completeExceptionally(new InvalidBrokerReplicaExclusionException("Brokers to exclude map is empty"));
            return new AlterBrokerReplicaExclusionsResult(future);
        }
        for (Map.Entry<Integer, ExclusionOp> exclusionOpEntry : operations.entrySet()) {
            int brokerId = exclusionOpEntry.getKey();
            if (this.brokerIdIsUnrepresentable(brokerId)) {
                future.completeExceptionally(new UnrepresentableBrokerIdException(String.format("The given broker id %s is invalid", brokerId), brokerId));
                return new AlterBrokerReplicaExclusionsResult(future);
            }
            try {
                ExclusionRequestUtils.validateReason(exclusionOpEntry.getValue().reason());
            }
            catch (IllegalArgumentException e) {
                future.completeExceptionally(new InvalidBrokerReplicaExclusionException("Invalid replica exclusion reason", e));
                return new AlterBrokerReplicaExclusionsResult(future);
            }
        }
        long now = this.time.milliseconds();
        Call call = new Call("alterBrokerReplicaExclusions", this.calcDeadlineMs(now, options.timeoutMs), new ControllerNodeProvider()){

            AlterBrokerReplicaExclusionsRequest.Builder createRequest(int timeoutMs) {
                AlterBrokerReplicaExclusionsRequest.Builder builder = new AlterBrokerReplicaExclusionsRequest.Builder();
                for (Map.Entry exclusionOpEntry : operations.entrySet()) {
                    builder.addExclusion((Integer)exclusionOpEntry.getKey(), (ExclusionOp)exclusionOpEntry.getValue());
                }
                return builder;
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                AlterBrokerReplicaExclusionsResponse response = (AlterBrokerReplicaExclusionsResponse)abstractResponse;
                Errors topLevelError = Errors.forCode(response.data().errorCode());
                switch (topLevelError) {
                    case NONE: {
                        break;
                    }
                    case NOT_CONTROLLER: {
                        KafkaAdminClient.this.handleNotControllerError(topLevelError);
                        break;
                    }
                    default: {
                        future.completeExceptionally(topLevelError.exception());
                        return;
                    }
                }
                HashMap<Integer, ExclusionOpResult> exclusionsByBroker = new HashMap<Integer, ExclusionOpResult>();
                for (AlterBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse brokerExclusion : response.data().brokerExclusions()) {
                    short errorCode = brokerExclusion.exclusionErrorCode();
                    ExclusionOperationError error = brokerExclusion.exclusionErrorCode() == Errors.NONE.code() ? null : new ExclusionOperationError(Errors.forCode(errorCode), brokerExclusion.exclusionErrorMessage());
                    ExclusionOp op = new ExclusionOp(ExclusionOp.OpType.forId(brokerExclusion.exclusionOperationCode()), brokerExclusion.reason());
                    ExclusionOpResult opResult = new ExclusionOpResult(op, error);
                    exclusionsByBroker.put(brokerExclusion.brokerId(), opResult);
                }
                future.complete(new AlterBrokerReplicaExclusionsResult.ExclusionsResult(exclusionsByBroker, response.data().wasApplied()));
            }
        };
        this.runnable.call(call, now);
        return new AlterBrokerReplicaExclusionsResult(future);
    }

    @Override
    @Confluent
    public DescribeBrokerReplicaExclusionsResult describeBrokerReplicaExclusions(DescribeBrokerReplicaExclusionsOptions options) {
        final KafkaFutureImpl<List<DescribeBrokerReplicaExclusionsResult.BrokerReplicaExclusionDescription>> future = new KafkaFutureImpl<List<DescribeBrokerReplicaExclusionsResult.BrokerReplicaExclusionDescription>>();
        long now = this.time.milliseconds();
        Call call = new Call("describeBrokerReplicaExclusions", this.calcDeadlineMs(now, options.timeoutMs), new ControllerNodeProvider()){

            DescribeBrokerReplicaExclusionsRequest.Builder createRequest(int timeoutMs) {
                DescribeBrokerReplicaExclusionsRequestData data = new DescribeBrokerReplicaExclusionsRequestData();
                return new DescribeBrokerReplicaExclusionsRequest.Builder(data);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DescribeBrokerReplicaExclusionsResponse response = (DescribeBrokerReplicaExclusionsResponse)abstractResponse;
                Errors topLevelError = Errors.forCode(response.data().errorCode());
                switch (topLevelError) {
                    case NONE: {
                        break;
                    }
                    case NOT_CONTROLLER: {
                        KafkaAdminClient.this.handleNotControllerError(topLevelError);
                        break;
                    }
                    default: {
                        future.completeExceptionally(topLevelError.exception(response.data().errorMessage()));
                        return;
                    }
                }
                List descriptions = response.data().excludedBrokers().stream().map(e -> new DescribeBrokerReplicaExclusionsResult.BrokerReplicaExclusionDescription(e.brokerId(), e.reason())).collect(Collectors.toList());
                future.complete(descriptions);
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        };
        this.runnable.call(call, now);
        return new DescribeBrokerReplicaExclusionsResult(future);
    }

    @Override
    @Confluent
    public RemoveBrokersResult removeBrokers(final List<Integer> brokersToRemove, final RemoveBrokersOptions options) {
        KafkaFutureImpl future;
        final HashMap removeBrokerFutures = new HashMap(brokersToRemove.size());
        HashMap<Integer, KafkaFutureImpl> invalidRemoveBrokerFutures = new HashMap<Integer, KafkaFutureImpl>();
        if (brokersToRemove.isEmpty()) {
            KafkaFutureImpl future2 = new KafkaFutureImpl();
            future2.completeExceptionally(new InvalidBrokerRemovalException("Broker to remove list is empty."));
            invalidRemoveBrokerFutures.put(null, future2);
            return new RemoveBrokersResult(new HashMap<Integer, KafkaFuture<Void>>(invalidRemoveBrokerFutures));
        }
        for (Integer n : brokersToRemove) {
            if (n == null) continue;
            if (this.brokerIdIsUnrepresentable(n)) {
                future = new KafkaFutureImpl();
                future.completeExceptionally(new InvalidBrokerRemovalException("The given broker id '" + n + "' is invalid and cannot be represented in a request"));
                invalidRemoveBrokerFutures.put(n, future);
                continue;
            }
            if (removeBrokerFutures.containsKey(n)) {
                future = new KafkaFutureImpl();
                future.completeExceptionally(new InvalidBrokerRemovalException("The given broker id '" + n + "' is duplicate and cannot be represented in a request"));
                invalidRemoveBrokerFutures.put(n, future);
                continue;
            }
            removeBrokerFutures.put(n, new KafkaFutureImpl());
        }
        if (!invalidRemoveBrokerFutures.isEmpty()) {
            for (Map.Entry entry : removeBrokerFutures.entrySet()) {
                future = (KafkaFutureImpl)entry.getValue();
                future.completeExceptionally(new InvalidBrokerRemovalException("The request contains some invalid or duplicate broker ids"));
                invalidRemoveBrokerFutures.putIfAbsent((Integer)entry.getKey(), future);
            }
            return new RemoveBrokersResult(new HashMap<Integer, KafkaFuture<Void>>(invalidRemoveBrokerFutures));
        }
        long now = this.time.milliseconds();
        Call call = new Call("removeBrokers", this.calcDeadlineMs(now, options.timeoutMs), new ControllerNodeProvider()){

            RemoveBrokersRequest.Builder createRequest(int timeoutMs) {
                Set<RemoveBrokersRequestData.BrokerId> brokerIds = brokersToRemove.stream().map(brokerId -> new RemoveBrokersRequestData.BrokerId().setBrokerId((int)brokerId)).collect(Collectors.toSet());
                return new RemoveBrokersRequest.Builder(brokerIds, options.shouldShutdownBrokers);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                KafkaFutureImpl future;
                RemoveBrokersResponse response = (RemoveBrokersResponse)abstractResponse;
                Errors topLevelError = Errors.forCode(response.data().errorCode());
                switch (topLevelError) {
                    case NONE: {
                        break;
                    }
                    case NOT_CONTROLLER: {
                        KafkaAdminClient.this.handleNotControllerError(topLevelError);
                        break;
                    }
                    default: {
                        KafkaAdminClient.completeAllExceptionally(removeBrokerFutures.values(), topLevelError.exception(response.data().errorMessage()));
                        return;
                    }
                }
                for (RemoveBrokersResponseData.RemoveBrokerResponse removeBrokerResponse : response.data().brokersToRemove()) {
                    future = (KafkaFutureImpl)removeBrokerFutures.get(removeBrokerResponse.brokerId());
                    if (future == null) {
                        KafkaAdminClient.this.log.warn("Server response mentioned unknown broker id {}", (Object)removeBrokerResponse.brokerId());
                        continue;
                    }
                    Errors error = Errors.forCode(removeBrokerResponse.errorCode());
                    if (error == Errors.NONE) {
                        future.complete(null);
                        continue;
                    }
                    future.completeExceptionally(error.exception());
                }
                for (Map.Entry entry : removeBrokerFutures.entrySet()) {
                    future = (KafkaFutureImpl)entry.getValue();
                    if (future.isDone()) continue;
                    future.completeExceptionally(new ApiException("The server response did not contain a reference to broker " + entry.getKey()));
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(removeBrokerFutures.values(), throwable);
            }
        };
        this.runnable.call(call, now);
        return new RemoveBrokersResult(new HashMap<Integer, KafkaFuture<Void>>(removeBrokerFutures));
    }

    @Override
    @Confluent
    public DescribeBrokerAdditionsResult describeBrokerAdditions(DescribeBrokerAdditionsOptions options) {
        final KafkaFutureImpl<Map<Integer, BrokerAdditionDescription>> describeBrokerAdditionsFuture = new KafkaFutureImpl<Map<Integer, BrokerAdditionDescription>>();
        long now = this.time.milliseconds();
        Call call = new Call("describeBrokerAdditions", this.calcDeadlineMs(now, options.timeoutMs), new ControllerNodeProvider()){

            DescribeBrokerAdditionsRequest.Builder createRequest(int timeoutMs) {
                return new DescribeBrokerAdditionsRequest.Builder();
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DescribeBrokerAdditionsResponse response = (DescribeBrokerAdditionsResponse)abstractResponse;
                Errors topLevelError = Errors.forCode(response.data().errorCode());
                switch (topLevelError) {
                    case NONE: {
                        break;
                    }
                    case NOT_CONTROLLER: {
                        KafkaAdminClient.this.handleNotControllerError(topLevelError);
                        break;
                    }
                    default: {
                        describeBrokerAdditionsFuture.completeExceptionally(topLevelError.exception(response.data().errorMessage()));
                        return;
                    }
                }
                Map<Integer, BrokerAdditionDescription> descriptions = response.data().brokerAdditions().stream().collect(Collectors.toMap(k -> k.brokerId(), v -> new BrokerAdditionDescription(v.brokerId(), BalancerOperationStatus.toEnum(v.generalOperationStatus()), PartitionReassignmentsStatus.toEnum(v.partitionReassignmentsStatus()), v.additionErrorCode() == Errors.NONE.code() ? Optional.empty() : Optional.of(new BalancerOperationError(Errors.forCode(v.additionErrorCode()), v.additionErrorMessage())), v.createTimeMs(), v.lastUpdateTimeMs())));
                describeBrokerAdditionsFuture.complete(descriptions);
            }

            @Override
            void handleFailure(Throwable throwable) {
                describeBrokerAdditionsFuture.completeExceptionally(throwable);
            }
        };
        this.runnable.call(call, now);
        return new DescribeBrokerAdditionsResult(describeBrokerAdditionsFuture);
    }

    @Override
    @Confluent
    public DescribeBrokerRemovalsResult describeBrokerRemovals(DescribeBrokerRemovalsOptions options) {
        final KafkaFutureImpl<Map<Integer, BrokerRemovalDescription>> describeBrokerRemovalsFuture = new KafkaFutureImpl<Map<Integer, BrokerRemovalDescription>>();
        long now = this.time.milliseconds();
        Call call = new Call("describeBrokerRemovals", this.calcDeadlineMs(now, options.timeoutMs), new ControllerNodeProvider()){

            DescribeBrokerRemovalsRequest.Builder createRequest(int timeoutMs) {
                return new DescribeBrokerRemovalsRequest.Builder();
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DescribeBrokerRemovalsResponse response = (DescribeBrokerRemovalsResponse)abstractResponse;
                Errors topLevelError = Errors.forCode(response.data().errorCode());
                switch (topLevelError) {
                    case NONE: {
                        break;
                    }
                    case NOT_CONTROLLER: {
                        KafkaAdminClient.this.handleNotControllerError(topLevelError);
                        break;
                    }
                    default: {
                        describeBrokerRemovalsFuture.completeExceptionally(new ApiError(topLevelError, response.data().errorMessage()).exception());
                        return;
                    }
                }
                Map<Integer, BrokerRemovalDescription> descriptions = response.data().removedBrokers().stream().collect(Collectors.toMap(k -> k.brokerId(), v -> new BrokerRemovalDescription(v.brokerId(), BalancerOperationStatus.toEnum(v.generalOperationStatus()), BrokerShutdownStatus.toEnum(v.shutdownStatus()), PartitionReassignmentsStatus.toEnum(v.reassignmentsStatus()), BrokerReplicaExclusionStatus.toEnum(v.brokerReplicaExclusionStatus()), v.shutdownScheduled(), v.removalErrorCode() == Errors.NONE.code() ? Optional.empty() : Optional.of(new BrokerRemovalError(Errors.forCode(v.removalErrorCode()), v.removalErrorMessage())), v.createTimeMs(), v.lastUpdateTimeMs())));
                describeBrokerRemovalsFuture.complete(descriptions);
            }

            @Override
            void handleFailure(Throwable throwable) {
                describeBrokerRemovalsFuture.completeExceptionally(throwable);
            }
        };
        this.runnable.call(call, now);
        return new DescribeBrokerRemovalsResult(describeBrokerRemovalsFuture);
    }

    @Override
    @Confluent
    public DescribeBalancerStatusResult describeBalancerStatus(DescribeBalancerStatusOptions options) {
        final KafkaFutureImpl<BalancerStatusDescription> describeBalancerStatusFuture = new KafkaFutureImpl<BalancerStatusDescription>();
        long now = this.time.milliseconds();
        Call call = new Call("describeBalancerStatus", this.calcDeadlineMs(now, options.timeoutMs), new ControllerNodeProvider()){

            DescribeBalancerStatusRequest.Builder createRequest(int timeoutMs) {
                return new DescribeBalancerStatusRequest.Builder();
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DescribeBalancerStatusResponse response = (DescribeBalancerStatusResponse)abstractResponse;
                DescribeBalancerStatusResponseData responseData = response.data();
                Errors topLevelError = Errors.forCode(responseData.errorCode());
                switch (topLevelError) {
                    case NONE: {
                        break;
                    }
                    case NOT_CONTROLLER: {
                        KafkaAdminClient.this.handleNotControllerError(topLevelError);
                        break;
                    }
                    default: {
                        describeBalancerStatusFuture.completeExceptionally(new ApiError(topLevelError, responseData.errorMessage()).exception());
                        return;
                    }
                }
                BalancerOperationError balancerError = responseData.balancerStatus().balancerStatusErrorCode() == Errors.NONE.code() ? null : new BalancerOperationError(Errors.forCode(responseData.balancerStatus().balancerStatusErrorCode()), responseData.balancerStatus().balancerStatusErrorMessage());
                BalancerStatusDescription description = new BalancerStatusDescription(BalancerStatus.toEnum(responseData.balancerStatus().generalBalancerStatus()), Collections.unmodifiableCollection(responseData.balancerStatus().brokerIds()), balancerError);
                describeBalancerStatusFuture.complete(description);
            }

            @Override
            void handleFailure(Throwable throwable) {
                describeBalancerStatusFuture.completeExceptionally(throwable);
            }
        };
        this.runnable.call(call, now);
        return new DescribeBalancerStatusResult(describeBalancerStatusFuture);
    }

    @Override
    public TriggerEvenClusterLoadResult triggerEvenClusterLoad(final List<String> goalList, TriggerEvenClusterLoadOptions options) {
        final KafkaFutureImpl<Void> triggerEvenClusterLoadFuture = new KafkaFutureImpl<Void>();
        long now = this.time.milliseconds();
        Call call = new Call("triggerEvenClusterLoad", this.calcDeadlineMs(now, options.timeoutMs), new ControllerNodeProvider()){

            TriggerEvenClusterLoadRequest.Builder createRequest(int timeoutMs) {
                return new TriggerEvenClusterLoadRequest.Builder(goalList);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                TriggerEvenClusterLoadResponse response = (TriggerEvenClusterLoadResponse)abstractResponse;
                TriggerEvenClusterLoadResponseData responseData = response.data();
                Errors topLevelError = Errors.forCode(responseData.errorCode());
                switch (topLevelError) {
                    case NONE: {
                        break;
                    }
                    case NOT_CONTROLLER: {
                        KafkaAdminClient.this.handleNotControllerError(topLevelError);
                        break;
                    }
                    default: {
                        triggerEvenClusterLoadFuture.completeExceptionally(topLevelError.exception(responseData.errorMessage()));
                    }
                }
                triggerEvenClusterLoadFuture.complete(null);
            }

            @Override
            void handleFailure(Throwable throwable) {
                triggerEvenClusterLoadFuture.completeExceptionally(throwable);
            }
        };
        this.runnable.call(call, now);
        return new TriggerEvenClusterLoadResult(triggerEvenClusterLoadFuture);
    }

    @Override
    @Confluent
    public ComputeEvenClusterLoadPlanResult computeEvenClusterLoadPlan(final List<String> goalList, ComputeEvenClusterLoadPlanOptions options) {
        final KafkaFutureImpl<EvenClusterLoadPlan> future = new KafkaFutureImpl<EvenClusterLoadPlan>();
        long now = this.time.milliseconds();
        Call call = new Call("computeEvenClusterLoadPlan", this.calcDeadlineMs(now, options.timeoutMs), new ControllerNodeProvider()){

            ComputeEvenClusterLoadPlanRequest.Builder createRequest(int timeoutMs) {
                return new ComputeEvenClusterLoadPlanRequest.Builder(goalList);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                ComputeEvenClusterLoadPlanResponse response = (ComputeEvenClusterLoadPlanResponse)abstractResponse;
                ComputeEvenClusterLoadPlanResponseData responseData = response.data();
                Errors topLevelError = Errors.forCode(responseData.errorCode());
                switch (topLevelError) {
                    case NONE: {
                        break;
                    }
                    case NOT_CONTROLLER: {
                        KafkaAdminClient.this.handleNotControllerError(topLevelError);
                        break;
                    }
                    default: {
                        future.completeExceptionally(new ApiError(topLevelError, responseData.errorMessage()).exception());
                        return;
                    }
                }
                future.complete(KafkaAdminClient.this.evenClusterLoadPlan(responseData));
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        };
        this.runnable.call(call, now);
        return new ComputeEvenClusterLoadPlanResult(future);
    }

    private EvenClusterLoadPlan evenClusterLoadPlan(ComputeEvenClusterLoadPlanResponseData responseData) {
        return new EvenClusterLoadPlan(new EvenClusterLoadPlanReplicaMovementStats(responseData.interBrokerMoves(), responseData.interBrokerMovesMB(), responseData.leadershipMoves()), new EvenClusterLoadPlanBrokerRelatedStats(responseData.brokersExcludedForLeadership(), responseData.brokersExcludedForReplicaMove(), responseData.newBrokers(), responseData.deadOrRemovedBrokers()), new EvenClusterLoadPlanClusterRelatedStats(responseData.recentWindows(), responseData.partitionCoveragePercent(), responseData.excludedTopics(), responseData.totalBrokers(), responseData.totalReplicas(), responseData.totalTopics()), new EvenClusterLoadPlanDetailedClusterBalanceStats(responseData.balancednessScorePreRebalance(), responseData.balancednessScorePostRebalance(), responseData.clusterLoadPreRebalance().stream().map(broker -> new EvenClusterLoadPlanBrokerStats(broker.brokerId(), broker.host(), broker.diskMB(), broker.diskPercent(), broker.cpuPercent(), broker.leaderNetworkInKBps(), broker.followerNetworkInKBps(), broker.networkOutKBps(), broker.potentialNetworkOutKBps(), broker.leaders(), broker.replicas())).collect(Collectors.toList()), responseData.clusterLoadPostRebalance().stream().map(broker -> new EvenClusterLoadPlanBrokerStats(broker.brokerId(), broker.host(), broker.diskMB(), broker.diskPercent(), broker.cpuPercent(), broker.leaderNetworkInKBps(), broker.followerNetworkInKBps(), broker.networkOutKBps(), broker.potentialNetworkOutKBps(), broker.leaders(), broker.replicas())).collect(Collectors.toList())), new EvenClusterLoadPlanGoalRelatedStats(responseData.movementGeneratingGoals(), responseData.goalStats().stream().map(gs -> new EvenClusterLoadPlanGoalStats(gs.goalName(), new EvenClusterLoadPlanGoalStatsResources(gs.avgResources().cpuPercent(), gs.avgResources().networkInboundKBps(), gs.avgResources().producerInboundKBps(), gs.avgResources().networkOutboundKBps(), gs.avgResources().consumerOutboundKBps(), gs.avgResources().diskMB(), gs.avgResources().potentialNwOutKBps(), gs.avgResources().replicas(), gs.avgResources().leaderReplicas(), gs.avgResources().topicReplicas()), new EvenClusterLoadPlanGoalStatsResources(gs.maxResources().cpuPercent(), gs.maxResources().networkInboundKBps(), gs.maxResources().producerInboundKBps(), gs.maxResources().networkOutboundKBps(), gs.maxResources().consumerOutboundKBps(), gs.maxResources().diskMB(), gs.maxResources().potentialNwOutKBps(), gs.maxResources().replicas(), gs.maxResources().leaderReplicas(), gs.maxResources().topicReplicas()), new EvenClusterLoadPlanGoalStatsResources(gs.minResources().cpuPercent(), gs.minResources().networkInboundKBps(), gs.minResources().producerInboundKBps(), gs.minResources().networkOutboundKBps(), gs.minResources().consumerOutboundKBps(), gs.minResources().diskMB(), gs.minResources().potentialNwOutKBps(), gs.minResources().replicas(), gs.minResources().leaderReplicas(), gs.minResources().topicReplicas()), new EvenClusterLoadPlanGoalStatsResources(gs.stdResources().cpuPercent(), gs.stdResources().networkInboundKBps(), gs.stdResources().producerInboundKBps(), gs.stdResources().networkOutboundKBps(), gs.stdResources().consumerOutboundKBps(), gs.stdResources().diskMB(), gs.stdResources().potentialNwOutKBps(), gs.stdResources().replicas(), gs.stdResources().leaderReplicas(), gs.stdResources().topicReplicas()), new EvenClusterLoadPlanGoalStatsOverview(gs.goalOverview().goalStatus(), gs.goalOverview().rejectingGoals().stream().map(rj -> new EvenClusterLoadPlanGoalStatsOverviewRejectingGoal(rj.goalName(), rj.proposalsRejected())).collect(Collectors.toList()), gs.goalOverview().proposalsGenerated(), gs.goalOverview().proposalsRejected(), gs.goalOverview().proposalsRejectedPercent(), gs.goalOverview().proposalsAccepted(), gs.goalOverview().proposalsAcceptedPercent(), gs.goalOverview().moves(), gs.goalOverview().swaps()))).collect(Collectors.toList()), responseData.violatedGoalsBeforeOptimization(), responseData.violatedGoalsAfterOptimization()));
    }

    @Override
    public DescribeEvenClusterLoadStatusResult describeEvenClusterLoadStatus(DescribeEvenClusterLoadStatusOptions options) {
        final KafkaFutureImpl<EvenClusterLoadStatusDescription> describeEvenClusterLoadStatusFuture = new KafkaFutureImpl<EvenClusterLoadStatusDescription>();
        long now = this.time.milliseconds();
        Call call = new Call("describeEvenClusterLoadStatus", this.calcDeadlineMs(now, options.timeoutMs), new ControllerNodeProvider()){

            DescribeEvenClusterLoadStatusRequest.Builder createRequest(int timeoutMs) {
                return new DescribeEvenClusterLoadStatusRequest.Builder();
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DescribeEvenClusterLoadStatusResponse response = (DescribeEvenClusterLoadStatusResponse)abstractResponse;
                DescribeEvenClusterLoadStatusResponseData responseData = response.data();
                DescribeEvenClusterLoadStatusResponseData.EvenClusterLoadStatusResponse evenClusterLoadStatusResponse = responseData.evenClusterLoadStatus();
                Errors topLevelError = Errors.forCode(responseData.errorCode());
                switch (topLevelError) {
                    case NONE: {
                        break;
                    }
                    case NOT_CONTROLLER: {
                        KafkaAdminClient.this.handleNotControllerError(topLevelError);
                        break;
                    }
                    default: {
                        describeEvenClusterLoadStatusFuture.completeExceptionally(new ApiError(topLevelError, responseData.errorMessage()).exception());
                        return;
                    }
                }
                BalancerOperationError evenClusterLoadError = evenClusterLoadStatusResponse.evenClusterLoadErrorCode() == Errors.NONE.code() ? null : new BalancerOperationError(Errors.forCode(evenClusterLoadStatusResponse.evenClusterLoadErrorCode()), evenClusterLoadStatusResponse.evenClusterLoadErrorMessage());
                EvenClusterLoadStatus currStatus = evenClusterLoadStatusResponse.currentStatus() == null ? null : EvenClusterLoadStatus.toEnum(evenClusterLoadStatusResponse.currentStatus());
                EvenClusterLoadStatus prevStatus = evenClusterLoadStatusResponse.previousStatus() == null ? null : EvenClusterLoadStatus.toEnum(evenClusterLoadStatusResponse.previousStatus());
                EvenClusterLoadStatusDescription description = new EvenClusterLoadStatusDescription(BalancerSelfHealMode.toEnum(evenClusterLoadStatusResponse.healUnevenLoadTrigger()), currStatus, prevStatus, evenClusterLoadStatusResponse.currentStatusLastUpdateTimeMs(), evenClusterLoadStatusResponse.previousStatusLastUpdateTimeMs(), evenClusterLoadError);
                describeEvenClusterLoadStatusFuture.complete(description);
            }

            @Override
            void handleFailure(Throwable throwable) {
                describeEvenClusterLoadStatusFuture.completeExceptionally(throwable);
            }
        };
        this.runnable.call(call, now);
        return new DescribeEvenClusterLoadStatusResult(describeEvenClusterLoadStatusFuture);
    }

    @Override
    @Confluent
    public CreateClusterLinksResult createClusterLinks(final Collection<NewClusterLink> clusterLinks, final CreateClusterLinksOptions options) {
        final HashMap results = new HashMap(clusterLinks.size());
        for (NewClusterLink clusterLink : clusterLinks) {
            results.put(clusterLink.linkName(), new KafkaFutureImpl());
        }
        long now = this.time.milliseconds();
        this.runnable.call(new Call("createClusterLinks", this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            CreateClusterLinksRequest.Builder createRequest(int timeoutMs) {
                ArrayList<CreateClusterLinksRequestData.EntryData> entries = new ArrayList<CreateClusterLinksRequestData.EntryData>(clusterLinks.size());
                for (NewClusterLink link : clusterLinks) {
                    Map<String, String> configs = link.configs();
                    ArrayList<CreateClusterLinksRequestData.ConfigData> configData = new ArrayList<CreateClusterLinksRequestData.ConfigData>(configs.size());
                    for (Map.Entry<String, String> entry : configs.entrySet()) {
                        configData.add(new CreateClusterLinksRequestData.ConfigData().setKey(entry.getKey()).setValue(entry.getValue()));
                    }
                    entries.add(new CreateClusterLinksRequestData.EntryData().setConfigs(configData).setLinkName(link.linkName()).setLinkId(link.linkId()).setClusterId(link.clusterId()));
                }
                return new CreateClusterLinksRequest.Builder(new CreateClusterLinksRequestData().setEntries(entries).setValidateOnly(options.validateOnly()).setValidateLink(options.validateLink()).setTimeoutMs(timeoutMs));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                CreateClusterLinksResponse response = (CreateClusterLinksResponse)abstractResponse;
                if (response.errorCounts().getOrDefault((Object)Errors.NOT_CONTROLLER, 0) > 0) {
                    KafkaAdminClient.this.handleNotControllerError(Errors.NOT_CONTROLLER);
                }
                response.complete(results);
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(results.values(), throwable);
            }
        }, now);
        return new CreateClusterLinksResult(Collections.unmodifiableMap(results));
    }

    @Override
    @Confluent
    public ListClusterLinksResult listClusterLinks(final ListClusterLinksOptions options) {
        final KafkaFutureImpl<Collection<ClusterLinkListing>> result = new KafkaFutureImpl<Collection<ClusterLinkListing>>();
        long now = this.time.milliseconds();
        this.runnable.call(new Call("listClusterLinks", this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            ListClusterLinksRequest.Builder createRequest(int timeoutMs) {
                return new ListClusterLinksRequest.Builder(options.linkNames(), options.includeTopics(), timeoutMs);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                ListClusterLinksResponse response = (ListClusterLinksResponse)abstractResponse;
                if (response.errorCounts().getOrDefault((Object)Errors.NOT_CONTROLLER, 0) > 0) {
                    KafkaAdminClient.this.handleNotControllerError(Errors.NOT_CONTROLLER);
                }
                response.complete(result);
            }

            @Override
            void handleFailure(Throwable throwable) {
                result.completeExceptionally(throwable);
            }
        }, now);
        return new ListClusterLinksResult(result);
    }

    @Override
    @Confluent
    public DescribeClusterLinksResult describeClusterLinks(DescribeClusterLinksOptions options) {
        long now = this.time.milliseconds();
        Consumer<ClusterLink.DescribeClusterLinksToControllerInput> unsupportedVersionHandler = input -> this.describeClusterLinksToController(options, input.result, now);
        if (options.linkNames().isPresent()) {
            return this.describeClusterLinksToLinkCoordinators(options.linkNames().get(), options.includeTopics(), options.includeTasks(), options.timeoutMs, unsupportedVersionHandler);
        }
        return this.describeClusterLinksToAllBrokers(options.includeTopics(), options.includeTasks(), options.timeoutMs, unsupportedVersionHandler);
    }

    public void describeClusterLinksToController(final DescribeClusterLinksOptions options, final KafkaFutureImpl<Collection<ClusterLinkDescription>> result, final long now) {
        this.runnable.call(new Call("describeClusterLinks", this.calcDeadlineMs(now, options.timeoutMs), new ControllerNodeProvider()){

            DescribeClusterLinksRequest.Builder createRequest(int timeoutMs) {
                return new DescribeClusterLinksRequest.Builder(options.linkNames(), options.includeTopics(), options.includeTasks(), timeoutMs, ApiKeys.DESCRIBE_CLUSTER_LINKS.oldestVersion(), 3);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DescribeClusterLinksResponse response = (DescribeClusterLinksResponse)abstractResponse;
                Map<Errors, Integer> errorCounts = response.errorCounts();
                if (errorCounts.getOrDefault((Object)Errors.NOT_CONTROLLER, 0) > 0) {
                    KafkaAdminClient.this.handleNotControllerError(Errors.NOT_CONTROLLER);
                }
                if (errorCounts.getOrDefault((Object)Errors.NONE, 0) > 0) {
                    Set<String> clusterLinkNames = response.clusterLinkNames();
                    boolean notFound = false;
                    if (options.linkNames().isPresent()) {
                        for (String inputLinkName : options.linkNames().get()) {
                            if (clusterLinkNames.contains(inputLinkName)) continue;
                            notFound = true;
                            break;
                        }
                    }
                    if (notFound) {
                        long deadlineMs = this.deadlineMs();
                        long timeoutMs = deadlineMs - now;
                        if (deadlineMs - KafkaAdminClient.this.time.milliseconds() > timeoutMs / 2L) {
                            KafkaAdminClient.this.log.debug("Retry due to missing cluster link");
                            throw new TimeoutException("missing cluster link");
                        }
                    }
                }
                response.complete(result);
            }

            @Override
            void handleFailure(Throwable throwable) {
                result.completeExceptionally(throwable);
            }
        }, now);
    }

    private DescribeClusterLinksResult describeClusterLinksToLinkCoordinators(Collection<String> linkNames, boolean includeTopics, boolean includeTasks, Integer driverTimeoutMs, Consumer<ClusterLink.DescribeClusterLinksToControllerInput> unsupportedVersionHandler) {
        AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, ClusterLinkDescription> future = ClusterLink.DescribeClusterLinksLinkCoordinatorsHandler.newFuture(linkNames);
        ClusterLink.DescribeClusterLinksLinkCoordinatorsHandler handler = new ClusterLink.DescribeClusterLinksLinkCoordinatorsHandler(this.logContext, includeTopics, includeTasks, this.requestTimeoutMs);
        this.invokeDriver(handler, future, driverTimeoutMs);
        return new DescribeClusterLinksResult(ClusterLink.linkCoordinatorsFutureToResultFuture(future, unsupportedVersionHandler, this.log));
    }

    private DescribeClusterLinksResult describeClusterLinksToAllBrokers(boolean includeTopics, boolean includeTasks, Integer driverTimeoutMs, Consumer<ClusterLink.DescribeClusterLinksToControllerInput> unsupportedVersionHandler) {
        AllBrokersStrategy.AllBrokersFuture<Collection<ClusterLinkDescription>> future = ClusterLink.DescribeClusterLinksAllBrokersHandler.newFuture();
        ClusterLink.DescribeClusterLinksAllBrokersHandler handler = new ClusterLink.DescribeClusterLinksAllBrokersHandler(this.logContext, includeTopics, includeTasks, this.requestTimeoutMs);
        this.invokeDriver(handler, future, driverTimeoutMs);
        return new DescribeClusterLinksResult(ClusterLink.allBrokersFutureToResultFuture(future.all(), unsupportedVersionHandler, this.log));
    }

    @Override
    @Confluent
    public DeleteClusterLinksResult deleteClusterLinks(final Collection<String> linkNames, final DeleteClusterLinksOptions options) {
        final HashMap results = new HashMap(linkNames.size());
        for (String linkName : linkNames) {
            results.put(linkName, new KafkaFutureImpl());
        }
        long now = this.time.milliseconds();
        this.runnable.call(new Call("deleteClusterLinks", this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            DeleteClusterLinksRequest.Builder createRequest(int timeoutMs) {
                return new DeleteClusterLinksRequest.Builder(linkNames, options.validateOnly(), options.force(), options.deleteMetadata(), timeoutMs);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DeleteClusterLinksResponse response = (DeleteClusterLinksResponse)abstractResponse;
                if (response.errorCounts().getOrDefault((Object)Errors.NOT_CONTROLLER, 0) > 0) {
                    KafkaAdminClient.this.handleNotControllerError(Errors.NOT_CONTROLLER);
                }
                response.complete(results);
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(results.values(), throwable);
            }
        }, now);
        return new DeleteClusterLinksResult(Collections.unmodifiableMap(results));
    }

    @Override
    @Confluent
    public AlterMirrorsResult alterMirrors(Map<String, AlterMirrorOp> ops, AlterMirrorsOptions options) {
        ArrayList<AlterMirrorsRequestData.MirrorOperation> requestOps = new ArrayList<AlterMirrorsRequestData.MirrorOperation>(ops.size());
        for (Map.Entry<String, AlterMirrorOp> op : ops.entrySet()) {
            String topic = op.getKey();
            AlterMirrorsRequestData.MirrorOperationData mirrorOperationData = new AlterMirrorsRequestData.MirrorOperationData().setLinkName(options.linkName());
            AlterMirrorsRequestData.MirrorOperation mirrorOperation = new AlterMirrorsRequestData.MirrorOperation().setTopic(topic).setOperationCode(op.getValue().id()).setMirrorOperationData(mirrorOperationData);
            requestOps.add(mirrorOperation);
        }
        return this.alterMirrors(requestOps, options.validateOnly(), options.timeoutMs());
    }

    private AlterMirrorsResult alterMirrors(final List<AlterMirrorsRequestData.MirrorOperation> alterMirrorOps, final boolean validateOnly, Integer timeoutMs) {
        final LinkedHashMap futures = new LinkedHashMap(alterMirrorOps.size());
        for (AlterMirrorsRequestData.MirrorOperation op : alterMirrorOps) {
            futures.put(op.topic(), new KafkaFutureImpl());
        }
        long now = this.time.milliseconds();
        this.runnable.call(new Call("alterMirrors", this.calcDeadlineMs(now, timeoutMs), new ControllerNodeProvider()){

            AlterMirrorsRequest.Builder createRequest(int timeoutMs) {
                return new AlterMirrorsRequest.Builder(alterMirrorOps, validateOnly, timeoutMs);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                AlterMirrorsResponse response = (AlterMirrorsResponse)abstractResponse;
                if (response.errorCounts().getOrDefault((Object)Errors.NOT_CONTROLLER, 0) > 0) {
                    KafkaAdminClient.this.handleNotControllerError(Errors.NOT_CONTROLLER);
                }
                response.complete(futures);
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        }, now);
        return new AlterMirrorsResult(new HashMap<String, KafkaFuture<Void>>(futures));
    }

    AlterMirrorsResult stopMirrors(Map<String, List<Long>> stoppedLogEndOffsets, Map<String, List<Integer>> stoppedEpochs, Map<String, Long> stoppedSequenceNumbers) {
        ArrayList<AlterMirrorsRequestData.MirrorOperation> ops = new ArrayList<AlterMirrorsRequestData.MirrorOperation>();
        stoppedLogEndOffsets.forEach((topic, endOffsets) -> {
            AlterMirrorsRequestData.MirrorOperationData opData = new AlterMirrorsRequestData.MirrorOperationData().setStoppedLogEndOffsets((List<Long>)endOffsets).setStoppedEpochs((List)stoppedEpochs.get(topic)).setStoppedSequenceNumber((Long)stoppedSequenceNumbers.get(topic));
            ops.add(new AlterMirrorsRequestData.MirrorOperation().setTopic((String)topic).setOperationCode(AlterMirrorOp.STOP.id()).setMirrorOperationData(opData));
        });
        return this.alterMirrors(ops, false, null);
    }

    AlterMirrorsResult failMirrors(Map<String, MirrorTopicError> mirrorFailures) {
        AlterMirrorsRequestData requestData = new AlterMirrorsRequestData();
        ArrayList<AlterMirrorsRequestData.MirrorOperation> ops = new ArrayList<AlterMirrorsRequestData.MirrorOperation>();
        for (Map.Entry<String, MirrorTopicError> entry : mirrorFailures.entrySet()) {
            ops.add(new AlterMirrorsRequestData.MirrorOperation().setTopic(entry.getKey()).setOperationCode(AlterMirrorOp.FAIL_MIRROR.id()).setMirrorOperationData(new AlterMirrorsRequestData.MirrorOperationData().setMirrorTopicErrorCode(entry.getValue().code())));
        }
        return this.alterMirrors(ops, false, null);
    }

    AlterMirrorsResult convertToPendingRestoreMirrors(Map<String, List<Long>> topicToMirrorStartOffsets) {
        ArrayList<AlterMirrorsRequestData.MirrorOperation> ops = new ArrayList<AlterMirrorsRequestData.MirrorOperation>();
        topicToMirrorStartOffsets.forEach((topic, startOffsets) -> {
            AlterMirrorsRequestData.MirrorOperationData opData = new AlterMirrorsRequestData.MirrorOperationData().setMirrorStartOffsets((List<Long>)startOffsets);
            ops.add(new AlterMirrorsRequestData.MirrorOperation().setTopic((String)topic).setOperationCode(AlterMirrorOp.CONVERT_TO_PENDING_RESTORE_MIRROR.id()).setMirrorOperationData(opData));
        });
        return this.alterMirrors(ops, false, null);
    }

    AlterMirrorsResult convertToStartPendingMirrors(Map<String, String> sourceTopicNames, Map<String, Uuid> sourceTopicIds, Map<String, Uuid> expectedLocalTopicIds, Map<String, Long> stoppedSequenceNumbers) {
        return this.convertToPendingMirrors(sourceTopicNames, sourceTopicIds, expectedLocalTopicIds, AlterMirrorOp.CONVERT_TO_START_PENDING_MIRROR, stoppedSequenceNumbers);
    }

    AlterMirrorsResult convertToPausePendingMirrors(Map<String, String> sourceTopicNames, Map<String, Uuid> sourceTopicIds, Map<String, Uuid> expectedLocalTopicIds, Map<String, Long> stoppedSequenceNumbers) {
        return this.convertToPendingMirrors(sourceTopicNames, sourceTopicIds, expectedLocalTopicIds, AlterMirrorOp.CONVERT_TO_PAUSE_PENDING_MIRROR, stoppedSequenceNumbers);
    }

    private AlterMirrorsResult convertToPendingMirrors(Map<String, String> sourceTopicNames, Map<String, Uuid> sourceTopicIds, Map<String, Uuid> expectedLocalTopicIds, AlterMirrorOp alterMirrorOp, Map<String, Long> stoppedSequenceNumbers) {
        ArrayList<AlterMirrorsRequestData.MirrorOperation> ops = new ArrayList<AlterMirrorsRequestData.MirrorOperation>();
        Set<String> topics = sourceTopicNames.keySet();
        for (String t : topics) {
            ops.add(new AlterMirrorsRequestData.MirrorOperation().setTopic(t).setOperationCode(alterMirrorOp.id()).setMirrorOperationData(new AlterMirrorsRequestData.MirrorOperationData().setSourceTopicName(sourceTopicNames.get(t)).setSourceTopicId(sourceTopicIds.get(t)).setExpectedLocalTopicId(expectedLocalTopicIds.get(t)).setStoppedSequenceNumber(stoppedSequenceNumbers.get(t))));
        }
        return this.alterMirrors(ops, false, null);
    }

    @Override
    @Confluent
    public ListMirrorsResult listMirrors(final ListMirrorsOptions options) {
        final KafkaFutureImpl<Collection<String>> result = new KafkaFutureImpl<Collection<String>>();
        long now = this.time.milliseconds();
        this.runnable.call(new Call("listMirrors", this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            ListMirrorsRequest.Builder createRequest(int timeoutMs) {
                return new ListMirrorsRequest.Builder(options.linkName(), options.includeStopped(), timeoutMs);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                ListMirrorsResponse response = (ListMirrorsResponse)abstractResponse;
                if (response.errorCounts().getOrDefault((Object)Errors.NOT_CONTROLLER, 0) > 0) {
                    KafkaAdminClient.this.handleNotControllerError(Errors.NOT_CONTROLLER);
                }
                response.complete(result);
            }

            @Override
            void handleFailure(Throwable throwable) {
                result.completeExceptionally(throwable);
            }
        }, now);
        return new ListMirrorsResult(result);
    }

    @Override
    @Confluent
    public DescribeMirrorsResult describeMirrors(Collection<String> topics, DescribeMirrorsOptions options) {
        long now = this.time.milliseconds();
        if (options.includeStateTransitionErrors()) {
            Consumer<ClusterLink.DescribeMirrorsToControllerInput> unsupportedVersionHandler = input -> this.describeMirrorsToController(options, input.result, now);
            return this.describeMirrorsToLinkCoordinators(topics, options.linkNames(), options.states(), options.timeoutMs, options.includeStateTransitionErrors(), unsupportedVersionHandler);
        }
        HashMap<String, KafkaFutureImpl<MirrorTopicDescription>> result = new HashMap<String, KafkaFutureImpl<MirrorTopicDescription>>();
        for (String topic : topics) {
            result.put(topic, new KafkaFutureImpl());
        }
        return this.describeMirrorsToController(options, result, now);
    }

    private DescribeMirrorsResult describeMirrorsToLinkCoordinators(Collection<String> topics, Collection<String> linkNames, Collection<String> states, Integer driverTimeoutMs, boolean includeTransitionErrors, Consumer<ClusterLink.DescribeMirrorsToControllerInput> unsupportedVersionHandler) {
        AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, MirrorTopicDescription> future = ClusterLink.DescribeMirrorsLinkCoordinatorsHandler.newFuture(topics);
        ClusterLink.DescribeMirrorsLinkCoordinatorsHandler handler = new ClusterLink.DescribeMirrorsLinkCoordinatorsHandler(this.logContext, linkNames, states, this.requestTimeoutMs, includeTransitionErrors);
        this.invokeDriver(handler, future, driverTimeoutMs);
        return new DescribeMirrorsResult(ClusterLink.toDescribeMirrorsResultFuture(future, unsupportedVersionHandler, this.log));
    }

    public DescribeMirrorsResult describeMirrorsToController(final DescribeMirrorsOptions options, final Map<String, KafkaFutureImpl<MirrorTopicDescription>> result, Long now) {
        final Set<String> topics = result.keySet();
        this.runnable.call(new Call("describeMirrors", this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            DescribeMirrorsRequest.Builder createRequest(int timeoutMs) {
                return new DescribeMirrorsRequest.Builder(topics, options.linkNames(), options.states(), timeoutMs);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DescribeMirrorsResponse response = (DescribeMirrorsResponse)abstractResponse;
                if (response.errorCounts().getOrDefault((Object)Errors.NOT_CONTROLLER, 0) > 0) {
                    KafkaAdminClient.this.handleNotControllerError(Errors.NOT_CONTROLLER);
                }
                response.complete(result);
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(result.values(), throwable);
            }
        }, now);
        return new DescribeMirrorsResult(Collections.unmodifiableMap(result));
    }

    @Override
    @Confluent
    public AlterLeadershipPriorityResult alterLeadershipPriority(final AlterLeadershipPrioritySpec data, AlterLeadershipPriorityOptions options) {
        final HashMap futures = new HashMap(data.brokerIds().size());
        for (int brokerId : data.brokerIds()) {
            futures.put(brokerId, new KafkaFutureImpl());
        }
        long now = this.time.milliseconds();
        this.runnable.call(new Call("alterLeadershipPriority", this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            AlterBrokerHealthRequest.Builder createRequest(int timeoutMs) {
                ArrayList<Integer> brokerIds = new ArrayList<Integer>(data.brokerIds());
                short oldestAllowedVersion = 0;
                short latestAllowedVersion = 1;
                return new AlterBrokerHealthRequest.Builder(oldestAllowedVersion, latestAllowedVersion, new AlterBrokerHealthRequestData().setReason(data.reason()).setBrokerIds(brokerIds).setStatusCode(data.priorityOperation().id()).setForce(data.force()));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                AlterBrokerHealthResponse response = (AlterBrokerHealthResponse)abstractResponse;
                Errors topLevelError = Errors.forCode(response.data().errorCode());
                switch (topLevelError) {
                    case NONE: {
                        break;
                    }
                    case NOT_CONTROLLER: {
                        KafkaAdminClient.this.handleNotControllerError(topLevelError);
                        break;
                    }
                    default: {
                        KafkaAdminClient.completeAllExceptionally(futures.values(), topLevelError.exception(response.data().errorMessage()));
                        return;
                    }
                }
                response.data().brokerHealthStatusResults().forEach(result -> {
                    KafkaFutureImpl future = (KafkaFutureImpl)futures.get(result.brokerId());
                    if (future == null) {
                        KafkaAdminClient.this.log.warn("Server response mentioned unknown brokerId {}", (Object)result.brokerId());
                    } else {
                        Errors error = Errors.forCode(result.errorCode());
                        if (error == Errors.NONE) {
                            future.complete(new BrokerLeadershipPriorityResult(result.brokerId(), result.statusCode()));
                        } else {
                            future.completeExceptionally(error.exception(result.errorMessage()));
                        }
                    }
                });
                KafkaAdminClient.completeUnrealizedFutures(futures.entrySet().stream(), brokerId -> "The broker response did not contain a result for broker " + brokerId);
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        }, now);
        return new AlterLeadershipPriorityResult(new HashMap<Integer, KafkaFuture<BrokerLeadershipPriorityResult>>(futures));
    }

    @Override
    @Confluent
    public DescribeLeadershipPriorityResult describeLeadershipPriority(DescribeLeadershipPriorityOptions options) {
        final KafkaFutureImpl<Collection<DemotedBroker>> future = new KafkaFutureImpl<Collection<DemotedBroker>>();
        long now = this.time.milliseconds();
        this.runnable.call(new Call("describeLeadershipPriority", this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            DescribeBrokerHealthRequest.Builder createRequest(int timeoutMs) {
                boolean oldestAllowedVersion = false;
                boolean newestAllowedVersion = false;
                return new DescribeBrokerHealthRequest.Builder(0, 0);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DescribeBrokerHealthResponse response = (DescribeBrokerHealthResponse)abstractResponse;
                Errors topLevelError = Errors.forCode(response.data().errorCode());
                switch (topLevelError) {
                    case NONE: {
                        break;
                    }
                    case NOT_CONTROLLER: {
                        KafkaAdminClient.this.handleNotControllerError(topLevelError);
                        break;
                    }
                    default: {
                        future.completeExceptionally(topLevelError.exception(response.data().errorMessage()));
                        return;
                    }
                }
                future.complete(response.demotedBrokersV0());
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        }, now);
        return new DescribeLeadershipPriorityResult(future);
    }

    @Override
    @Confluent
    public AlterBrokerHealthResult alterBrokerHealth(final AlterBrokerHealthSpec data, AlterBrokerHealthOptions options) {
        final HashMap futures = new HashMap(data.brokerIds().size());
        for (int brokerId : data.brokerIds()) {
            futures.put(brokerId, new KafkaFutureImpl());
        }
        long now = this.time.milliseconds();
        this.runnable.call(new Call("alterBrokerHealth", this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            AlterBrokerHealthRequest.Builder createRequest(int timeoutMs) {
                ArrayList<Integer> brokerIds = new ArrayList<Integer>(data.brokerIds());
                return new AlterBrokerHealthRequest.Builder(new AlterBrokerHealthRequestData().setReason(data.reason()).setBrokerIds(brokerIds).setComponentCode(data.brokerComponent().id()).setStatusCode(data.componentHealthStatus().id()).setForce(data.force()));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                AlterBrokerHealthResponse response = (AlterBrokerHealthResponse)abstractResponse;
                Errors topLevelError = Errors.forCode(response.data().errorCode());
                switch (topLevelError) {
                    case NONE: {
                        break;
                    }
                    case NOT_CONTROLLER: {
                        KafkaAdminClient.this.handleNotControllerError(topLevelError);
                        break;
                    }
                    default: {
                        KafkaAdminClient.completeAllExceptionally(futures.values(), topLevelError.exception(response.data().errorMessage()));
                        return;
                    }
                }
                response.data().brokerHealthStatusResults().forEach(result -> {
                    KafkaFutureImpl future = (KafkaFutureImpl)futures.get(result.brokerId());
                    if (future == null) {
                        KafkaAdminClient.this.log.warn("Server response mentioned unknown brokerId {}", (Object)result.brokerId());
                    } else {
                        Errors error = Errors.forCode(result.errorCode());
                        if (error == Errors.NONE) {
                            future.complete(new BrokerHealthStatusResult(result.brokerId(), BrokerComponent.forId(result.componentCode()), ComponentHealthStatus.forId(result.statusCode())));
                        } else {
                            future.completeExceptionally(error.exception(result.errorMessage()));
                        }
                    }
                });
                KafkaAdminClient.completeUnrealizedFutures(futures.entrySet().stream(), brokerId -> "The broker response did not contain a result for broker " + brokerId);
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        }, now);
        return new AlterBrokerHealthResult(new HashMap<Integer, KafkaFuture<BrokerHealthStatusResult>>(futures));
    }

    @Override
    @Confluent
    public DescribeBrokerHealthResult describeBrokerHealth(DescribeBrokerHealthOptions options) {
        final KafkaFutureImpl<Collection<DegradedBroker>> future = new KafkaFutureImpl<Collection<DegradedBroker>>();
        long now = this.time.milliseconds();
        this.runnable.call(new Call("describeBrokerHealth", this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            DescribeBrokerHealthRequest.Builder createRequest(int timeoutMs) {
                return new DescribeBrokerHealthRequest.Builder();
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DescribeBrokerHealthResponse response = (DescribeBrokerHealthResponse)abstractResponse;
                Errors topLevelError = Errors.forCode(response.data().errorCode());
                switch (topLevelError) {
                    case NONE: {
                        break;
                    }
                    case NOT_CONTROLLER: {
                        KafkaAdminClient.this.handleNotControllerError(topLevelError);
                        break;
                    }
                    default: {
                        future.completeExceptionally(topLevelError.exception(response.data().errorMessage()));
                        return;
                    }
                }
                future.complete(response.degradedBrokers());
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        }, now);
        return new DescribeBrokerHealthResult(future);
    }

    @Override
    public DescribeFeaturesResult describeFeatures(DescribeFeaturesOptions options) {
        final KafkaFutureImpl<FeatureMetadata> future = new KafkaFutureImpl<FeatureMetadata>();
        long now = this.time.milliseconds();
        Call call = new Call("describeFeatures", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedBrokerOrActiveKController()){

            private FeatureMetadata createFeatureMetadata(ApiVersionsResponse response) {
                HashMap<String, FinalizedVersionRange> finalizedFeatures = new HashMap<String, FinalizedVersionRange>();
                for (ApiVersionsResponseData.FinalizedFeatureKey key : response.data().finalizedFeatures().valuesSet()) {
                    finalizedFeatures.put(key.name(), new FinalizedVersionRange(key.minVersionLevel(), key.maxVersionLevel()));
                }
                Optional<Long> finalizedFeaturesEpoch = response.data().finalizedFeaturesEpoch() >= 0L ? Optional.of(response.data().finalizedFeaturesEpoch()) : Optional.empty();
                HashMap<String, SupportedVersionRange> supportedFeatures = new HashMap<String, SupportedVersionRange>();
                for (ApiVersionsResponseData.SupportedFeatureKey key : response.data().supportedFeatures().valuesSet()) {
                    supportedFeatures.put(key.name(), new SupportedVersionRange(key.minVersion(), key.maxVersion()));
                }
                return new FeatureMetadata(finalizedFeatures, finalizedFeaturesEpoch, supportedFeatures);
            }

            ApiVersionsRequest.Builder createRequest(int timeoutMs) {
                return new ApiVersionsRequest.Builder();
            }

            @Override
            void handleResponse(AbstractResponse response) {
                ApiVersionsResponse apiVersionsResponse = (ApiVersionsResponse)response;
                if (apiVersionsResponse.data().errorCode() == Errors.NONE.code()) {
                    future.complete(this.createFeatureMetadata(apiVersionsResponse));
                } else {
                    future.completeExceptionally(Errors.forCode(apiVersionsResponse.data().errorCode()).exception());
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(Collections.singletonList(future), throwable);
            }
        };
        this.runnable.call(call, now);
        return new DescribeFeaturesResult(future);
    }

    @Override
    public UpdateFeaturesResult updateFeatures(final Map<String, FeatureUpdate> featureUpdates, final UpdateFeaturesOptions options) {
        if (featureUpdates.isEmpty()) {
            throw new IllegalArgumentException("Feature updates can not be null or empty.");
        }
        final HashMap updateFutures = new HashMap();
        for (Map.Entry<String, FeatureUpdate> entry : featureUpdates.entrySet()) {
            String feature = entry.getKey();
            if (Utils.isBlank(feature)) {
                throw new IllegalArgumentException("Provided feature can not be empty.");
            }
            updateFutures.put(entry.getKey(), new KafkaFutureImpl());
        }
        long now = this.time.milliseconds();
        Call call = new Call("updateFeatures", this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider(true)){

            UpdateFeaturesRequest.Builder createRequest(int timeoutMs) {
                UpdateFeaturesRequestData.FeatureUpdateKeyCollection featureUpdatesRequestData = new UpdateFeaturesRequestData.FeatureUpdateKeyCollection();
                for (Map.Entry entry : featureUpdates.entrySet()) {
                    String feature = (String)entry.getKey();
                    FeatureUpdate update = (FeatureUpdate)entry.getValue();
                    UpdateFeaturesRequestData.FeatureUpdateKey requestItem = new UpdateFeaturesRequestData.FeatureUpdateKey();
                    requestItem.setFeature(feature);
                    requestItem.setMaxVersionLevel(update.maxVersionLevel());
                    requestItem.setUpgradeType(update.upgradeType().code());
                    featureUpdatesRequestData.add(requestItem);
                }
                return new UpdateFeaturesRequest.Builder(new UpdateFeaturesRequestData().setTimeoutMs(timeoutMs).setValidateOnly(options.validateOnly()).setFeatureUpdates(featureUpdatesRequestData));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                UpdateFeaturesResponse response = (UpdateFeaturesResponse)abstractResponse;
                ApiError topLevelError = response.topLevelError();
                switch (topLevelError.error()) {
                    case NONE: {
                        for (UpdateFeaturesResponseData.UpdatableFeatureResult result : response.data().results()) {
                            KafkaFutureImpl future = (KafkaFutureImpl)updateFutures.get(result.feature());
                            if (future == null) {
                                KafkaAdminClient.this.log.warn("Server response mentioned unknown feature {}", (Object)result.feature());
                                continue;
                            }
                            Errors error = Errors.forCode(result.errorCode());
                            if (error == Errors.NONE) {
                                future.complete(null);
                                continue;
                            }
                            future.completeExceptionally(error.exception(result.errorMessage()));
                        }
                        KafkaAdminClient.completeUnrealizedFutures(updateFutures.entrySet().stream(), feature -> "The controller response did not contain a result for feature " + feature);
                        break;
                    }
                    case NOT_CONTROLLER: {
                        KafkaAdminClient.this.handleNotControllerError(topLevelError.error());
                        break;
                    }
                    default: {
                        for (Map.Entry entry : updateFutures.entrySet()) {
                            ((KafkaFutureImpl)entry.getValue()).completeExceptionally(topLevelError.exception());
                        }
                    }
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(updateFutures.values(), throwable);
            }
        };
        this.runnable.call(call, now);
        return new UpdateFeaturesResult(new HashMap<String, KafkaFuture<Void>>(updateFutures));
    }

    @Override
    public DescribeMetadataQuorumResult describeMetadataQuorum(DescribeMetadataQuorumOptions options) {
        LeastLoadedBrokerOrActiveKController provider = new LeastLoadedBrokerOrActiveKController();
        final KafkaFutureImpl<QuorumInfo> future = new KafkaFutureImpl<QuorumInfo>();
        long now = this.time.milliseconds();
        Call call = new Call("describeMetadataQuorum", this.calcDeadlineMs(now, options.timeoutMs()), provider){

            private QuorumInfo.ReplicaState translateReplicaState(DescribeQuorumResponseData.ReplicaState replica) {
                return new QuorumInfo.ReplicaState(replica.replicaId(), replica.logEndOffset(), replica.lastFetchTimestamp() == -1L ? OptionalLong.empty() : OptionalLong.of(replica.lastFetchTimestamp()), replica.lastCaughtUpTimestamp() == -1L ? OptionalLong.empty() : OptionalLong.of(replica.lastCaughtUpTimestamp()));
            }

            private QuorumInfo createQuorumResult(DescribeQuorumResponseData.PartitionData partition) {
                List<QuorumInfo.ReplicaState> voters = partition.currentVoters().stream().map(this::translateReplicaState).collect(Collectors.toList());
                List<QuorumInfo.ReplicaState> observers = partition.observers().stream().map(this::translateReplicaState).collect(Collectors.toList());
                return new QuorumInfo(partition.leaderId(), partition.leaderEpoch(), partition.highWatermark(), voters, observers);
            }

            DescribeQuorumRequest.Builder createRequest(int timeoutMs) {
                return new DescribeQuorumRequest.Builder(DescribeQuorumRequest.singletonRequest(new TopicPartition("__cluster_metadata", Topic.CLUSTER_METADATA_TOPIC_PARTITION.partition())));
            }

            @Override
            void handleResponse(AbstractResponse response) {
                DescribeQuorumResponse quorumResponse = (DescribeQuorumResponse)response;
                if (quorumResponse.data().errorCode() != Errors.NONE.code()) {
                    throw Errors.forCode(quorumResponse.data().errorCode()).exception();
                }
                if (quorumResponse.data().topics().size() != 1) {
                    String msg = String.format("DescribeMetadataQuorum received %d topics when 1 was expected", quorumResponse.data().topics().size());
                    KafkaAdminClient.this.log.debug(msg);
                    throw new UnknownServerException(msg);
                }
                DescribeQuorumResponseData.TopicData topic = quorumResponse.data().topics().get(0);
                if (!topic.topicName().equals("__cluster_metadata")) {
                    String msg = String.format("DescribeMetadataQuorum received a topic with name %s when %s was expected", topic.topicName(), "__cluster_metadata");
                    KafkaAdminClient.this.log.debug(msg);
                    throw new UnknownServerException(msg);
                }
                if (topic.partitions().size() != 1) {
                    String msg = String.format("DescribeMetadataQuorum received a topic %s with %d partitions when 1 was expected", topic.topicName(), topic.partitions().size());
                    KafkaAdminClient.this.log.debug(msg);
                    throw new UnknownServerException(msg);
                }
                DescribeQuorumResponseData.PartitionData partition = topic.partitions().get(0);
                if (partition.partitionIndex() != Topic.CLUSTER_METADATA_TOPIC_PARTITION.partition()) {
                    String msg = String.format("DescribeMetadataQuorum received a single partition with index %d when %d was expected", partition.partitionIndex(), Topic.CLUSTER_METADATA_TOPIC_PARTITION.partition());
                    KafkaAdminClient.this.log.debug(msg);
                    throw new UnknownServerException(msg);
                }
                if (partition.errorCode() != Errors.NONE.code()) {
                    throw Errors.forCode(partition.errorCode()).exception();
                }
                future.complete(this.createQuorumResult(partition));
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        };
        this.runnable.call(call, now);
        return new DescribeMetadataQuorumResult(future);
    }

    @Override
    public UnregisterBrokerResult unregisterBroker(final int brokerId, UnregisterBrokerOptions options) {
        final KafkaFutureImpl<Void> future = new KafkaFutureImpl<Void>();
        long now = this.time.milliseconds();
        Call call = new Call("unregisterBroker", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            UnregisterBrokerRequest.Builder createRequest(int timeoutMs) {
                UnregisterBrokerRequestData data = new UnregisterBrokerRequestData().setBrokerId(brokerId);
                return new UnregisterBrokerRequest.Builder(data);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                UnregisterBrokerResponse response = (UnregisterBrokerResponse)abstractResponse;
                Errors error = Errors.forCode(response.data().errorCode());
                switch (error) {
                    case NONE: {
                        future.complete(null);
                        break;
                    }
                    case REQUEST_TIMED_OUT: {
                        throw error.exception();
                    }
                    default: {
                        KafkaAdminClient.this.log.error("Unregister broker request for broker ID {} failed: {}", (Object)brokerId, (Object)error.message());
                        future.completeExceptionally(error.exception());
                    }
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        };
        this.runnable.call(call, now);
        return new UnregisterBrokerResult(future);
    }

    @Override
    public DescribeProducersResult describeProducers(Collection<TopicPartition> topicPartitions, DescribeProducersOptions options) {
        AdminApiFuture.SimpleAdminApiFuture<TopicPartition, DescribeProducersResult.PartitionProducerState> future = DescribeProducersHandler.newFuture(topicPartitions);
        DescribeProducersHandler handler = new DescribeProducersHandler(options, this.logContext);
        this.invokeDriver(handler, future, options.timeoutMs);
        return new DescribeProducersResult(future.all());
    }

    @Override
    public DescribeTransactionsResult describeTransactions(Collection<String> transactionalIds, DescribeTransactionsOptions options) {
        AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, TransactionDescription> future = DescribeTransactionsHandler.newFuture(transactionalIds);
        DescribeTransactionsHandler handler = new DescribeTransactionsHandler(this.logContext);
        this.invokeDriver(handler, future, options.timeoutMs);
        return new DescribeTransactionsResult(future.all());
    }

    @Override
    public AbortTransactionResult abortTransaction(AbortTransactionSpec spec, AbortTransactionOptions options) {
        AdminApiFuture.SimpleAdminApiFuture<TopicPartition, Void> future = AbortTransactionHandler.newFuture(Collections.singleton(spec.topicPartition()));
        AbortTransactionHandler handler = new AbortTransactionHandler(spec, this.logContext);
        this.invokeDriver(handler, future, options.timeoutMs);
        return new AbortTransactionResult(future.all());
    }

    @Override
    public ListTransactionsResult listTransactions(ListTransactionsOptions options) {
        AllBrokersStrategy.AllBrokersFuture<Collection<TransactionListing>> future = ListTransactionsHandler.newFuture();
        ListTransactionsHandler handler = new ListTransactionsHandler(options, this.logContext);
        this.invokeDriver(handler, future, options.timeoutMs);
        return new ListTransactionsResult(future.all());
    }

    @Override
    public FenceProducersResult fenceProducers(Collection<String> transactionalIds, FenceProducersOptions options) {
        AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, ProducerIdAndEpoch> future = FenceProducersHandler.newFuture(transactionalIds);
        FenceProducersHandler handler = new FenceProducersHandler(options, this.logContext, this.requestTimeoutMs);
        this.invokeDriver(handler, future, options.timeoutMs);
        return new FenceProducersResult(future.all());
    }

    @Override
    public ListClientMetricsResourcesResult listClientMetricsResources(ListClientMetricsResourcesOptions options) {
        long now = this.time.milliseconds();
        final KafkaFutureImpl<Collection<ClientMetricsResourceListing>> future = new KafkaFutureImpl<Collection<ClientMetricsResourceListing>>();
        this.runnable.call(new Call("listClientMetricsResources", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            ListClientMetricsResourcesRequest.Builder createRequest(int timeoutMs) {
                return new ListClientMetricsResourcesRequest.Builder(new ListClientMetricsResourcesRequestData());
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                ListClientMetricsResourcesResponse response = (ListClientMetricsResourcesResponse)abstractResponse;
                if (response.error().isFailure()) {
                    future.completeExceptionally(response.error().exception());
                } else {
                    future.complete(response.clientMetricsResources());
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        }, now);
        return new ListClientMetricsResourcesResult(future);
    }

    @Override
    public Uuid clientInstanceId(Duration timeout) {
        if (timeout.isNegative()) {
            throw new IllegalArgumentException("The timeout cannot be negative.");
        }
        if (!this.clientTelemetryEnabled) {
            throw new IllegalStateException("Telemetry is not enabled. Set config `enable.metrics.push` to `true`.");
        }
        if (this.clientInstanceId != null) {
            return this.clientInstanceId;
        }
        long now = this.time.milliseconds();
        final KafkaFutureImpl future = new KafkaFutureImpl();
        this.runnable.call(new Call("getTelemetrySubscriptions", this.calcDeadlineMs(now, (int)timeout.toMillis()), new LeastLoadedNodeProvider()){

            GetTelemetrySubscriptionsRequest.Builder createRequest(int timeoutMs) {
                return new GetTelemetrySubscriptionsRequest.Builder(new GetTelemetrySubscriptionsRequestData(), true);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                GetTelemetrySubscriptionsResponse response = (GetTelemetrySubscriptionsResponse)abstractResponse;
                if (response.error() != Errors.NONE) {
                    future.completeExceptionally(response.error().exception());
                } else {
                    future.complete(response.data().clientInstanceId());
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        }, now);
        try {
            this.clientInstanceId = (Uuid)future.get();
        }
        catch (Exception e) {
            this.log.error("Error occurred while fetching client instance id", (Throwable)e);
            throw new KafkaException("Error occurred while fetching client instance id", e);
        }
        return this.clientInstanceId;
    }

    private <K, V> void invokeDriver(AdminApiHandler<K, V> handler, AdminApiFuture<K, V> future, Integer timeoutMs) {
        long currentTimeMs = this.time.milliseconds();
        long deadlineMs = this.calcDeadlineMs(currentTimeMs, timeoutMs);
        AdminApiDriver<K, V> driver = new AdminApiDriver<K, V>(handler, future, deadlineMs, this.retryBackoffMs, this.retryBackoffMaxMs, this.logContext);
        this.maybeSendRequests(driver, currentTimeMs);
    }

    private <K, V> void maybeSendRequests(AdminApiDriver<K, V> driver, long currentTimeMs) {
        for (AdminApiDriver.RequestSpec<K> spec : driver.poll()) {
            this.runnable.call(this.newCall(driver, spec), currentTimeMs);
        }
    }

    private <K, V> Call newCall(final AdminApiDriver<K, V> driver, final AdminApiDriver.RequestSpec<K> spec) {
        NodeProvider nodeProvider = spec.scope.destinationBrokerId().isPresent() ? new ConstantNodeIdProvider(spec.scope.destinationBrokerId().getAsInt()) : new LeastLoadedNodeProvider();
        return new Call(spec.name, spec.nextAllowedTryMs, spec.tries, spec.deadlineMs, nodeProvider){

            @Override
            AbstractRequest.Builder<?> createRequest(int timeoutMs) {
                return spec.request;
            }

            @Override
            void handleResponse(AbstractResponse response) {
                long currentTimeMs = KafkaAdminClient.this.time.milliseconds();
                driver.onResponse(currentTimeMs, spec, response, this.curNode());
                KafkaAdminClient.this.maybeSendRequests(driver, currentTimeMs);
            }

            @Override
            void handleFailure(Throwable throwable) {
                long currentTimeMs = KafkaAdminClient.this.time.milliseconds();
                driver.onFailure(currentTimeMs, spec, throwable);
                KafkaAdminClient.this.maybeSendRequests(driver, currentTimeMs);
            }

            @Override
            void maybeRetry(long currentTimeMs, Throwable throwable) {
                if (throwable instanceof DisconnectException) {
                    driver.onFailure(currentTimeMs, spec, throwable);
                    KafkaAdminClient.this.maybeSendRequests(driver, currentTimeMs);
                } else {
                    super.maybeRetry(currentTimeMs, throwable);
                }
            }
        };
    }

    static long getOffsetFromSpec(OffsetSpec offsetSpec) {
        if (offsetSpec instanceof OffsetSpec.TimestampSpec) {
            return ((OffsetSpec.TimestampSpec)offsetSpec).timestamp();
        }
        if (offsetSpec instanceof OffsetSpec.EarliestSpec) {
            return -2L;
        }
        if (offsetSpec instanceof OffsetSpec.MaxTimestampSpec) {
            return -3L;
        }
        return -1L;
    }

    Map<Integer, KafkaFutureImpl<Void>> initiateReverseConnections(final InitiateReverseConnectionsRequestData request, Integer brokerId) {
        final HashMap<Integer, KafkaFutureImpl<Void>> results = new HashMap<Integer, KafkaFutureImpl<Void>>(request.entries().size());
        for (InitiateReverseConnectionsRequestData.EntryData entry : request.entries()) {
            results.put(entry.initiateRequestId(), new KafkaFutureImpl());
        }
        long now = this.time.milliseconds();
        NodeProvider nodeProvider = brokerId == null ? new ControllerNodeProvider() : (brokerId < 0 ? new LeastLoadedNodeProvider() : new ConstantNodeIdProvider(brokerId));
        this.runnable.call(new Call("initiateReverseConnections", this.calcDeadlineMs(now, null), nodeProvider){

            InitiateReverseConnectionsRequest.Builder createRequest(int timeoutMs) {
                return new InitiateReverseConnectionsRequest.Builder(request);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                InitiateReverseConnectionsResponse response = (InitiateReverseConnectionsResponse)abstractResponse;
                if (response.errorCounts().getOrDefault((Object)Errors.NOT_CONTROLLER, 0) > 0) {
                    KafkaAdminClient.this.handleNotControllerError(Errors.NOT_CONTROLLER);
                }
                for (InitiateReverseConnectionsResponseData.EntryData entryData : response.data.entries()) {
                    int requestId = entryData.initiateRequestId();
                    KafkaFutureImpl future = (KafkaFutureImpl)results.get(requestId);
                    Errors error = Errors.forCode(entryData.errorCode());
                    if (error == Errors.NONE) {
                        future.complete(null);
                        continue;
                    }
                    future.completeExceptionally(error.exception(entryData.errorMessage()));
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(results.values(), throwable);
            }
        }, now);
        return results;
    }

    DeleteAclsResult deleteAcls(Collection<AclBindingFilter> filters, DeleteAclsOptions options, AclState aclState) {
        return this.deleteAclsInternal(filters, options, null, Node.noNode().id(), aclState);
    }

    private DeleteAclsResult deleteAclsInternal(Collection<AclBindingFilter> filters, DeleteAclsOptions options, final String clusterId, int writerBrokerId, AclState aclState) {
        long now = this.time.milliseconds();
        final HashMap futures = new HashMap();
        final ArrayList<AclBindingFilter> aclBindingFiltersSent = new ArrayList<AclBindingFilter>();
        ArrayList<DeleteAclsRequestData.DeleteAclsFilter> deleteAclsFilters = new ArrayList<DeleteAclsRequestData.DeleteAclsFilter>();
        for (AclBindingFilter filter : filters) {
            if (futures.get(filter) != null) continue;
            aclBindingFiltersSent.add(filter);
            deleteAclsFilters.add(DeleteAclsRequest.deleteAclsFilter(filter));
            futures.put(filter, new KafkaFutureImpl());
        }
        NodeProvider nodeProvider = writerBrokerId == Node.noNode().id() ? new LeastLoadedNodeProvider() : new ConstantNodeIdProvider(writerBrokerId);
        final DeleteAclsRequestData data = new DeleteAclsRequestData().setFilters(deleteAclsFilters).setAclState(aclState.code());
        this.runnable.call(new Call("deleteAcls", this.calcDeadlineMs(now, options.timeoutMs()), nodeProvider){

            DeleteAclsRequest.Builder createRequest(int timeoutMs) {
                DeleteAclsRequest.Builder builder = new DeleteAclsRequest.Builder(data);
                if (clusterId != null) {
                    return builder.setClusterId(clusterId);
                }
                return builder;
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DeleteAclsResponse response = (DeleteAclsResponse)abstractResponse;
                List<DeleteAclsResponseData.DeleteAclsFilterResult> results = response.filterResults();
                Iterator<DeleteAclsResponseData.DeleteAclsFilterResult> iter = results.iterator();
                for (AclBindingFilter bindingFilter : aclBindingFiltersSent) {
                    KafkaFutureImpl future = (KafkaFutureImpl)futures.get(bindingFilter);
                    if (!iter.hasNext()) {
                        future.completeExceptionally(new UnknownServerException("The broker reported no deletion result for the given filter."));
                        continue;
                    }
                    DeleteAclsResponseData.DeleteAclsFilterResult filterResult = iter.next();
                    ApiError error = new ApiError(Errors.forCode(filterResult.errorCode()), filterResult.errorMessage());
                    if (error.isFailure()) {
                        future.completeExceptionally(error.exception());
                        continue;
                    }
                    ArrayList<DeleteAclsResult.FilterResult> filterResults = new ArrayList<DeleteAclsResult.FilterResult>();
                    for (DeleteAclsResponseData.DeleteAclsMatchingAcl matchingAcl : filterResult.matchingAcls()) {
                        ApiError aclError = new ApiError(Errors.forCode(matchingAcl.errorCode()), matchingAcl.errorMessage());
                        AclBinding aclBinding = DeleteAclsResponse.aclBinding(matchingAcl);
                        filterResults.add(new DeleteAclsResult.FilterResult(aclBinding, aclError.exception()));
                    }
                    future.complete(new DeleteAclsResult.FilterResults(filterResults));
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        }, now);
        return new DeleteAclsResult(new HashMap<AclBindingFilter, KafkaFuture<DeleteAclsResult.FilterResults>>(futures));
    }

    DescribeAclsResult describeAcls(final AclBindingFilter filter, DescribeAclsOptions options, final AclState aclState) {
        if (filter.isUnknown()) {
            KafkaFutureImpl<Collection<AclBinding>> future = new KafkaFutureImpl<Collection<AclBinding>>();
            future.completeExceptionally(new InvalidRequestException("The AclBindingFilter must not contain UNKNOWN elements."));
            return new DescribeAclsResult(future);
        }
        long now = this.time.milliseconds();
        final KafkaFutureImpl<Collection<AclBinding>> future = new KafkaFutureImpl<Collection<AclBinding>>();
        this.runnable.call(new Call("describeAcls", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            DescribeAclsRequest.Builder createRequest(int timeoutMs) {
                return new DescribeAclsRequest.Builder(filter).setAclState(aclState);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DescribeAclsResponse response = (DescribeAclsResponse)abstractResponse;
                if (response.error().isFailure()) {
                    future.completeExceptionally(response.error().exception());
                } else {
                    future.complete(DescribeAclsResponse.aclBindings(response.acls()));
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        }, now);
        return new DescribeAclsResult(future);
    }

    OffsetForLeaderEpochResult offsetsForLeaderEpoch(final Collection<OffsetForLeaderEpochRequestData.OffsetForLeaderTopic> topics, OffsetForLeaderEpochOptions options) {
        final HashMap resultMap = new HashMap();
        final HashSet<String> topicSet = new HashSet<String>();
        for (OffsetForLeaderEpochRequestData.OffsetForLeaderTopic topic : topics) {
            for (OffsetForLeaderEpochRequestData.OffsetForLeaderPartition partition : topic.partitions()) {
                resultMap.put(new TopicPartition(topic.topic(), partition.partition()), new KafkaFutureImpl());
                topicSet.add(topic.topic());
            }
        }
        long nowMetadata = this.time.milliseconds();
        final long deadline = this.calcDeadlineMs(nowMetadata, options.timeoutMs());
        this.runnable.call(new Call("topicsMetadata", deadline, new LeastLoadedNodeProvider()){

            AbstractRequest.Builder createRequest(int timeoutMs) {
                return new MetadataRequest.Builder(new MetadataRequestData().setTopics(MetadataRequest.convertToMetadataRequestTopic(topicSet)).setAllowAutoTopicCreation(false));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                MetadataResponse response = (MetadataResponse)abstractResponse;
                Map<String, Errors> errors = response.errors();
                Cluster cluster = response.buildCluster();
                HashMap<Node, Set> leaderPartitions = new HashMap<Node, Set>();
                for (final Map.Entry entry : resultMap.entrySet()) {
                    Errors error = errors.get(((TopicPartition)entry.getKey()).topic());
                    if (error != null) {
                        ((KafkaFutureImpl)entry.getValue()).completeExceptionally(error.exception());
                        continue;
                    }
                    PartitionInfo partitionInfo = cluster.partition((TopicPartition)entry.getKey());
                    if (partitionInfo == null) {
                        ((KafkaFutureImpl)entry.getValue()).completeExceptionally(new UnknownTopicOrPartitionException("Partition " + entry.getKey() + " not found."));
                        continue;
                    }
                    if (partitionInfo.leader() == null) {
                        ((KafkaFutureImpl)entry.getValue()).completeExceptionally(new LeaderNotAvailableException("Leader for partition " + entry.getKey() + " not found."));
                        continue;
                    }
                    leaderPartitions.computeIfAbsent(partitionInfo.leader(), k -> new HashSet()).add(entry.getKey());
                }
                for (final Map.Entry entry : leaderPartitions.entrySet()) {
                    final HashMap resultSubset = new HashMap();
                    for (TopicPartition partition : (Set)entry.getValue()) {
                        resultSubset.put(partition, resultMap.get(partition));
                    }
                    long nowStatus = KafkaAdminClient.this.time.milliseconds();
                    KafkaAdminClient.this.runnable.call(new Call("offsetForLeaderEpoch", deadline, new ConstantNodeIdProvider(((Node)entry.getKey()).id())){

                        OffsetsForLeaderEpochRequest.Builder createRequest(int timeoutMs) {
                            return OffsetsForLeaderEpochRequest.Builder.forConsumer(new OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection(KafkaAdminClient.this.convertPartitionsToRequestData((Set)entry.getValue(), topics).iterator()));
                        }

                        @Override
                        void handleResponse(AbstractResponse abstractResponse) {
                            OffsetsForLeaderEpochResponse response = (OffsetsForLeaderEpochResponse)abstractResponse;
                            response.complete(resultSubset);
                        }

                        @Override
                        void handleFailure(Throwable throwable) {
                            KafkaAdminClient.completeAllExceptionally(resultSubset.values(), throwable);
                            KafkaAdminClient.this.log.error("OffsetsForLeaderEpoch request failed", throwable);
                        }
                    }, nowStatus);
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(resultMap.values(), throwable);
            }
        }, nowMetadata);
        return new OffsetForLeaderEpochResult(Collections.unmodifiableMap(resultMap));
    }

    private Collection<OffsetForLeaderEpochRequestData.OffsetForLeaderTopic> convertPartitionsToRequestData(Set<TopicPartition> partitions, Collection<OffsetForLeaderEpochRequestData.OffsetForLeaderTopic> requestData) {
        HashSet<OffsetForLeaderEpochRequestData.OffsetForLeaderTopic> topics = new HashSet<OffsetForLeaderEpochRequestData.OffsetForLeaderTopic>();
        for (OffsetForLeaderEpochRequestData.OffsetForLeaderTopic topic : requestData) {
            ArrayList<OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitionsList = new ArrayList<OffsetForLeaderEpochRequestData.OffsetForLeaderPartition>();
            for (OffsetForLeaderEpochRequestData.OffsetForLeaderPartition partition : topic.partitions()) {
                if (!partitions.contains(new TopicPartition(topic.topic(), partition.partition()))) continue;
                OffsetForLeaderEpochRequestData.OffsetForLeaderPartition newPartition = new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(partition.partition()).setLeaderEpoch(partition.leaderEpoch());
                partitionsList.add(newPartition);
            }
            if (partitionsList.isEmpty()) continue;
            topics.add(new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic(topic.topic()).setPartitions(partitionsList));
        }
        return topics;
    }

    static <K> Throwable getSubLevelError(Map<K, Errors> subLevelErrors, K subKey, String keyNotFoundMsg) {
        if (!subLevelErrors.containsKey(subKey)) {
            return new IllegalArgumentException(keyNotFoundMsg);
        }
        return subLevelErrors.get(subKey).exception();
    }

    private static final class ListConsumerGroupsResults {
        private final List<Throwable> errors = new ArrayList<Throwable>();
        private final HashMap<String, ConsumerGroupListing> listings = new HashMap();
        private final HashSet<Node> remaining;
        private final KafkaFutureImpl<Collection<Object>> future;

        ListConsumerGroupsResults(Collection<Node> leaders, KafkaFutureImpl<Collection<Object>> future) {
            this.remaining = new HashSet<Node>(leaders);
            this.future = future;
            this.tryComplete();
        }

        synchronized void addError(Throwable throwable, Node node) {
            ApiError error = ApiError.fromThrowable(throwable);
            if (error.message() == null || error.message().isEmpty()) {
                this.errors.add(error.error().exception("Error listing groups on " + node));
            } else {
                this.errors.add(error.error().exception("Error listing groups on " + node + ": " + error.message()));
            }
        }

        synchronized void addListing(ConsumerGroupListing listing) {
            this.listings.put(listing.groupId(), listing);
        }

        synchronized void tryComplete(Node leader) {
            this.remaining.remove(leader);
            this.tryComplete();
        }

        private synchronized void tryComplete() {
            if (this.remaining.isEmpty()) {
                ArrayList<ConsumerGroupListing> results = new ArrayList<ConsumerGroupListing>(this.listings.values());
                results.addAll(this.errors);
                this.future.complete(results);
            }
        }
    }

    private final class AdminClientRunnable
    implements Runnable {
        private final ArrayList<Call> pendingCalls = new ArrayList();
        private final Map<Node, List<Call>> callsToSend = new HashMap<Node, List<Call>>();
        private final Map<String, Call> callsInFlight = new HashMap<String, Call>();
        private final Map<Integer, Call> correlationIdToCalls = new HashMap<Integer, Call>();
        private final List<Call> newCalls = new LinkedList<Call>();
        private final Map<Node, Long> nodeReadyDeadlines = new HashMap<Node, Long>();
        private volatile boolean closing = false;

        private AdminClientRunnable() {
        }

        private void timeoutPendingCalls(TimeoutProcessor processor) {
            int numTimedOut = processor.handleTimeouts(this.pendingCalls, "Timed out waiting for a node assignment.");
            if (numTimedOut > 0) {
                KafkaAdminClient.this.log.debug("Timed out {} pending calls.", (Object)numTimedOut);
            }
        }

        private int timeoutCallsToSend(TimeoutProcessor processor) {
            int numTimedOut = 0;
            for (List<Call> callList : this.callsToSend.values()) {
                numTimedOut += processor.handleTimeouts(callList, "Timed out waiting to send the call.");
            }
            if (numTimedOut > 0) {
                KafkaAdminClient.this.log.debug("Timed out {} call(s) with assigned nodes.", (Object)numTimedOut);
            }
            return numTimedOut;
        }

        private synchronized void drainNewCalls() {
            this.transitionToPendingAndClearList(this.newCalls);
        }

        private void transitionToPendingAndClearList(List<Call> calls) {
            for (Call call : calls) {
                call.curNode = null;
                this.pendingCalls.add(call);
            }
            calls.clear();
        }

        private long maybeDrainPendingCalls(long now) {
            long pollTimeout = Long.MAX_VALUE;
            KafkaAdminClient.this.log.trace("Trying to choose nodes for {} at {}", this.pendingCalls, (Object)now);
            Iterator<Call> pendingIter = this.pendingCalls.iterator();
            while (pendingIter.hasNext()) {
                Call call = pendingIter.next();
                if (now < call.nextAllowedTryMs) {
                    pollTimeout = Math.min(pollTimeout, call.nextAllowedTryMs - now);
                    continue;
                }
                if (!this.maybeDrainPendingCall(call, now)) continue;
                pendingIter.remove();
            }
            return pollTimeout;
        }

        private boolean maybeDrainPendingCall(Call call, long now) {
            try {
                Node node = call.nodeProvider.provide();
                if (!call.isReady()) {
                    return false;
                }
                if (node != null) {
                    KafkaAdminClient.this.log.trace("Assigned {} to node {}", (Object)call, (Object)node);
                    call.curNode = node;
                    KafkaAdminClient.getOrCreateListValue(this.callsToSend, node).add(call);
                    return true;
                }
                KafkaAdminClient.this.log.trace("Unable to assign {} to a node.", (Object)call);
                return false;
            }
            catch (Throwable t) {
                KafkaAdminClient.this.log.debug("Unable to choose node for {}", (Object)call, (Object)t);
                call.fail(now, t);
                return true;
            }
        }

        private long sendEligibleCalls(long now) {
            long pollTimeout = Long.MAX_VALUE;
            Iterator<Map.Entry<Node, List<Call>>> iter = this.callsToSend.entrySet().iterator();
            block2: while (iter.hasNext()) {
                Map.Entry<Node, List<Call>> entry = iter.next();
                List<Call> calls = entry.getValue();
                if (calls.isEmpty()) {
                    iter.remove();
                    continue;
                }
                Node node = entry.getKey();
                if (this.callsInFlight.containsKey(node.idString())) {
                    KafkaAdminClient.this.log.trace("Still waiting for other calls to finish on node {}.", (Object)node);
                    this.nodeReadyDeadlines.remove(node);
                    continue;
                }
                if (!KafkaAdminClient.this.client.ready(node, now)) {
                    Long deadline = this.nodeReadyDeadlines.get(node);
                    if (deadline != null) {
                        if (now >= deadline) {
                            KafkaAdminClient.this.log.info("Disconnecting from {} and revoking {} node assignment(s) because the node is taking too long to become ready.", (Object)node.idString(), (Object)calls.size());
                            this.transitionToPendingAndClearList(calls);
                            KafkaAdminClient.this.client.disconnect(node.idString());
                            this.nodeReadyDeadlines.remove(node);
                            iter.remove();
                            continue;
                        }
                        pollTimeout = Math.min(pollTimeout, deadline - now);
                    } else {
                        this.nodeReadyDeadlines.put(node, now + (long)KafkaAdminClient.this.requestTimeoutMs);
                    }
                    long nodeTimeout = KafkaAdminClient.this.client.pollDelayMs(node, now);
                    pollTimeout = Math.min(pollTimeout, nodeTimeout);
                    KafkaAdminClient.this.log.trace("Client is not ready to send to {}. Must delay {} ms", (Object)node, (Object)nodeTimeout);
                    continue;
                }
                Long deadlineMs = this.nodeReadyDeadlines.remove(node);
                int remainingRequestTime = deadlineMs == null ? KafkaAdminClient.this.requestTimeoutMs : KafkaAdminClient.calcTimeoutMsRemainingAsInt(now, deadlineMs);
                while (!calls.isEmpty()) {
                    AbstractRequest.Builder<?> requestBuilder;
                    int timeoutMs;
                    Call call;
                    block11: {
                        call = calls.remove(0);
                        timeoutMs = Math.min(remainingRequestTime, KafkaAdminClient.calcTimeoutMsRemainingAsInt(now, call.deadlineMs));
                        try {
                            requestBuilder = call.createAndMaybeInterceptRequest(now, timeoutMs);
                            if (requestBuilder == null) {
                            }
                            break block11;
                        }
                        catch (Throwable t) {
                            call.fail(now, new KafkaException(String.format("Internal error sending %s to %s.", call.callName, node), t));
                        }
                        continue;
                    }
                    ClientRequest clientRequest = KafkaAdminClient.this.client.newClientRequest(node.idString(), requestBuilder, now, true, timeoutMs, null);
                    KafkaAdminClient.this.log.debug("Sending {} to {}. correlationId={}, timeoutMs={}", new Object[]{requestBuilder, node, clientRequest.correlationId(), timeoutMs});
                    KafkaAdminClient.this.client.send(clientRequest, now);
                    this.callsInFlight.put(node.idString(), call);
                    this.correlationIdToCalls.put(clientRequest.correlationId(), call);
                    continue block2;
                }
            }
            return pollTimeout;
        }

        private void timeoutCallsInFlight(TimeoutProcessor processor) {
            int numTimedOut = 0;
            for (Map.Entry<String, Call> entry : this.callsInFlight.entrySet()) {
                Call call = entry.getValue();
                String nodeId = entry.getKey();
                if (!processor.callHasExpired(call)) continue;
                KafkaAdminClient.this.log.info("Disconnecting from {} due to timeout while awaiting {}", (Object)nodeId, (Object)call);
                KafkaAdminClient.this.client.disconnect(nodeId);
                ++numTimedOut;
            }
            if (numTimedOut > 0) {
                KafkaAdminClient.this.log.debug("Timed out {} call(s) in flight.", (Object)numTimedOut);
            }
        }

        private void handleResponses(long now, List<ClientResponse> responses) {
            for (ClientResponse response : responses) {
                int correlationId = response.requestHeader().correlationId();
                Call call = this.correlationIdToCalls.get(correlationId);
                if (call == null) {
                    KafkaAdminClient.this.log.error("Internal server error on {}: server returned information about unknown correlation ID {}, requestHeader = {}", new Object[]{response.destination(), correlationId, response.requestHeader()});
                    KafkaAdminClient.this.client.disconnect(response.destination());
                    continue;
                }
                this.correlationIdToCalls.remove(correlationId);
                if (!this.callsInFlight.remove(response.destination(), call)) {
                    KafkaAdminClient.this.log.error("Internal server error on {}: ignoring call {} in correlationIdToCall that did not exist in callsInFlight", (Object)response.destination(), (Object)call);
                    continue;
                }
                if (response.versionMismatch() != null) {
                    call.fail(now, response.versionMismatch());
                    continue;
                }
                if (response.wasDisconnected()) {
                    AuthenticationException authException = KafkaAdminClient.this.client.authenticationException(call.curNode());
                    if (authException != null) {
                        call.fail(now, authException);
                        continue;
                    }
                    call.fail(now, new DisconnectException(String.format("Cancelled %s request with correlation id %d due to node %s being disconnected", call.callName, correlationId, response.destination())));
                    continue;
                }
                call.processResponse(response.responseBody(), now);
            }
        }

        private void unassignUnsentCalls(Predicate<Node> shouldUnassign) {
            Iterator<Map.Entry<Node, List<Call>>> iter = this.callsToSend.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Node, List<Call>> entry = iter.next();
                Node node = entry.getKey();
                List<Call> awaitingCalls = entry.getValue();
                if (awaitingCalls.isEmpty()) {
                    iter.remove();
                    continue;
                }
                if (!shouldUnassign.test(node)) continue;
                this.nodeReadyDeadlines.remove(node);
                this.transitionToPendingAndClearList(awaitingCalls);
                iter.remove();
            }
        }

        private boolean hasActiveExternalCalls(Collection<Call> calls) {
            for (Call call : calls) {
                if (call.isInternal()) continue;
                return true;
            }
            return false;
        }

        private boolean hasActiveExternalCalls() {
            if (this.hasActiveExternalCalls(this.pendingCalls)) {
                return true;
            }
            for (List<Call> callList : this.callsToSend.values()) {
                if (!this.hasActiveExternalCalls(callList)) continue;
                return true;
            }
            return this.hasActiveExternalCalls(this.correlationIdToCalls.values());
        }

        private boolean threadShouldExit(long now, long curHardShutdownTimeMs) {
            if (!this.hasActiveExternalCalls()) {
                KafkaAdminClient.this.log.trace("All work has been completed, and the I/O thread is now exiting.");
                return true;
            }
            if (now >= curHardShutdownTimeMs) {
                KafkaAdminClient.this.log.info("Forcing a hard I/O thread shutdown. Requests in progress will be aborted.");
                return true;
            }
            KafkaAdminClient.this.log.debug("Hard shutdown in {} ms.", (Object)(curHardShutdownTimeMs - now));
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            KafkaAdminClient.this.log.debug("Thread starting");
            try {
                this.processRequests();
            }
            finally {
                this.closing = true;
                AppInfoParser.unregisterAppInfo(KafkaAdminClient.JMX_PREFIX, KafkaAdminClient.this.clientId, KafkaAdminClient.this.metrics);
                int numTimedOut = 0;
                TimeoutProcessor timeoutProcessor = new TimeoutProcessor(Long.MAX_VALUE);
                AdminClientRunnable adminClientRunnable = this;
                synchronized (adminClientRunnable) {
                    numTimedOut += timeoutProcessor.handleTimeouts(this.newCalls, "The AdminClient thread has exited.");
                }
                numTimedOut += timeoutProcessor.handleTimeouts(this.pendingCalls, "The AdminClient thread has exited.");
                numTimedOut += this.timeoutCallsToSend(timeoutProcessor);
                if ((numTimedOut += timeoutProcessor.handleTimeouts(this.correlationIdToCalls.values(), "The AdminClient thread has exited.")) > 0) {
                    KafkaAdminClient.this.log.info("Timed out {} remaining operation(s) during close.", (Object)numTimedOut);
                }
                Utils.closeQuietly(KafkaAdminClient.this.client, "KafkaClient");
                Utils.closeQuietly(KafkaAdminClient.this.metrics, "Metrics");
                KafkaAdminClient.this.log.debug("Exiting AdminClientRunnable thread.");
            }
        }

        private void processRequests() {
            long now = KafkaAdminClient.this.time.milliseconds();
            while (true) {
                this.drainNewCalls();
                long curHardShutdownTimeMs = KafkaAdminClient.this.hardShutdownTimeMs.get();
                if (curHardShutdownTimeMs != -1L && this.threadShouldExit(now, curHardShutdownTimeMs)) break;
                TimeoutProcessor timeoutProcessor = KafkaAdminClient.this.timeoutProcessorFactory.create(now);
                this.timeoutPendingCalls(timeoutProcessor);
                this.timeoutCallsToSend(timeoutProcessor);
                this.timeoutCallsInFlight(timeoutProcessor);
                long pollTimeout = Math.min(1200000, timeoutProcessor.nextTimeoutMs());
                if (curHardShutdownTimeMs != -1L) {
                    pollTimeout = Math.min(pollTimeout, curHardShutdownTimeMs - now);
                }
                pollTimeout = Math.min(pollTimeout, this.maybeDrainPendingCalls(now));
                long metadataFetchDelayMs = KafkaAdminClient.this.metadataManager.metadataFetchDelayMs(now);
                if (metadataFetchDelayMs == 0L) {
                    KafkaAdminClient.this.metadataManager.transitionToUpdatePending(now);
                    Call metadataCall = this.makeMetadataCall(now);
                    if (!this.maybeDrainPendingCall(metadataCall, now)) {
                        this.pendingCalls.add(metadataCall);
                    }
                }
                pollTimeout = Math.min(pollTimeout, this.sendEligibleCalls(now));
                if (metadataFetchDelayMs > 0L) {
                    pollTimeout = Math.min(pollTimeout, metadataFetchDelayMs);
                }
                if (!this.pendingCalls.isEmpty()) {
                    pollTimeout = Math.min(pollTimeout, KafkaAdminClient.this.retryBackoffMs);
                }
                KafkaAdminClient.this.log.trace("Entering KafkaClient#poll(timeout={})", (Object)pollTimeout);
                List<ClientResponse> responses = KafkaAdminClient.this.client.poll(Math.max(0L, pollTimeout), now);
                KafkaAdminClient.this.log.trace("KafkaClient#poll retrieved {} response(s)", (Object)responses.size());
                this.unassignUnsentCalls(KafkaAdminClient.this.client::connectionFailed);
                now = KafkaAdminClient.this.time.milliseconds();
                this.handleResponses(now, responses);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void enqueue(Call call, long now) {
            if (call.tries > KafkaAdminClient.this.maxRetries) {
                KafkaAdminClient.this.log.debug("Max retries {} for {} reached", (Object)KafkaAdminClient.this.maxRetries, (Object)call);
                call.handleTimeoutFailure(KafkaAdminClient.this.time.milliseconds(), new TimeoutException("Exceeded maxRetries after " + call.tries + " tries."));
                return;
            }
            if (KafkaAdminClient.this.log.isDebugEnabled()) {
                KafkaAdminClient.this.log.debug("Queueing {} with a timeout {} ms from now.", (Object)call, (Object)Math.min((long)KafkaAdminClient.this.requestTimeoutMs, call.deadlineMs - now));
            }
            boolean accepted = false;
            AdminClientRunnable adminClientRunnable = this;
            synchronized (adminClientRunnable) {
                if (!this.closing) {
                    this.newCalls.add(call);
                    accepted = true;
                }
            }
            if (accepted) {
                KafkaAdminClient.this.client.wakeup();
            } else {
                KafkaAdminClient.this.log.debug("The AdminClient thread has exited. Timing out {}.", (Object)call);
                call.handleTimeoutFailure(KafkaAdminClient.this.time.milliseconds(), new TimeoutException("The AdminClient thread has exited."));
            }
        }

        void call(Call call, long now) {
            if (KafkaAdminClient.this.hardShutdownTimeMs.get() != -1L) {
                KafkaAdminClient.this.log.debug("Cannot accept new call {} when AdminClient is closing.", (Object)call);
                call.handleFailure(new IllegalStateException("Cannot accept new calls when AdminClient is closing."));
            } else if (KafkaAdminClient.this.metadataManager.usingBootstrapControllers() && !call.nodeProvider.supportsUseControllers()) {
                call.fail(now, new UnsupportedEndpointTypeException("This Admin API is not yet supported when communicating directly with the controller quorum."));
            } else {
                this.enqueue(call, now);
            }
        }

        private Call makeMetadataCall(long now) {
            if (KafkaAdminClient.this.metadataManager.usingBootstrapControllers()) {
                return this.makeControllerMetadataCall(now);
            }
            return this.makeBrokerMetadataCall(now);
        }

        private Call makeControllerMetadataCall(long now) {
            return new Call(true, "describeCluster", KafkaAdminClient.this.calcDeadlineMs(now, KafkaAdminClient.this.requestTimeoutMs), (NodeProvider)new MetadataUpdateNodeIdProvider()){

                public DescribeClusterRequest.Builder createRequest(int timeoutMs) {
                    return new DescribeClusterRequest.Builder(new DescribeClusterRequestData().setIncludeClusterAuthorizedOperations(false).setEndpointType(EndpointType.CONTROLLER.id()));
                }

                @Override
                public void handleResponse(AbstractResponse abstractResponse) {
                    Cluster cluster;
                    DescribeClusterResponse response = (DescribeClusterResponse)abstractResponse;
                    try {
                        cluster = KafkaAdminClient.parseDescribeClusterResponse(response.data());
                    }
                    catch (ApiException e) {
                        this.handleFailure(e);
                        return;
                    }
                    long now = KafkaAdminClient.this.time.milliseconds();
                    KafkaAdminClient.this.metadataManager.update(cluster, now);
                    AdminClientRunnable.this.unassignUnsentCalls(node -> true);
                }

                @Override
                boolean handleUnsupportedVersionException(UnsupportedVersionException e) {
                    KafkaAdminClient.this.metadataManager.updateFailed(e);
                    return false;
                }

                @Override
                public void handleFailure(Throwable e) {
                    KafkaAdminClient.this.metadataManager.updateFailed(e);
                }
            };
        }

        private Call makeBrokerMetadataCall(long now) {
            return new Call(true, "fetchMetadata", KafkaAdminClient.this.calcDeadlineMs(now, KafkaAdminClient.this.requestTimeoutMs), (NodeProvider)new MetadataUpdateNodeIdProvider()){

                public MetadataRequest.Builder createRequest(int timeoutMs) {
                    return new MetadataRequest.Builder(new MetadataRequestData().setTopics(Collections.emptyList()).setAllowAutoTopicCreation(true));
                }

                @Override
                public void handleResponse(AbstractResponse abstractResponse) {
                    MetadataResponse response = (MetadataResponse)abstractResponse;
                    long now = KafkaAdminClient.this.time.milliseconds();
                    KafkaAdminClient.this.metadataManager.update(response.buildCluster(), now);
                    AdminClientRunnable.this.unassignUnsentCalls(node -> true);
                }

                @Override
                boolean handleUnsupportedVersionException(UnsupportedVersionException e) {
                    KafkaAdminClient.this.metadataManager.updateFailed(e);
                    return false;
                }

                @Override
                public void handleFailure(Throwable e) {
                    KafkaAdminClient.this.metadataManager.updateFailed(e);
                }
            };
        }
    }

    static class TimeoutProcessor {
        private final long now;
        private int nextTimeoutMs;

        TimeoutProcessor(long now) {
            this.now = now;
            this.nextTimeoutMs = Integer.MAX_VALUE;
        }

        int handleTimeouts(Collection<Call> calls, String msg) {
            int numTimedOut = 0;
            Iterator<Call> iter = calls.iterator();
            while (iter.hasNext()) {
                Call call = iter.next();
                int remainingMs = KafkaAdminClient.calcTimeoutMsRemainingAsInt(this.now, call.deadlineMs);
                if (remainingMs < 0) {
                    call.fail(this.now, new TimeoutException(msg + " Call: " + call.callName));
                    iter.remove();
                    ++numTimedOut;
                    continue;
                }
                this.nextTimeoutMs = Math.min(this.nextTimeoutMs, remainingMs);
            }
            return numTimedOut;
        }

        boolean callHasExpired(Call call) {
            int remainingMs = KafkaAdminClient.calcTimeoutMsRemainingAsInt(this.now, call.deadlineMs);
            if (remainingMs < 0) {
                return true;
            }
            this.nextTimeoutMs = Math.min(this.nextTimeoutMs, remainingMs);
            return false;
        }

        int nextTimeoutMs() {
            return this.nextTimeoutMs;
        }
    }

    static class TimeoutProcessorFactory {
        TimeoutProcessorFactory() {
        }

        TimeoutProcessor create(long now) {
            return new TimeoutProcessor(now);
        }
    }

    abstract class Call {
        private final boolean internal;
        private final String callName;
        private final long deadlineMs;
        private final NodeProvider nodeProvider;
        protected int tries;
        private Node curNode = null;
        private long nextAllowedTryMs;
        private final AdminRequestInterceptor requestInterceptor;

        Call(boolean internal, String callName, long nextAllowedTryMs, int tries, long deadlineMs, NodeProvider nodeProvider) {
            this.internal = internal;
            this.callName = callName;
            this.nextAllowedTryMs = nextAllowedTryMs;
            this.tries = tries;
            this.deadlineMs = deadlineMs;
            this.nodeProvider = nodeProvider;
            try {
                this.requestInterceptor = KafkaAdminClient.this.interceptorFactory.createInterceptor(this::createRequest);
            }
            catch (Throwable e) {
                throw new KafkaException("Could not create request interceptor", e);
            }
        }

        Call(boolean internal, String callName, long deadlineMs, NodeProvider nodeProvider) {
            this(internal, callName, 0L, 0, deadlineMs, nodeProvider);
        }

        Call(String callName, long deadlineMs, NodeProvider nodeProvider) {
            this(false, callName, 0L, 0, deadlineMs, nodeProvider);
        }

        Call(String callName, long nextAllowedTryMs, int tries, long deadlineMs, NodeProvider nodeProvider) {
            this(false, callName, nextAllowedTryMs, tries, deadlineMs, nodeProvider);
        }

        protected Node curNode() {
            return this.curNode;
        }

        protected long deadlineMs() {
            return this.deadlineMs;
        }

        final void fail(long now, Throwable throwable) {
            if (this.curNode != null) {
                KafkaAdminClient.this.runnable.nodeReadyDeadlines.remove(this.curNode);
                this.curNode = null;
            }
            if (KafkaAdminClient.this.runnable.closing) {
                this.handleFailure(throwable);
                return;
            }
            if (throwable instanceof UnsupportedVersionException && this.handleUnsupportedVersionException((UnsupportedVersionException)throwable)) {
                KafkaAdminClient.this.log.debug("{} attempting protocol downgrade and then retry.", (Object)this);
                KafkaAdminClient.this.runnable.pendingCalls.add(this);
                return;
            }
            this.nextAllowedTryMs = now + KafkaAdminClient.this.retryBackoff.backoff(this.tries++);
            if (KafkaAdminClient.calcTimeoutMsRemainingAsInt(now, this.deadlineMs) <= 0) {
                this.handleTimeoutFailure(now, throwable);
                return;
            }
            if (!(throwable instanceof RetriableException)) {
                if (KafkaAdminClient.this.log.isDebugEnabled()) {
                    KafkaAdminClient.this.log.debug("{} failed with non-retriable exception after {} attempt(s)", new Object[]{this, this.tries, new Exception(KafkaAdminClient.prettyPrintException(throwable))});
                }
                this.handleFailure(throwable);
                return;
            }
            if (this.tries > KafkaAdminClient.this.maxRetries) {
                this.handleTimeoutFailure(now, throwable);
                return;
            }
            if (KafkaAdminClient.this.log.isDebugEnabled()) {
                KafkaAdminClient.this.log.debug("{} failed: {}. Beginning retry #{}", new Object[]{this, KafkaAdminClient.prettyPrintException(throwable), this.tries});
            }
            this.maybeRetry(now, throwable);
        }

        void maybeRetry(long now, Throwable throwable) {
            KafkaAdminClient.this.runnable.pendingCalls.add(this);
        }

        private void handleTimeoutFailure(long now, Throwable cause) {
            if (KafkaAdminClient.this.log.isDebugEnabled()) {
                KafkaAdminClient.this.log.debug("{} timed out at {} after {} attempt(s)", new Object[]{this, now, this.tries, new Exception(KafkaAdminClient.prettyPrintException(cause))});
            }
            if (cause instanceof TimeoutException) {
                this.handleFailure(cause);
            } else {
                this.handleFailure(new TimeoutException(this + " timed out at " + now + " after " + this.tries + " attempt(s)", cause));
            }
        }

        boolean isReady() {
            return this.requestInterceptor.isReady();
        }

        AbstractRequest.Builder<?> createAndMaybeInterceptRequest(long now, int timeoutMs) {
            AbstractRequest.Builder<?> requestBuilder = this.requestInterceptor.createRequest(this.curNode.idString(), timeoutMs);
            Optional<AbstractResponse> response = this.requestInterceptor.interceptedResponse();
            if (response.isPresent()) {
                this.onResponse(response.get(), now);
                return null;
            }
            return requestBuilder;
        }

        private void onResponse(AbstractResponse response, long now) {
            try {
                this.handleResponse(response);
                if (KafkaAdminClient.this.log.isTraceEnabled()) {
                    KafkaAdminClient.this.log.trace("{} got response {}", (Object)this, (Object)response);
                }
            }
            catch (Throwable t) {
                if (KafkaAdminClient.this.log.isTraceEnabled()) {
                    KafkaAdminClient.this.log.trace("{} handleResponse failed with {}", (Object)this, (Object)KafkaAdminClient.prettyPrintException(t));
                }
                this.fail(now, t);
            }
        }

        void processResponse(AbstractResponse response, long now) {
            this.onResponse(this.requestInterceptor.onResponse(response), now);
        }

        abstract AbstractRequest.Builder<?> createRequest(int var1);

        abstract void handleResponse(AbstractResponse var1);

        abstract void handleFailure(Throwable var1);

        boolean handleUnsupportedVersionException(UnsupportedVersionException exception) {
            return false;
        }

        public String toString() {
            return "Call(callName=" + this.callName + ", deadlineMs=" + this.deadlineMs + ", tries=" + this.tries + ", nextAllowedTryMs=" + this.nextAllowedTryMs + ")";
        }

        public boolean isInternal() {
            return this.internal;
        }
    }

    private class LeastLoadedBrokerOrActiveKController
    implements NodeProvider {
        private LeastLoadedBrokerOrActiveKController() {
        }

        @Override
        public Node provide() {
            if (KafkaAdminClient.this.metadataManager.isReady()) {
                if (KafkaAdminClient.this.metadataManager.usingBootstrapControllers()) {
                    return KafkaAdminClient.this.metadataManager.controller();
                }
                return KafkaAdminClient.this.client.leastLoadedNode(KafkaAdminClient.this.time.milliseconds()).node();
            }
            KafkaAdminClient.this.metadataManager.requestUpdate();
            return null;
        }

        @Override
        public boolean supportsUseControllers() {
            return true;
        }
    }

    private class ConstantBrokerOrActiveKController
    implements NodeProvider {
        private final int nodeId;

        ConstantBrokerOrActiveKController(int nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public Node provide() {
            if (KafkaAdminClient.this.metadataManager.isReady()) {
                if (KafkaAdminClient.this.metadataManager.usingBootstrapControllers()) {
                    return KafkaAdminClient.this.metadataManager.controller();
                }
                if (KafkaAdminClient.this.metadataManager.nodeById(this.nodeId) != null) {
                    return KafkaAdminClient.this.metadataManager.nodeById(this.nodeId);
                }
            }
            KafkaAdminClient.this.metadataManager.requestUpdate();
            return null;
        }

        @Override
        public boolean supportsUseControllers() {
            return true;
        }
    }

    private class LeastLoadedNodeProvider
    implements NodeProvider {
        private LeastLoadedNodeProvider() {
        }

        @Override
        public Node provide() {
            if (KafkaAdminClient.this.metadataManager.isReady()) {
                return KafkaAdminClient.this.client.leastLoadedNode(KafkaAdminClient.this.time.milliseconds()).node();
            }
            KafkaAdminClient.this.metadataManager.requestUpdate();
            return null;
        }

        @Override
        public boolean supportsUseControllers() {
            return false;
        }
    }

    private class ControllerNodeProvider
    implements NodeProvider {
        private final boolean supportsUseControllers;

        ControllerNodeProvider(boolean supportsUseControllers) {
            this.supportsUseControllers = supportsUseControllers;
        }

        ControllerNodeProvider() {
            this.supportsUseControllers = false;
        }

        @Override
        public Node provide() {
            if (KafkaAdminClient.this.metadataManager.isReady() && KafkaAdminClient.this.metadataManager.controller() != null) {
                return KafkaAdminClient.this.metadataManager.controller();
            }
            KafkaAdminClient.this.metadataManager.requestUpdate();
            return null;
        }

        @Override
        public boolean supportsUseControllers() {
            return this.supportsUseControllers;
        }
    }

    private class ConstantNodeIdProvider
    implements NodeProvider {
        private final int nodeId;
        private final boolean supportsUseControllers;

        ConstantNodeIdProvider(int nodeId, boolean supportsUseControllers) {
            this.nodeId = nodeId;
            this.supportsUseControllers = supportsUseControllers;
        }

        ConstantNodeIdProvider(int nodeId) {
            this.nodeId = nodeId;
            this.supportsUseControllers = false;
        }

        @Override
        public Node provide() {
            if (KafkaAdminClient.this.metadataManager.isReady() && KafkaAdminClient.this.metadataManager.nodeById(this.nodeId) != null) {
                return KafkaAdminClient.this.metadataManager.nodeById(this.nodeId);
            }
            KafkaAdminClient.this.metadataManager.requestUpdate();
            return null;
        }

        @Override
        public boolean supportsUseControllers() {
            return this.supportsUseControllers;
        }
    }

    private class MetadataUpdateNodeIdProvider
    implements NodeProvider {
        private MetadataUpdateNodeIdProvider() {
        }

        @Override
        public Node provide() {
            LeastLoadedNode leastLoadedNode = KafkaAdminClient.this.client.leastLoadedNode(KafkaAdminClient.this.time.milliseconds());
            if (KafkaAdminClient.this.metadataRecoveryStrategy == MetadataRecoveryStrategy.REBOOTSTRAP && !leastLoadedNode.hasNodeAvailableOrConnectionReady()) {
                KafkaAdminClient.this.metadataManager.rebootstrap(KafkaAdminClient.this.time.milliseconds());
            }
            return leastLoadedNode.node();
        }

        @Override
        public boolean supportsUseControllers() {
            return true;
        }
    }

    private static interface NodeProvider {
        public Node provide();

        public boolean supportsUseControllers();
    }
}

