/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Objects;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class NewMirrorTopic {
    private final String linkName;
    private final String sourceTopic;
    private final OffsetSpec startOffsetSpec;

    public NewMirrorTopic(String linkName, String sourceTopic) {
        this(linkName, sourceTopic, null);
    }

    public NewMirrorTopic(String linkName, String sourceTopic, OffsetSpec startOffsetSpec) {
        this.linkName = Objects.requireNonNull(linkName);
        this.sourceTopic = Objects.requireNonNull(sourceTopic);
        this.startOffsetSpec = startOffsetSpec;
    }

    public String linkName() {
        return this.linkName;
    }

    @Deprecated
    public String mirrorTopic() {
        return this.sourceTopic;
    }

    public String sourceTopic() {
        return this.sourceTopic;
    }

    public OffsetSpec startOffsetSpec() {
        return this.startOffsetSpec;
    }

    public String toString() {
        String startOffsetName = "";
        if (this.startOffsetSpec != null) {
            startOffsetName = ", startOffsetSpec=" + this.startOffsetSpec.getClass().getSimpleName();
        }
        return "NewMirrorTopic(linkName=" + this.linkName + ", sourceTopic=" + this.sourceTopic + startOffsetName + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewMirrorTopic that = (NewMirrorTopic)o;
        return Objects.equals(this.linkName, that.linkName) && Objects.equals(this.sourceTopic, that.sourceTopic) && Objects.equals(this.startOffsetSpec, that.startOffsetSpec);
    }

    public int hashCode() {
        return Objects.hash(this.linkName, this.sourceTopic, this.startOffsetSpec);
    }
}

