/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class FindCoordinatorRequestData
implements ApiMessage {
    String key;
    byte keyType;
    List<String> coordinatorKeys;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("key", Type.STRING, "The coordinator key."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 5;

    public FindCoordinatorRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public FindCoordinatorRequestData() {
        this.key = "";
        this.keyType = 0;
        this.coordinatorKeys = new ArrayList<String>(0);
    }

    @Override
    public short apiKey() {
        return 10;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 5;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        if (_version <= 3) {
            int length = _version >= 3 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field key was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field key had invalid length " + length);
            }
            this.key = _context.read(EntityType.COORDINATOR_KEY, _readable.readString(length));
        } else {
            this.key = "";
        }
        this.keyType = _version >= 1 ? _readable.readByte() : (byte)0;
        if (_version >= 4) {
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field coordinatorKeys was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<String> newCollection = new ArrayList<String>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                int length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field coordinatorKeys element was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field coordinatorKeys element had invalid length " + length);
                }
                newCollection.add(_context.read(EntityType.COORDINATOR_KEY, _readable.readString(length)));
            }
            this.coordinatorKeys = newCollection;
        } else {
            this.coordinatorKeys = new ArrayList<String>(0);
        }
        this._unknownTaggedFields = null;
        if (_version >= 3) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        if (_version <= 3) {
            _stringBytes = _cache.getSerializedValue(this.key);
            if (_version >= 3) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
        } else if (!this.key.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default key at version " + _version);
        }
        if (_version >= 1) {
            _writable.writeByte(this.keyType);
        } else if (this.keyType != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default keyType at version " + _version);
        }
        if (_version >= 4) {
            _writable.writeUnsignedVarint(this.coordinatorKeys.size() + 1);
            _stringBytes = this.coordinatorKeys.iterator();
            while (_stringBytes.hasNext()) {
                String coordinatorKeysElement = (String)_stringBytes.next();
                byte[] _stringBytes2 = _cache.getSerializedValue(coordinatorKeysElement);
                _writable.writeUnsignedVarint(_stringBytes2.length + 1);
                _writable.writeByteArray(_stringBytes2);
            }
        } else if (!this.coordinatorKeys.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default coordinatorKeys at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 3) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version <= 3) {
            byte[] _stringBytes = _context.write(EntityType.COORDINATOR_KEY, this.key).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'key' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.key, _stringBytes);
            if (_version >= 3) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
        }
        if (_version >= 1) {
            _size.addBytes(1);
        }
        if (_version >= 4) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.coordinatorKeys.size() + 1));
            for (String coordinatorKeysElement : this.coordinatorKeys) {
                byte[] _stringBytes = _context.write(EntityType.COORDINATOR_KEY, coordinatorKeysElement).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'coordinatorKeysElement' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(coordinatorKeysElement, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 3) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FindCoordinatorRequestData)) {
            return false;
        }
        FindCoordinatorRequestData other = (FindCoordinatorRequestData)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.keyType != other.keyType) {
            return false;
        }
        if (this.coordinatorKeys == null ? other.coordinatorKeys != null : !this.coordinatorKeys.equals(other.coordinatorKeys)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.key == null ? 0 : this.key.hashCode());
        hashCode = 31 * hashCode + this.keyType;
        hashCode = 31 * hashCode + (this.coordinatorKeys == null ? 0 : this.coordinatorKeys.hashCode());
        return hashCode;
    }

    @Override
    public FindCoordinatorRequestData duplicate() {
        FindCoordinatorRequestData _duplicate = new FindCoordinatorRequestData();
        _duplicate.key = this.key;
        _duplicate.keyType = this.keyType;
        ArrayList<String> newCoordinatorKeys = new ArrayList<String>(this.coordinatorKeys.size());
        for (String _element : this.coordinatorKeys) {
            newCoordinatorKeys.add(_element);
        }
        _duplicate.coordinatorKeys = newCoordinatorKeys;
        return _duplicate;
    }

    public String toString() {
        return "FindCoordinatorRequestData(key=" + (this.key == null ? "null" : "'" + this.key.toString() + "'") + ", keyType=" + this.keyType + ", coordinatorKeys=" + MessageUtil.deepToString(this.coordinatorKeys.iterator()) + ")";
    }

    public String key() {
        return this.key;
    }

    public byte keyType() {
        return this.keyType;
    }

    public List<String> coordinatorKeys() {
        return this.coordinatorKeys;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public FindCoordinatorRequestData setKey(String v) {
        this.key = v;
        return this;
    }

    public FindCoordinatorRequestData setKeyType(byte v) {
        this.keyType = v;
        return this;
    }

    public FindCoordinatorRequestData setCoordinatorKeys(List<String> v) {
        this.coordinatorKeys = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = new Schema(new Field("key", Type.STRING, "The coordinator key."), new Field("key_type", Type.INT8, "The coordinator key type. (Group, transaction, etc.)"));
        SCHEMA_3 = new Schema(new Field("key", Type.COMPACT_STRING, "The coordinator key."), new Field("key_type", Type.INT8, "The coordinator key type. (Group, transaction, etc.)"), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_5 = SCHEMA_4 = new Schema(new Field("key_type", Type.INT8, "The coordinator key type. (Group, transaction, etc.)"), new Field("coordinator_keys", new CompactArrayOf(Type.COMPACT_STRING), "The coordinator keys."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
    }
}

