/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.AlterMirrorsRequestData;
import org.apache.kafka.common.message.AlterMirrorsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class AlterMirrorsResponse
extends AbstractResponse {
    private final AlterMirrorsResponseData data;

    public AlterMirrorsResponse(List<AlterMirrorsResponseData.AlterMirrorResult> results, int throttleTimeMs) {
        super(ApiKeys.ALTER_MIRRORS);
        this.data = new AlterMirrorsResponseData().setThrottleTimeMs(throttleTimeMs);
        this.data.setResults(results);
    }

    public AlterMirrorsResponse(List<AlterMirrorsResponseData.AlterMirrorResult> results, List<AlterMirrorsRequestData.MirrorOperation> ops, int throttleTimeMs, short version) {
        super(ApiKeys.ALTER_MIRRORS);
        if (results.size() != ops.size()) {
            throw new IllegalArgumentException("Expected results and operations of the same size");
        }
        for (int i = 0; i < results.size(); ++i) {
            AlterMirrorOp alterMirrorOp;
            AlterMirrorsResponseData.AlterMirrorResult result = results.get(i);
            AlterMirrorsRequestData.MirrorOperation op = ops.get(i);
            if (version >= 2 && result.topic().isEmpty()) {
                result.setTopic(op.topic());
                continue;
            }
            if (version >= 2 || (alterMirrorOp = AlterMirrorOp.forId(op.operationCode())) == null) continue;
            AlterMirrorsResponse.populateResultArrays(result, alterMirrorOp);
        }
        this.data = new AlterMirrorsResponseData().setThrottleTimeMs(throttleTimeMs);
        this.data.setResults(results);
    }

    public AlterMirrorsResponse(Map<String, Errors> errorResults, int throttleTimeMs) {
        super(ApiKeys.ALTER_MIRRORS);
        ArrayList<AlterMirrorsResponseData.AlterMirrorResult> alterMirrorResults = new ArrayList<AlterMirrorsResponseData.AlterMirrorResult>(errorResults.size());
        for (Map.Entry<String, Errors> result : errorResults.entrySet()) {
            AlterMirrorsResponseData.AlterMirrorResult alterMirrorResult = new AlterMirrorsResponseData.AlterMirrorResult().setErrorCode(result.getValue().code()).setErrorMessage(result.getValue().message()).setTopic(result.getKey());
            alterMirrorResults.add(alterMirrorResult);
        }
        this.data = new AlterMirrorsResponseData().setThrottleTimeMs(throttleTimeMs).setResults(alterMirrorResults);
    }

    public AlterMirrorsResponse(AlterMirrorsResponseData data) {
        super(ApiKeys.ALTER_MIRRORS);
        this.data = data;
    }

    public void complete(LinkedHashMap<String, KafkaFutureImpl<Void>> futures) {
        Iterator<KafkaFutureImpl<Void>> iterator = futures.values().iterator();
        for (AlterMirrorsResponseData.AlterMirrorResult result : this.data.results()) {
            Errors error = Errors.forCode(result.errorCode());
            KafkaFutureImpl<Void> future = iterator.next();
            if (error != Errors.NONE) {
                future.completeExceptionally(error.exception(result.errorMessage()));
                continue;
            }
            future.complete(null);
        }
    }

    public AlterMirrorsResponse updateResponseWithValidationErrors(Map<String, Errors> errorResults, int throttleTimeMs) {
        if (errorResults.isEmpty()) {
            return this;
        }
        ArrayList<AlterMirrorsResponseData.AlterMirrorResult> updatedResults = new ArrayList<AlterMirrorsResponseData.AlterMirrorResult>(this.data.results());
        for (Map.Entry<String, Errors> entry : errorResults.entrySet()) {
            String topic = entry.getKey();
            Errors error = entry.getValue();
            AlterMirrorsResponseData.AlterMirrorResult errorResult = new AlterMirrorsResponseData.AlterMirrorResult().setTopic(topic).setErrorCode(error.code()).setErrorMessage(error.message());
            updatedResults.add(errorResult);
        }
        AlterMirrorsResponseData newData = new AlterMirrorsResponseData().setResults(updatedResults).setThrottleTimeMs(throttleTimeMs);
        return new AlterMirrorsResponse(newData);
    }

    @Override
    public AlterMirrorsResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        for (AlterMirrorsResponseData.AlterMirrorResult result : this.data.results()) {
            Errors error = Errors.forCode(result.errorCode());
            counts.put(error, counts.getOrDefault((Object)error, 0) + 1);
        }
        return counts;
    }

    public static AlterMirrorsResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new AlterMirrorsResponse(new AlterMirrorsResponseData(new ByteBufferAccessor(buffer), version, context));
    }

    private static void populateResultArrays(AlterMirrorsResponseData.AlterMirrorResult result, AlterMirrorOp op) {
        switch (op) {
            case CLEAR: {
                result.setClearMirrorTopic(Collections.singletonList(new AlterMirrorsResponseData.ClearMirrorTopicData()));
                break;
            }
            case PROMOTE: 
            case FAILOVER: {
                result.setStopMirrorTopic(Collections.singletonList(new AlterMirrorsResponseData.StopMirrorTopicData()));
                break;
            }
            case PAUSE: 
            case RESUME: 
            case PAUSE_LINK: 
            case RESUME_LINK: {
                result.setPauseMirrorTopic(Collections.singletonList(new AlterMirrorsResponseData.PauseMirrorTopicData()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected mirror operation " + (Object)((Object)op));
            }
        }
    }
}

