/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.Login;
import org.apache.kafka.common.security.authenticator.AbstractLogin;
import org.apache.kafka.common.security.authenticator.FileBasedDynamicCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredLoginCallbackHandler;
import org.apache.kafka.common.utils.FileWatchService;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginManager.class);
    private static final Map<LoginMetadata<String>, LoginManager> STATIC_INSTANCES = new HashMap<LoginMetadata<String>, LoginManager>();
    private static final Map<LoginMetadata<Password>, LoginManager> DYNAMIC_INSTANCES = new HashMap<LoginMetadata<Password>, LoginManager>();
    private static final FileWatchService FILE_WATCH_SERVICE = new FileWatchService();
    private final Login login;
    private final LoginMetadata<?> loginMetadata;
    private final AuthenticateCallbackHandler loginCallbackHandler;
    private final FileWatchListener fileWatchListener;
    private int refCount;

    private LoginManager(JaasContext jaasContext, String saslMechanism, Map<String, ?> configs, LoginMetadata<?> loginMetadata) throws LoginException {
        this.loginMetadata = loginMetadata;
        this.login = Utils.newInstance(loginMetadata.loginClass);
        this.loginCallbackHandler = Utils.newInstance(loginMetadata.loginCallbackClass);
        try {
            this.loginCallbackHandler.configure(configs, saslMechanism, jaasContext.configurationEntries());
            this.login.configure(configs, jaasContext.name(), jaasContext.configuration(), this.loginCallbackHandler);
            if (this.loginCallbackHandler instanceof FileBasedDynamicCallbackHandler) {
                this.fileWatchListener = new FileWatchListener((FileBasedDynamicCallbackHandler)this.loginCallbackHandler);
                FILE_WATCH_SERVICE.add(this.fileWatchListener);
            } else {
                this.fileWatchListener = null;
            }
            this.login.login();
        }
        catch (Exception e) {
            this.closeResources();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoginManager acquireLoginManager(JaasContext jaasContext, String saslMechanism, Class<? extends Login> defaultLoginClass, Map<String, ?> configs) throws LoginException {
        Class<? extends Login> loginClass = LoginManager.configuredClassOrDefault(configs, jaasContext, saslMechanism, "sasl.login.class", defaultLoginClass);
        Class defaultLoginCallbackHandlerClass = "OAUTHBEARER".equals(saslMechanism) ? OAuthBearerUnsecuredLoginCallbackHandler.class : AbstractLogin.DefaultLoginCallbackHandler.class;
        Class<OAuthBearerUnsecuredLoginCallbackHandler> loginCallbackClass = LoginManager.configuredClassOrDefault(configs, jaasContext, saslMechanism, "sasl.login.callback.handler.class", defaultLoginCallbackHandlerClass);
        Class<LoginManager> clazz = LoginManager.class;
        synchronized (LoginManager.class) {
            LoginManager loginManager;
            Password jaasConfigValue = jaasContext.dynamicJaasConfig();
            if (jaasConfigValue != null) {
                LoginMetadata<Password> loginMetadata = new LoginMetadata<Password>(jaasConfigValue, loginClass, loginCallbackClass, configs);
                loginManager = DYNAMIC_INSTANCES.get(loginMetadata);
                if (loginManager == null) {
                    loginManager = new LoginManager(jaasContext, saslMechanism, configs, loginMetadata);
                    DYNAMIC_INSTANCES.put(loginMetadata, loginManager);
                }
            } else {
                LoginMetadata<String> loginMetadata = new LoginMetadata<String>(jaasContext.name(), loginClass, loginCallbackClass, configs);
                loginManager = STATIC_INSTANCES.get(loginMetadata);
                if (loginManager == null) {
                    loginManager = new LoginManager(jaasContext, saslMechanism, configs, loginMetadata);
                    STATIC_INSTANCES.put(loginMetadata, loginManager);
                }
            }
            SecurityUtils.addConfiguredSecurityProviders(configs);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return loginManager.acquire();
        }
    }

    public void reconfigure(Map<String, ?> newConfigs) throws LoginException {
        if (!(this.loginCallbackHandler instanceof Reconfigurable)) {
            LOGGER.error("Cannot reconfigure LoginManager with a non-reconfigurable callback handler");
            throw new IllegalStateException("This login hasn't been configured with a reconfigurable callback handler");
        }
        LOGGER.debug("Reconfiguring LoginManager that has a reconfigurable callback handler");
        ((Reconfigurable)((Object)this.loginCallbackHandler)).reconfigure(newConfigs);
        this.login.relogin();
    }

    public Subject subject() {
        return this.login.subject();
    }

    public String serviceName() {
        return this.login.serviceName();
    }

    Object cacheKey() {
        return this.loginMetadata.configInfo;
    }

    private LoginManager acquire() {
        ++this.refCount;
        LOGGER.trace("{} acquired", (Object)this);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Class<LoginManager> clazz = LoginManager.class;
        synchronized (LoginManager.class) {
            if (this.refCount == 0) {
                throw new IllegalStateException("release() called on disposed " + this);
            }
            if (this.refCount == 1) {
                if (this.loginMetadata.configInfo instanceof Password) {
                    DYNAMIC_INSTANCES.remove(this.loginMetadata);
                } else {
                    STATIC_INSTANCES.remove(this.loginMetadata);
                }
                this.login.close();
                this.loginCallbackHandler.close();
                if (this.fileWatchListener != null) {
                    FILE_WATCH_SERVICE.remove(this.fileWatchListener);
                }
            }
            --this.refCount;
            LOGGER.trace("{} released", (Object)this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        return "LoginManager(serviceName=" + this.serviceName() + ", publicCredentials=" + this.subject().getPublicCredentials() + ", refCount=" + this.refCount + ')';
    }

    private void closeResources() {
        try {
            List<Callable<Void>> tasks = Arrays.asList(() -> {
                this.login.close();
                return null;
            }, () -> {
                this.loginCallbackHandler.close();
                return null;
            }, () -> {
                if (this.fileWatchListener != null) {
                    FILE_WATCH_SERVICE.remove(this.fileWatchListener);
                }
                return null;
            });
            Utils.tryAll(tasks);
        }
        catch (Throwable t) {
            LOGGER.info("Exception thrown during closing", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        Class<LoginManager> clazz = LoginManager.class;
        synchronized (LoginManager.class) {
            for (LoginMetadata<String> loginMetadata : new ArrayList<LoginMetadata<String>>(STATIC_INSTANCES.keySet())) {
                LoginManager.STATIC_INSTANCES.remove(loginMetadata).login.close();
            }
            for (LoginMetadata<Object> loginMetadata : new ArrayList<LoginMetadata<Password>>(DYNAMIC_INSTANCES.keySet())) {
                LoginManager.DYNAMIC_INSTANCES.remove(loginMetadata).login.close();
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }

    private static <T> Class<? extends T> configuredClassOrDefault(Map<String, ?> configs, JaasContext jaasContext, String saslMechanism, String configName, Class<? extends T> defaultClass) {
        String prefix = jaasContext.type() == JaasContext.Type.SERVER ? ListenerName.saslMechanismPrefix(saslMechanism) : "";
        Class<? extends T> clazz = (Class<? extends T>)configs.get(prefix + configName);
        if (clazz != null && jaasContext.configurationEntries().size() != 1) {
            String errorMessage = configName + " cannot be specified with multiple login modules in the JAAS context. " + "sasl.jaas.config" + " must be configured to override mechanism-specific configs.";
            throw new ConfigException(errorMessage);
        }
        if (clazz == null) {
            clazz = defaultClass;
        }
        return clazz;
    }

    private class FileWatchListener
    implements FileWatchService.Listener {
        private final File configFile;
        private final File watchFile;
        private final FileBasedDynamicCallbackHandler callbackHandler;

        public FileWatchListener(FileBasedDynamicCallbackHandler callbackHandler) {
            this.callbackHandler = callbackHandler;
            this.configFile = callbackHandler.configFile();
            if (this.configFile == null) {
                throw new ConfigException("Properties directory not specified for file-based login callback handler");
            }
            if (!this.configFile.exists()) {
                throw new ConfigException("Login properties file not found: " + this.configFile);
            }
            File watchFile = callbackHandler.watchFile();
            if (watchFile == null) {
                this.watchFile = this.configFile;
            } else {
                if (!watchFile.exists()) {
                    throw new ConfigException("Login properties watch file not found: " + watchFile);
                }
                this.watchFile = watchFile;
            }
        }

        @Override
        public File file() {
            return this.watchFile;
        }

        @Override
        public void onInit() {
            Map<String, ?> configs = this.loadConfigs();
            this.callbackHandler.validateReconfiguration(configs);
            this.callbackHandler.configure(configs);
        }

        @Override
        public void onUpdate() {
            try {
                Map<String, ?> configs = this.loadConfigs();
                this.callbackHandler.validateReconfiguration(configs);
                LoginManager.this.reconfigure(configs);
            }
            catch (Exception e) {
                LOGGER.error("Failed to reconfigure login manager", (Throwable)e);
            }
        }

        private Map<String, ?> loadConfigs() {
            try {
                String propStr = Utils.readFileAsString(this.configFile.getAbsolutePath()).trim();
                if (!propStr.startsWith("{")) {
                    Properties props = new Properties();
                    props.load(new StringReader(propStr));
                    return Utils.propsToMap(props);
                }
                HashMap props = new HashMap();
                new ObjectMapper().readTree(propStr).fields().forEachRemaining(prop -> props.put(prop.getKey(), ((JsonNode)prop.getValue()).asText()));
                return props;
            }
            catch (IOException e) {
                LOGGER.error("Callback handler properties could not be parsed from file : " + this.callbackHandler.configFile(), (Throwable)e);
                throw new ConfigException("Callback handler properties could not be parsed from file: " + this.callbackHandler.configFile(), (Object)e);
            }
        }
    }

    private static class LoginMetadata<T> {
        final T configInfo;
        final Class<? extends Login> loginClass;
        final Class<? extends AuthenticateCallbackHandler> loginCallbackClass;
        final Map<String, Object> saslConfigs;

        LoginMetadata(T configInfo, Class<? extends Login> loginClass, Class<? extends AuthenticateCallbackHandler> loginCallbackClass, Map<String, ?> configs) {
            this.configInfo = configInfo;
            this.loginClass = loginClass;
            this.loginCallbackClass = loginCallbackClass;
            this.saslConfigs = new HashMap<String, Object>();
            configs.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("sasl.")).forEach(e -> this.saslConfigs.put((String)e.getKey(), e.getValue()));
        }

        public int hashCode() {
            return Objects.hash(this.configInfo, this.loginClass, this.loginCallbackClass, this.saslConfigs);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LoginMetadata loginMetadata = (LoginMetadata)o;
            return Objects.equals(this.configInfo, loginMetadata.configInfo) && Objects.equals(this.loginClass, loginMetadata.loginClass) && Objects.equals(this.loginCallbackClass, loginMetadata.loginCallbackClass) && Objects.equals(this.saslConfigs, loginMetadata.saslConfigs);
        }
    }
}

