/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.server.metrics.AbstractSensorBuilder;
import org.apache.kafka.server.metrics.AbstractSensorCreator;
import org.apache.kafka.server.metrics.MetricsBuilderContext;
import org.apache.kafka.server.metrics.TenantRequestSensors;

public class TenantRequestSensorBuilder
extends AbstractSensorBuilder<MetricsBuilderContext, TenantRequestSensors> {
    public static final long EXPIRY_SECONDS = TimeUnit.HOURS.toSeconds(1L);
    protected static final String REQUEST_RATE = "aggregate-request";
    private static final Map<String, RequestMeterSensorCreator> REQUEST_SENSOR_CREATORS = new HashMap<String, RequestMeterSensorCreator>();

    public TenantRequestSensorBuilder(Metrics metrics, MetricsBuilderContext context) {
        super(metrics, context);
    }

    @Override
    public TenantRequestSensors build() {
        Map<String, Sensor> sensors = this.getOrCreateSuffixedSensors();
        return new TenantRequestSensors(sensors.get(REQUEST_RATE));
    }

    @Override
    protected String sensorSuffix(String unused, MetricsBuilderContext context) {
        return context.sensorSuffix();
    }

    @Override
    protected Map<String, ? extends AbstractSensorCreator> sensorCreators() {
        return REQUEST_SENSOR_CREATORS;
    }

    @Override
    protected <T> Sensor createSensor(Map<T, ? extends AbstractSensorCreator> sensorCreators, T sensorKey, String sensorName) {
        RequestMeterSensorCreator sensorCreator = (RequestMeterSensorCreator)sensorCreators.get(sensorKey);
        return sensorCreator.createSensor(this.metrics, sensorName, this.context);
    }

    static {
        REQUEST_SENSOR_CREATORS.put(REQUEST_RATE, new RequestMeterSensorCreator(REQUEST_RATE, "requests"));
    }

    private static class RequestMeterSensorCreator
    extends AbstractSensorCreator {
        RequestMeterSensorCreator(String name, String descriptiveName) {
            super(name, descriptiveName);
        }

        protected Map<String, String> metricTags(MetricsBuilderContext context) {
            return context.metricTags();
        }

        protected Sensor createSensor(Metrics metrics, String sensorName, MetricsBuilderContext context) {
            Sensor sensor = super.createSensor(metrics, sensorName, EXPIRY_SECONDS);
            Map<String, String> metricTags = this.metricTags(context);
            String group = context.metricsGroup();
            sensor.add(this.createMeter(metrics, group, metricTags, this.name, this.descriptiveName));
            return sensor;
        }
    }
}

