/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.security.config.manipulation;

import io.confluent.connect.security.config.manipulation.ConfigManipulator;
import io.confluent.connect.security.util.ConnectRestApiMethods;
import io.confluent.connect.security.util.ConnectRestUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ResourceInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConfigInfos;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorInfo;
import org.apache.kafka.connect.runtime.rest.entities.CreateConnectorRequest;

public class ConfigManipulators {
    private final List<ConfigManipulator> configManipulators;

    public ConfigManipulators(ConfigManipulator ... configManipulators) {
        this(Arrays.asList(configManipulators));
    }

    public ConfigManipulators(List<ConfigManipulator> configManipulators) {
        this.configManipulators = configManipulators;
    }

    public void transformRequest(ResourceInfo resourceInfo, ContainerRequestContext requestContext) throws IOException {
        Method resourceMethod = resourceInfo.getResourceMethod();
        if (ConnectRestApiMethods.CREATE_CONNECTOR.equals(resourceMethod)) {
            CreateConnectorRequest createConnectorRequest = ConnectRestUtils.readEntity(requestContext, CreateConnectorRequest.class);
            this.transformIncomingConnectorConfig(requestContext, createConnectorRequest.config(), config -> new CreateConnectorRequest(createConnectorRequest.name(), config, null));
        } else if (ConnectRestApiMethods.PUT_CONNECTOR_CONFIG.equals(resourceMethod)) {
            Map<String, String> connectorConfig = ConnectRestUtils.readEntity(requestContext, ConnectRestUtils.CONNECTOR_CONFIG_TYPE);
            this.transformIncomingConnectorConfig(requestContext, connectorConfig, Function.identity());
        }
    }

    public void transformResponse(ResourceInfo resourceInfo, ContainerResponseContext responseContext) {
        Method resourceMethod = resourceInfo.getResourceMethod();
        if (ConnectRestApiMethods.LIST_CONNECTORS.equals(resourceMethod)) {
            Object rawResponse = responseContext.getEntity();
            if (rawResponse instanceof Map) {
                Map connectors = (Map)rawResponse;
                this.transformOutgoingConnectorsList(responseContext, connectors);
            }
        } else if (ConnectRestApiMethods.CONNECTOR_CONFIG_VALIDATE.equals(resourceMethod)) {
            this.transformConfigValidateResponse(responseContext);
        } else if (ConnectRestApiMethods.CREATE_CONNECTOR.equals(resourceMethod) || ConnectRestApiMethods.PUT_CONNECTOR_CONFIG.equals(resourceMethod) || ConnectRestApiMethods.GET_CONNECTOR.equals(resourceMethod)) {
            ConnectorInfo responseBody = (ConnectorInfo)ConnectRestUtils.responseEntity(responseContext);
            this.transformOutgoingConnectorConfig(responseContext, responseBody.config(), transformedConfig -> new ConnectorInfo(responseBody.name(), transformedConfig, responseBody.tasks(), responseBody.type()));
        } else if (ConnectRestApiMethods.GET_CONNECTOR_CONFIG.equals(resourceMethod)) {
            this.transformOutgoingConnectorConfig(responseContext, (Map)ConnectRestUtils.responseEntity(responseContext), Function.identity());
        }
    }

    private void transformConfigValidateResponse(ContainerResponseContext responseContext) {
        ConfigInfos configInfos = (ConfigInfos)ConnectRestUtils.responseEntity(responseContext);
        ConfigInfos transformedConfigInfos = this.applyAllVirtualConfigurations(ConnectRestUtils.responseEntity(responseContext), ConfigManipulator::transformConfigValidateResponse);
        if (!transformedConfigInfos.equals((Object)configInfos)) {
            responseContext.setEntity((Object)transformedConfigInfos);
        }
    }

    private void transformOutgoingConnectorsList(ContainerResponseContext responseContext, Map<String, Map<String, Object>> connectorsList) {
        Map<String, Map> newConnectorsList = connectorsList.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, innerEntry -> {
            if (innerEntry.getValue() instanceof ConnectorInfo) {
                ConnectorInfo connectorInfo = (ConnectorInfo)innerEntry.getValue();
                Map transformedConnectorConfig = this.applyAllVirtualConfigurations(connectorInfo.config(), ConfigManipulator::transformOutgoingConnectorConfig);
                return new ConnectorInfo(connectorInfo.name(), transformedConnectorConfig, connectorInfo.tasks(), connectorInfo.type());
            }
            return innerEntry.getValue();
        }))));
        if (!newConnectorsList.equals(connectorsList)) {
            responseContext.setEntity(newConnectorsList);
        }
    }

    private <T> void transformIncomingConnectorConfig(ContainerRequestContext requestContext, Map<String, String> connectorConfig, Function<Map<String, String>, T> configToEntity) throws IOException {
        Map transformedConfig = this.applyAllVirtualConfigurations(connectorConfig, ConfigManipulator::transformIncomingConnectorConfig);
        if (!connectorConfig.equals(transformedConfig)) {
            ConnectRestUtils.setEntity(requestContext, configToEntity.apply(transformedConfig));
        }
    }

    private <T> void transformOutgoingConnectorConfig(ContainerResponseContext responseContext, Map<String, String> connectorConfig, Function<Map<String, String>, T> configToEntity) {
        Map transformedConfig = this.applyAllVirtualConfigurations(connectorConfig, ConfigManipulator::transformOutgoingConnectorConfig);
        if (!connectorConfig.equals(transformedConfig)) {
            responseContext.setEntity(configToEntity.apply(transformedConfig));
        }
    }

    private <T> T applyAllVirtualConfigurations(T initialInput, BiFunction<ConfigManipulator, T, T> virtualConfigurationMethod) {
        T result = initialInput;
        for (ConfigManipulator configManipulator : this.configManipulators) {
            result = virtualConfigurationMethod.apply(configManipulator, (ConfigManipulator)result);
            Objects.requireNonNull(result);
        }
        return result;
    }
}

