/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.security.rbac;

import com.fasterxml.jackson.core.type.TypeReference;
import io.confluent.connect.security.rbac.ActionBuilder;
import io.confluent.connect.security.rbac.ConnectActions;
import io.confluent.connect.security.rbac.ConnectorOperations;
import io.confluent.connect.security.util.ConnectRestUtils;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.roledefinitions.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.container.ContainerRequestContext;
import org.apache.kafka.connect.health.ConnectClusterState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PutConnectorConfigActionBuilder
implements ActionBuilder {
    private static final Logger log = LoggerFactory.getLogger(PutConnectorConfigActionBuilder.class);
    private final Scope scope;
    private final ConnectClusterState clusterState;

    public PutConnectorConfigActionBuilder(Scope scope, ConnectClusterState clusterState) {
        this.scope = scope;
        this.clusterState = clusterState;
    }

    @Override
    public List<Action> computeActions(ContainerRequestContext requestContext) throws IOException {
        String existingTasks;
        String connectorName = ConnectRestUtils.connectorName(requestContext);
        Collection connectors = this.clusterState.connectors();
        if (!connectors.contains(connectorName)) {
            return Collections.singletonList(new Action(this.scope, ConnectActions.CONNECTOR_RESOURCE, connectorName, ConnectorOperations.CREATE));
        }
        ArrayList<Operation> operations = new ArrayList<Operation>(2);
        Map<String, String> newConfig = ConnectRestUtils.readEntity(requestContext, new TypeReference<Map<String, String>>(){});
        Map existingConfig = this.clusterState.connectorConfig(connectorName);
        String newTasks = newConfig.get("tasks.max");
        if (!Objects.equals(newTasks, existingTasks = (String)existingConfig.get("tasks.max"))) {
            operations.add(ConnectorOperations.SCALE);
        }
        newConfig.remove("tasks.max");
        newConfig.remove("name");
        existingConfig.remove("tasks.max");
        existingConfig.remove("name");
        if (!Objects.equals(newConfig, existingConfig)) {
            operations.add(ConnectorOperations.CONFIGURE);
        }
        return operations.stream().map(operation -> new Action(this.scope, ConnectActions.CONNECTOR_RESOURCE, connectorName, operation)).collect(Collectors.toList());
    }
}

