/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.link;

import io.confluent.kafka.multitenant.MultiTenantRequestContext;
import io.confluent.kafka.multitenant.schema.TenantContext;
import java.util.Optional;
import kafka.server.link.AclBindingFilterTransformer;
import kafka.server.link.ClusterLinkManager;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import scala.collection.immutable.Map;

public class MultiTenantAclBindingFilterTransformer
implements AclBindingFilterTransformer {
    private String tenantPrefix;

    public void configure(Map<String, String> configs) {
        Optional<Object> tenantPrefixOpt = Optional.ofNullable(configs.get((Object)ClusterLinkManager.LocalTenantPrefixProp()).getOrElse(null));
        if (!tenantPrefixOpt.isPresent()) {
            throw new IllegalStateException(String.format("Config value %s is not set.", ClusterLinkManager.LocalTenantPrefixProp()));
        }
        this.tenantPrefix = (String)tenantPrefixOpt.get();
    }

    public AclBindingFilter transform(AclBindingFilter aclBindingFilter) {
        String transformedPrincipal = TenantContext.addTenantPrefixToPrincipal(this.tenantPrefix, aclBindingFilter.entryFilter().principal());
        ResourcePatternFilter currPatternFilter = aclBindingFilter.patternFilter();
        String resourceName = TenantContext.isTransformRequired(currPatternFilter.resourceType()) ? TenantContext.addTenantPrefixNullable(this.tenantPrefix, currPatternFilter.name()) : currPatternFilter.name();
        AccessControlEntryFilter currEntryFilter = aclBindingFilter.entryFilter();
        return MultiTenantRequestContext.transformAclFilter(this.tenantPrefix, this.tenantPrefix + "*", new AclBindingFilter(new ResourcePatternFilter(currPatternFilter.resourceType(), resourceName, currPatternFilter.patternType()), new AccessControlEntryFilter(transformedPrincipal, currEntryFilter.host(), currEntryFilter.operation(), currEntryFilter.permissionType(), currEntryFilter.clusterLinkIds())));
    }
}

