/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.MultiTenantConfigRestrictions;
import io.confluent.kafka.multitenant.MultiTenantInterceptorConfig;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.ZoneAlignment;
import io.confluent.kafka.multitenant.ZoneUtils;
import io.confluent.kafka.multitenant.metrics.HotPartitionManager;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import io.confluent.kafka.multitenant.schema.MultiTenantApis;
import io.confluent.kafka.multitenant.schema.TenantContext;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.AlterMirrorsRequestData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.ConsumerProtocolSubscription;
import org.apache.kafka.common.message.CreateClusterLinksRequestData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteAclsRequestData;
import org.apache.kafka.common.message.DescribeAclsResponseData;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ProduceConsumeAuditLogTracker;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.AlterMirrorsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.CreateAclsRequest;
import org.apache.kafka.common.requests.CreateClusterLinksRequest;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteAclsRequest;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.requests.DescribeAclsRequest;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.requests.DescribeClusterLinksResponse;
import org.apache.kafka.common.requests.DescribeClusterResponse;
import org.apache.kafka.common.requests.DescribeConfigsRequest;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.ListClusterLinksResponse;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListMirrorsResponse;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RequestAndSize;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.link.ClusterLinkSourceMetrics;
import org.apache.kafka.server.metrics.ApiSensors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTenantRequestContext
extends RequestContext {
    private static final Logger log = LoggerFactory.getLogger(MultiTenantRequestContext.class);
    static final Set<AlterMirrorOp> DISALLOWED_ALTER_MIRROR_OPS = Utils.mkSet((Object[])new AlterMirrorOp[]{AlterMirrorOp.REPAIR, AlterMirrorOp.ROLLBACK});
    final TenantContext tenantContext;
    private final Metrics metrics;
    private final TenantMetrics tenantMetrics;
    private final HotPartitionManager hotPartitionManager;
    private final TenantMetrics.MetricsRequestContext metricsRequestContext;
    private final Time time;
    private final long startNanos;
    private boolean isJoinConsumerGroup = false;
    private PatternType describeAclsPatternType;
    private boolean requestParsingFailed = false;
    private ApiException tenantApiException;
    private final boolean clusterPrefixForHostnameEnabled;
    private final Optional<ClusterLinkSourceMetrics> clusterLinkSourceMetrics;
    private final boolean schemaValidationEnabled;
    private final MultiTenantApis multiTenantApis;
    private final String brokerRack;
    private final Set<String> validBrokerRackSet;
    private final boolean shouldAppendSubdomainToHostname;
    private final Map<String, String> separatorsBySubdomain;
    private final String subdomainSeparatorVariable;
    private final boolean fetchFromFollowerRequireLeaderEpochEnabled;

    public MultiTenantRequestContext(RequestHeader header, String connectionId, long requestId, InetAddress clientAddress, Optional<Integer> clientPort, MultiTenantPrincipal principal, ListenerName listenerName, SecurityProtocol securityProtocol, ClientInformation clientInformation, PathAwareSniHostName sniHostName, Time time, Metrics metrics, TenantMetrics tenantMetrics, HotPartitionManager hotPartitionManager, MultiTenantInterceptorConfig config, Optional<ClusterLinkSourceMetrics> clusterLinkSourceMetrics, boolean isPrivilegedListener, Optional<KafkaPrincipalSerde> principalSerde, AuthenticationContext authenticationContext, ProduceConsumeAuditLogTracker produceConsumeAuditLogTracker, boolean isProxyModeLocal) {
        super(header, connectionId, Long.valueOf(requestId), clientAddress, clientPort, (KafkaPrincipal)principal, listenerName, securityProtocol, clientInformation, sniHostName, isPrivilegedListener, principalSerde, authenticationContext, produceConsumeAuditLogTracker, isProxyModeLocal);
        this.tenantContext = new TenantContext(principal);
        this.metrics = metrics;
        this.tenantMetrics = tenantMetrics;
        this.hotPartitionManager = hotPartitionManager;
        this.metricsRequestContext = new TenantMetrics.MetricsRequestContext(principal, header.clientId(), header.apiKey(), config.isFetchFromFollowerEnabled());
        this.time = time;
        this.startNanos = time.nanoseconds();
        this.clusterPrefixForHostnameEnabled = config.isClusterPrefixForHostnameEnabled();
        this.clusterLinkSourceMetrics = clusterLinkSourceMetrics;
        this.schemaValidationEnabled = config.isSchemaValidationEnabled();
        this.multiTenantApis = new MultiTenantApis(config.sbcApisEnabled());
        this.brokerRack = config.brokerRack();
        this.validBrokerRackSet = config.validBrokerRackSet();
        this.shouldAppendSubdomainToHostname = config.shouldAppendSubdomainToHostname();
        this.separatorsBySubdomain = config.subdomainSeparatorMap();
        this.subdomainSeparatorVariable = config.subdomainSeparatorVariable();
        this.fetchFromFollowerRequireLeaderEpochEnabled = config.isFetchFromFollowerRequireLeaderEpochEnabled();
    }

    public Optional<String> tenantPrefix() {
        return Optional.of(this.tenantContext.prefix());
    }

    public RequestAndSize parseRequest(ByteBuffer buffer) {
        long requestTimestampMs = this.time.milliseconds();
        this.updateRequestMetrics(buffer, requestTimestampMs);
        if (this.isUnsupportedApiVersionsRequest()) {
            return super.parseRequest(buffer);
        }
        ApiKeys api = this.header.apiKey();
        short apiVersion = this.header.apiVersion();
        try {
            log.trace("Parsing request of type {} with version {}", (Object)api, (Object)apiVersion);
            if (!this.multiTenantApis.isApiAllowed(this.header.apiKey(), apiVersion)) {
                this.tenantApiException = Errors.CLUSTER_AUTHORIZATION_FAILED.exception();
            }
            RequestAndSize requestAndSize = AbstractRequest.parseRequest((ApiKeys)api, (short)apiVersion, (ByteBuffer)buffer, (MessageContext)this.tenantContext);
            AbstractRequest body = requestAndSize.request;
            try {
                AlterMirrorsRequest alterMirrorsRequest;
                if (body instanceof CreateAclsRequest) {
                    body = this.transformCreateAclsRequest((CreateAclsRequest)body);
                } else if (body instanceof DescribeAclsRequest) {
                    body = this.transformDescribeAclsRequest((DescribeAclsRequest)body);
                } else if (body instanceof DeleteAclsRequest) {
                    body = this.transformDeleteAclsRequest((DeleteAclsRequest)body);
                } else if (body instanceof DescribeConfigsRequest) {
                    body = this.transformDescribeConfigsRequest((DescribeConfigsRequest)body);
                } else if (body instanceof CreateTopicsRequest) {
                    body = this.transformCreateTopicsRequest((CreateTopicsRequest)body, apiVersion);
                } else if (body instanceof CreatePartitionsRequest) {
                    body = this.transformCreatePartitionsRequest((CreatePartitionsRequest)body);
                } else if (body instanceof ProduceRequest) {
                    this.updatePartitionBytesInMetrics((ProduceRequest)body, requestTimestampMs);
                } else if (body instanceof AlterConfigsRequest) {
                    body = this.transformAlterConfigsRequest((AlterConfigsRequest)body, apiVersion);
                } else if (body instanceof IncrementalAlterConfigsRequest) {
                    body = this.transformIncrementalAlterConfigsRequest((IncrementalAlterConfigsRequest)body, apiVersion);
                } else if (body instanceof JoinGroupRequest) {
                    body = this.transformJoinGroupRequest((JoinGroupRequest)body);
                } else if (body instanceof CreateClusterLinksRequest) {
                    body = this.transformCreateClusterLinksRequest((CreateClusterLinksRequest)body, apiVersion);
                } else if (body instanceof FetchRequest) {
                    this.updateFetchFromFollowerTags((FetchRequest)body);
                } else if (body instanceof AlterMirrorsRequest && (alterMirrorsRequest = (AlterMirrorsRequest)body).mirrorOperations().stream().anyMatch(this::alterMirrorOpDisallowed)) {
                    this.tenantApiException = Errors.CLUSTER_AUTHORIZATION_FAILED.exception();
                }
            }
            catch (InvalidRequestException e) {
                this.tenantApiException = e;
            }
            return new RequestAndSize(body, requestAndSize.size);
        }
        catch (ApiException e) {
            this.requestParsingFailed = true;
            throw e;
        }
        catch (Throwable ex) {
            this.requestParsingFailed = true;
            throw new InvalidRequestException("Error getting request for apiKey: " + api + ", apiVersion: " + this.header.apiVersion() + ", connectionId: " + this.connectionId + ", listenerName: " + this.listenerName + ", principal: " + this.principal, ex);
        }
    }

    public boolean shouldIntercept() {
        return this.tenantApiException != null;
    }

    ApiException tenantApiException() {
        return this.tenantApiException;
    }

    public AbstractResponse intercept(AbstractRequest request, int throttleTimeMs) {
        return request.getErrorResponse(throttleTimeMs, (Throwable)this.tenantApiException);
    }

    public RequestContext.ResponseSend buildResponseSend(AbstractResponse body) {
        long responseTimestampMs = this.time.milliseconds();
        if (this.requestParsingFailed) {
            return super.buildResponseSend(body);
        }
        if (this.isUnsupportedApiVersionsRequest()) {
            RequestContext.ResponseSend responseSend = super.buildResponseSend(body);
            if (this.shouldAsyncUpdateResponseMetrics(body)) {
                responseSend.addDelayedAction(() -> this.updateResponseMetrics(body, responseSend.getSend(), responseTimestampMs));
            } else {
                this.updateResponseMetrics(body, responseSend.getSend(), responseTimestampMs);
            }
            return responseSend;
        }
        return this.transformResponseAndBuildSend(body, responseTimestampMs);
    }

    public boolean transformed() {
        return true;
    }

    public AbstractResponse parsedResponse(AbstractResponse response, short version) {
        if (this.apiKey().equals((Object)ApiKeys.FETCH)) {
            return response;
        }
        ObjectSerializationCache cache = new ObjectSerializationCache();
        int messageSize = response.data().size(cache, version, (MessageContext)this.tenantContext);
        ByteBufferAccessor bytes = new ByteBufferAccessor(ByteBuffer.allocate(messageSize));
        response.data().write((Writable)bytes, cache, version, (MessageContext)this.tenantContext);
        bytes.flip();
        ApiKeys apiKey = ApiKeys.forId((int)this.requestType());
        return AbstractResponse.parseResponse((ApiKeys)apiKey, (ByteBuffer)bytes.buffer(), (short)version, (MessageContext)MessageContext.IDENTITY);
    }

    private boolean shouldAsyncUpdateResponseMetrics(AbstractResponse body) {
        return body instanceof FetchResponse || body instanceof ProduceResponse;
    }

    private RequestContext.ResponseSend transformResponseAndBuildSend(AbstractResponse body, long responseTimestampMs) {
        ArrayList<Runnable> delayedActions = new ArrayList<Runnable>();
        AbstractResponse transformedResponse = body;
        if (body instanceof MetadataResponse) {
            transformedResponse = this.transformMetadataResponse((MetadataResponse)body);
        } else if (body instanceof DescribeClusterResponse) {
            transformedResponse = this.transformDescribeClusterResponse((DescribeClusterResponse)body);
        } else if (body instanceof ListGroupsResponse) {
            transformedResponse = this.filteredListGroupsResponse((ListGroupsResponse)body);
        } else if (body instanceof ListClusterLinksResponse) {
            transformedResponse = this.filteredListClusterLinksResponse((ListClusterLinksResponse)body);
        } else if (body instanceof DescribeClusterLinksResponse) {
            transformedResponse = this.filteredDescribeClusterLinksResponse((DescribeClusterLinksResponse)body);
        } else if (body instanceof ListMirrorsResponse) {
            transformedResponse = this.filteredListMirrorsResponse((ListMirrorsResponse)body);
        } else if (body instanceof DescribeConfigsResponse) {
            transformedResponse = this.transformDescribeConfigsResponse((DescribeConfigsResponse)body);
        } else if (body instanceof AlterConfigsResponse) {
            transformedResponse = this.transformAlterConfigsResponse((AlterConfigsResponse)body);
        } else if (body instanceof FetchResponse) {
            delayedActions.add(() -> this.updatePartitionBytesOutMetrics((FetchResponse)body, responseTimestampMs));
            transformedResponse = this.transformFetchResponse((FetchResponse)body);
        } else if (body instanceof IncrementalAlterConfigsResponse) {
            transformedResponse = this.transformIncrementalAlterConfigsResponse((IncrementalAlterConfigsResponse)body);
        } else if (body instanceof DescribeAclsResponse) {
            transformedResponse = this.filteredDescribeAclsResponse((DescribeAclsResponse)body);
        } else if (body instanceof DeleteAclsResponse) {
            transformedResponse = this.transformDeleteAclsResponse((DeleteAclsResponse)body);
        } else if (body instanceof CreateTopicsResponse) {
            transformedResponse = this.filteredCreateTopicsResponse((CreateTopicsResponse)body);
        } else if (body instanceof JoinGroupResponse) {
            transformedResponse = this.transformJoinGroupResponse((JoinGroupResponse)body);
        } else if (body instanceof DescribeGroupsResponse) {
            transformedResponse = this.transformDescribeGroupsResponse((DescribeGroupsResponse)body);
        } else if (body instanceof FindCoordinatorResponse) {
            transformedResponse = this.transformFindCoordinatorResponse((FindCoordinatorResponse)body);
        } else if (body instanceof ApiVersionsResponse) {
            transformedResponse = this.transformApiVersionsResponse((ApiVersionsResponse)body);
        } else if (body instanceof ProduceResponse) {
            transformedResponse = this.transformProduceResponse((ProduceResponse)body);
        }
        Send send = transformedResponse.toSend(this.header.toResponseHeader(), this.apiVersion(), (MessageContext)this.tenantContext);
        if (this.shouldAsyncUpdateResponseMetrics(body)) {
            delayedActions.add(() -> this.updateResponseMetrics(body, send, responseTimestampMs));
        } else {
            this.updateResponseMetrics(body, send, responseTimestampMs);
        }
        return new RequestContext.ResponseSend((RequestContext)this, send, delayedActions);
    }

    private AbstractRequest transformCreateTopicsRequest(CreateTopicsRequest topicsRequest, short version) {
        CreateTopicsRequestData.CreatableTopicCollection topics = topicsRequest.data().topics();
        CreateTopicsRequestData.CreatableTopicCollection updatedTopicSet = new CreateTopicsRequestData.CreatableTopicCollection();
        for (CreateTopicsRequestData.CreatableTopic topicDetails : topics) {
            this.removeFilteredConfigs(topicDetails);
            updatedTopicSet.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setConfigs(topicDetails.configs()).setAssignments(topicDetails.assignments()).setReplicationFactor(topicDetails.replicationFactor()).setNumPartitions(topicDetails.numPartitions()).setName(topicDetails.name()).setLinkName(topicDetails.linkName()).setMirrorTopic(topicDetails.mirrorTopic()));
        }
        this.validateAndTransformCreateTopic(updatedTopicSet);
        return new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTopics(updatedTopicSet).setTimeoutMs(topicsRequest.data().timeoutMs()).setValidateOnly(topicsRequest.data().validateOnly())).build(version);
    }

    private void removeFilteredConfigs(CreateTopicsRequestData.CreatableTopic topicDetails) {
        CreateTopicsRequestData.CreateableTopicConfigCollection filteredConfigs = new CreateTopicsRequestData.CreateableTopicConfigCollection();
        for (CreateTopicsRequestData.CreateableTopicConfig config : topicDetails.configs()) {
            if (!this.allowTopicConfigInRequest(config.name())) continue;
            filteredConfigs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreateableTopicConfig().setValue(config.value()).setName(config.name()));
        }
        topicDetails.setConfigs(filteredConfigs);
    }

    private void validateAndTransformCreateTopic(CreateTopicsRequestData.CreatableTopicCollection topics) {
        for (CreateTopicsRequestData.CreatableTopic topicDetails : topics) {
            if (topicDetails.assignments().isEmpty()) continue;
            if (topicDetails.replicationFactor() != -1 || topicDetails.numPartitions() != -1) {
                throw new InvalidRequestException("The createTopics request had either numPartitions or replicationFactor set with a provided assignment. Those cannot be used when replicasAssignments is set.");
            }
            int partitions = topicDetails.assignments().size();
            short replication = (short)((CreateTopicsRequestData.CreatableReplicaAssignment)topicDetails.assignments().iterator().next()).brokerIds().size();
            topicDetails.setAssignments(new CreateTopicsRequestData.CreatableReplicaAssignmentCollection());
            topicDetails.setNumPartitions(partitions);
            topicDetails.setReplicationFactor(replication);
        }
    }

    private AlterConfigsRequest transformAlterConfigsRequest(AlterConfigsRequest alterConfigsRequest, short version) {
        Map configs = alterConfigsRequest.configs();
        HashMap transformedConfigs = new HashMap(0);
        for (Map.Entry resourceConfigEntry : configs.entrySet()) {
            if (((ConfigResource)resourceConfigEntry.getKey()).type() == ConfigResource.Type.TOPIC) {
                List filteredEntries = ((AlterConfigsRequest.Config)resourceConfigEntry.getValue()).entries().stream().filter(configEntry -> this.allowTopicConfigInRequest(configEntry.name())).collect(Collectors.toList());
                transformedConfigs.put(resourceConfigEntry.getKey(), new AlterConfigsRequest.Config(filteredEntries));
                continue;
            }
            if (((ConfigResource)resourceConfigEntry.getKey()).type() == ConfigResource.Type.BROKER) {
                List transformedEntries = ((AlterConfigsRequest.Config)resourceConfigEntry.getValue()).entries().stream().map(configEntry -> new AlterConfigsRequest.ConfigEntry(this.transformBrokerConfigName(configEntry.name()), configEntry.value())).collect(Collectors.toList());
                transformedConfigs.put(resourceConfigEntry.getKey(), new AlterConfigsRequest.Config(transformedEntries));
                continue;
            }
            transformedConfigs.put(resourceConfigEntry.getKey(), resourceConfigEntry.getValue());
        }
        return new AlterConfigsRequest.Builder(transformedConfigs, alterConfigsRequest.validateOnly()).build(version);
    }

    private IncrementalAlterConfigsRequest transformIncrementalAlterConfigsRequest(IncrementalAlterConfigsRequest incrementalAlterConfigsRequestRequest, short version) {
        Map<ConfigResource, IncrementalAlterConfigsRequestData.AlterableConfigCollection> configs = incrementalAlterConfigsRequestRequest.data().resources().stream().collect(Collectors.toMap(alterConfigsResource -> new ConfigResource(ConfigResource.Type.forId((byte)alterConfigsResource.resourceType()), alterConfigsResource.resourceName()), IncrementalAlterConfigsRequestData.AlterConfigsResource::configs));
        IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection transformedConfigs = new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection();
        block5: for (Map.Entry<ConfigResource, IncrementalAlterConfigsRequestData.AlterableConfigCollection> resourceConfigEntry : configs.entrySet()) {
            ConfigResource resource = resourceConfigEntry.getKey();
            switch (resource.type()) {
                case TOPIC: {
                    IncrementalAlterConfigsRequestData.AlterableConfigCollection filteredConfigs = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
                    for (IncrementalAlterConfigsRequestData.AlterableConfig configEntry : resourceConfigEntry.getValue().valuesSet()) {
                        if (!this.allowTopicConfigInRequest(configEntry.name())) continue;
                        filteredConfigs.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterableConfig().setConfigOperation(configEntry.configOperation()).setName(configEntry.name()).setValue(configEntry.value()));
                    }
                    transformedConfigs.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceType(resource.type().id()).setResourceName(resource.name()).setConfigs(filteredConfigs));
                    continue block5;
                }
                case BROKER: {
                    IncrementalAlterConfigsRequestData.AlterableConfigCollection transformedConfigEntries = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
                    for (IncrementalAlterConfigsRequestData.AlterableConfig configEntry : resourceConfigEntry.getValue().valuesSet()) {
                        transformedConfigEntries.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterableConfig().setConfigOperation(configEntry.configOperation()).setName(this.transformBrokerConfigName(configEntry.name())).setValue(configEntry.value()));
                    }
                    transformedConfigs.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceType(resource.type().id()).setResourceName(resource.name()).setConfigs(transformedConfigEntries));
                    continue block5;
                }
                case CLUSTER_LINK: {
                    IncrementalAlterConfigsRequestData.AlterableConfigCollection filteredConfigs = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
                    for (IncrementalAlterConfigsRequestData.AlterableConfig configEntry : resourceConfigEntry.getValue().valuesSet()) {
                        if (MultiTenantConfigRestrictions.UPDATABLE_CLUSTER_LINK_INTERNAL_CONFIGS.contains(configEntry.name())) continue;
                        filteredConfigs.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterableConfig().setConfigOperation(configEntry.configOperation()).setName(configEntry.name()).setValue(configEntry.value()));
                    }
                    transformedConfigs.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceType(resource.type().id()).setResourceName(resource.name()).setConfigs(filteredConfigs));
                    continue block5;
                }
            }
            transformedConfigs.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceType(resource.type().id()).setResourceName(resource.name()).setConfigs(resourceConfigEntry.getValue()));
        }
        return new IncrementalAlterConfigsRequest.Builder(new IncrementalAlterConfigsRequestData().setResources(transformedConfigs).setValidateOnly(incrementalAlterConfigsRequestRequest.data().validateOnly())).build(version);
    }

    private boolean allowTopicConfigInRequest(String key) {
        if (MultiTenantConfigRestrictions.updatableTopicConfig(key, this.schemaValidationEnabled)) {
            log.trace("Allowing config {} in the request because it is updateable", (Object)key);
            return true;
        }
        log.info("Altering config property {} is disallowed, ignoring config.", (Object)key);
        return false;
    }

    private String transformBrokerConfigName(String configName) {
        return MultiTenantConfigRestrictions.prependExternalListenerToConfigName(configName).orElse(configName);
    }

    private AbstractRequest transformCreatePartitionsRequest(CreatePartitionsRequest partitionsRequest) {
        for (CreatePartitionsRequestData.CreatePartitionsTopic topic : partitionsRequest.data().topics()) {
            if (topic.assignments() == null || topic.assignments().isEmpty()) continue;
            log.debug("Clearing replica assignments for {} provided in CreatePartitionsRequest", (Object)topic.name());
            topic.setAssignments(Collections.emptyList());
        }
        return partitionsRequest;
    }

    private JoinGroupRequest transformJoinGroupRequest(JoinGroupRequest joinGroupRequest) {
        if (joinGroupRequest.data().protocolType().equals("consumer")) {
            this.isJoinConsumerGroup = true;
            JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = joinGroupRequest.data().protocols();
            for (JoinGroupRequestData.JoinGroupRequestProtocol protocol : protocols) {
                protocol.setMetadata(this.transformSubscription(protocol.metadata(), true));
            }
        }
        return joinGroupRequest;
    }

    private JoinGroupResponse transformJoinGroupResponse(JoinGroupResponse response) {
        if (this.isJoinConsumerGroup && response.isLeader()) {
            for (JoinGroupResponseData.JoinGroupResponseMember member : response.data().members()) {
                member.setMetadata(this.transformSubscription(member.metadata(), false));
            }
        }
        return response;
    }

    private DescribeGroupsResponse transformDescribeGroupsResponse(DescribeGroupsResponse response) {
        for (DescribeGroupsResponseData.DescribedGroup group : response.data().groups()) {
            if (!group.protocolType().equals("consumer")) continue;
            for (DescribeGroupsResponseData.DescribedGroupMember member : group.members()) {
                member.setMemberMetadata(this.transformSubscription(member.memberMetadata(), false));
            }
        }
        return response;
    }

    private FindCoordinatorResponse transformFindCoordinatorResponse(FindCoordinatorResponse response) {
        if (this.clusterPrefixForHostnameEnabled) {
            if (this.apiVersion() < 4) {
                response.data().setHost(this.transformHostname(response.data().host()));
            } else {
                response.data().coordinators().forEach(b -> b.setHost(this.transformHostname(b.host())));
            }
        }
        return response;
    }

    private ApiVersionsResponse transformApiVersionsResponse(ApiVersionsResponse response) {
        ApiVersionsResponseData.ApiVersionCollection keys = response.data().apiKeys();
        ApiVersionsResponseData.ApiVersionCollection newApiKeys = new ApiVersionsResponseData.ApiVersionCollection();
        keys.stream().filter(key -> key.apiKey() != ApiKeys.DESCRIBE_TOPIC_PARTITIONS.id).forEach(key -> newApiKeys.add((ImplicitLinkedHashCollection.Element)key.duplicate()));
        response.data().setApiKeys(newApiKeys);
        return response;
    }

    private byte[] transformSubscription(byte[] metadata, boolean addPrefix) {
        if (metadata.length == 0) {
            return metadata;
        }
        ByteBuffer buffer = ByteBuffer.wrap(metadata);
        short ver = ConsumerProtocol.deserializeVersion((ByteBuffer)buffer);
        Struct struct = ConsumerProtocolSubscription.SCHEMA_0.read(buffer);
        Object[] topics = struct.getArray("topics");
        int bytesDelta = 0;
        for (int i = 0; i < topics.length; ++i) {
            String topic = (String)topics[i];
            if (addPrefix) {
                topics[i] = this.tenantContext.addTenantPrefix(topic);
                bytesDelta += this.tenantContext.prefixSizeInBytes();
                continue;
            }
            if (!this.tenantContext.hasTenantPrefix(topic)) continue;
            topics[i] = this.tenantContext.removeTenantPrefix((String)topics[i]);
            bytesDelta -= this.tenantContext.prefixSizeInBytes();
        }
        struct.set("topics", (Object)topics);
        ByteBuffer newBuffer = ByteBuffer.allocate(buffer.capacity() + bytesDelta);
        ConsumerProtocol.CONSUMER_PROTOCOL_HEADER_SCHEMA.write(newBuffer, (Object)new Struct(ConsumerProtocol.CONSUMER_PROTOCOL_HEADER_SCHEMA).set("version", (Object)ver));
        ConsumerProtocolSubscription.SCHEMA_0.write(newBuffer, (Object)struct);
        newBuffer.put(buffer);
        newBuffer.flip();
        return newBuffer.array();
    }

    private MetadataResponse transformMetadataResponse(MetadataResponse response) {
        response.data().topics().removeIf(topic -> !this.tenantContext.hasTenantPrefix(topic.name()));
        if (this.clusterPrefixForHostnameEnabled) {
            response.data().brokers().forEach(b -> b.setHost(this.transformHostname(b.host())));
        }
        return response;
    }

    private DescribeClusterResponse transformDescribeClusterResponse(DescribeClusterResponse response) {
        if (this.clusterPrefixForHostnameEnabled) {
            response.data().brokers().forEach(b -> b.setHost(this.transformHostname(b.host())));
        }
        return response;
    }

    private ProduceResponse transformProduceResponse(ProduceResponse response) {
        if (this.clusterPrefixForHostnameEnabled) {
            response.data().nodeEndpoints().forEach(b -> b.setHost(this.transformHostname(b.host())));
        }
        return response;
    }

    private FetchResponse transformFetchResponse(FetchResponse response) {
        if (this.clusterPrefixForHostnameEnabled) {
            response.data().nodeEndpoints().forEach(b -> b.setHost(this.transformHostname(b.host())));
        }
        return response;
    }

    private String transformHostname(String hostName) {
        String transformedHostName = hostName;
        if (this.sniHostName != null) {
            if (this.shouldAppendSubdomainToHostname) {
                transformedHostName = this.replaceSeparator(transformedHostName);
            }
            if (this.sniHostName.apeId() != null) {
                transformedHostName = transformedHostName.concat(this.sniHostName.apeId()).concat(".");
            }
            if (this.shouldAppendSubdomainToHostname && this.sniHostName.subdomain() != null && !transformedHostName.endsWith(this.sniHostName.subdomain())) {
                transformedHostName = transformedHostName.concat(this.sniHostName.subdomain());
            }
        }
        if (transformedHostName.startsWith("-")) {
            return this.tenantContext.principal.tenantMetadata().clusterId.concat(transformedHostName);
        }
        return transformedHostName;
    }

    private String replaceSeparator(String hostname) {
        String separator = this.separatorsBySubdomain.getOrDefault(this.sniHostName.subdomain(), this.separatorsBySubdomain.get("default"));
        if (separator != null) {
            hostname = hostname.replace(this.subdomainSeparatorVariable, separator);
        }
        return hostname;
    }

    private ListGroupsResponse filteredListGroupsResponse(ListGroupsResponse response) {
        ArrayList<ListGroupsResponseData.ListedGroup> filteredGroups = new ArrayList<ListGroupsResponseData.ListedGroup>();
        for (ListGroupsResponseData.ListedGroup group : response.data().groups()) {
            if (!this.tenantContext.hasTenantPrefix(group.groupId())) continue;
            filteredGroups.add(group);
        }
        ListGroupsResponseData data = new ListGroupsResponseData();
        data.setThrottleTimeMs(response.throttleTimeMs());
        data.setErrorCode(response.data().errorCode());
        data.setGroups(filteredGroups);
        return new ListGroupsResponse(data);
    }

    private ListClusterLinksResponse filteredListClusterLinksResponse(ListClusterLinksResponse response) {
        response.data().entries().removeIf(link -> !this.tenantContext.hasTenantPrefix(link.linkName()));
        return response;
    }

    private DescribeClusterLinksResponse filteredDescribeClusterLinksResponse(DescribeClusterLinksResponse response) {
        response.data().entries().removeIf(link -> !this.tenantContext.hasTenantPrefix(link.linkName()));
        if (this.clusterPrefixForHostnameEnabled && this.apiVersion() >= 1) {
            response.data().entries().forEach(b -> b.setLinkCoordinatorHost(this.transformHostname(b.linkCoordinatorHost())));
        }
        return response;
    }

    private ListMirrorsResponse filteredListMirrorsResponse(ListMirrorsResponse response) {
        response.data().topics().removeIf(topic -> !this.tenantContext.hasTenantPrefix((String)topic));
        return response;
    }

    private DescribeConfigsResponse transformDescribeConfigsResponse(DescribeConfigsResponse response) {
        List configsResults = response.data().results();
        ArrayList<DescribeConfigsResponseData.DescribeConfigsResult> results = new ArrayList<DescribeConfigsResponseData.DescribeConfigsResult>(configsResults.size());
        for (DescribeConfigsResponseData.DescribeConfigsResult configResult : configsResults) {
            ConfigResource.Type resourceType = ConfigResource.Type.forId((byte)configResult.resourceType());
            List configsResourceResults = configResult.configs();
            List filteredResults = configsResourceResults.stream().filter(crr -> {
                switch (resourceType) {
                    case BROKER: {
                        return MultiTenantConfigRestrictions.VISIBLE_BROKER_CONFIGS.contains(crr.name());
                    }
                    case TOPIC: {
                        return MultiTenantConfigRestrictions.visibleTopicConfig(crr.name(), this.schemaValidationEnabled);
                    }
                    case CLUSTER_LINK: {
                        return MultiTenantConfigRestrictions.VISIBLE_CLUSTER_LINK_CONFIGS.contains(crr.name());
                    }
                }
                return false;
            }).map(crr -> {
                switch (resourceType) {
                    case TOPIC: {
                        return MultiTenantConfigRestrictions.updatableTopicConfig(crr.name(), this.schemaValidationEnabled) ? crr : this.newDescribeConfigsResponseConfigEntry((DescribeConfigsResponseData.DescribeConfigsResourceResult)crr, crr.name(), true);
                    }
                    case BROKER: {
                        return MultiTenantConfigRestrictions.stripExternalListenerPrefixFromConfigName(crr.name()).map(configName -> this.newDescribeConfigsResponseConfigEntry((DescribeConfigsResponseData.DescribeConfigsResourceResult)crr, (String)configName, crr.readOnly())).orElse((DescribeConfigsResponseData.DescribeConfigsResourceResult)crr);
                    }
                    case CLUSTER_LINK: {
                        return MultiTenantConfigRestrictions.UPDATABLE_CLUSTER_LINK_CONFIGS.contains(crr.name()) ? crr : this.newDescribeConfigsResponseConfigEntry((DescribeConfigsResponseData.DescribeConfigsResourceResult)crr, crr.name(), true);
                    }
                }
                return crr;
            }).collect(Collectors.toList());
            results.add(configResult.duplicate().setConfigs(filteredResults));
        }
        DescribeConfigsResponseData data = new DescribeConfigsResponseData();
        data.setThrottleTimeMs(response.data().throttleTimeMs());
        data.setResults(results);
        return new DescribeConfigsResponse(data);
    }

    private DescribeConfigsResponseData.DescribeConfigsResourceResult newDescribeConfigsResponseConfigEntry(DescribeConfigsResponseData.DescribeConfigsResourceResult crr, String configName, boolean readOnly) {
        return crr.duplicate().setName(configName).setReadOnly(readOnly);
    }

    private AlterConfigsResponse transformAlterConfigsResponse(AlterConfigsResponse alterConfigsResponse) {
        alterConfigsResponse.data().responses().forEach(response -> {
            if (response.resourceType() == ConfigResource.Type.BROKER.id()) {
                response.setErrorMessage(this.transformAlterConfigsResponseErrorMessage(response.errorMessage()));
            }
        });
        return alterConfigsResponse;
    }

    private String transformAlterConfigsResponseErrorMessage(String errorMessage) {
        return errorMessage == null ? null : errorMessage.replace(MultiTenantConfigRestrictions.EXTERNAL_LISTENER_PREFIX, "");
    }

    private IncrementalAlterConfigsResponse transformIncrementalAlterConfigsResponse(IncrementalAlterConfigsResponse alterConfigsResponse) {
        alterConfigsResponse.data().responses().forEach(response -> {
            if (response.resourceType() == ConfigResource.Type.BROKER.id()) {
                response.setErrorMessage(this.transformAlterConfigsResponseErrorMessage(response.errorMessage()));
            }
        });
        return alterConfigsResponse;
    }

    private DescribeAclsResponse filteredDescribeAclsResponse(DescribeAclsResponse response) {
        DescribeAclsResponseData responseData = response.data().duplicate().setResources(response.acls().stream().filter(this::isTenantPrefixedAclsResource).map(this::transformAclsResource).collect(Collectors.toList()));
        return new DescribeAclsResponse(responseData, this.header.apiVersion());
    }

    private DescribeAclsResponseData.DescribeAclsResource transformAclsResource(DescribeAclsResponseData.DescribeAclsResource binding) {
        if (binding.resourceName().equals(this.tenantContext.prefix)) {
            return new DescribeAclsResponseData.DescribeAclsResource().setResourceType(binding.resourceType()).setResourceName(this.tenantContext.prefix + "*").setPatternType(PatternType.LITERAL.code()).setAcls(binding.acls());
        }
        return new DescribeAclsResponseData.DescribeAclsResource().setResourceType(binding.resourceType()).setResourceName(binding.resourceName()).setPatternType(binding.patternType()).setAcls(binding.acls());
    }

    private boolean isTenantPrefixedAclsResource(DescribeAclsResponseData.DescribeAclsResource binding) {
        ResourcePattern pattern = new ResourcePattern(ResourceType.fromCode((byte)binding.resourceType()), binding.resourceName(), PatternType.fromCode((byte)binding.patternType()));
        if (this.describeAclsPatternType == PatternType.LITERAL && pattern.patternType() != PatternType.LITERAL && !pattern.name().equals(this.tenantContext.prefix())) {
            return false;
        }
        if (this.describeAclsPatternType == PatternType.PREFIXED && pattern.patternType() == PatternType.PREFIXED && pattern.name().equals(this.tenantContext.prefix())) {
            return false;
        }
        return pattern.name().startsWith(this.tenantContext.prefix());
    }

    private DeleteAclsResponse transformDeleteAclsResponse(DeleteAclsResponse response) {
        String tenantPrefix = this.tenantContext.prefix();
        response.filterResults().forEach(fr -> fr.matchingAcls().forEach(acl -> {
            if (acl.resourceName().equals(tenantPrefix)) {
                acl.setResourceName(tenantPrefix + "*");
                acl.setPatternType(PatternType.LITERAL.code());
            }
        }));
        return response;
    }

    private CreateTopicsResponse filteredCreateTopicsResponse(CreateTopicsResponse response) {
        CreateTopicsResponseData responseData = response.data();
        CreateTopicsResponseData.CreatableTopicResultCollection topics = new CreateTopicsResponseData.CreatableTopicResultCollection(responseData.topics().size());
        for (CreateTopicsResponseData.CreatableTopicResult result : responseData.topics()) {
            List filteredConfigs = result.configs().stream().filter(c -> MultiTenantConfigRestrictions.visibleTopicConfig(c.configName(), this.schemaValidationEnabled)).collect(Collectors.toList());
            CreateTopicsResponseData.CreatableTopicResult topic = result.duplicate().setConfigs(filteredConfigs);
            topics.add((ImplicitLinkedHashCollection.Element)topic);
        }
        CreateTopicsResponseData data = new CreateTopicsResponseData().setThrottleTimeMs(responseData.throttleTimeMs()).setTopics(topics);
        return new CreateTopicsResponse(data);
    }

    private boolean isUnsupportedApiVersionsRequest() {
        return this.header.apiKey() == ApiKeys.API_VERSIONS && !ApiKeys.API_VERSIONS.isVersionSupported(this.header.apiVersion());
    }

    private short minAclsRequestVersion(AbstractRequest request) {
        return request.version() >= 1 ? request.version() : (short)1;
    }

    private AbstractRequest transformCreateAclsRequest(CreateAclsRequest request) {
        String prefixedWildcard = this.tenantContext.prefixedWildcard();
        request.aclCreations().forEach(creation -> {
            this.ensureResourceNameNonEmpty(creation.resourceName());
            MultiTenantRequestContext.ensureSupportedResourceType(ResourceType.fromCode((byte)creation.resourceType()));
            PatternType patternType = PatternType.fromCode((byte)creation.resourcePatternType());
            MultiTenantRequestContext.ensureValidRequestPatternType(patternType);
            this.ensureValidPrincipal(creation.principal());
            if (patternType == PatternType.LITERAL && prefixedWildcard.equals(creation.resourceName())) {
                creation.setResourceName(this.tenantContext.prefix());
                creation.setResourcePatternType(PatternType.PREFIXED.code());
            }
        });
        return request;
    }

    private AbstractRequest transformDescribeConfigsRequest(DescribeConfigsRequest request) {
        List resources = request.data().resources();
        ArrayList<DescribeConfigsRequestData.DescribeConfigsResource> transformedResources = new ArrayList<DescribeConfigsRequestData.DescribeConfigsResource>(resources.size());
        for (DescribeConfigsRequestData.DescribeConfigsResource resource : resources) {
            DescribeConfigsRequestData.DescribeConfigsResource transformedResource;
            List configKeys = resource.configurationKeys();
            ConfigResource.Type configResourceType = ConfigResource.Type.forId((byte)resource.resourceType());
            if (configKeys != null && configResourceType == ConfigResource.Type.BROKER) {
                List transformedConfigKeys = configKeys.stream().map(this::transformBrokerConfigName).collect(Collectors.toList());
                transformedResource = resource.duplicate().setConfigurationKeys(transformedConfigKeys);
            } else {
                transformedResource = resource;
            }
            transformedResources.add(transformedResource);
        }
        return new DescribeConfigsRequest.Builder(request.data().duplicate().setResources(transformedResources)).build(request.version());
    }

    private AbstractRequest transformDescribeAclsRequest(DescribeAclsRequest request) {
        this.describeAclsPatternType = request.filter().patternFilter().patternType();
        AclBindingFilter transformedFilter = this.transformAclFilter(request.filter());
        this.ensureValidPrincipal(request.filter().entryFilter().principal());
        return new DescribeAclsRequest.Builder(transformedFilter).setAclState(request.aclState()).build(this.minAclsRequestVersion((AbstractRequest)request));
    }

    private AbstractRequest transformDeleteAclsRequest(DeleteAclsRequest request) {
        List transformedFilters = request.filters().stream().map(this::transformAclFilter).collect(Collectors.toList());
        request.filters().forEach(filter -> this.ensureValidPrincipal(filter.entryFilter().principal()));
        return new DeleteAclsRequest.Builder(new DeleteAclsRequestData().setFilters(transformedFilters.stream().map(DeleteAclsRequest::deleteAclsFilter).collect(Collectors.toList())).setAclState(request.data().aclState())).build(this.minAclsRequestVersion((AbstractRequest)request));
    }

    private CreateClusterLinksRequest transformCreateClusterLinksRequest(CreateClusterLinksRequest request, short version) {
        List entries = request.data().entries();
        ArrayList<CreateClusterLinksRequestData.EntryData> newEntries = new ArrayList<CreateClusterLinksRequestData.EntryData>(entries.size());
        for (CreateClusterLinksRequestData.EntryData e : entries) {
            List configs = e.configs();
            ArrayList<CreateClusterLinksRequestData.ConfigData> filteredConfigs = new ArrayList<CreateClusterLinksRequestData.ConfigData>(configs.size());
            for (CreateClusterLinksRequestData.ConfigData c : configs) {
                if (!MultiTenantConfigRestrictions.UPDATABLE_CLUSTER_LINK_CONFIGS.contains(c.key())) continue;
                filteredConfigs.add(new CreateClusterLinksRequestData.ConfigData().setKey(c.key()).setValue(c.value()));
            }
            newEntries.add(new CreateClusterLinksRequestData.EntryData().setLinkName(e.linkName()).setLinkId(e.linkId()).setClusterId(e.clusterId()).setConfigs(filteredConfigs));
        }
        return new CreateClusterLinksRequest.Builder(new CreateClusterLinksRequestData().setEntries(newEntries).setValidateOnly(request.validateOnly()).setValidateLink(request.validateLink()).setTimeoutMs(request.timeoutMs())).build(version);
    }

    private void ensureResourceNameNonEmpty(String name) {
        if (this.tenantContext.prefix().equals(name)) {
            throw new InvalidRequestException("Invalid empty resource name specified");
        }
    }

    private static void ensureResourceNameNonEmpty(String tenantPrefix, String name) {
        if (tenantPrefix.equals(name)) {
            throw new InvalidRequestException("Invalid empty resource name specified");
        }
    }

    private static void ensureSupportedResourceType(ResourceType resourceType) {
        if (resourceType != ResourceType.TOPIC && resourceType != ResourceType.GROUP && resourceType != ResourceType.CLUSTER && resourceType != ResourceType.TRANSACTIONAL_ID && resourceType != ResourceType.ANY) {
            throw new InvalidRequestException("Unsupported resource type specified: " + resourceType);
        }
    }

    private static void ensureValidRequestPatternType(PatternType patternType) {
        if (patternType.isTenantPrefixed()) {
            throw new InvalidRequestException("Unsupported pattern type specified: " + patternType);
        }
    }

    private void ensureValidPrincipal(String principal) {
        try {
            if (principal != null) {
                SecurityUtils.parseKafkaPrincipal((String)principal);
            }
        }
        catch (IllegalArgumentException e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }

    private AclBindingFilter transformAclFilter(AclBindingFilter aclFilter) {
        return MultiTenantRequestContext.transformAclFilter(this.tenantContext.prefix(), this.tenantContext.addTenantPrefix("*"), aclFilter);
    }

    public static AclBindingFilter transformAclFilter(String tenantPrefix, String prefixedWildcard, AclBindingFilter aclFilter) {
        ResourcePatternFilter pattern = aclFilter.patternFilter();
        String resourceName = pattern.name();
        PatternType patternType = pattern.patternType();
        MultiTenantRequestContext.ensureValidRequestPatternType(patternType);
        MultiTenantRequestContext.ensureResourceNameNonEmpty(tenantPrefix, resourceName);
        MultiTenantRequestContext.ensureSupportedResourceType(pattern.resourceType());
        if (prefixedWildcard.equals(resourceName) && patternType != PatternType.PREFIXED) {
            resourceName = tenantPrefix;
            patternType = PatternType.PREFIXED;
        }
        if (resourceName == null) {
            switch (patternType) {
                case LITERAL: {
                    patternType = PatternType.CONFLUENT_ALL_TENANT_LITERAL;
                    break;
                }
                case PREFIXED: {
                    patternType = PatternType.CONFLUENT_ALL_TENANT_PREFIXED;
                    break;
                }
                case ANY: 
                case MATCH: {
                    patternType = PatternType.CONFLUENT_ALL_TENANT_ANY;
                    break;
                }
            }
            resourceName = tenantPrefix;
        } else if (patternType == PatternType.MATCH) {
            patternType = PatternType.CONFLUENT_ONLY_TENANT_MATCH;
        }
        ResourcePatternFilter transformedPattern = new ResourcePatternFilter(pattern.resourceType(), resourceName, patternType);
        return new AclBindingFilter(transformedPattern, aclFilter.entryFilter());
    }

    private void updateRequestMetrics(ByteBuffer buffer, long currentTimeMs) {
        int requestSize = ApiSensors.calculateRequestSize((RequestHeader)this.header, (ByteBuffer)buffer);
        if (this.clusterLinkSourceMetrics.isPresent()) {
            this.clusterLinkSourceMetrics.get().recordRequest(this.header.apiKey(), (long)requestSize, currentTimeMs);
        } else {
            this.tenantMetrics.recordRequest(this.metrics, this.metricsRequestContext, requestSize, currentTimeMs);
        }
    }

    private void updateResponseMetrics(AbstractResponse body, Send response, long currentTimeMs) {
        long responseTimeNs = this.time.nanoseconds() - this.startNanos;
        if (this.clusterLinkSourceMetrics.isPresent()) {
            this.clusterLinkSourceMetrics.get().recordResponse(this.header.apiKey(), response.size(), responseTimeNs, body.errorCounts(), currentTimeMs);
        } else {
            if (log.isTraceEnabled()) {
                String zoneAlignment = this.metricsRequestContext.metricTags().get("zone-alignment");
                String isSupportedFFFClient = this.metricsRequestContext.metricTags().get("is-supported-fff-client");
                if (body instanceof FetchResponse && zoneAlignment != null && zoneAlignment.equals(ZoneAlignment.CROSS_ZONE.toString())) {
                    FetchResponse fetchResponse = (FetchResponse)body;
                    log.trace("Zone alignment is CROSS_ZONE for header: {}, response: {}, Fetch from follower client support status: {}", new Object[]{this.header, fetchResponse, isSupportedFFFClient});
                }
            }
            this.tenantMetrics.recordResponse(this.metrics, this.metricsRequestContext, response.size(), responseTimeNs, body.errorCounts(), currentTimeMs);
        }
    }

    private void updatePartitionBytesInMetrics(ProduceRequest request, long currentTimeMs) {
        request.data().topicData().forEach(topicData -> topicData.partitionData().forEach(partitionData -> {
            TopicPartition tp = new TopicPartition(topicData.name(), partitionData.index());
            BaseRecords records = partitionData.records();
            this.tenantMetrics.recordPartitionStatsIn(this.metrics, this.metricsRequestContext, tp, records.sizeInBytes(), MultiTenantRequestContext.numRecords(records), currentTimeMs);
            this.hotPartitionManager.mayRecordHotPartitionIn(this.metrics, this.metricsRequestContext, tp, currentTimeMs);
        }));
    }

    private void updatePartitionBytesOutMetrics(FetchResponse response, long currentTimeMs) {
        response.data().responses().forEach(topicResponse -> topicResponse.partitions().forEach(partition -> {
            TopicPartition tp = new TopicPartition(topicResponse.topic(), partition.partitionIndex());
            int size = partition.records() == null ? 0 : partition.records().sizeInBytes();
            this.tenantMetrics.recordPartitionStatsOut(this.metrics, this.metricsRequestContext, tp, size, MultiTenantRequestContext.numRecords(partition.records()), currentTimeMs);
            this.hotPartitionManager.mayRecordHotPartitionOut(this.metrics, this.metricsRequestContext, tp, currentTimeMs);
        }));
    }

    private void updateFetchFromFollowerTags(FetchRequest request) {
        if (this.metricsRequestContext.isFetchFromFollowerEnabled()) {
            ZoneAlignment zoneAlignment = ZoneUtils.validateZoneAlignment(this.validBrokerRackSet, (String)this.brokerRack, (String)request.rackId());
            boolean isSupportedFFFClient = MultiTenantRequestContext.isSupportedFFFClient(request, this.fetchFromFollowerRequireLeaderEpochEnabled);
            this.tenantMetrics.setFetchFromFollowerTags(this.metrics, this.metricsRequestContext, ApiKeys.FETCH, zoneAlignment, isSupportedFFFClient);
        }
    }

    public static boolean isSupportedFFFClient(FetchRequest request, boolean fetchFromFollowerRequireLeaderEpochEnabled) {
        if (!FetchRequest.isConsumer((int)request.replicaId()) || !FetchRequest.isFFFClient((short)request.version())) {
            return false;
        }
        boolean partitionWithoutleaderEpochIsPresent = false;
        block0: for (FetchRequestData.FetchTopic fetchTopic : request.data().topics()) {
            for (FetchRequestData.FetchPartition fetchPartition : fetchTopic.partitions()) {
                if (RequestUtils.getLeaderEpoch((int)fetchPartition.currentLeaderEpoch()).isPresent()) continue;
                partitionWithoutleaderEpochIsPresent = true;
                continue block0;
            }
        }
        return !fetchFromFollowerRequireLeaderEpochEnabled || !partitionWithoutleaderEpochIsPresent;
    }

    private static int numRecords(BaseRecords records) {
        if (records instanceof Records) {
            return MultiTenantRequestContext.numRecords(((Records)records).batches());
        }
        return 0;
    }

    private static int numRecords(Iterable<? extends RecordBatch> batches) {
        return StreamSupport.stream(batches.spliterator(), false).mapToInt(b -> {
            Integer count = b.countOrNull();
            return count != null ? count : 0;
        }).sum();
    }

    public TenantMetrics.MetricsRequestContext metricsRequestContext() {
        return this.metricsRequestContext;
    }

    private boolean alterMirrorOpDisallowed(AlterMirrorsRequestData.MirrorOperation op) {
        AlterMirrorOp alterMirrorOp = AlterMirrorOp.forId((byte)op.operationCode());
        if (alterMirrorOp == null) {
            return true;
        }
        return DISALLOWED_ALTER_MIRROR_OPS.contains(alterMirrorOp) || alterMirrorOp.isInternal();
    }
}

