/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.protobuf.cloud.events.v1.EventsMetadata;
import java.util.Objects;

public class EventsMetadataHeader {
    private final long sequenceId;
    private final String appName;

    @JsonCreator
    public EventsMetadataHeader(@JsonProperty(value="sequence_id") long sequenceId, @JsonProperty(value="app_name") String appName) {
        this.sequenceId = sequenceId;
        this.appName = appName;
    }

    public static EventsMetadataHeader fromProtobuf(EventsMetadata eventsMetadata) {
        return new EventsMetadataHeader(eventsMetadata.getSequenceId(), eventsMetadata.getAppName());
    }

    @JsonProperty
    public long sequenceId() {
        return this.sequenceId;
    }

    @JsonProperty
    public String appName() {
        return this.appName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventsMetadataHeader that = (EventsMetadataHeader)o;
        return this.sequenceId == that.sequenceId && Objects.equals(this.appName, that.appName);
    }

    public int hashCode() {
        return Objects.hash(this.sequenceId, this.appName);
    }

    public String toString() {
        return "EventsMetadataHeader(sequenceId=" + this.sequenceId + ", appName=" + this.appName + ')';
    }
}

