/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.server.plugins.auth.DefaultDataPolicyContext;
import io.confluent.kafka.server.plugins.auth.DefaultDataPolicyValidationMode;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.kafka.server.multitenant.LogicalClusterMetadata;

public class DefaultDataPolicyAuthenticator {
    private final DefaultDataPolicyValidationMode defaultDataPolicyValidationMode;
    private final boolean defaultDataPolicyEnabled;
    private final Optional<LogicalClusterMetadata> lkcMetadata;
    private final Consumer<String> errorHandler;

    public DefaultDataPolicyAuthenticator(DefaultDataPolicyValidationMode validationMode, boolean defaultDataPolicyEnabled, LogicalClusterMetadata lkcMetadata, Consumer<String> errorHandler) {
        this.defaultDataPolicyValidationMode = validationMode;
        this.defaultDataPolicyEnabled = defaultDataPolicyEnabled;
        this.lkcMetadata = Optional.ofNullable(lkcMetadata);
        this.errorHandler = errorHandler;
    }

    public boolean authenticate(DefaultDataPolicyContext policyContext) {
        if (this.defaultDataPolicyValidationMode.trafficAllowed(this.defaultDataPolicyEnabled, this.lkcMetadata.map(lkc -> lkc.environmentId()), policyContext)) {
            return true;
        }
        String networkTypeStr = policyContext.networkType.isPresent() ? policyContext.networkType.get().name() : "<not-provided>";
        String errorMessage = String.format("EnvironmentId: %s, NetworkType: %s, HasPeerCertificate: %s isn't allowed to communicate to the cluster ID %s", policyContext.environmentId.orElse("<not-provided>"), networkTypeStr, policyContext.hasSslPeerCertificate.orElse(false), this.lkcMetadata.map(lkc -> lkc.logicalClusterId()).orElse(""));
        this.errorHandler.accept(errorMessage);
        return false;
    }
}

