/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import java.util.Optional;
import org.apache.kafka.common.security.authenticator.SaslInternalConfigs;

public class DefaultDataPolicyContext {
    public final Optional<String> environmentId;
    public final Optional<SaslInternalConfigs.NetworkType> networkType;
    public final Optional<Boolean> hasSslPeerCertificate;

    private DefaultDataPolicyContext(Builder builder) {
        this.environmentId = builder.environmentId;
        this.networkType = builder.networkType;
        this.hasSslPeerCertificate = builder.hasSslPeerCertificate;
    }

    public static class Builder {
        private Optional<String> environmentId = Optional.empty();
        private Optional<SaslInternalConfigs.NetworkType> networkType = Optional.empty();
        private Optional<Boolean> hasSslPeerCertificate = Optional.empty();

        public Builder() {
        }

        public Builder(String environmentId, SaslInternalConfigs.NetworkType networkType, Boolean hasSslPeerCertificate) {
            this.environmentId = Optional.ofNullable(environmentId);
            this.networkType = Optional.ofNullable(networkType);
            this.hasSslPeerCertificate = Optional.ofNullable(hasSslPeerCertificate);
        }

        public Builder(Optional<String> environmentId, Optional<SaslInternalConfigs.NetworkType> networkType, Optional<Boolean> hasSslPeerCertificate) {
            this.environmentId = environmentId;
            this.networkType = networkType;
            this.hasSslPeerCertificate = hasSslPeerCertificate;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = Optional.ofNullable(environmentId);
            return this;
        }

        public Builder networkType(SaslInternalConfigs.NetworkType networkType) {
            this.networkType = Optional.ofNullable(networkType);
            return this;
        }

        public Builder hasSslPeerCertificate(Boolean hasSslPeerCertificate) {
            this.hasSslPeerCertificate = Optional.ofNullable(hasSslPeerCertificate);
            return this;
        }

        public DefaultDataPolicyContext build() {
            return new DefaultDataPolicyContext(this);
        }
    }
}

