/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.multitenant.metrics.ApiKeyConnectionSensorBuilder;
import io.confluent.kafka.multitenant.utils.AuthUtils;
import io.confluent.kafka.server.plugins.auth.BaseMultiTenantSaslSecretsStore;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslConfigEntry;
import io.confluent.kafka.server.plugins.auth.PlainSaslAuthenticator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kafka.server.BrokerSession;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.PublicCredential;
import org.apache.kafka.connect.util.KafkaBasedLog;

public class MultiTenantSaslSecretsStore
extends BaseMultiTenantSaslSecretsStore {
    public MultiTenantSaslSecretsStore(Map<String, Object> clientConfigs, Metrics metrics) {
        super(clientConfigs, metrics);
    }

    protected String getSessionUuid(Map<String, ?> config) {
        return AuthUtils.getBrokerSessionUuid(config);
    }

    protected synchronized void deleteCredential(String deletedKey) {
        BrokerSession session;
        BrokerSession brokerSession = session = this.sessionUuid != null ? BrokerSession.session((String)this.sessionUuid) : null;
        if (session != null) {
            LOG.trace("Deleting API key {} for broker session {}", (Object)deletedKey, (Object)this.sessionUuid);
            session.handleCredentialDelete(PublicCredential.saslCredential((String)deletedKey, (String)"PLAIN"));
        } else {
            LOG.warn("Ignoring deleted API key {} because broker session {} is not available.", (Object)deletedKey, (Object)this.sessionUuid);
        }
    }

    protected Map<String, Object> getConsumerConfig(Map<String, ?> config) {
        HashSet configNames = new HashSet(ConsumerConfig.configNames());
        configNames.remove("metric.reporters");
        HashMap<String, Object> clientConfigs = new HashMap<String, Object>(this.baseClientProperties);
        clientConfigs.keySet().retainAll(configNames);
        clientConfigs.put("client.id", String.format("%s-%s-%s", this.topicName, ConfluentConfigs.ClientType.CONSUMER, config.get("broker.id")));
        clientConfigs.put("bootstrap.servers", this.baseClientProperties.get("bootstrap.servers"));
        return clientConfigs;
    }

    protected void createSensors(Map<String, MultiTenantSaslConfigEntry> entries) {
        entries.forEach((username, userInfo) -> new ApiKeyConnectionSensorBuilder(this.metrics, PlainSaslAuthenticator.multiTenantPrincipal(username, userInfo)).build());
    }

    void configure(KafkaBasedLog<String, String> secretsLog, List<String> multitenantListenerNames) {
        LOG.warn("configure(KafkaBasedLog<>) called, shouldn't happen outside tests (Ignore if this is a unittest.)");
        this.topicName = "unused_var-secretsLog-passed-into-ctor";
        this.topicLoadTimeoutMs = ConfluentConfigs.CDC_TOPIC_LOAD_TIMEOUT_MS_DEFAULT;
        this.multitenantListenerNames = multitenantListenerNames;
        this.secretsLog = secretsLog;
    }
}

