/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth.oauth;

import io.confluent.kafka.server.plugins.auth.oauth.MockTrustCache;
import io.confluent.security.auth.metadata.AuthCache;
import io.confluent.security.auth.metadata.AuthStore;
import io.confluent.security.auth.metadata.AuthWriter;
import io.confluent.security.trustservice.store.TrustCache;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockBasicAuthStore
implements AuthStore {
    private static final Logger log = LoggerFactory.getLogger(MockBasicAuthStore.class);
    private final MockTrustCache authCache = new MockTrustCache();
    private final String brokerSessionId;

    public MockBasicAuthStore(String brokerSessionId) {
        this.brokerSessionId = brokerSessionId;
        AuthStore.addInstance((String)brokerSessionId, (AuthStore)this, (Logger)log);
    }

    public static MockBasicAuthStore create() {
        return MockBasicAuthStore.create("uuid");
    }

    public static MockBasicAuthStore create(String brokerSessionId) {
        return new MockBasicAuthStore(brokerSessionId);
    }

    public CompletionStage<Void> startReader() {
        return null;
    }

    public CompletionStage<Void> startService(Collection<URL> serverUrls) {
        return null;
    }

    public AuthCache authCache() {
        return null;
    }

    public TrustCache trustCache() {
        return this.authCache;
    }

    public AuthWriter writer() {
        return null;
    }

    public boolean isMasterWriter() {
        return false;
    }

    public URL masterWriterUrl(String protocol) {
        return null;
    }

    public Integer masterWriterId() {
        return null;
    }

    public Collection<URL> activeNodeUrls(String protocol) {
        return null;
    }

    public void close() {
        AuthStore.removeInstance((String)this.brokerSessionId, (AuthStore)this, (Logger)log);
    }

    public void configure(Map<String, ?> configs) {
    }
}

