/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kafka.common.CellLoad;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.placement.CellAssignor;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;

public class CellLoadMetrics
implements AutoCloseable {
    private static final MetricName CELL_LOAD_FRESH = KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)"KafkaController", (String)"CellLoadFresh");
    private static final String CELL_ID_TAG = "cellId";
    private final Optional<MetricsRegistry> registry;
    private final Time time;
    private volatile boolean cellLoadFreshInstalled;
    private volatile long lastCellLoadUpdateTimeMs;
    private final ConcurrentMap<Integer, Double> cellIdToLoad;

    public CellLoadMetrics(Optional<MetricsRegistry> registry, Time time) {
        this.registry = registry;
        this.time = time;
        this.cellLoadFreshInstalled = false;
        this.lastCellLoadUpdateTimeMs = 0L;
        this.cellIdToLoad = new ConcurrentHashMap<Integer, Double>();
    }

    long lastCellLoadUpdateTimeMs() {
        return this.lastCellLoadUpdateTimeMs;
    }

    void setLastCellLoadUpdateTimeMs(long lastCellLoadUpdateTimeMs) {
        this.lastCellLoadUpdateTimeMs = lastCellLoadUpdateTimeMs;
        this.installCellLoadFreshMetricIfNeeded();
    }

    Map<Integer, Double> cellIdToLoad() {
        return this.cellIdToLoad;
    }

    boolean cellLoadIsFresh() {
        return this.time.milliseconds() - this.lastCellLoadUpdateTimeMs <= CellAssignor.CELL_LOAD_FRESH_DURATION_MS;
    }

    double cellLoad(int cellId) {
        return this.cellIdToLoad.getOrDefault(cellId, -1.0);
    }

    public void updateCellLoads(Set<CellLoad> cellLoads, long lastCellLoadUpdateTimeMs) {
        HashMap cellLoadsMap = new HashMap();
        cellLoads.forEach(cellLoad -> cellLoadsMap.put(cellLoad.cellId(), cellLoad));
        for (Map.Entry entry : this.cellIdToLoad.entrySet()) {
            int cellId = (Integer)entry.getKey();
            CellLoad cellLoad2 = (CellLoad)cellLoadsMap.remove(cellId);
            if (cellLoad2 == null) {
                this.uninstallCellLoadMetricForCell(cellId);
                continue;
            }
            entry.setValue(cellLoad2.load());
        }
        for (Map.Entry entry : cellLoadsMap.entrySet()) {
            this.cellIdToLoad.put((Integer)entry.getKey(), ((CellLoad)entry.getValue()).load());
            this.installLoadMetricForCell((Integer)entry.getKey());
        }
        if (!this.cellIdToLoad.isEmpty()) {
            this.setLastCellLoadUpdateTimeMs(lastCellLoadUpdateTimeMs);
        }
    }

    void installCellLoadFreshMetricIfNeeded() {
        if (this.cellLoadFreshInstalled) {
            return;
        }
        this.cellLoadFreshInstalled = true;
        this.registry.ifPresent(r -> r.newGauge(CELL_LOAD_FRESH, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return CellLoadMetrics.this.cellLoadIsFresh() ? 1 : 0;
            }
        }));
    }

    static MetricName cellLoadMetricName(int cellId) {
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        tags.put(CELL_ID_TAG, String.valueOf(cellId));
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)"KafkaController", (String)"Load", tags);
    }

    void installLoadMetricForCell(final int cellId) {
        this.registry.ifPresent(r -> r.newGauge(CellLoadMetrics.cellLoadMetricName(cellId), (Gauge)new Gauge<Double>(){

            public Double value() {
                return CellLoadMetrics.this.cellLoad(cellId);
            }
        }));
    }

    void uninstallCellLoadMetricForCell(int cellId) {
        this.registry.ifPresent(r -> r.removeMetric(CellLoadMetrics.cellLoadMetricName(cellId)));
    }

    @Override
    public void close() {
        if (this.cellLoadFreshInstalled) {
            this.registry.ifPresent(r -> r.removeMetric(CELL_LOAD_FRESH));
            this.cellLoadFreshInstalled = false;
        }
        this.cellIdToLoad.keySet().forEach(this::uninstallCellLoadMetricForCell);
        this.cellIdToLoad.clear();
    }
}

