/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;

public class ConfluentControllerMetrics
implements AutoCloseable {
    private static final MetricName GLOBAL_TOPIC_COUNT = ConfluentControllerMetrics.getMetricName("KafkaController", "GlobalTopicCount");
    private static final MetricName GLOBAL_PARTITION_COUNT = ConfluentControllerMetrics.getMetricName("KafkaController", "GlobalPartitionCount");
    private static final MetricName GLOBAL_OFFLINE_PARTITION_COUNT = ConfluentControllerMetrics.getMetricName("KafkaController", "OfflinePartitionsCount");
    private static final MetricName GLOBAL_UNDER_MIN_ISR_COUNT = ConfluentControllerMetrics.getMetricName("KafkaController", "GlobalUnderMinIsrPartitionCount");
    private static final MetricName GLOBAL_PARTITION_AVAILABILITY = ConfluentControllerMetrics.getMetricName("KafkaController", "PartitionAvailability");
    private static final MetricName PREFERRED_REPLICA_IMBALANCE_COUNT = ConfluentControllerMetrics.getMetricName("KafkaController", "PreferredReplicaImbalanceCount");
    private final Optional<MetricsRegistry> registry;
    private volatile int globalTopicCount;
    private final Map<String, TenantPartitionMetrics> tenantPartitionMetricsMap = new ConcurrentHashMap<String, TenantPartitionMetrics>();
    private volatile int globalPartitionCount;
    private volatile int globalOfflinePartitionCount;
    private volatile int globalUnderMinIsrCount;
    private volatile int preferredReplicaImbalanceCount;

    public ConfluentControllerMetrics(Optional<MetricsRegistry> registry) {
        this.registry = registry;
        this.globalTopicCount = 0;
        this.globalPartitionCount = 0;
        this.globalOfflinePartitionCount = 0;
        this.globalUnderMinIsrCount = 0;
        this.preferredReplicaImbalanceCount = 0;
        registry.ifPresent(r -> r.newGauge(GLOBAL_TOPIC_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ConfluentControllerMetrics.this.globalTopicCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(GLOBAL_PARTITION_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ConfluentControllerMetrics.this.globalPartitionCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(GLOBAL_OFFLINE_PARTITION_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ConfluentControllerMetrics.this.globalOfflinePartitionCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(GLOBAL_UNDER_MIN_ISR_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ConfluentControllerMetrics.this.globalUnderMinIsrCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(GLOBAL_PARTITION_AVAILABILITY, (Gauge)new Gauge<Double>(){

            public Double value() {
                return ConfluentControllerMetrics.this.globalPartitionAvailability();
            }
        }));
        registry.ifPresent(r -> r.newGauge(PREFERRED_REPLICA_IMBALANCE_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ConfluentControllerMetrics.this.preferredReplicaImbalanceCount();
            }
        }));
    }

    public int globalTopicCount() {
        return this.globalTopicCount;
    }

    public void setGlobalTopicCount(int value) {
        this.globalTopicCount = value;
    }

    public void addToGlobalTopicCount(int delta) {
        this.globalTopicCount += delta;
    }

    public int globalPartitionCount() {
        return this.globalPartitionCount;
    }

    public void setGlobalPartitionCount(int value) {
        this.globalPartitionCount = value;
    }

    public void addToGlobalPartitionCount(int delta) {
        this.globalPartitionCount += delta;
    }

    public int globalOfflinePartitionCount() {
        return this.globalOfflinePartitionCount;
    }

    public void setGlobalOfflinePartitionCount(int value) {
        this.globalOfflinePartitionCount = value;
    }

    public void addToGlobalOfflinePartitionCount(int delta) {
        this.globalOfflinePartitionCount += delta;
    }

    public int globalUnderMinIsrCount() {
        return this.globalUnderMinIsrCount;
    }

    public void setGlobalUnderMinIsrCount(int value) {
        this.globalUnderMinIsrCount = value;
    }

    public void addToGlobalUnderMinIsrCount(int delta) {
        this.globalUnderMinIsrCount += delta;
    }

    public int preferredReplicaImbalanceCount() {
        return this.preferredReplicaImbalanceCount;
    }

    public void setPreferredReplicaImbalanceCount(int value) {
        this.preferredReplicaImbalanceCount = value;
    }

    public void addToPreferredReplicaImbalanceCount(int delta) {
        this.preferredReplicaImbalanceCount += delta;
    }

    public double globalPartitionAvailability() {
        return ConfluentControllerMetrics.computePartitionAvailability(this.globalPartitionCount, this.globalOfflinePartitionCount, this.globalUnderMinIsrCount);
    }

    @Override
    public void close() {
        this.registry.ifPresent(r -> Arrays.asList(GLOBAL_TOPIC_COUNT, GLOBAL_PARTITION_COUNT, GLOBAL_OFFLINE_PARTITION_COUNT, GLOBAL_UNDER_MIN_ISR_COUNT, GLOBAL_PARTITION_AVAILABILITY, PREFERRED_REPLICA_IMBALANCE_COUNT).forEach(arg_0 -> ((MetricsRegistry)r).removeMetric(arg_0)));
        this.tenantPartitionMetricsMap.keySet().forEach(this::uninstallTenantMetrics);
        this.tenantPartitionMetricsMap.clear();
    }

    private static MetricName getMetricName(String type, String name) {
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)type, (String)name);
    }

    static MetricName tenantPartitionAvailabilityMetricName(String tenant) {
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        tags.put("tenant", tenant);
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)"KafkaController", (String)"TenantPartitionAvailability", tags);
    }

    static double computePartitionAvailability(double partitionCount, double offlineCount, double underMinIsrCount) {
        return partitionCount == 0.0 ? 1.0 : (partitionCount - underMinIsrCount - offlineCount) / partitionCount;
    }

    TenantPartitionMetrics tenantPartitionMetrics(String tenant) {
        return this.tenantPartitionMetricsMap.getOrDefault(tenant, TenantPartitionMetrics.EMPTY);
    }

    void setTenantPartitionMetrics(Map<String, TenantPartitionMetrics> newTenantPartitionMetricsMap) {
        Iterator<Map.Entry<String, TenantPartitionMetrics>> iter = this.tenantPartitionMetricsMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, TenantPartitionMetrics> entry = iter.next();
            TenantPartitionMetrics newMetrics = newTenantPartitionMetricsMap.get(entry.getKey());
            if (newMetrics != null && !newMetrics.empty()) continue;
            iter.remove();
            this.uninstallTenantMetrics(entry.getKey());
        }
        for (Map.Entry<String, TenantPartitionMetrics> entry : newTenantPartitionMetricsMap.entrySet()) {
            if (entry.getValue().empty() || this.tenantPartitionMetricsMap.put(entry.getKey(), entry.getValue()) != null) continue;
            this.installTenantMetrics(entry.getKey());
        }
    }

    void addToTenantPartitionMetrics(String tenant, int partitionCountDelta, int offlinePartitionCountDelta, int underMinIsrCountDelta) {
        this.tenantPartitionMetricsMap.compute(tenant, (__, tenantMetrics) -> {
            if (tenantMetrics == null) {
                tenantMetrics = TenantPartitionMetrics.EMPTY;
            }
            TenantPartitionMetrics next = tenantMetrics.next(partitionCountDelta, offlinePartitionCountDelta, underMinIsrCountDelta);
            if (tenantMetrics.empty()) {
                if (!next.empty()) {
                    this.installTenantMetrics(tenant);
                }
            } else if (next.empty()) {
                this.uninstallTenantMetrics(tenant);
                return null;
            }
            return next;
        });
    }

    private void uninstallTenantMetrics(String tenant) {
        this.registry.ifPresent(r -> r.removeMetric(ConfluentControllerMetrics.tenantPartitionAvailabilityMetricName(tenant)));
    }

    private void installTenantMetrics(final String tenant) {
        this.registry.ifPresent(r -> r.newGauge(ConfluentControllerMetrics.tenantPartitionAvailabilityMetricName(tenant), (Gauge)new Gauge<Double>(){

            public Double value() {
                return ConfluentControllerMetrics.this.tenantPartitionMetrics(tenant).partitionAvailability();
            }
        }));
    }

    static final class TenantPartitionMetrics {
        final int partitionCount;
        final int offlinePartitionCount;
        final int underMinIsrCount;
        static final TenantPartitionMetrics EMPTY = new TenantPartitionMetrics(0, 0, 0);

        TenantPartitionMetrics(int partitionCount, int offlinePartitionCount, int underMinIsrCount) {
            this.partitionCount = partitionCount;
            this.offlinePartitionCount = offlinePartitionCount;
            this.underMinIsrCount = underMinIsrCount;
        }

        boolean empty() {
            return this.partitionCount == 0;
        }

        double partitionAvailability() {
            return ConfluentControllerMetrics.computePartitionAvailability(this.partitionCount, this.offlinePartitionCount, this.underMinIsrCount);
        }

        TenantPartitionMetrics next(int partitionCountDelta, int offlinePartitionCountDelta, int underMinIsrCountDelta) {
            return new TenantPartitionMetrics(this.partitionCount + partitionCountDelta, this.offlinePartitionCount + offlinePartitionCountDelta, this.underMinIsrCount + underMinIsrCountDelta);
        }

        public boolean equals(Object o) {
            if (o == null || !o.getClass().equals(TenantPartitionMetrics.class)) {
                return false;
            }
            TenantPartitionMetrics other = (TenantPartitionMetrics)o;
            return this.partitionCount == other.partitionCount && this.offlinePartitionCount == other.offlinePartitionCount && this.underMinIsrCount == other.underMinIsrCount;
        }

        public int hashCode() {
            return Objects.hash(this.partitionCount, this.offlinePartitionCount, this.underMinIsrCount);
        }

        public String toString() {
            return "TenantPartitionMetrics(partitionCount=" + this.partitionCount + ", offlinePartitionCount=" + this.offlinePartitionCount + ", underMinIsrCount=" + this.underMinIsrCount + ")";
        }
    }
}

