/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.Tenant;
import org.apache.kafka.common.metadata.RemoveTenantRecord;
import org.apache.kafka.common.metadata.TenantRecord;
import org.apache.kafka.image.TenantImage;

public class TenantDelta {
    private final TenantImage image;
    private final Map<String, Optional<Tenant>> changes;

    public TenantDelta(TenantImage image) {
        this.image = image;
        this.changes = new HashMap<String, Optional<Tenant>>();
    }

    public Map<String, Optional<Tenant>> changes() {
        return this.changes;
    }

    public void replay(TenantRecord record) {
        this.changes.put(record.tenantId(), Optional.of(new Tenant(record.tenantId(), record.cellId())));
    }

    public void replay(RemoveTenantRecord record) {
        this.changes.put(record.tenantId(), Optional.empty());
    }

    public TenantImage apply() {
        HashMap<String, Tenant> newTenantIdToTenant = new HashMap<String, Tenant>(this.image.tenantIdToTenant());
        this.changes.forEach((k, v) -> {
            if (v.isPresent()) {
                newTenantIdToTenant.put((String)k, (Tenant)v.get());
            } else {
                newTenantIdToTenant.remove(k);
            }
        });
        return new TenantImage(newTenantIdToTenant);
    }

    public void finishSnapshot() {
        for (String tenant : this.image.tenantIdToTenant().keySet()) {
            if (this.changes.containsKey(tenant)) continue;
            this.changes.put(tenant, Optional.empty());
        }
    }

    public String toString() {
        return "TenantDelta(changes=" + this.changes + ")";
    }
}

