/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.kafka.common.Cell;
import org.apache.kafka.image.CellImage;
import org.apache.kafka.image.node.MetadataLeafNode;
import org.apache.kafka.image.node.MetadataNode;

public class CellImageNode
implements MetadataNode {
    public static final String NAME = "cells";
    private final CellImage image;

    public CellImageNode(CellImage image) {
        this.image = image;
    }

    @Override
    public Collection<String> childNames() {
        ArrayList<String> children = new ArrayList<String>();
        this.image.cellIdToCell().keySet().forEach(id -> children.add(Integer.toString(id)));
        return children;
    }

    @Override
    public MetadataNode child(String name) {
        int id;
        try {
            id = Integer.parseInt(name);
        }
        catch (NumberFormatException e) {
            return null;
        }
        Cell cell = this.image.cellIdToCell().get(id);
        if (cell == null) {
            return null;
        }
        return new MetadataLeafNode(cell.toString());
    }
}

