/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.ClusterLinkRecord;

public class ClusterLink {
    private final String linkName;
    private final Uuid linkId;
    private final Optional<String> tenantPrefix;
    private final String remoteClusterId;
    private final ClusterLinkConfig.LinkMode linkMode;

    public ClusterLink(ClusterLinkRecord record) {
        this(record.clusterLinkName(), record.clusterLinkId(), record.tenantPrefix(), record.remoteClusterId(), record.linkMode());
    }

    public ClusterLink(String linkName, Uuid linkId, String tenantPrefix, String remoteClusterId, String linkMode) {
        this.linkName = linkName;
        this.linkId = linkId;
        this.tenantPrefix = Optional.ofNullable(tenantPrefix);
        this.remoteClusterId = remoteClusterId;
        this.linkMode = ClusterLinkConfig.LinkMode.fromString((String)linkMode);
    }

    public String linkName() {
        return this.linkName;
    }

    public Uuid linkId() {
        return this.linkId;
    }

    public Optional<String> tenantPrefix() {
        return this.tenantPrefix;
    }

    public String remoteClusterId() {
        return this.remoteClusterId;
    }

    public ClusterLinkConfig.LinkMode linkMode() {
        return this.linkMode;
    }

    public ClusterLinkRecord toRecord() {
        return new ClusterLinkRecord().setClusterLinkName(this.linkName).setClusterLinkId(this.linkId).setRemoteClusterId(this.remoteClusterId).setTenantPrefix(this.tenantPrefix.orElse(null)).setLinkMode(this.linkMode.toString());
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClusterLink)) {
            return false;
        }
        ClusterLink other = (ClusterLink)o;
        return this.linkName.equals(other.linkName) && this.linkId.equals((Object)other.linkId) && this.tenantPrefix.equals(other.tenantPrefix) && this.remoteClusterId.equals(other.remoteClusterId) && this.linkMode.equals((Object)other.linkMode);
    }

    public int hashCode() {
        return Objects.hash(this.linkName, this.linkId, this.tenantPrefix, this.remoteClusterId, this.linkMode);
    }

    public String toString() {
        String tenantPrefixString = this.tenantPrefix.map(s -> ", tenantPrefix=" + s).orElse("");
        return "ClusterLinkImage(linkName=" + this.linkName + ", linkId=" + this.linkId + tenantPrefixString + ", remoteClusterId=" + this.remoteClusterId + ", linkMode=" + this.linkMode + ")";
    }
}

