/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.metadata.MirrorTopicChangeRecord;
import org.apache.kafka.common.metadata.MirrorTopicRecord;
import org.apache.kafka.common.protocol.Errors;

public interface MirrorTopic {
    public Uuid linkId();

    public String linkName();

    public Uuid topicId();

    public String topicName();

    public Uuid sourceTopicId();

    public String sourceTopicName();

    public State mirrorState();

    public MirrorTopicError mirrorTopicError();

    public List<Long> mirrorStartOffsets();

    default public List<Long> mirrorStoppedOffsets() {
        return Collections.emptyList();
    }

    default public List<Integer> mirrorStoppedEpochs() {
        return Collections.emptyList();
    }

    public boolean mirrorIsEstablished();

    public long stoppedSequenceNumber();

    public long timeMs();

    public static boolean wasFailed(State state) {
        return state == State.FAILED || state == State.PENDING_REPAIR;
    }

    public static MirrorTopic paused(MirrorTopic mirrorTopic, long timeMs, boolean topicLevel, boolean linkLevel, State previousState, List<Long> mirrorStartOffsets, short errorCode, State pendingSynchronizeNextState) {
        MirrorTopicError error = MirrorTopicError.forCode((short)errorCode, (boolean)MirrorTopic.wasFailed(previousState));
        return new PausedMirrorTopic(mirrorTopic.linkId(), mirrorTopic.linkName(), mirrorTopic.topicId(), mirrorTopic.topicName(), mirrorTopic.sourceTopicId(), mirrorTopic.sourceTopicName(), mirrorStartOffsets, mirrorTopic.stoppedSequenceNumber(), timeMs, topicLevel, linkLevel, previousState, error, pendingSynchronizeNextState);
    }

    public static MirrorTopic pendingStopped(MirrorTopic mirrorTopic, long timeMs, boolean promoted) {
        return new PendingStoppedMirrorTopic(mirrorTopic.linkId(), mirrorTopic.linkName(), mirrorTopic.topicId(), mirrorTopic.topicName(), mirrorTopic.sourceTopicId(), mirrorTopic.sourceTopicName(), mirrorTopic.stoppedSequenceNumber(), timeMs, promoted);
    }

    public static MirrorTopic mirror(MirrorTopic mirrorTopic, long timeMs, List<Long> startOffsets) {
        return new ActiveMirrorTopic(mirrorTopic.linkId(), mirrorTopic.linkName(), mirrorTopic.topicId(), mirrorTopic.topicName(), mirrorTopic.sourceTopicId(), mirrorTopic.sourceTopicName(), startOffsets, mirrorTopic.stoppedSequenceNumber(), timeMs);
    }

    public static MirrorTopic failed(MirrorTopic mirrorTopic, long timeMs, short error) {
        return new FailedMirrorTopic(mirrorTopic.linkId(), mirrorTopic.linkName(), mirrorTopic.topicId(), mirrorTopic.topicName(), mirrorTopic.sourceTopicId(), mirrorTopic.sourceTopicName(), mirrorTopic.stoppedSequenceNumber(), timeMs, MirrorTopicError.forCode((short)error, (boolean)true));
    }

    public static MirrorTopic stopped(MirrorTopic mirrorTopic, long timeMs, List<Long> offsets, List<Integer> stoppedEpochs, long stoppedSequenceNumber) {
        return new StoppedMirrorTopic(mirrorTopic.linkId(), mirrorTopic.linkName(), mirrorTopic.topicId(), mirrorTopic.topicName(), mirrorTopic.sourceTopicId(), mirrorTopic.sourceTopicName(), stoppedSequenceNumber, timeMs, offsets, stoppedEpochs);
    }

    public static MirrorTopic pendingSynchronize(MirrorTopic mirrorTopic, long timeMs, State remoteMirrorNextState) {
        return new PendingSynchronizeMirrorTopic(mirrorTopic.linkId(), mirrorTopic.linkName(), mirrorTopic.topicId(), mirrorTopic.topicName(), mirrorTopic.sourceTopicId(), mirrorTopic.sourceTopicName(), mirrorTopic.stoppedSequenceNumber(), timeMs, remoteMirrorNextState);
    }

    public static MirrorTopic pendingMirror(MirrorTopic mirrorTopic, long timeMs, State nextState, long stoppedSequenceNumber) {
        return new PendingMirrorTopic(mirrorTopic.linkId(), mirrorTopic.linkName(), mirrorTopic.topicId(), mirrorTopic.topicName(), mirrorTopic.sourceTopicId(), mirrorTopic.sourceTopicName(), stoppedSequenceNumber, timeMs, nextState);
    }

    public static MirrorTopic pendingRepairMirror(MirrorTopic mirrorTopic, long timeMs, short error) {
        return new PendingRepairMirrorTopic(mirrorTopic.linkId(), mirrorTopic.linkName(), mirrorTopic.topicId(), mirrorTopic.topicName(), mirrorTopic.sourceTopicId(), mirrorTopic.sourceTopicName(), mirrorTopic.stoppedSequenceNumber(), timeMs, MirrorTopicError.forCode((short)error, (boolean)true));
    }

    public static MirrorTopic pendingSetupForRestoreMirror(MirrorTopic mirrorTopic, long timeMs, List<Long> truncationOffsets, List<Integer> truncationEpochs, long stoppedSequenceNumber) {
        return new PendingSetupForRestoreMirrorTopic(mirrorTopic.linkId(), mirrorTopic.linkName(), mirrorTopic.topicId(), mirrorTopic.topicName(), mirrorTopic.sourceTopicId(), mirrorTopic.sourceTopicName(), truncationOffsets, truncationEpochs, stoppedSequenceNumber, timeMs);
    }

    public static MirrorTopic pendingRestoreMirror(MirrorTopic mirrorTopic, long timeMs, List<Long> mirrorStartOffsets) {
        return new PendingRestoreMirrorTopic(mirrorTopic.linkId(), mirrorTopic.linkName(), mirrorTopic.topicId(), mirrorTopic.topicName(), mirrorTopic.sourceTopicId(), mirrorTopic.sourceTopicName(), mirrorStartOffsets, mirrorTopic.stoppedSequenceNumber(), timeMs);
    }

    public static MirrorTopic fromRecord(MirrorTopicRecord record) {
        State state = State.fromStateName(record.mirrorTopicState());
        switch (state) {
            case MIRROR: {
                return ActiveMirrorTopic.fromRecord(record);
            }
            case FAILED: {
                return FailedMirrorTopic.fromRecord(record);
            }
            case PAUSED: {
                return PausedMirrorTopic.fromRecord(record);
            }
            case PENDING_STOPPED: {
                return PendingStoppedMirrorTopic.fromRecord(record);
            }
            case STOPPED: {
                return StoppedMirrorTopic.fromRecord(record);
            }
            case PENDING_MIRROR: {
                return PendingMirrorTopic.fromRecord(record);
            }
            case PENDING_SYNCHRONIZE: {
                return PendingSynchronizeMirrorTopic.fromRecord(record);
            }
            case PENDING_REPAIR: {
                return PendingRepairMirrorTopic.fromRecord(record);
            }
            case PENDING_SETUP_FOR_RESTORE: {
                return PendingSetupForRestoreMirrorTopic.fromRecord(record);
            }
            case PENDING_RESTORE: {
                return PendingRestoreMirrorTopic.fromRecord(record);
            }
        }
        throw new IllegalStateException("Unknown mirror topic state " + record.mirrorTopicState());
    }

    public static MirrorTopic fromChangeRecord(MirrorTopic mirrorTopic, MirrorTopicChangeRecord changeRecord) {
        State state = State.fromStateName(changeRecord.mirrorTopicState());
        switch (state) {
            case MIRROR: {
                return MirrorTopic.mirror(mirrorTopic, changeRecord.timeMs(), changeRecord.mirrorStartOffsets());
            }
            case PAUSED: {
                State pendingSynchronizeNextState = changeRecord.nextState() == null ? null : State.fromStateName(changeRecord.nextState());
                return MirrorTopic.paused(mirrorTopic, changeRecord.timeMs(), changeRecord.topicLevelPause(), changeRecord.linkLevelPause(), State.fromStateName(changeRecord.previousToPausedState()), changeRecord.mirrorStartOffsets(), changeRecord.mirrorTopicError(), pendingSynchronizeNextState);
            }
            case FAILED: {
                return MirrorTopic.failed(mirrorTopic, changeRecord.timeMs(), changeRecord.mirrorTopicError());
            }
            case PENDING_STOPPED: {
                return MirrorTopic.pendingStopped(mirrorTopic, changeRecord.timeMs(), changeRecord.promoted());
            }
            case STOPPED: {
                return MirrorTopic.stopped(mirrorTopic, changeRecord.timeMs(), changeRecord.stoppedLogEndOffsets(), changeRecord.stoppedEpochs(), changeRecord.stoppedSequenceNumber());
            }
            case PENDING_MIRROR: {
                State nextState = changeRecord.nextState() == null ? null : State.fromStateName(changeRecord.nextState());
                return MirrorTopic.pendingMirror(mirrorTopic, changeRecord.timeMs(), nextState, changeRecord.stoppedSequenceNumber());
            }
            case PENDING_SYNCHRONIZE: {
                return MirrorTopic.pendingSynchronize(mirrorTopic, changeRecord.timeMs(), State.fromStateName(changeRecord.nextState()));
            }
            case PENDING_REPAIR: {
                return MirrorTopic.pendingRepairMirror(mirrorTopic, changeRecord.timeMs(), changeRecord.mirrorTopicError());
            }
            case PENDING_SETUP_FOR_RESTORE: {
                return MirrorTopic.pendingSetupForRestoreMirror(mirrorTopic, changeRecord.timeMs(), changeRecord.truncationOffsets(), changeRecord.truncationEpochs(), changeRecord.stoppedSequenceNumber());
            }
            case PENDING_RESTORE: {
                return MirrorTopic.pendingRestoreMirror(mirrorTopic, changeRecord.timeMs(), changeRecord.mirrorStartOffsets());
            }
        }
        throw new IllegalStateException("Unknown mirror topic state " + changeRecord.mirrorTopicState());
    }

    public static MirrorTopicRecord toSnapshotRecord(MirrorTopic mirrorTopic, String topicName) {
        MirrorTopicRecord record = new MirrorTopicRecord().setTopicId(mirrorTopic.topicId()).setTopicName(topicName).setSourceTopicName(mirrorTopic.sourceTopicName()).setSourceTopicId(mirrorTopic.sourceTopicId()).setClusterLinkId(mirrorTopic.linkId()).setClusterLinkName(mirrorTopic.linkName()).setMirrorTopicState(mirrorTopic.mirrorState().stateName()).setStoppedSequenceNumber(mirrorTopic.stoppedSequenceNumber()).setTimeMs(mirrorTopic.timeMs());
        switch (mirrorTopic.mirrorState()) {
            case MIRROR: {
                if (mirrorTopic.mirrorStartOffsets() == null) break;
                record.setMirrorStartOffsets(mirrorTopic.mirrorStartOffsets());
                break;
            }
            case FAILED: {
                record.setMirrorTopicError(mirrorTopic.mirrorTopicError().code());
                break;
            }
            case PAUSED: {
                record.setPreviousToPausedState(((PausedMirrorTopic)mirrorTopic).prevToPausedState().stateName());
                record.setLinkLevelPause(((PausedMirrorTopic)mirrorTopic).linkLevel);
                record.setTopicLevelPause(((PausedMirrorTopic)mirrorTopic).topicLevel);
                if (mirrorTopic.mirrorStartOffsets() != null) {
                    record.setMirrorStartOffsets(mirrorTopic.mirrorStartOffsets());
                }
                if (((PausedMirrorTopic)mirrorTopic).pendingSynchronizeNextState() != null) {
                    record.setNextState(((PausedMirrorTopic)mirrorTopic).pendingSynchronizeNextState.stateName);
                }
                record.setMirrorTopicError(mirrorTopic.mirrorTopicError().code());
                break;
            }
            case PENDING_STOPPED: {
                record.setPromoted(((PendingStoppedMirrorTopic)mirrorTopic).promoted());
                if (mirrorTopic.mirrorStartOffsets() == null) break;
                record.setMirrorStartOffsets(mirrorTopic.mirrorStartOffsets());
                break;
            }
            case STOPPED: {
                record.setStoppedLogEndOffsets(mirrorTopic.mirrorStoppedOffsets());
                record.setStoppedEpochs(mirrorTopic.mirrorStoppedEpochs());
                break;
            }
            case PENDING_MIRROR: {
                record.setSourceTopicId(mirrorTopic.sourceTopicId());
                record.setSourceTopicName(mirrorTopic.sourceTopicName());
                record.setNextState(((PendingMirrorTopic)mirrorTopic).nextState().stateName());
                break;
            }
            case PENDING_SYNCHRONIZE: {
                record.setNextState(((PendingSynchronizeMirrorTopic)mirrorTopic).remoteMirrorNextState().stateName());
                break;
            }
            case PENDING_REPAIR: {
                record.setMirrorTopicError(mirrorTopic.mirrorTopicError().code());
                break;
            }
            case PENDING_SETUP_FOR_RESTORE: {
                record.setTruncationEpochs(((PendingSetupForRestoreMirrorTopic)mirrorTopic).truncationEpochs());
                record.setTruncationOffsets(((PendingSetupForRestoreMirrorTopic)mirrorTopic).truncationOffsets());
                break;
            }
            case PENDING_RESTORE: {
                record.setMirrorStartOffsets(mirrorTopic.mirrorStartOffsets());
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled mirror topic state " + (Object)((Object)mirrorTopic.mirrorState()));
            }
        }
        return record;
    }

    public static MirrorTopicChangeRecord toChangeRecord(MirrorTopic mirrorTopic) {
        MirrorTopicChangeRecord record = new MirrorTopicChangeRecord().setTopicName(mirrorTopic.topicName()).setTopicId(mirrorTopic.topicId()).setTimeMs(mirrorTopic.timeMs()).setClusterLinkId(mirrorTopic.linkId()).setClusterLinkName(mirrorTopic.linkName()).setStoppedSequenceNumber(mirrorTopic.stoppedSequenceNumber()).setMirrorTopicState(mirrorTopic.mirrorState().stateName());
        switch (mirrorTopic.mirrorState()) {
            case MIRROR: {
                if (mirrorTopic.mirrorStartOffsets() == null) break;
                record.setMirrorStartOffsets(mirrorTopic.mirrorStartOffsets());
                break;
            }
            case FAILED: {
                record.setMirrorTopicError(mirrorTopic.mirrorTopicError().code());
                break;
            }
            case PAUSED: {
                record.setPreviousToPausedState(((PausedMirrorTopic)mirrorTopic).prevToPausedState().stateName());
                record.setLinkLevelPause(((PausedMirrorTopic)mirrorTopic).linkLevel);
                record.setTopicLevelPause(((PausedMirrorTopic)mirrorTopic).topicLevel);
                if (mirrorTopic.mirrorStartOffsets() != null) {
                    record.setMirrorStartOffsets(mirrorTopic.mirrorStartOffsets());
                }
                if (((PausedMirrorTopic)mirrorTopic).pendingSynchronizeNextState() != null) {
                    record.setNextState(((PausedMirrorTopic)mirrorTopic).pendingSynchronizeNextState.stateName);
                }
                record.setMirrorTopicError(mirrorTopic.mirrorTopicError().code());
                break;
            }
            case PENDING_STOPPED: {
                record.setPromoted(((PendingStoppedMirrorTopic)mirrorTopic).promoted());
                break;
            }
            case STOPPED: {
                record.setStoppedLogEndOffsets(mirrorTopic.mirrorStoppedOffsets());
                record.setStoppedEpochs(mirrorTopic.mirrorStoppedEpochs());
                break;
            }
            case PENDING_MIRROR: {
                record.setNextState(((PendingMirrorTopic)mirrorTopic).nextState().stateName());
                break;
            }
            case PENDING_SYNCHRONIZE: {
                record.setNextState(((PendingSynchronizeMirrorTopic)mirrorTopic).remoteMirrorNextState().stateName());
                break;
            }
            case PENDING_REPAIR: {
                record.setMirrorTopicError(mirrorTopic.mirrorTopicError().code());
                break;
            }
            case PENDING_SETUP_FOR_RESTORE: {
                record.setTruncationEpochs(((PendingSetupForRestoreMirrorTopic)mirrorTopic).truncationEpochs());
                record.setTruncationOffsets(((PendingSetupForRestoreMirrorTopic)mirrorTopic).truncationOffsets());
                break;
            }
            case PENDING_RESTORE: {
                record.setMirrorStartOffsets(mirrorTopic.mirrorStartOffsets());
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled mirror topic state " + (Object)((Object)mirrorTopic.mirrorState()));
            }
        }
        return record;
    }

    public Optional<MirrorTopic> clearMirrorStartOffsets(long var1);

    public Optional<MirrorTopic> toStopped(List<Long> var1, List<Integer> var2, long var3, long var5);

    public Optional<MirrorTopic> toPaused(boolean var1, long var2);

    public Optional<MirrorTopic> toUnpaused(boolean var1, long var2);

    public Optional<MirrorTopic> toPendingStopped(boolean var1, long var2);

    public Optional<MirrorTopic> toPendingMirror(Uuid var1, Uuid var2, long var3, State var5, long var6);

    public Optional<MirrorTopic> toMirror(long var1);

    public Optional<MirrorTopic> toPendingRepair(long var1);

    public Optional<MirrorTopic> toFailedMirror(short var1, long var2);

    public Optional<MirrorTopic> toPendingSynchronize(State var1, long var2);

    public Optional<MirrorTopic> toPendingSetupForRestore(Uuid var1, Uuid var2, List<Integer> var3, List<Long> var4, long var5, long var7);

    public Optional<MirrorTopic> toPendingRestore(List<Long> var1, long var2);

    public static final class PendingRepairMirrorTopic
    extends BaseMirrorTopic
    implements MirrorTopic {
        private final MirrorTopicError error;

        public PendingRepairMirrorTopic(Uuid linkId, String linkName, Uuid topicId, String topicName, Uuid sourceTopicId, String sourceTopicName, long stoppedSequenceNumber, long timeMs, MirrorTopicError error) {
            super(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, State.PENDING_REPAIR, stoppedSequenceNumber, timeMs);
            this.error = error;
        }

        public static PendingRepairMirrorTopic fromRecord(MirrorTopicRecord record) {
            if (!State.fromStateName(record.mirrorTopicState()).equals((Object)State.PENDING_REPAIR)) {
                throw new IllegalStateException("PendingRepairMirrorTopic can be created only with state PENDING_REPAIR");
            }
            return new PendingRepairMirrorTopic(record.clusterLinkId(), record.clusterLinkName(), record.topicId(), record.topicName(), record.sourceTopicId(), record.sourceTopicName(), record.stoppedSequenceNumber(), record.timeMs(), MirrorTopicError.forCode((short)record.mirrorTopicError(), (boolean)true));
        }

        @Override
        public MirrorTopicError mirrorTopicError() {
            return this.error;
        }

        @Override
        public boolean mirrorIsEstablished() {
            return true;
        }

        @Override
        public Optional<MirrorTopic> toStopped(List<Long> stoppedLogEndOffsets, List<Integer> stoppedEpochs, long timeMs, long stoppedSequenceNumber) {
            throw new InvalidRequestException("Cannot stop pending repair mirror topic");
        }

        @Override
        public Optional<MirrorTopic> toPaused(boolean linkLevel, long timeMs) {
            return Optional.of(MirrorTopic.paused(this, timeMs, !linkLevel, linkLevel, this.mirrorState(), this.mirrorStartOffsets(), this.error.code(), null));
        }

        @Override
        public Optional<MirrorTopic> toUnpaused(boolean linkLevel, long timeMs) {
            return Optional.empty();
        }

        @Override
        public Optional<MirrorTopic> toPendingStopped(boolean synchronize, long timeMs) {
            return Optional.of(MirrorTopic.pendingStopped(this, timeMs, synchronize));
        }

        @Override
        public Optional<MirrorTopic> toMirror(long timeMs) {
            return Optional.of(MirrorTopic.mirror(this, timeMs, this.mirrorStartOffsets()));
        }

        @Override
        public Optional<MirrorTopic> toFailedMirror(short mirrorTopicError, long timeMs) {
            return Optional.of(MirrorTopic.failed(this, timeMs, mirrorTopicError));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PendingRepairMirrorTopic that = (PendingRepairMirrorTopic)o;
            return Objects.equals(this.error, that.error);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.error);
        }

        public String toString() {
            return "PendingRepairMirrorTopic{linkId=" + this.linkId() + ", linkName=" + this.linkName() + ", topicId=" + this.topicId() + ", topicName=" + this.topicName() + ", sourceTopicId=" + this.sourceTopicId() + ", sourceTopicName=" + this.sourceTopicName() + ", mirrorState=" + (Object)((Object)this.mirrorState()) + ", error=" + this.mirrorTopicError() + ", stoppedSequenceNumber=" + this.stoppedSequenceNumber() + ", timeMs=" + this.timeMs() + '}';
        }
    }

    public static final class PendingRestoreMirrorTopic
    extends BaseMirrorTopic
    implements MirrorTopic {
        private final List<Long> mirrorStartOffsets;

        public PendingRestoreMirrorTopic(Uuid linkId, String linkName, Uuid topicId, String topicName, Uuid sourceTopicId, String sourceTopicName, List<Long> mirrorStartOffsets, long stoppedSequenceNumber, long timeMs) {
            super(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, State.PENDING_RESTORE, stoppedSequenceNumber, timeMs);
            this.mirrorStartOffsets = mirrorStartOffsets != null ? Collections.unmodifiableList(mirrorStartOffsets) : Collections.emptyList();
        }

        public static PendingRestoreMirrorTopic fromRecord(MirrorTopicRecord record) {
            if (!State.fromStateName(record.mirrorTopicState()).equals((Object)State.PENDING_RESTORE)) {
                throw new IllegalStateException("PendingRestoreMirrorTopic can be created only with state PENDING_RESTORE");
            }
            return new PendingRestoreMirrorTopic(record.clusterLinkId(), record.clusterLinkName(), record.topicId(), record.topicName(), record.sourceTopicId(), record.sourceTopicName(), record.mirrorStartOffsets(), record.stoppedSequenceNumber(), record.timeMs());
        }

        @Override
        public boolean mirrorIsEstablished() {
            return true;
        }

        @Override
        public Optional<MirrorTopic> toMirror(long timeMs) {
            return Optional.of(MirrorTopic.mirror(this, timeMs, this.mirrorStartOffsets()));
        }

        @Override
        public Optional<MirrorTopic> toStopped(List<Long> stoppedLogEndOffsets, List<Integer> stoppedEpochs, long timeMs, long stoppedSequenceNumber) {
            throw new UnsupportedVersionException("Cannot stop a pending restore mirror topic");
        }

        @Override
        public Optional<MirrorTopic> toPaused(boolean linkLevel, long timeMs) {
            return Optional.of(MirrorTopic.paused(this, timeMs, !linkLevel, linkLevel, this.mirrorState(), this.mirrorStartOffsets, Errors.NONE.code(), null));
        }

        @Override
        public Optional<MirrorTopic> toUnpaused(boolean linkLevel, long timeMs) {
            return Optional.empty();
        }

        @Override
        public Optional<MirrorTopic> toPendingStopped(boolean synchronize, long timeMs) {
            if (synchronize) {
                throw new InvalidRequestException("Cannot promote a PendingRestoreMirror");
            }
            return Optional.of(MirrorTopic.pendingStopped(this, timeMs, false));
        }

        @Override
        public List<Long> mirrorStartOffsets() {
            return this.mirrorStartOffsets;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PendingRestoreMirrorTopic that = (PendingRestoreMirrorTopic)o;
            return Objects.equals(this.mirrorStartOffsets, that.mirrorStartOffsets);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.mirrorStartOffsets);
        }

        public String toString() {
            return "PendingRestoreMirrorTopic{linkId=" + this.linkId() + ", linkName=" + this.linkName() + ", topicId=" + this.topicId() + ", topicName=" + this.topicName() + ", sourceTopicId=" + this.sourceTopicId() + ", sourceTopicName=" + this.sourceTopicName() + ", mirrorState=" + (Object)((Object)this.mirrorState()) + ", mirrorStartOffsets=" + this.mirrorStartOffsets + ", stoppedSequenceNumber=" + this.stoppedSequenceNumber() + ", timeMs=" + this.timeMs() + '}';
        }
    }

    public static final class PendingSetupForRestoreMirrorTopic
    extends BaseMirrorTopic
    implements MirrorTopic {
        private final List<Long> truncationOffsets;
        private final List<Integer> truncationEpochs;

        public PendingSetupForRestoreMirrorTopic(Uuid linkId, String linkName, Uuid topicId, String topicName, Uuid sourceTopicId, String sourceTopicName, List<Long> truncationOffsets, List<Integer> truncationEpochs, long stoppedSequenceNumber, long timeMs) {
            super(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, State.PENDING_SETUP_FOR_RESTORE, stoppedSequenceNumber, timeMs);
            this.truncationOffsets = truncationOffsets;
            this.truncationEpochs = truncationEpochs;
        }

        public static PendingSetupForRestoreMirrorTopic fromRecord(MirrorTopicRecord record) {
            if (!State.fromStateName(record.mirrorTopicState()).equals((Object)State.PENDING_SETUP_FOR_RESTORE)) {
                throw new IllegalStateException("PendingRestoreMirrorTopic can be created only with state PENDING_SETUP_FOR_RESTORE");
            }
            return new PendingSetupForRestoreMirrorTopic(record.clusterLinkId(), record.clusterLinkName(), record.topicId(), record.topicName(), record.sourceTopicId(), record.sourceTopicName(), record.truncationOffsets(), record.truncationEpochs(), record.stoppedSequenceNumber(), record.timeMs());
        }

        @Override
        public boolean mirrorIsEstablished() {
            return true;
        }

        @Override
        public Optional<MirrorTopic> toStopped(List<Long> stoppedLogEndOffsets, List<Integer> stoppedEpochs, long timeMs, long stoppedSequenceNumber) {
            throw new UnsupportedVersionException("Cannot stop a pending setup for restore mirror topic");
        }

        @Override
        public Optional<MirrorTopic> toPaused(boolean linkLevel, long timeMs) {
            throw new InvalidRequestException("Topic is not mirrored");
        }

        @Override
        public Optional<MirrorTopic> toUnpaused(boolean linkLevel, long timeMs) {
            throw new InvalidRequestException("Topic is not mirrored");
        }

        @Override
        public Optional<MirrorTopic> toFailedMirror(short mirrorTopicError, long timeMs) {
            return Optional.of(MirrorTopic.failed(this, timeMs, mirrorTopicError));
        }

        @Override
        public Optional<MirrorTopic> toPendingStopped(boolean synchronize, long timeMs) {
            if (synchronize) {
                throw new InvalidRequestException("Cannot promote a PendingSetupForRestoreMirrorTopic");
            }
            return Optional.of(MirrorTopic.pendingStopped(this, timeMs, false));
        }

        @Override
        public Optional<MirrorTopic> toPendingRestore(List<Long> mirrorStartOffsets, long timeMs) {
            return Optional.of(MirrorTopic.pendingRestoreMirror(this, timeMs, mirrorStartOffsets));
        }

        public List<Long> truncationOffsets() {
            return this.truncationOffsets;
        }

        public List<Integer> truncationEpochs() {
            return this.truncationEpochs;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PendingSetupForRestoreMirrorTopic that = (PendingSetupForRestoreMirrorTopic)o;
            return Objects.equals(this.truncationOffsets, that.truncationOffsets) && Objects.equals(this.truncationEpochs, that.truncationEpochs);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.truncationOffsets, this.truncationEpochs);
        }

        public String toString() {
            return "PendingSetupForRestoreMirrorTopic{linkId=" + this.linkId() + ", linkName=" + this.linkName() + ", topicId=" + this.topicId() + ", topicName=" + this.topicName() + ", sourceTopicId=" + this.sourceTopicId() + ", sourceTopicName=" + this.sourceTopicName() + ", mirrorState=" + (Object)((Object)this.mirrorState()) + ", truncationOffsets=" + this.truncationOffsets + ", truncationEpochs=" + this.truncationEpochs + ", stoppedSequenceNumber=" + this.stoppedSequenceNumber() + ", timeMs=" + this.timeMs() + '}';
        }
    }

    public static final class PendingSynchronizeMirrorTopic
    extends BaseMirrorTopic
    implements MirrorTopic {
        private final State remoteMirrorNextState;

        public PendingSynchronizeMirrorTopic(Uuid linkId, String linkName, Uuid topicId, String topicName, Uuid sourceTopicId, String sourceTopicName, long stoppedSequenceNumber, long timeMs, State remoteMirrorNextState) {
            super(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, State.PENDING_SYNCHRONIZE, stoppedSequenceNumber, timeMs);
            if (remoteMirrorNextState == null) {
                throw new InvalidRequestException("Cannot have null NextState for PendingSynchronizeMirrorTopic");
            }
            this.remoteMirrorNextState = remoteMirrorNextState;
        }

        @Override
        public boolean mirrorIsEstablished() {
            return true;
        }

        public static PendingSynchronizeMirrorTopic fromRecord(MirrorTopicRecord record) {
            if (!State.fromStateName(record.mirrorTopicState()).equals((Object)State.PENDING_SYNCHRONIZE)) {
                throw new IllegalStateException("PendingSynchronizeMirrorTopic can be created only with state PENDING_SYNCHRONIZE");
            }
            State remoteMirrorNextState = State.fromStateName(record.nextState());
            return new PendingSynchronizeMirrorTopic(record.clusterLinkId(), record.clusterLinkName(), record.topicId(), record.topicName(), record.sourceTopicId(), record.sourceTopicName(), record.stoppedSequenceNumber(), record.timeMs(), remoteMirrorNextState);
        }

        @Override
        public Optional<MirrorTopic> toStopped(List<Long> stoppedLogEndOffsets, List<Integer> stoppedEpochs, long timeMs, long stoppedSequenceNumber) {
            throw new UnsupportedVersionException("Cannot stop a pending synchronize mirror topic");
        }

        @Override
        public Optional<MirrorTopic> toPaused(boolean linkLevel, long timeMs) {
            return Optional.of(MirrorTopic.paused(this, timeMs, !linkLevel, linkLevel, this.mirrorState(), this.mirrorStartOffsets(), Errors.NONE.code(), this.remoteMirrorNextState()));
        }

        @Override
        public Optional<MirrorTopic> toUnpaused(boolean linkLevel, long timeMs) {
            return Optional.empty();
        }

        @Override
        public Optional<MirrorTopic> toPendingStopped(boolean synchronize, long timeMs) {
            return Optional.of(MirrorTopic.pendingStopped(this, timeMs, synchronize));
        }

        @Override
        public Optional<MirrorTopic> toFailedMirror(short mirrorTopicError, long timeMs) {
            return Optional.of(MirrorTopic.failed(this, timeMs, mirrorTopicError));
        }

        @Override
        public Optional<MirrorTopic> toMirror(long timeMs) {
            return Optional.of(MirrorTopic.mirror(this, timeMs, this.mirrorStartOffsets()));
        }

        public State remoteMirrorNextState() {
            return this.remoteMirrorNextState;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PendingSynchronizeMirrorTopic that = (PendingSynchronizeMirrorTopic)o;
            return this.remoteMirrorNextState.equals((Object)that.remoteMirrorNextState);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.remoteMirrorNextState});
        }

        public String toString() {
            return "PendingSynchronizeMirrorTopic{linkId=" + this.linkId() + ", linkName=" + this.linkName() + ", topicId=" + this.topicId() + ", topicName=" + this.topicName() + ", sourceTopicId=" + this.sourceTopicId() + ", sourceTopicName=" + this.sourceTopicName() + ", mirrorState=" + (Object)((Object)this.mirrorState()) + ", stoppedSequenceNumber=" + this.stoppedSequenceNumber() + ", timeMs=" + this.timeMs() + ", remoteMirrorNextState=" + (Object)((Object)this.remoteMirrorNextState) + '}';
        }
    }

    public static final class PendingMirrorTopic
    extends BaseMirrorTopic
    implements MirrorTopic {
        private final State nextState;

        public PendingMirrorTopic(Uuid linkId, String linkName, Uuid topicId, String topicName, Uuid sourceTopicId, String sourceTopicName, long stoppedSequenceNumber, long timeMs, State nextState) {
            super(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, State.PENDING_MIRROR, stoppedSequenceNumber, timeMs);
            if (nextState == null) {
                throw new InvalidRequestException("Cannot have null NextState for PendingMirrorTopic");
            }
            this.nextState = nextState;
        }

        @Override
        public boolean mirrorIsEstablished() {
            return true;
        }

        public static PendingMirrorTopic fromRecord(MirrorTopicRecord record) {
            if (!State.fromStateName(record.mirrorTopicState()).equals((Object)State.PENDING_MIRROR)) {
                throw new IllegalStateException("PendingMirrorTopic can be created only with state PENDING_MIRROR");
            }
            State state = State.fromStateName(record.nextState());
            return new PendingMirrorTopic(record.clusterLinkId(), record.clusterLinkName(), record.topicId(), record.topicName(), record.sourceTopicId(), record.sourceTopicName(), record.stoppedSequenceNumber(), record.timeMs(), state);
        }

        public State nextState() {
            return this.nextState;
        }

        @Override
        public Optional<MirrorTopic> toStopped(List<Long> stoppedLogEndOffsets, List<Integer> stoppedEpochs, long timeMs, long stoppedSequenceNumber) {
            throw new InvalidRequestException("Cannot stop pending mirror topic");
        }

        @Override
        public Optional<MirrorTopic> toPaused(boolean linkLevel, long timeMs) {
            return Optional.of(MirrorTopic.paused(this, timeMs, !linkLevel, linkLevel, State.MIRROR, this.mirrorStartOffsets(), Errors.NONE.code(), null));
        }

        @Override
        public Optional<MirrorTopic> toUnpaused(boolean linkLevel, long timeMs) {
            return Optional.empty();
        }

        @Override
        public Optional<MirrorTopic> toPendingStopped(boolean synchronize, long timeMs) {
            if (synchronize) {
                throw new InvalidRequestException("Cannot promote a PendingMirror");
            }
            return Optional.of(MirrorTopic.pendingStopped(this, timeMs, false));
        }

        @Override
        public Optional<MirrorTopic> toMirror(long timeMs) {
            return Optional.of(MirrorTopic.mirror(this, timeMs, this.mirrorStartOffsets()));
        }

        @Override
        public Optional<MirrorTopic> toFailedMirror(short mirrorTopicError, long timeMs) {
            return Optional.of(MirrorTopic.failed(this, timeMs, mirrorTopicError));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PendingMirrorTopic that = (PendingMirrorTopic)o;
            return Objects.equals((Object)this.nextState, (Object)that.nextState);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.nextState});
        }

        public String toString() {
            return "PendingMirrorTopic{linkId=" + this.linkId() + ", linkName=" + this.linkName() + ", topicId=" + this.topicId() + ", topicName=" + this.topicName() + ", sourceTopicId=" + this.sourceTopicId() + ", sourceTopicName=" + this.sourceTopicName() + ", mirrorState=" + (Object)((Object)this.mirrorState()) + ", stoppedSequenceNumber=" + this.stoppedSequenceNumber() + ", timeMs=" + this.timeMs() + ", nextState=" + (Object)((Object)this.nextState()) + '}';
        }
    }

    public static final class StoppedMirrorTopic
    extends BaseMirrorTopic
    implements MirrorTopic {
        private final List<Long> offsets;
        private final List<Integer> stoppedEpochs;

        public StoppedMirrorTopic(Uuid linkId, String linkName, Uuid topicId, String topicName, Uuid sourceTopicId, String sourceTopicName, long stoppedSequenceNumber, long timeMs, List<Long> offsets, List<Integer> stoppedEpochs) {
            super(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, State.STOPPED, stoppedSequenceNumber, timeMs);
            this.offsets = offsets == null ? Collections.emptyList() : Collections.unmodifiableList(offsets);
            this.stoppedEpochs = stoppedEpochs == null ? Collections.emptyList() : Collections.unmodifiableList(stoppedEpochs);
        }

        @Override
        public boolean mirrorIsEstablished() {
            return false;
        }

        public static StoppedMirrorTopic fromRecord(MirrorTopicRecord record) {
            if (!State.fromStateName(record.mirrorTopicState()).equals((Object)State.STOPPED)) {
                throw new IllegalStateException();
            }
            return new StoppedMirrorTopic(record.clusterLinkId(), record.clusterLinkName(), record.topicId(), record.topicName(), record.sourceTopicId(), record.sourceTopicName(), record.stoppedSequenceNumber(), record.timeMs(), record.stoppedLogEndOffsets(), record.stoppedEpochs());
        }

        @Override
        public Optional<MirrorTopic> toStopped(List<Long> stoppedLogEndOffsets, List<Integer> stoppedEpochs, long timeMs, long stoppedSequenceNumber) {
            return Optional.empty();
        }

        @Override
        public Optional<MirrorTopic> toPaused(boolean linkLevel, long timeMs) {
            throw new InvalidRequestException("Topic is not mirrored");
        }

        @Override
        public Optional<MirrorTopic> toUnpaused(boolean linkLevel, long timeMs) {
            throw new InvalidRequestException("Topic is not mirrored");
        }

        @Override
        public Optional<MirrorTopic> toPendingStopped(boolean synchronize, long timeMs) {
            throw new InvalidRequestException("Topic " + this.topicName() + " in link " + this.linkName() + " is already stopped.");
        }

        @Override
        public Optional<MirrorTopic> toPendingMirror(Uuid sourceTopicId, Uuid linkId, long timeMs, State nextState, long stoppedSequenceNumber) {
            if (!linkId.equals((Object)this.linkId())) {
                throw new InvalidRequestException("Invalid link id" + linkId + " found while converting the mirror topic state to PendingMirror");
            }
            if (!sourceTopicId.equals((Object)this.sourceTopicId())) {
                throw new InvalidRequestException("Invalid source topic id" + sourceTopicId + " found while converting the mirror topic state to PendingMirror");
            }
            return Optional.of(MirrorTopic.pendingMirror(this, timeMs, nextState, stoppedSequenceNumber));
        }

        @Override
        public Optional<MirrorTopic> toPendingSetupForRestore(Uuid linkId, Uuid sourceTopicId, List<Integer> truncationEpochs, List<Long> truncationOffsets, long stoppedSequenceNumber, long timeMs) {
            if (!linkId.equals((Object)this.linkId())) {
                throw new InvalidRequestException("Invalid link id" + linkId + " found while converting the mirror topic state to PendingSetupForRestoreMirror");
            }
            if (!sourceTopicId.equals((Object)this.sourceTopicId())) {
                throw new InvalidRequestException("Invalid source topic id" + sourceTopicId + " found while converting the mirror topic state to PendingSetupForRestoreMirror");
            }
            return Optional.of(MirrorTopic.pendingSetupForRestoreMirror(this, timeMs, truncationOffsets, truncationEpochs, stoppedSequenceNumber));
        }

        @Override
        public List<Long> mirrorStoppedOffsets() {
            return this.offsets;
        }

        @Override
        public List<Integer> mirrorStoppedEpochs() {
            return this.stoppedEpochs;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            StoppedMirrorTopic that = (StoppedMirrorTopic)o;
            return Objects.equals(this.offsets, that.offsets);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.offsets);
        }

        public String toString() {
            return "StoppedMirrorTopic{linkId=" + this.linkId() + ", linkName=" + this.linkName() + ", topicId=" + this.topicId() + ", topicName=" + this.topicName() + ", sourceTopicId=" + this.sourceTopicId() + ", sourceTopicName=" + this.sourceTopicName() + ", mirrorState=" + (Object)((Object)this.mirrorState()) + ", stoppedSequenceNumber=" + this.stoppedSequenceNumber() + ", timeMs=" + this.timeMs() + ", mirrorStoppedOffsets=" + this.mirrorStoppedOffsets() + '}';
        }
    }

    public static final class PendingStoppedMirrorTopic
    extends BaseMirrorTopic
    implements MirrorTopic {
        private final boolean promoted;

        public PendingStoppedMirrorTopic(Uuid linkId, String linkName, Uuid topicId, String topicName, Uuid sourceTopicId, String sourceTopicName, long stoppedSequenceNumber, long timeMs, boolean promoted) {
            super(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, State.PENDING_STOPPED, stoppedSequenceNumber, timeMs);
            this.promoted = promoted;
        }

        @Override
        public boolean mirrorIsEstablished() {
            return true;
        }

        public static PendingStoppedMirrorTopic fromRecord(MirrorTopicRecord record) {
            if (!State.fromStateName(record.mirrorTopicState()).equals((Object)State.PENDING_STOPPED)) {
                throw new IllegalStateException();
            }
            return new PendingStoppedMirrorTopic(record.clusterLinkId(), record.clusterLinkName(), record.topicId(), record.topicName(), record.sourceTopicId(), record.sourceTopicName(), record.stoppedSequenceNumber(), record.timeMs(), record.promoted());
        }

        @Override
        public Optional<MirrorTopic> toStopped(List<Long> stoppedLogEndOffsets, List<Integer> stoppedEpochs, long timeMs, long stoppedSequenceNumber) {
            if (stoppedLogEndOffsets != null && !stoppedLogEndOffsets.isEmpty()) {
                return Optional.of(MirrorTopic.stopped(this, timeMs, stoppedLogEndOffsets, stoppedEpochs, stoppedSequenceNumber));
            }
            throw new InvalidRequestException("Invalid stopped long end offsets provided to stop the pending-stopped mirror topic");
        }

        @Override
        public Optional<MirrorTopic> toPaused(boolean linkLevel, long timeMs) {
            throw new InvalidRequestException("Topic is not mirrored");
        }

        @Override
        public Optional<MirrorTopic> toUnpaused(boolean linkLevel, long timeMs) {
            throw new InvalidRequestException("Topic is not mirrored");
        }

        @Override
        public Optional<MirrorTopic> toPendingStopped(boolean synchronize, long timeMs) {
            if (this.promoted && !synchronize) {
                return Optional.of(MirrorTopic.pendingStopped(this, timeMs, false));
            }
            throw new InvalidRequestException("Topic " + this.topicName() + " in link " + this.linkName() + " is already stopped.");
        }

        @Override
        public Optional<MirrorTopic> toMirror(long timeMs) {
            return Optional.of(MirrorTopic.mirror(this, timeMs, this.mirrorStartOffsets()));
        }

        public boolean promoted() {
            return this.promoted;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PendingStoppedMirrorTopic that = (PendingStoppedMirrorTopic)o;
            return this.promoted == that.promoted;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.promoted);
        }

        public String toString() {
            return "PendingStoppedMirrorTopic{linkId=" + this.linkId() + ", linkName=" + this.linkName() + ", topicId=" + this.topicId() + ", topicName=" + this.topicName() + ", sourceTopicId=" + this.sourceTopicId() + ", sourceTopicName=" + this.sourceTopicName() + ", mirrorState=" + (Object)((Object)this.mirrorState()) + ", stoppedSequenceNumber=" + this.stoppedSequenceNumber() + ", timeMs=" + this.timeMs() + ", promoted=" + this.promoted + '}';
        }
    }

    public static final class PausedMirrorTopic
    extends BaseMirrorTopic
    implements MirrorTopic {
        private final boolean topicLevel;
        private final boolean linkLevel;
        private final State prevToPausedState;
        private final List<Long> mirrorStartOffsets;
        private final MirrorTopicError mirrorTopicError;
        private final State pendingSynchronizeNextState;

        public PausedMirrorTopic(Uuid linkId, String linkName, Uuid topicId, String topicName, Uuid sourceTopicId, String sourceTopicName, List<Long> mirrorStartOffsets, long stoppedSequenceNumber, long timeMs, boolean topicLevel, boolean linkLevel, State prevToPausedState, MirrorTopicError error, State pendingSynchronizeNextState) {
            super(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, State.PAUSED, stoppedSequenceNumber, timeMs);
            this.topicLevel = topicLevel;
            this.linkLevel = linkLevel;
            this.prevToPausedState = prevToPausedState;
            this.mirrorStartOffsets = mirrorStartOffsets != null ? Collections.unmodifiableList(mirrorStartOffsets) : Collections.emptyList();
            this.mirrorTopicError = MirrorTopic.wasFailed(prevToPausedState) ? error : MirrorTopicError.NO_ERROR;
            this.pendingSynchronizeNextState = pendingSynchronizeNextState;
        }

        public static PausedMirrorTopic fromRecord(MirrorTopicRecord record) {
            if (!State.fromStateName(record.mirrorTopicState()).equals((Object)State.PAUSED)) {
                throw new IllegalStateException();
            }
            State prevState = State.fromStateName(record.previousToPausedState());
            MirrorTopicError error = MirrorTopicError.forCode((short)record.mirrorTopicError(), (boolean)MirrorTopic.wasFailed(prevState));
            State pendingSynchronize = record.nextState() == null ? null : State.fromStateName(record.nextState());
            return new PausedMirrorTopic(record.clusterLinkId(), record.clusterLinkName(), record.topicId(), record.topicName(), record.sourceTopicId(), record.sourceTopicName(), record.mirrorStartOffsets(), record.stoppedSequenceNumber(), record.timeMs(), record.topicLevelPause(), record.linkLevelPause(), prevState, error, pendingSynchronize);
        }

        public boolean topicLevel() {
            return this.topicLevel;
        }

        public boolean linkLevel() {
            return this.linkLevel;
        }

        public State prevToPausedState() {
            return this.prevToPausedState;
        }

        public State pendingSynchronizeNextState() {
            return this.pendingSynchronizeNextState;
        }

        @Override
        public List<Long> mirrorStartOffsets() {
            return this.mirrorStartOffsets;
        }

        @Override
        public boolean mirrorIsEstablished() {
            return true;
        }

        @Override
        public Optional<MirrorTopic> clearMirrorStartOffsets(long timeMs) {
            if (this.mirrorStartOffsets.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(MirrorTopic.paused(this, timeMs, this.topicLevel, this.linkLevel, this.prevToPausedState, Collections.emptyList(), this.mirrorTopicError.code(), this.pendingSynchronizeNextState));
        }

        @Override
        public Optional<MirrorTopic> toStopped(List<Long> stoppedLogEndOffsets, List<Integer> stoppedEpochs, long timeMs, long stoppedSequenceNumber) {
            throw new InvalidRequestException("Cannot stop paused mirror topic");
        }

        @Override
        public Optional<MirrorTopic> toPaused(boolean isLinkLevel, long timeMs) {
            if (isLinkLevel && !this.linkLevel) {
                return Optional.of(MirrorTopic.paused(this, timeMs, this.topicLevel, true, this.prevToPausedState, Collections.emptyList(), this.mirrorTopicError.code(), this.pendingSynchronizeNextState));
            }
            if (!isLinkLevel && !this.topicLevel) {
                return Optional.of(MirrorTopic.paused(this, timeMs, true, this.linkLevel, this.prevToPausedState, Collections.emptyList(), this.mirrorTopicError.code(), this.pendingSynchronizeNextState));
            }
            return Optional.empty();
        }

        @Override
        public Optional<MirrorTopic> toUnpaused(boolean isLinkLevel, long timeMs) {
            if (this.linkLevel && this.topicLevel) {
                return Optional.of(MirrorTopic.paused(this, timeMs, isLinkLevel, !isLinkLevel, this.prevToPausedState, this.mirrorStartOffsets, this.mirrorTopicError.code(), this.pendingSynchronizeNextState));
            }
            if (isLinkLevel == this.linkLevel && isLinkLevel != this.topicLevel) {
                if (this.prevToPausedState == State.FAILED) {
                    return Optional.of(MirrorTopic.failed(this, timeMs, this.mirrorTopicError.code()));
                }
                if (this.prevToPausedState == State.PENDING_REPAIR) {
                    return Optional.of(MirrorTopic.pendingRepairMirror(this, timeMs, this.mirrorTopicError.code()));
                }
                if (this.prevToPausedState == State.PENDING_SYNCHRONIZE) {
                    return Optional.of(MirrorTopic.pendingSynchronize(this, timeMs, this.pendingSynchronizeNextState));
                }
                if (this.prevToPausedState == State.PENDING_RESTORE) {
                    return Optional.of(MirrorTopic.pendingRestoreMirror(this, timeMs, this.mirrorStartOffsets));
                }
                return Optional.of(MirrorTopic.mirror(this, timeMs, this.mirrorStartOffsets));
            }
            return Optional.empty();
        }

        @Override
        public Optional<MirrorTopic> toPendingStopped(boolean synchronize, long timeMs) {
            return Optional.of(MirrorTopic.pendingStopped(this, timeMs, synchronize));
        }

        @Override
        public MirrorTopicError mirrorTopicError() {
            return this.mirrorTopicError;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PausedMirrorTopic that = (PausedMirrorTopic)o;
            return this.topicLevel == that.topicLevel && this.linkLevel == that.linkLevel && this.prevToPausedState == that.prevToPausedState && Objects.equals(this.mirrorStartOffsets, that.mirrorStartOffsets) && Objects.equals(this.mirrorTopicError, that.mirrorTopicError);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.topicLevel, this.linkLevel, this.prevToPausedState, this.mirrorStartOffsets, this.mirrorTopicError});
        }

        public String toString() {
            return "PausedMirrorTopic{linkId=" + this.linkId() + ", linkName=" + this.linkName() + ", topicId=" + this.topicId() + ", topicName=" + this.topicName() + ", sourceTopicId=" + this.sourceTopicId() + ", sourceTopicName=" + this.sourceTopicName() + ", mirrorState=" + (Object)((Object)this.mirrorState()) + ", stoppedSequenceNumber=" + this.stoppedSequenceNumber() + ", timeMs=" + this.timeMs() + ", topicLevel=" + this.topicLevel + ", linkLevel=" + this.linkLevel + ", prevToPausedState=" + (Object)((Object)this.prevToPausedState) + ", failureReason=" + this.mirrorTopicError + '}';
        }
    }

    public static final class FailedMirrorTopic
    extends BaseMirrorTopic
    implements MirrorTopic {
        private final MirrorTopicError error;

        public FailedMirrorTopic(Uuid linkId, String linkName, Uuid topicId, String topicName, Uuid sourceTopicId, String sourceTopicName, long stoppedSequenceNumber, long timeMs, MirrorTopicError error) {
            super(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, State.FAILED, stoppedSequenceNumber, timeMs);
            this.error = error;
        }

        public static FailedMirrorTopic fromRecord(MirrorTopicRecord record) {
            if (!State.fromStateName(record.mirrorTopicState()).equals((Object)State.FAILED)) {
                throw new IllegalStateException("FailedMirrorTopic can be created only with state FAILED");
            }
            return new FailedMirrorTopic(record.clusterLinkId(), record.clusterLinkName(), record.topicId(), record.topicName(), record.sourceTopicId(), record.sourceTopicName(), record.stoppedSequenceNumber(), record.timeMs(), MirrorTopicError.forCode((short)record.mirrorTopicError(), (boolean)true));
        }

        @Override
        public Optional<MirrorTopic> toStopped(List<Long> stoppedLogEndOffsets, List<Integer> stoppedEpochs, long timeMs, long stoppedSequenceNumber) {
            throw new InvalidRequestException("Cannot stop failed mirror topic");
        }

        @Override
        public Optional<MirrorTopic> toPaused(boolean linkLevel, long timeMs) {
            return Optional.of(MirrorTopic.paused(this, timeMs, !linkLevel, linkLevel, this.mirrorState(), this.mirrorStartOffsets(), this.error.code(), null));
        }

        @Override
        public Optional<MirrorTopic> toUnpaused(boolean linkLevel, long timeMs) {
            return Optional.empty();
        }

        @Override
        public Optional<MirrorTopic> toPendingRepair(long timeMs) {
            return Optional.of(MirrorTopic.pendingRepairMirror(this, timeMs, this.error.code()));
        }

        @Override
        public Optional<MirrorTopic> toPendingStopped(boolean synchronize, long timeMs) {
            if (synchronize) {
                throw new InvalidRequestException("Cannot promote mirror topic " + this.topicName() + " as it is in a failed state.");
            }
            return Optional.of(MirrorTopic.pendingStopped(this, timeMs, false));
        }

        @Override
        public MirrorTopicError mirrorTopicError() {
            return this.error;
        }

        @Override
        public boolean mirrorIsEstablished() {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FailedMirrorTopic that = (FailedMirrorTopic)o;
            return this.error == that.error;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.error);
        }

        public String toString() {
            return "FailedMirrorTopic{linkId=" + this.linkId() + ", linkName=" + this.linkName() + ", topicId=" + this.topicId() + ", topicName=" + this.topicName() + ", sourceTopicId=" + this.sourceTopicId() + ", sourceTopicName=" + this.sourceTopicName() + ", mirrorState=" + (Object)((Object)this.mirrorState()) + ", error=" + this.error + ", stoppedSequenceNumber=" + this.stoppedSequenceNumber() + ", timeMs=" + this.timeMs() + '}';
        }
    }

    public static final class ActiveMirrorTopic
    extends BaseMirrorTopic
    implements MirrorTopic {
        private final List<Long> mirrorStartOffsets;

        public ActiveMirrorTopic(Uuid linkId, String linkName, Uuid topicId, String topicName, Uuid sourceTopicId, String sourceTopicName, List<Long> mirrorStartOffsets, long stoppedSequenceNumber, long timeMs) {
            super(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, State.MIRROR, stoppedSequenceNumber, timeMs);
            this.mirrorStartOffsets = mirrorStartOffsets != null ? Collections.unmodifiableList(mirrorStartOffsets) : Collections.emptyList();
        }

        public static ActiveMirrorTopic fromRecord(MirrorTopicRecord record) {
            if (!State.fromStateName(record.mirrorTopicState()).equals((Object)State.MIRROR)) {
                throw new IllegalStateException("ActiveMirrorTopic can be created only with state MIRROR");
            }
            return new ActiveMirrorTopic(record.clusterLinkId(), record.clusterLinkName(), record.topicId(), record.topicName(), record.sourceTopicId(), record.sourceTopicName(), record.mirrorStartOffsets(), record.stoppedSequenceNumber(), record.timeMs());
        }

        @Override
        public Optional<MirrorTopic> clearMirrorStartOffsets(long timeMs) {
            if (!this.mirrorStartOffsets.isEmpty()) {
                return Optional.of(MirrorTopic.mirror(this, timeMs, Collections.emptyList()));
            }
            return Optional.empty();
        }

        @Override
        public Optional<MirrorTopic> toStopped(List<Long> stoppedLogEndOffsets, List<Integer> stoppedEpochs, long timeMs, long stoppedSequenceNumber) {
            throw new InvalidRequestException("Cannot stop active mirror topic");
        }

        @Override
        public Optional<MirrorTopic> toPaused(boolean linkLevel, long timeMs) {
            return Optional.of(MirrorTopic.paused(this, timeMs, !linkLevel, linkLevel, this.mirrorState(), this.mirrorStartOffsets, Errors.NONE.code(), null));
        }

        @Override
        public Optional<MirrorTopic> toUnpaused(boolean linkLevel, long timeMs) {
            return Optional.empty();
        }

        @Override
        public Optional<MirrorTopic> toPendingStopped(boolean synchronize, long timeMs) {
            return Optional.of(MirrorTopic.pendingStopped(this, timeMs, synchronize));
        }

        @Override
        public Optional<MirrorTopic> toPendingSynchronize(State remoteMirrorNextState, long timeMs) {
            return Optional.of(MirrorTopic.pendingSynchronize(this, timeMs, remoteMirrorNextState));
        }

        @Override
        public List<Long> mirrorStartOffsets() {
            return this.mirrorStartOffsets;
        }

        @Override
        public boolean mirrorIsEstablished() {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ActiveMirrorTopic that = (ActiveMirrorTopic)o;
            return Objects.equals(this.mirrorStartOffsets, that.mirrorStartOffsets);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.mirrorStartOffsets);
        }

        public String toString() {
            return "ActiveMirrorTopic{linkId=" + this.linkId() + ", linkName=" + this.linkName() + ", topicId=" + this.topicId() + ", topicName=" + this.topicName() + ", sourceTopicId=" + this.sourceTopicId() + ", sourceTopicName=" + this.sourceTopicName() + ", mirrorState=" + (Object)((Object)this.mirrorState()) + ", mirrorStartOffsets=" + this.mirrorStartOffsets + ", stoppedSequenceNumber=" + this.stoppedSequenceNumber() + ", timeMs=" + this.timeMs() + '}';
        }
    }

    public static abstract class BaseMirrorTopic
    implements MirrorTopic {
        private final Uuid linkId;
        private final String linkName;
        private final Uuid topicId;
        private final String topicName;
        private final Uuid sourceTopicId;
        private final String sourceTopicName;
        private final State mirrorState;
        private final long stoppedSequenceNumber;
        private final long timeMs;

        public BaseMirrorTopic(Uuid linkId, String linkName, Uuid topicId, String topicName, Uuid sourceTopicId, String sourceTopicName, State mirrorState, long stoppedSequenceNumber, long timeMs) {
            this.linkId = linkId;
            this.linkName = linkName;
            this.topicId = topicId;
            this.topicName = topicName;
            this.sourceTopicId = sourceTopicId;
            this.sourceTopicName = sourceTopicName;
            this.mirrorState = mirrorState;
            this.stoppedSequenceNumber = stoppedSequenceNumber;
            this.timeMs = timeMs;
        }

        @Override
        public Uuid linkId() {
            return this.linkId;
        }

        @Override
        public String linkName() {
            return this.linkName;
        }

        @Override
        public Uuid topicId() {
            return this.topicId;
        }

        @Override
        public String topicName() {
            return this.topicName;
        }

        @Override
        public Uuid sourceTopicId() {
            return this.sourceTopicId;
        }

        @Override
        public long stoppedSequenceNumber() {
            return this.stoppedSequenceNumber;
        }

        @Override
        public List<Long> mirrorStartOffsets() {
            return Collections.emptyList();
        }

        @Override
        public Optional<MirrorTopic> clearMirrorStartOffsets(long timeMs) {
            return Optional.empty();
        }

        @Override
        public Optional<MirrorTopic> toPendingMirror(Uuid sourceTopicId, Uuid linkId, long timeMs, State nextState, long stoppedSequenceNumber) {
            throw new InvalidRequestException("Cannot convert the topic to PendingMirror since it is in " + this.mirrorState().stateName + " state");
        }

        @Override
        public Optional<MirrorTopic> toMirror(long timeMs) {
            throw new InvalidRequestException("Cannot convert the topic state to a Mirror state since it is in " + this.mirrorState.stateName + " state");
        }

        @Override
        public Optional<MirrorTopic> toPendingRepair(long timeMs) {
            throw new InvalidRequestException("Cannot repair mirror topic since it is in " + this.mirrorState.stateName + " state");
        }

        @Override
        public Optional<MirrorTopic> toFailedMirror(short mirrorTopicError, long timeMs) {
            throw new InvalidRequestException("Cannot fail a mirror in " + this.mirrorState.stateName + " state");
        }

        @Override
        public Optional<MirrorTopic> toPendingSynchronize(State remoteMirrorNextState, long timeMs) {
            throw new InvalidRequestException("Cannot convert the topic to PendingSynchronize since it is in " + this.mirrorState.stateName + " state");
        }

        @Override
        public Optional<MirrorTopic> toPendingSetupForRestore(Uuid linkId, Uuid sourceTopicId, List<Integer> truncationEpochs, List<Long> truncationOffsets, long stoppedSequenceNumber, long timeMs) {
            throw new InvalidRequestException("Cannot convert the topic to PendingSetupForRestoreMirror since it is in " + this.mirrorState.stateName + " state");
        }

        @Override
        public Optional<MirrorTopic> toPendingRestore(List<Long> mirrorStartOffsets, long timeMs) {
            throw new InvalidRequestException("Cannot convert the topic to PendingRestoreMirror since it is in " + this.mirrorState.stateName + " state");
        }

        @Override
        public String sourceTopicName() {
            return this.sourceTopicName;
        }

        @Override
        public State mirrorState() {
            return this.mirrorState;
        }

        @Override
        public MirrorTopicError mirrorTopicError() {
            return MirrorTopicError.NO_ERROR;
        }

        @Override
        public long timeMs() {
            return this.timeMs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseMirrorTopic that = (BaseMirrorTopic)o;
            return this.timeMs == that.timeMs && Objects.equals(this.linkId, that.linkId) && Objects.equals(this.topicId, that.topicId) && Objects.equals(this.sourceTopicId, that.sourceTopicId) && Objects.equals(this.sourceTopicName, that.sourceTopicName) && this.stoppedSequenceNumber == that.stoppedSequenceNumber && this.mirrorState == that.mirrorState;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.linkId, this.topicId, this.sourceTopicId, this.sourceTopicName, this.mirrorState, this.stoppedSequenceNumber, this.timeMs});
        }
    }

    public static enum State {
        MIRROR("Mirror"),
        PAUSED("PausedMirror"),
        FAILED("FailedMirror"),
        PENDING_STOPPED("PendingStoppedMirror"),
        STOPPED("StoppedMirror"),
        PENDING_MIRROR("PendingMirror"),
        PENDING_SYNCHRONIZE("PendingSynchronizeMirror"),
        PENDING_REPAIR("PendingRepair"),
        PENDING_SETUP_FOR_RESTORE("PendingSetupForRestoreMirror"),
        PENDING_RESTORE("PendingRestoreMirror");

        private final String stateName;

        private State(String stateName) {
            this.stateName = stateName;
        }

        public String stateName() {
            return this.stateName;
        }

        public static State fromStateName(String stateName) {
            for (State state : State.values()) {
                if (!stateName.equals(state.stateName())) continue;
                return state;
            }
            throw new IllegalArgumentException("Unknown mirror topic state '" + stateName + "'.");
        }
    }
}

