/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.client.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.secretregistry.client.rest.entities.ErrorMessage;
import io.confluent.kafka.secretregistry.client.rest.entities.Secret;
import io.confluent.kafka.secretregistry.client.rest.entities.requests.RegisterSecretRequest;
import io.confluent.kafka.secretregistry.client.rest.entities.requests.RegisterSecretResponse;
import io.confluent.kafka.secretregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.secretregistry.client.rest.utils.UrlList;
import io.confluent.kafka.secretregistry.client.security.basicauth.BasicAuthCredentialProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestService {
    private static final Logger log = LoggerFactory.getLogger(RestService.class);
    private static final TypeReference<RegisterSecretResponse> REGISTER_RESPONSE_TYPE = new TypeReference<RegisterSecretResponse>(){};
    private static final TypeReference<JsonNode> GET_SECRET_ONLY_BY_VERSION_RESPONSE_TYPE = new TypeReference<JsonNode>(){};
    private static final TypeReference<Secret> GET_SECRET_BY_VERSION_RESPONSE_TYPE = new TypeReference<Secret>(){};
    private static final TypeReference<List<Secret>> ALL_SECRETS_RESPONSE_TYPE = new TypeReference<List<Secret>>(){};
    private static final TypeReference<List<Integer>> ALL_VERSIONS_RESPONSE_TYPE = new TypeReference<List<Integer>>(){};
    private static final TypeReference<List<String>> ALL_NAMES_RESPONSE_TYPE = new TypeReference<List<String>>(){};
    private static final TypeReference<Integer> DELETE_VERSION_RESPONSE_TYPE = new TypeReference<Integer>(){};
    private static final TypeReference<? extends List<Integer>> DELETE_KEY_RESPONSE_TYPE = new TypeReference<List<Integer>>(){};
    private static final TypeReference<? extends Set<String>> DELETE_PATH_RESPONSE_TYPE = new TypeReference<Set<String>>(){};
    private static final int HTTP_CONNECT_TIMEOUT_MS = 60000;
    private static final int HTTP_READ_TIMEOUT_MS = 60000;
    private static final int JSON_PARSE_ERROR_CODE = 50005;
    private static ObjectMapper jsonDeserializer = new ObjectMapper();
    static final Map<String, String> DEFAULT_REQUEST_PROPERTIES = new HashMap<String, String>();
    private UrlList baseUrls;
    private SSLSocketFactory sslSocketFactory;
    private BasicAuthCredentialProvider basicAuthCredentialProvider;
    private Map<String, String> httpHeaders;

    public RestService(UrlList baseUrls) {
        this.baseUrls = baseUrls;
    }

    public RestService(List<String> baseUrls) {
        this(new UrlList(baseUrls));
    }

    public RestService(String baseUrlConfig) {
        this(RestService.parseBaseUrl(baseUrlConfig));
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    private <T> T sendHttpRequest(String requestUrl, String method, byte[] requestBodyData, Map<String, String> requestProperties, TypeReference<T> responseFormat) throws IOException, RestClientException {
        log.debug("Sending {} to {}", (Object)method, (Object)requestUrl);
        HttpURLConnection connection = null;
        try {
            ErrorMessage errorMessage;
            InputStream is;
            int responseCode;
            URL url = this.url(requestUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(60000);
            connection.setReadTimeout(60000);
            this.setupSsl(connection);
            connection.setRequestMethod(method);
            this.setBasicAuthRequestHeader(connection);
            this.setCustomHeaders(connection);
            connection.setDoInput(true);
            for (Map.Entry<String, String> entry : requestProperties.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            connection.setUseCaches(false);
            if (requestBodyData != null) {
                connection.setDoOutput(true);
                try (OutputStream os = null;){
                    os = connection.getOutputStream();
                    os.write(requestBodyData);
                    os.flush();
                }
            }
            if ((responseCode = connection.getResponseCode()) == 200) {
                is = connection.getInputStream();
                Object result = jsonDeserializer.readValue(is, responseFormat);
                is.close();
                Object object = result;
                return (T)object;
            }
            if (responseCode == 204) {
                is = null;
                return (T)is;
            }
            InputStream es = connection.getErrorStream();
            try {
                errorMessage = (ErrorMessage)jsonDeserializer.readValue(es, ErrorMessage.class);
            }
            catch (JsonProcessingException e) {
                errorMessage = new ErrorMessage(50005, e.getMessage());
            }
            es.close();
            throw new RestClientException(errorMessage.getMessage(), responseCode, errorMessage.getErrorCode());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    URL url(String requestUrl) throws MalformedURLException {
        return new URL(requestUrl);
    }

    private void setupSsl(HttpURLConnection connection) {
        if (connection instanceof HttpsURLConnection && this.sslSocketFactory != null) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(this.sslSocketFactory);
        }
    }

    private <T> T httpRequest(String path, String method, byte[] requestBodyData, Map<String, String> requestProperties, TypeReference<T> responseFormat) throws IOException, RestClientException {
        int n = this.baseUrls.size();
        for (int i = 0; i < n; ++i) {
            String baseUrl = this.baseUrls.current();
            String requestUrl = RestService.buildRequestUrl(baseUrl, path);
            try {
                return this.sendHttpRequest(requestUrl, method, requestBodyData, requestProperties, responseFormat);
            }
            catch (IOException e) {
                this.baseUrls.fail(baseUrl);
                if (i != n - 1) continue;
                throw e;
            }
        }
        throw new IOException("Internal HTTP retry error");
    }

    static String buildRequestUrl(String baseUrl, String path) {
        return baseUrl.replaceFirst("/$", "") + "/" + path.replaceFirst("^/", "");
    }

    public int registerSecret(String secretString, String path, String key) throws IOException, RestClientException {
        RegisterSecretRequest request = new RegisterSecretRequest();
        request.setSecret(secretString);
        return this.registerSecret(request, path, key);
    }

    public int registerSecret(RegisterSecretRequest registerSecretRequest, String path, String key) throws IOException, RestClientException {
        return this.registerSecret(DEFAULT_REQUEST_PROPERTIES, registerSecretRequest, path, key);
    }

    public int registerSecret(Map<String, String> requestProperties, RegisterSecretRequest registerSecretRequest, String path, String key) throws IOException, RestClientException {
        String url = String.format("/secret/paths/%s/keys/%s/versions", path, key);
        RegisterSecretResponse response = this.httpRequest(url, "POST", registerSecretRequest.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, REGISTER_RESPONSE_TYPE);
        return response.getVersion();
    }

    public Secret getVersion(String path, String key, int version) throws IOException, RestClientException {
        return this.getVersion(DEFAULT_REQUEST_PROPERTIES, path, key, version);
    }

    public Secret getVersion(Map<String, String> requestProperties, String path, String key, int version) throws IOException, RestClientException {
        String url = String.format("/secret/paths/%s/keys/%s/versions/%d", path, key, version);
        Secret response = this.httpRequest(url, "GET", null, requestProperties, GET_SECRET_BY_VERSION_RESPONSE_TYPE);
        return response;
    }

    public Secret getLatestVersion(String path, String key) throws IOException, RestClientException {
        return this.getLatestVersion(DEFAULT_REQUEST_PROPERTIES, path, key);
    }

    public Secret getLatestVersion(Map<String, String> requestProperties, String path, String key) throws IOException, RestClientException {
        String url = String.format("/secret/paths/%s/keys/%s/versions/latest", path, key);
        Secret response = this.httpRequest(url, "GET", null, requestProperties, GET_SECRET_BY_VERSION_RESPONSE_TYPE);
        return response;
    }

    public String getVersionSecretOnly(String path, String key, int version) throws IOException, RestClientException {
        String url = String.format("/secret/paths/%s/keys/%s/versions/%d/secret", path, key, version);
        JsonNode response = this.httpRequest(url, "GET", null, DEFAULT_REQUEST_PROPERTIES, GET_SECRET_ONLY_BY_VERSION_RESPONSE_TYPE);
        return response.toString();
    }

    public String getLatestVersionSecretOnly(String path, String key) throws IOException, RestClientException {
        String url = String.format("/secret/paths/%s/keys/%s/versions/latest/secret", path, key);
        JsonNode response = this.httpRequest(url, "GET", null, DEFAULT_REQUEST_PROPERTIES, GET_SECRET_ONLY_BY_VERSION_RESPONSE_TYPE);
        return response.toString();
    }

    public List<Secret> getAllVersions(String path, String key) throws IOException, RestClientException {
        return this.getAllVersions(DEFAULT_REQUEST_PROPERTIES, path, key);
    }

    public List<Secret> getAllVersions(Map<String, String> requestProperties, String path, String key) throws IOException, RestClientException {
        String url = String.format("/secret/paths/%s/keys/%s", path, key);
        List<Secret> response = this.httpRequest(url, "GET", null, requestProperties, ALL_SECRETS_RESPONSE_TYPE);
        return response;
    }

    public List<Secret> getAllLatest(String path) throws IOException, RestClientException {
        return this.getAllLatest(DEFAULT_REQUEST_PROPERTIES, path);
    }

    public List<Secret> getAllLatest(Map<String, String> requestProperties, String path) throws IOException, RestClientException {
        String url = String.format("/secret/paths/%s", path);
        List<Secret> response = this.httpRequest(url, "GET", null, requestProperties, ALL_SECRETS_RESPONSE_TYPE);
        return response;
    }

    public List<Integer> listAllVersions(String path, String key) throws IOException, RestClientException {
        return this.listAllVersions(DEFAULT_REQUEST_PROPERTIES, path, key);
    }

    public List<Integer> listAllVersions(Map<String, String> requestProperties, String path, String key) throws IOException, RestClientException {
        String url = String.format("/secret/paths/%s/keys/%s/versions", path, key);
        List<Integer> response = this.httpRequest(url, "GET", null, requestProperties, ALL_VERSIONS_RESPONSE_TYPE);
        return response;
    }

    public List<String> listAllKeys(String path) throws IOException, RestClientException {
        return this.listAllKeys(DEFAULT_REQUEST_PROPERTIES, path);
    }

    public List<String> listAllKeys(Map<String, String> requestProperties, String path) throws IOException, RestClientException {
        String url = String.format("/secret/paths/%s", path);
        List<String> response = this.httpRequest(url, "GET", null, requestProperties, ALL_NAMES_RESPONSE_TYPE);
        return response;
    }

    public List<String> listAllPaths() throws IOException, RestClientException {
        return this.listAllPaths(DEFAULT_REQUEST_PROPERTIES);
    }

    public List<String> listAllPaths(Map<String, String> requestProperties) throws IOException, RestClientException {
        List<String> response = this.httpRequest("/secret/paths", "GET", null, requestProperties, ALL_NAMES_RESPONSE_TYPE);
        return response;
    }

    public int deleteVersion(Map<String, String> requestProperties, String path, String key, String version) throws IOException, RestClientException {
        String url = String.format("/secret/paths/%s/keys/%s/versions/%s", path, key, version);
        int response = this.httpRequest(url, "DELETE", null, requestProperties, DELETE_VERSION_RESPONSE_TYPE);
        return response;
    }

    public List<Integer> deleteKey(Map<String, String> requestProperties, String path, String key) throws IOException, RestClientException {
        String url = String.format("/secret/paths/%s/keys/%s", path, key);
        List<Integer> response = this.httpRequest(url, "DELETE", null, requestProperties, DELETE_KEY_RESPONSE_TYPE);
        return response;
    }

    public Set<String> deletePath(Map<String, String> requestProperties, String path) throws IOException, RestClientException {
        String url = String.format("/secret/paths/%s", path);
        Set<String> response = this.httpRequest(url, "DELETE", null, requestProperties, DELETE_PATH_RESPONSE_TYPE);
        return response;
    }

    private static List<String> parseBaseUrl(String baseUrl) {
        List<String> baseUrls = Arrays.asList(baseUrl.split("\\s*,\\s*"));
        if (baseUrls.isEmpty()) {
            throw new IllegalArgumentException("Missing required secret registry url list");
        }
        return baseUrls;
    }

    public UrlList getBaseUrls() {
        return this.baseUrls;
    }

    private void setBasicAuthRequestHeader(HttpURLConnection connection) {
        String userInfo;
        if (this.basicAuthCredentialProvider != null && (userInfo = this.basicAuthCredentialProvider.getUserInfo(connection.getURL())) != null) {
            String authHeader = Base64.getEncoder().encodeToString(userInfo.getBytes(StandardCharsets.UTF_8));
            connection.setRequestProperty("Authorization", "Basic " + authHeader);
        }
    }

    private void setCustomHeaders(HttpURLConnection connection) {
        if (this.httpHeaders != null) {
            this.httpHeaders.forEach((k, v) -> connection.setRequestProperty((String)k, (String)v));
        }
    }

    public void setBasicAuthCredentialProvider(BasicAuthCredentialProvider basicAuthCredentialProvider) {
        this.basicAuthCredentialProvider = basicAuthCredentialProvider;
    }

    public void setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    static {
        DEFAULT_REQUEST_PROPERTIES.put("Content-Type", "application/vnd.secretregistry.v1+json");
    }
}

