/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import io.confluent.kafka.tools.recovery.AutoCloseableIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.Isolation;
import org.apache.kafka.raft.LogFetchInfo;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.internals.RecordsIterator;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;

class MetadataLogIterator
implements AutoCloseableIterator<Batch<ApiMessageAndVersion>> {
    private final ReplicatedLog log;
    private long nextOffset;
    private boolean isClosed = false;
    private Iterator<Batch<ApiMessageAndVersion>> nextBatches = Collections.emptyIterator();
    private Optional<Batch<ApiMessageAndVersion>> nextBatch = Optional.empty();

    private MetadataLogIterator(ReplicatedLog log, long nextOffset) {
        this.log = log;
        this.nextOffset = nextOffset;
    }

    public static MetadataLogIterator open(ReplicatedLog log, long offset) {
        return new MetadataLogIterator(log, offset);
    }

    @Override
    public boolean hasNext() {
        this.ensureOpen();
        if (!this.nextBatch.isPresent()) {
            this.nextBatch = this.nextBatch();
        }
        return this.nextBatch.isPresent();
    }

    @Override
    public Batch<ApiMessageAndVersion> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Records batch reader doesn't have any more elements");
        }
        Batch<ApiMessageAndVersion> batch = this.nextBatch.get();
        this.nextBatch = Optional.empty();
        this.nextOffset = batch.lastOffset() + 1L;
        return batch;
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.closeIterator();
    }

    private void ensureOpen() {
        if (this.isClosed) {
            throw new IllegalStateException("Serde record batch iterator was closed");
        }
    }

    private RecordsIterator<ApiMessageAndVersion> nextBatches() {
        this.closeIterator();
        LogFetchInfo readInfo = this.log.read(this.nextOffset, Isolation.UNCOMMITTED);
        return new RecordsIterator(readInfo.records, (RecordSerde)MetadataRecordSerde.INSTANCE, BufferSupplier.NO_CACHING, 0x800000, true);
    }

    private Optional<Batch<ApiMessageAndVersion>> nextBatch() {
        if (!this.nextBatches.hasNext()) {
            this.nextBatches = this.nextBatches();
        }
        if (this.nextBatches.hasNext()) {
            return Optional.of(this.nextBatches.next());
        }
        return Optional.empty();
    }

    private void closeIterator() {
        if (this.nextBatches instanceof RecordsIterator) {
            ((RecordsIterator)this.nextBatches).close();
            this.nextBatches = Collections.emptyIterator();
        }
    }
}

