/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import io.confluent.kafka.tools.recovery.AutoCloseableIterator;
import io.confluent.kafka.tools.recovery.MetadataBatchLoader;
import io.confluent.kafka.tools.recovery.MetadataRecoveryPartition;
import io.confluent.kafka.tools.recovery.MetadataRecoveryUtils;
import java.nio.file.Path;
import org.apache.kafka.common.metadata.NoOpRecord;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RaftSnapshotWriter;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.ControlRecord;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.RecordsSnapshotReader;
import org.apache.kafka.snapshot.RecordsSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotWriter;

public final class MetadataRecoveryState {
    private final MetadataRecoveryPartition recoveryPartition;
    private final MetadataBatchLoader currentLoader;

    public MetadataRecoveryState(MetadataRecoveryPartition metadataRecoveryPartition, MetadataEncryptorFactory metadataEncryptorFactory) {
        this.recoveryPartition = metadataRecoveryPartition;
        this.currentLoader = new MetadataBatchLoader(new LogContext("[MetadataRecoveryState] "), metadataEncryptorFactory);
    }

    public void load() {
        if (!this.currentLoader.getImage().equals((Object)MetadataImage.EMPTY)) {
            throw new IllegalStateException("load() was called more than once because the current image is not empty");
        }
        for (Batch recordBatch : this.recoveryPartition) {
            this.currentLoader.loadBatch((Batch<ApiMessageAndVersion>)recordBatch);
        }
        this.currentLoader.maybeFlushBatches();
    }

    public MetadataImage getImage() {
        return this.currentLoader.getImage();
    }

    public void importCheckpoint(RecordsSnapshotReader<ApiMessageAndVersion> snapshotReplay, RecordsSnapshotReader<ApiMessageAndVersion> snapshotAppend) {
        Batch batch;
        if (this.recoveryPartition.iterator().hasNext()) {
            throw new IllegalStateException("Recovery partition should be empty");
        }
        while (snapshotReplay.hasNext()) {
            batch = snapshotReplay.next();
            this.currentLoader.loadBatch((Batch<ApiMessageAndVersion>)batch);
        }
        this.currentLoader.maybeFlushBatches();
        while (snapshotAppend.hasNext()) {
            batch = snapshotAppend.next();
            for (ApiMessageAndVersion record : batch.records()) {
                if (record.message() instanceof NoOpRecord) continue;
                this.recoveryPartition.appendRecord(record);
            }
            for (ControlRecord controlRecord : batch.controlRecords()) {
                this.recoveryPartition.maybeAppendControlRecord(controlRecord);
            }
        }
    }

    public void applyLogs(AutoCloseableIterator<Batch<ApiMessageAndVersion>> iterator, long startOffset, long endingOffset) {
        long lastContainedLogTimestamp = 0L;
        int epoch = 0;
        block2: while (iterator.hasNext()) {
            Batch batch = (Batch)iterator.next();
            lastContainedLogTimestamp = Math.max(batch.appendTimestamp(), lastContainedLogTimestamp);
            epoch = batch.epoch();
            ApiMessageAndVersion currRecord = null;
            long currOffset = batch.baseOffset() - 1L;
            try {
                this.currentLoader.loadBatchWithinOffsets((Batch<ApiMessageAndVersion>)batch, startOffset, endingOffset);
                this.currentLoader.maybeFlushBatches();
                for (ApiMessageAndVersion record : batch.records()) {
                    if (++currOffset < startOffset) continue;
                    if (currOffset >= endingOffset) break;
                    currRecord = record;
                    if (record.message() instanceof NoOpRecord) continue;
                    this.recoveryPartition.appendRecord(record);
                }
                for (ControlRecord controlRecord : batch.controlRecords()) {
                    if (++currOffset < startOffset) continue;
                    if (currOffset >= endingOffset) continue block2;
                    this.recoveryPartition.maybeAppendControlRecord(controlRecord);
                }
            }
            catch (RuntimeException e) {
                if (currRecord != null) {
                    System.err.printf("Failed to apply record at offset %s. Please use %s(.sh/.bat) %s to view the current state of the recovery partition%nFailed to replay/apply the following record (json format): %n", currOffset, "kafka-metadata-recovery", "display");
                    MetadataRecoveryUtils.writeSingleRecordAsJson(currRecord, System.out);
                }
                throw e;
            }
        }
    }

    public void exportCheckpoint(long offset, int epoch, long lastContainedLogTimestamp, Path outDirectory) {
        try (RaftSnapshotWriter raftSnapshotWriter = new RaftSnapshotWriter((SnapshotWriter)new RecordsSnapshotWriter.Builder().setTime(Time.SYSTEM).setLastContainedLogTimestamp(lastContainedLogTimestamp).setRawSnapshotWriter((RawSnapshotWriter)FileRawSnapshotWriter.create((Path)outDirectory, (OffsetAndEpoch)new OffsetAndEpoch(offset, epoch))).setKraftVersion(KRaftVersion.KRAFT_VERSION_0).build((RecordSerde)MetadataRecordSerde.INSTANCE), 0x800000);){
            this.currentLoader.getImage().write((ImageWriter)raftSnapshotWriter, new ImageWriterOptions.Builder(this.currentLoader.getImage()).build());
        }
    }
}

