/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import io.confluent.kafka.clients.CloudAdmin;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.tools.CloudAdminCommand;
import org.apache.kafka.tools.PrintVersionAndExitAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudAdminCommandBase {
    private static final Logger log = LoggerFactory.getLogger(CloudAdminCommandBase.class);

    public static void printErrorAndExit(String message, Throwable t) {
        log.debug(message, t);
        String exitMessage = message + ": " + t.getMessage() + ". Enable debug logging for additional detail.";
        CloudAdminCommandBase.printErrorAndExit(exitMessage);
    }

    public static void printErrorAndExit(String message) {
        System.err.println(message);
        Exit.exit((int)1, (String)message);
    }

    public static void printMessageAndExit(PrintStream out, String exitMessage) {
        out.println(exitMessage);
        Exit.exit((int)0, (String)exitMessage);
    }

    private static CloudAdmin buildAdminClient(Namespace ns) {
        Properties properties;
        String configFile = ns.getString("command_config");
        if (configFile == null) {
            properties = new Properties();
        } else {
            try {
                properties = Utils.loadProps((String)configFile);
                System.getProperties().putAll((Map<?, ?>)properties);
            }
            catch (IOException e) {
                CloudAdminCommandBase.printErrorAndExit("Failed to load admin client properties", e);
                return null;
            }
        }
        String bootstrapServers = ns.getString("bootstrap_server");
        properties.put("bootstrap.servers", bootstrapServers);
        return CloudAdmin.create((Properties)properties);
    }

    private static ArgumentParser buildBaseParser(String commandName, String description) {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)commandName).description(description);
        parser.addArgument(new String[]{"-v", "--version"}).action((ArgumentAction)new PrintVersionAndExitAction()).help("show the version of this Kafka distribution and exit");
        parser.addArgument(new String[]{"--command-config"}).help("property file containing configs to be passed to admin client").action((ArgumentAction)Arguments.store()).type(String.class).metavar(new String[]{"FILE"}).required(false);
        parser.addArgument(new String[]{"--bootstrap-server"}).help("hostname and port for the broker to connect to, in the form `host:port`  (multiple comma-separated entries can be given)").action((ArgumentAction)Arguments.store()).type(String.class).metavar(new String[]{"host:port"}).required(true);
        return parser;
    }

    public static void execute(String cmdName, String cmdDesc, String[] args, List<CloudAdminCommand> commands, PrintStream out) throws Exception {
        CloudAdminCommandBase.execute(cmdName, cmdDesc, args, Optional.empty(), commands, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String cmdName, String cmdDesc, String[] args, Optional<CloudAdmin> adminOpt, List<CloudAdminCommand> commands, PrintStream out) throws Exception {
        Namespace ns;
        ArgumentParser parser = CloudAdminCommandBase.buildBaseParser(cmdName, cmdDesc);
        Subparsers subparsers = parser.addSubparsers().dest("command").title("commands").metavar("COMMAND");
        commands.forEach(command -> command.addSubparser(subparsers));
        try {
            ns = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            Exit.exit((int)1);
            return;
        }
        CloudAdmin admin = adminOpt.orElseGet(() -> CloudAdminCommandBase.buildAdminClient(ns));
        try {
            String commandName = ns.getString("command");
            Optional<CloudAdminCommand> commandOpt = commands.stream().filter(cmd -> cmd.name().equals(commandName)).findFirst();
            if (!commandOpt.isPresent()) {
                CloudAdminCommandBase.printErrorAndExit("Unexpected command " + commandName);
            }
            CloudAdminCommand command2 = commandOpt.get();
            command2.execute(admin, ns, out);
        }
        finally {
            if (!adminOpt.isPresent()) {
                admin.close();
            }
        }
        Exit.exit((int)0);
    }
}

