/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.cellsadmincmd;

import io.confluent.kafka.clients.CloudAdmin;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.message.AssignTenantsToCellRequestData;
import org.apache.kafka.common.message.AssignTenantsToCellResponseData;
import org.apache.kafka.tools.CloudAdminCommand;
import org.apache.kafka.tools.cellsadmincmd.CellsAdminCommand;

public class AssignTenantsCommand
implements CloudAdminCommand {
    @Override
    public String name() {
        return "assign-tenants";
    }

    @Override
    public void addSubparser(Subparsers subparsers) {
        Subparser parser = subparsers.addParser(this.name()).help("Assigns tenants to cells");
        parser.addArgument(new String[]{"--tenant-ids"}).help("list of tenants to assign separated by comma").action((ArgumentAction)Arguments.store()).type(String.class).required(true);
        parser.addArgument(new String[]{"--cell-id"}).help("cell id to be assigned").action((ArgumentAction)Arguments.store()).type(String.class).required(false);
        parser.addArgument(new String[]{"--cell-ids"}).help("list of cell ids to assign tenants to, separated by comma").action((ArgumentAction)Arguments.store()).type(String.class).required(false);
        parser.addArgument(new String[]{"--force"}).help("force assign even if moving tenant(s) to quarantined cell or excluded cells or moving out of a quarantined cells").action((ArgumentAction)Arguments.storeTrue()).type(Boolean.class).required(false);
    }

    @Override
    public void execute(CloudAdmin admin, Namespace ns, PrintStream out) throws Exception {
        List errs;
        Optional<String> cellIdsArg = Optional.ofNullable(ns.getString("cell_ids"));
        Optional<String> cellIdArg = Optional.ofNullable(ns.getString("cell_id"));
        if (cellIdsArg.isPresent() && cellIdArg.isPresent()) {
            CellsAdminCommand.printErrorAndExit("cell-id and cell-ids both shouldn't be specified");
            return;
        }
        if (!cellIdsArg.isPresent() && !cellIdArg.isPresent()) {
            CellsAdminCommand.printErrorAndExit("At-least one of cell-id or cell-ids should be specified");
            return;
        }
        List cellIdsList = cellIdsArg.map(this::getCellIdsList).orElse(null);
        int cellId = cellIdArg.map(this::getCellId).orElse(-1);
        String tenantIds = ns.getString("tenant_ids");
        boolean force = Optional.ofNullable(ns.getString("force")).map(Boolean::parseBoolean).orElse(false);
        List assignments = Arrays.stream(tenantIds.split(",")).map(tenantId -> this.getTenantToCellAssignment((String)tenantId, force, cellIdsList, cellId)).collect(Collectors.toList());
        try {
            errs = (List)admin.assignTenantsToCells(assignments).value().get();
        }
        catch (ExecutionException e) {
            CellsAdminCommand.printErrorAndExit("Failed to assign tenants to cells", e.getCause());
            return;
        }
        if (errs.isEmpty()) {
            CellsAdminCommand.printMessageAndExit(out, "Successfully set tenants " + tenantIds + " to cells " + cellIdsArg.orElseGet(cellIdArg::get));
        } else {
            for (AssignTenantsToCellResponseData.TenantAssignmentErrors err : errs) {
                out.println(err.errorMessage());
            }
            CellsAdminCommand.printErrorAndExit("Failed to set all tenants to cells");
        }
    }

    private int getCellId(String cellIdArg) {
        try {
            return Integer.parseInt(cellIdArg);
        }
        catch (NumberFormatException e) {
            CellsAdminCommand.printErrorAndExit("Invalid cell id specified. CellId must be an Integer", e);
            return 0;
        }
    }

    private List<Integer> getCellIdsList(String cellIds) {
        ArrayList<Integer> cellIdsList = new ArrayList(0);
        try {
            cellIdsList = Arrays.stream(cellIds.split(",")).map(Integer::parseInt).collect(Collectors.toList());
        }
        catch (NumberFormatException e) {
            CellsAdminCommand.printErrorAndExit("Invalid cell id(s) specified. CellId must be an Integer", e);
        }
        if (cellIdsList.size() != new HashSet(cellIdsList).size()) {
            CellsAdminCommand.printErrorAndExit("Duplicate cell ids specified");
        }
        return cellIdsList;
    }

    private AssignTenantsToCellRequestData.TenantToCellAssignment getTenantToCellAssignment(String tenantId, boolean force, List<Integer> cellIdsList, int cellId) {
        AssignTenantsToCellRequestData.TenantToCellAssignment tenantToCellAssignment = new AssignTenantsToCellRequestData.TenantToCellAssignment();
        tenantToCellAssignment.setTenantId(tenantId);
        tenantToCellAssignment.setForce(force);
        if (cellIdsList == null) {
            tenantToCellAssignment.setCellId(cellId);
        } else {
            tenantToCellAssignment.setCellIds(cellIdsList);
        }
        return tenantToCellAssignment;
    }
}

