/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.cellsadmincmd;

import io.confluent.kafka.clients.CloudAdmin;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.message.AssignTenantsToCellRequestData;
import org.apache.kafka.common.message.DescribeTenantsResponseData;
import org.apache.kafka.tools.CloudAdminCommand;
import org.apache.kafka.tools.cellsadmincmd.CellsAdminCommand;
import org.apache.kafka.tools.tenantplacementadvisor.Cell;
import org.apache.kafka.tools.tenantplacementadvisor.DefaultCellLoadResolver;
import org.apache.kafka.tools.tenantplacementadvisor.DefaultTenantLoadFunction;
import org.apache.kafka.tools.tenantplacementadvisor.Plan;
import org.apache.kafka.tools.tenantplacementadvisor.Tenant;
import org.apache.kafka.tools.tenantplacementadvisor.TenantPlacementAdvisor;

public class OffloadCellCommand
implements CloudAdminCommand {
    public static final String CELL = "cell";
    public static final String LOAD = "goal-load";
    public static final String LOAD_ARGPARSE4J_FORMATTED = "goal_load";
    public static final String SILENT = "silent";

    @Override
    public String name() {
        return "offload";
    }

    @Override
    public void addSubparser(Subparsers subparsers) {
        Subparser parser = subparsers.addParser(this.name()).help("reduces load on a cell to input value");
        parser.addArgument(new String[]{String.format("--%s", CELL)}).help("cell to offload").type(Integer.class).required(true);
        parser.addArgument(new String[]{String.format("--%s", LOAD)}).help("load which the input cell will be attempted to be reduced to").type(Double.class).required(true);
        parser.addArgument(new String[]{"-s", String.format("--%s", SILENT)}).type(Boolean.TYPE).action((ArgumentAction)Arguments.storeTrue()).required(false);
    }

    @Override
    public void execute(CloudAdmin admin, Namespace ns, PrintStream out) throws Exception {
        int sourceCellId = (Integer)ns.get(CELL);
        double goalLoad = (Double)ns.get(LOAD_ARGPARSE4J_FORMATTED);
        boolean silent = (Boolean)ns.get(SILENT);
        Map<Integer, Set<String>> cellToTenantPlacements = this.buildTenantToCellMap(admin);
        DefaultTenantLoadFunction tenantLoadFunction = new DefaultTenantLoadFunction();
        DefaultCellLoadResolver cellLoadResolver = new DefaultCellLoadResolver(admin);
        TenantPlacementAdvisor tenantPlacementAdvisor = new TenantPlacementAdvisor(cellToTenantPlacements, tenantLoadFunction, cellLoadResolver, Collections.emptyList(), Collections.emptyList());
        Plan plan = tenantPlacementAdvisor.getPlan(new Cell(sourceCellId), goalLoad);
        this.verifyPlan(plan);
        this.displayPlanAndSubmitDecision(plan, sourceCellId, out, admin, !silent);
    }

    public Map<Integer, Set<String>> buildTenantToCellMap(CloudAdmin admin) throws Exception {
        List tenantDescriptions = (List)admin.describeTenants(Collections.emptyList()).value().get();
        return tenantDescriptions.stream().collect(Collectors.groupingBy(DescribeTenantsResponseData.TenantDescription::cellId, Collectors.mapping(DescribeTenantsResponseData.TenantDescription::tenantId, Collectors.toSet())));
    }

    public void verifyPlan(Plan plan) {
        if (plan.getTenantToCellRecommendedPlacements().entrySet().isEmpty()) {
            throw new RuntimeException("Returned plan is empty- this may be due to all other cells in PKC being heavily loaded.");
        }
        if (plan.getBefore().isEmpty()) {
            throw new RuntimeException("Plan before loads are empty- please report this to KCFUN team.");
        }
        if (plan.getAfter().isEmpty()) {
            throw new RuntimeException("Plan after loads are empty- please report this to KCFUN team.");
        }
    }

    public void displayPlanAndSubmitDecision(Plan plan, int sourceCellId, PrintStream out, CloudAdmin admin, boolean verbose) {
        Cell sourceCell = new Cell(sourceCellId);
        Map<Tenant, Cell> tenantToCellRecommendedPlacements = plan.getTenantToCellRecommendedPlacements();
        Map<Cell, TenantPlacementAdvisor.CellLoad> before = plan.getBefore();
        Map<Cell, TenantPlacementAdvisor.CellLoad> after = plan.getAfter();
        if (verbose) {
            out.println(OffloadCellCommand.color(Color.GREEN, "\n###### Detailed Output ######\n"));
            this.printVerboseBeforeAndAfter(sourceCell, before, after, out);
            for (Map.Entry<Cell, TenantPlacementAdvisor.CellLoad> entry : before.entrySet()) {
                if (entry.getKey().getCellID() == sourceCellId) continue;
                this.printVerboseBeforeAndAfter(entry.getKey(), before, after, out);
            }
        }
        Scanner s = new Scanner(System.in);
        boolean validUserInputGiven = false;
        String yesPattern = "^[yY].{0,5}$";
        String noPattern = "^[nN].{0,5}$";
        out.printf("--> Proposed Plan (reduces load from %s to %s)\n", before.get(sourceCell).getTotalLoad(), after.get(sourceCell).getTotalLoad());
        for (Map.Entry<Tenant, Cell> entry : tenantToCellRecommendedPlacements.entrySet()) {
            out.printf("\t Tenant %s -> Cell %s\n", OffloadCellCommand.color(Color.CYAN, entry.getKey().getTenantID()), OffloadCellCommand.color(Color.YELLOW, entry.getValue().getCellID()));
        }
        while (!validUserInputGiven) {
            out.printf("--> Execute plan? %s/%s\n", OffloadCellCommand.color(Color.GREEN, "y"), OffloadCellCommand.color(Color.RED, "n"));
            String userInput = s.next();
            if (userInput.matches(yesPattern)) {
                validUserInputGiven = true;
                try {
                    this.submitPlan(plan, admin);
                    out.println("Plan submitted.");
                    continue;
                }
                catch (Exception e) {
                    CellsAdminCommand.printErrorAndExit("Failed to submit plan with exception", e.getCause());
                    return;
                }
            }
            if (userInput.matches(noPattern)) {
                validUserInputGiven = true;
                out.println("Plan not submitted.");
                continue;
            }
            out.printf("Please enter one of the following valid patterns: \n%s\n%s\n", yesPattern, noPattern);
        }
        out.println("Exiting.");
    }

    private void printVerboseBeforeAndAfter(Cell cell, Map<Cell, TenantPlacementAdvisor.CellLoad> before, Map<Cell, TenantPlacementAdvisor.CellLoad> after, PrintStream out) {
        out.println(OffloadCellCommand.color(Color.YELLOW, String.format("===== Cell %d =====", cell.getCellID())));
        out.println(OffloadCellCommand.color(Color.CYAN, "Estimated loads before plan executes:"));
        this.printVerbose(cell, before, out);
        out.println(OffloadCellCommand.color(Color.CYAN, "Estimated loads after plan executes:"));
        this.printVerbose(cell, after, out);
        out.println();
    }

    private void printVerbose(Cell cell, Map<Cell, TenantPlacementAdvisor.CellLoad> loads, PrintStream out) {
        String output = loads.get(cell).getPerMetricLoads().get().entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> String.format("%s: %.1f%%", entry.getKey(), (Double)entry.getValue() * 100.0)).collect(Collectors.joining("\n"));
        out.println(output);
    }

    private void submitPlan(Plan plan, CloudAdmin admin) {
        ArrayList<AssignTenantsToCellRequestData.TenantToCellAssignment> assignments = new ArrayList<AssignTenantsToCellRequestData.TenantToCellAssignment>();
        for (Map.Entry<Tenant, Cell> entry : plan.getTenantToCellRecommendedPlacements().entrySet()) {
            AssignTenantsToCellRequestData.TenantToCellAssignment assignment = new AssignTenantsToCellRequestData.TenantToCellAssignment();
            assignment.setTenantId(entry.getKey().getTenantID());
            assignment.setCellIds(Collections.singletonList(entry.getValue().getCellID()));
            assignments.add(assignment);
        }
        admin.assignTenantsToCells(assignments);
    }

    private static String color(Color color, Object in) {
        return color.val + in + Color.RESET.val;
    }

    static enum Color {
        YELLOW("\u001b[33m"),
        GREEN("\u001b[32m"),
        RED("\u001b[31m"),
        CYAN("\u001b[36m"),
        RESET("\u001b[0m");

        private final String val;

        private Color(String val) {
            this.val = val;
        }
    }
}

