/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer.group;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import kafka.common.TenantHelpers;
import org.apache.kafka.clients.admin.AbstractOptions;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.GroupType;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.ToolsUtils;
import org.apache.kafka.tools.consumer.group.ConsumerGroupCommandOptions;
import org.apache.kafka.tools.consumer.group.CsvUtils;
import org.apache.kafka.tools.consumer.group.GroupState;
import org.apache.kafka.tools.consumer.group.MemberAssignmentState;
import org.apache.kafka.tools.consumer.group.PartitionAssignmentState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerGroupCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerGroupCommand.class);
    static final String MISSING_COLUMN_VALUE = "-";

    public static void main(String[] args) {
        ConsumerGroupCommandOptions opts = ConsumerGroupCommandOptions.fromArgs(args);
        try {
            long actions = Stream.of(opts.listOpt, opts.describeOpt, opts.deleteOpt, opts.resetOffsetsOpt, opts.deleteOffsetsOpt).filter(arg_0 -> ((OptionSet)opts.options).has(arg_0)).count();
            if (actions != 1L) {
                CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)"Command must include exactly one action: --list, --describe, --delete, --reset-offsets, --delete-offsets");
            }
            ConsumerGroupCommand.run(opts);
        }
        catch (OptionException e) {
            CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)e.getMessage());
        }
    }

    static void run(ConsumerGroupCommandOptions opts) {
        try (ConsumerGroupService consumerGroupService = new ConsumerGroupService(opts, Collections.emptyMap());){
            if (opts.options.has(opts.listOpt)) {
                consumerGroupService.listGroups();
            } else if (opts.options.has(opts.describeOpt)) {
                consumerGroupService.describeGroups();
            } else if (opts.options.has(opts.deleteOpt)) {
                consumerGroupService.deleteGroups();
            } else if (opts.options.has(opts.resetOffsetsOpt)) {
                Map<String, Map<TopicPartition, OffsetAndMetadata>> offsetsToReset = consumerGroupService.resetOffsets();
                if (opts.options.has(opts.exportOpt)) {
                    String exported = consumerGroupService.exportOffsetsToCsv(offsetsToReset);
                    System.out.println(exported);
                } else {
                    ConsumerGroupCommand.printOffsetsToReset(offsetsToReset);
                }
            } else if (opts.options.has(opts.deleteOffsetsOpt)) {
                consumerGroupService.deleteOffsets();
            }
        }
        catch (IllegalArgumentException e) {
            CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)e.getMessage());
        }
        catch (Throwable e) {
            ConsumerGroupCommand.printError("Executing consumer group command failed due to " + e.getMessage(), Optional.of(e));
        }
    }

    static Set<ConsumerGroupState> consumerGroupStatesFromString(String input) {
        Set<ConsumerGroupState> parsedStates = Arrays.stream(input.split(",")).map(s -> ConsumerGroupState.parse((String)s.trim())).collect(Collectors.toSet());
        if (parsedStates.contains(ConsumerGroupState.UNKNOWN)) {
            Collection validStates = Arrays.stream(ConsumerGroupState.values()).filter(s -> s != ConsumerGroupState.UNKNOWN).collect(Collectors.toList());
            throw new IllegalArgumentException("Invalid state list '" + input + "'. Valid states are: " + validStates.stream().map(ConsumerGroupState::toString).collect(Collectors.joining(", ")));
        }
        return parsedStates;
    }

    static Set<GroupType> consumerGroupTypesFromString(String input) {
        Set<GroupType> parsedTypes = Stream.of(input.toLowerCase().split(",")).map(s -> GroupType.parse((String)s.trim())).collect(Collectors.toSet());
        if (parsedTypes.contains(GroupType.UNKNOWN)) {
            List validTypes = Arrays.stream(GroupType.values()).filter(t -> t != GroupType.UNKNOWN).map(Object::toString).collect(Collectors.toList());
            throw new IllegalArgumentException("Invalid types list '" + input + "'. Valid types are: " + String.join((CharSequence)", ", validTypes));
        }
        return parsedTypes;
    }

    static void printError(String msg, Optional<Throwable> e) {
        System.out.println("\nError: " + msg);
        e.ifPresent(Throwable::printStackTrace);
    }

    static void printOffsetsToReset(Map<String, Map<TopicPartition, OffsetAndMetadata>> groupAssignmentsToReset) {
        String format = "%-30s %-30s %-10s %-15s";
        if (!groupAssignmentsToReset.isEmpty()) {
            System.out.printf("\n" + format, "GROUP", "TOPIC", "PARTITION", "NEW-OFFSET");
        }
        groupAssignmentsToReset.forEach((groupId, assignment) -> assignment.forEach((consumerAssignment, offsetAndMetadata) -> System.out.printf(format, groupId, consumerAssignment.topic(), consumerAssignment.partition(), offsetAndMetadata.offset())));
    }

    private static class Ignore
    implements LogOffsetResult {
        private Ignore() {
        }
    }

    private static class Unknown
    implements LogOffsetResult {
        private Unknown() {
        }
    }

    private static class LogOffset
    implements LogOffsetResult {
        final long value;

        LogOffset(long value) {
            this.value = value;
        }
    }

    static interface LogOffsetResult {
    }

    static class ConsumerGroupService
    implements AutoCloseable {
        final ConsumerGroupCommandOptions opts;
        final Map<String, String> configOverrides;
        private final Admin adminClient;

        ConsumerGroupService(ConsumerGroupCommandOptions opts, Map<String, String> configOverrides) {
            this.opts = opts;
            this.configOverrides = configOverrides;
            try {
                this.adminClient = this.createAdminClient(configOverrides);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        Optional<Map<String, Map<TopicPartition, OffsetAndMetadata>>> resetPlanFromFile() {
            if (this.opts.options.has(this.opts.resetFromFileOpt)) {
                try {
                    String resetPlanPath = (String)this.opts.options.valueOf(this.opts.resetFromFileOpt);
                    String resetPlanCsv = Utils.readFileAsString((String)resetPlanPath);
                    Map<String, Map<TopicPartition, OffsetAndMetadata>> resetPlan = this.parseResetPlan(resetPlanCsv);
                    return Optional.of(resetPlan);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return Optional.empty();
        }

        void listGroups() throws ExecutionException, InterruptedException {
            boolean includeType = this.opts.options.has(this.opts.typeOpt);
            boolean includeState = this.opts.options.has(this.opts.stateOpt);
            if (includeType || includeState) {
                Set<GroupType> types = this.typeValues();
                Set<ConsumerGroupState> states = this.stateValues();
                List<ConsumerGroupListing> listings = this.listConsumerGroupsWithFilters(types, states);
                this.printGroupInfo(listings, includeType, includeState);
            } else {
                this.listConsumerGroups().forEach(System.out::println);
            }
        }

        private Set<ConsumerGroupState> stateValues() {
            String stateValue = (String)this.opts.options.valueOf(this.opts.stateOpt);
            return stateValue == null || stateValue.isEmpty() ? Collections.emptySet() : ConsumerGroupCommand.consumerGroupStatesFromString(stateValue);
        }

        private Set<GroupType> typeValues() {
            String typeValue = (String)this.opts.options.valueOf(this.opts.typeOpt);
            return typeValue == null || typeValue.isEmpty() ? Collections.emptySet() : ConsumerGroupCommand.consumerGroupTypesFromString(typeValue);
        }

        private void printGroupInfo(List<ConsumerGroupListing> groups, boolean includeType, boolean includeState) {
            Function<ConsumerGroupListing, String> groupId = ConsumerGroupListing::groupId;
            Function<ConsumerGroupListing, String> groupType = groupListing -> groupListing.type().orElse(GroupType.UNKNOWN).toString();
            Function<ConsumerGroupListing, String> groupState = groupListing -> groupListing.state().orElse(ConsumerGroupState.UNKNOWN).toString();
            OptionalInt maybeMax = groups.stream().mapToInt(groupListing -> Math.max(15, ((String)groupId.apply((ConsumerGroupListing)groupListing)).length())).max();
            int maxGroupLen = maybeMax.orElse(15) + 10;
            String format = "%-" + maxGroupLen + "s";
            ArrayList<String> header = new ArrayList<String>();
            header.add("GROUP");
            ArrayList<Function<ConsumerGroupListing, String>> extractors = new ArrayList<Function<ConsumerGroupListing, String>>();
            extractors.add(groupId);
            if (includeType) {
                header.add("TYPE");
                extractors.add(groupType);
                format = format + " %-20s";
            }
            if (includeState) {
                header.add("STATE");
                extractors.add(groupState);
                format = format + " %-20s";
            }
            System.out.printf(format + "%n", header.toArray(new Object[0]));
            for (ConsumerGroupListing groupListing2 : groups) {
                Object[] info = extractors.stream().map(extractor -> (String)extractor.apply(groupListing2)).toArray(Object[]::new);
                System.out.printf(format + "%n", info);
            }
        }

        List<String> listConsumerGroups() {
            try {
                ListConsumerGroupsResult result = this.adminClient.listConsumerGroups(this.withTimeoutMs(new ListConsumerGroupsOptions()));
                Collection listings = (Collection)result.all().get();
                return listings.stream().map(ConsumerGroupListing::groupId).collect(Collectors.toList());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        List<ConsumerGroupListing> listConsumerGroupsWithFilters(Set<GroupType> types, Set<ConsumerGroupState> states) throws ExecutionException, InterruptedException {
            ListConsumerGroupsOptions listConsumerGroupsOptions = this.withTimeoutMs(new ListConsumerGroupsOptions());
            listConsumerGroupsOptions.inStates(states).withTypes(types);
            ListConsumerGroupsResult result = this.adminClient.listConsumerGroups(listConsumerGroupsOptions);
            return new ArrayList<ConsumerGroupListing>((Collection)result.all().get());
        }

        private boolean shouldPrintMemberState(String group, Optional<ConsumerGroupState> state, Optional<Integer> numRows) {
            if (!numRows.isPresent()) {
                ConsumerGroupCommand.printError("The consumer group '" + group + "' does not exist.", Optional.empty());
                return false;
            }
            int num = numRows.get();
            ConsumerGroupState state0 = state.orElse(ConsumerGroupState.UNKNOWN);
            switch (state0) {
                case DEAD: {
                    ConsumerGroupCommand.printError("Consumer group '" + group + "' does not exist.", Optional.empty());
                    break;
                }
                case EMPTY: {
                    System.err.println("\nConsumer group '" + group + "' has no active members.");
                    break;
                }
                case PREPARING_REBALANCE: 
                case COMPLETING_REBALANCE: 
                case ASSIGNING: 
                case RECONCILING: {
                    System.err.println("\nWarning: Consumer group '" + group + "' is rebalancing.");
                    break;
                }
                case STABLE: {
                    break;
                }
                default: {
                    throw new KafkaException("Expected a valid consumer group state, but found '" + state0 + "'.");
                }
            }
            return !state0.equals((Object)ConsumerGroupState.DEAD) && num > 0;
        }

        private Optional<Integer> size(Optional<? extends Collection<?>> colOpt) {
            return colOpt.map(Collection::size);
        }

        private void printOffsets(Map<String, Map.Entry<Optional<ConsumerGroupState>, Optional<Collection<PartitionAssignmentState>>>> offsets) {
            offsets.forEach((groupId, tuple) -> {
                Optional assignments;
                Optional state = (Optional)tuple.getKey();
                if (this.shouldPrintMemberState((String)groupId, state, this.size(assignments = (Optional)tuple.getValue()))) {
                    String format = ConsumerGroupService.printOffsetFormat(assignments);
                    System.out.printf(format, "GROUP", "TOPIC", "PARTITION", "CURRENT-OFFSET", "LOG-END-OFFSET", "LAG", "CONSUMER-ID", "HOST", "CLIENT-ID");
                    if (assignments.isPresent()) {
                        Collection consumerAssignments = (Collection)assignments.get();
                        for (PartitionAssignmentState consumerAssignment : consumerAssignments) {
                            System.out.printf(format, consumerAssignment.group, consumerAssignment.topic.orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), consumerAssignment.partition.map(Object::toString).orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), consumerAssignment.offset.map(Object::toString).orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), consumerAssignment.logEndOffset.map(Object::toString).orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), consumerAssignment.lag.map(Object::toString).orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), consumerAssignment.consumerId.orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), consumerAssignment.host.orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE), consumerAssignment.clientId.orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE));
                        }
                    }
                }
            });
        }

        private static String printOffsetFormat(Optional<Collection<PartitionAssignmentState>> assignments) {
            int maxGroupLen = 15;
            int maxTopicLen = 15;
            int maxConsumerIdLen = 15;
            int maxHostLen = 15;
            if (assignments.isPresent()) {
                Collection<PartitionAssignmentState> consumerAssignments = assignments.get();
                for (PartitionAssignmentState consumerAssignment : consumerAssignments) {
                    maxGroupLen = Math.max(maxGroupLen, consumerAssignment.group.length());
                    maxTopicLen = Math.max(maxTopicLen, consumerAssignment.topic.orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE).length());
                    maxConsumerIdLen = Math.max(maxConsumerIdLen, consumerAssignment.consumerId.orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE).length());
                    maxHostLen = Math.max(maxHostLen, consumerAssignment.host.orElse(ConsumerGroupCommand.MISSING_COLUMN_VALUE).length());
                }
            }
            return "\n%" + -maxGroupLen + "s %" + -maxTopicLen + "s %-10s %-15s %-15s %-15s %" + -maxConsumerIdLen + "s %" + -maxHostLen + "s %s";
        }

        private void printMembers(Map<String, Map.Entry<Optional<ConsumerGroupState>, Optional<Collection<MemberAssignmentState>>>> members, boolean verbose) {
            members.forEach((groupId, tuple) -> {
                Optional state = (Optional)tuple.getKey();
                Optional assignments = (Optional)tuple.getValue();
                int maxGroupLen = 15;
                int maxConsumerIdLen = 15;
                int maxGroupInstanceIdLen = 17;
                int maxHostLen = 15;
                int maxClientIdLen = 15;
                boolean includeGroupInstanceId = false;
                if (this.shouldPrintMemberState((String)groupId, state, this.size(assignments)) && assignments.isPresent()) {
                    for (MemberAssignmentState memberAssignment : (Collection)assignments.get()) {
                        maxGroupLen = Math.max(maxGroupLen, memberAssignment.group.length());
                        maxConsumerIdLen = Math.max(maxConsumerIdLen, memberAssignment.consumerId.length());
                        maxGroupInstanceIdLen = Math.max(maxGroupInstanceIdLen, memberAssignment.groupInstanceId.length());
                        maxHostLen = Math.max(maxHostLen, memberAssignment.host.length());
                        maxClientIdLen = Math.max(maxClientIdLen, memberAssignment.clientId.length());
                        includeGroupInstanceId = includeGroupInstanceId || !memberAssignment.groupInstanceId.isEmpty();
                    }
                }
                String format0 = "%" + -maxGroupLen + "s %" + -maxConsumerIdLen + "s %" + -maxGroupInstanceIdLen + "s %" + -maxHostLen + "s %" + -maxClientIdLen + "s %-15s ";
                String format1 = "%" + -maxGroupLen + "s %" + -maxConsumerIdLen + "s %" + -maxHostLen + "s %" + -maxClientIdLen + "s %-15s ";
                if (includeGroupInstanceId) {
                    System.out.printf("\n" + format0, "GROUP", "CONSUMER-ID", "GROUP-INSTANCE-ID", "HOST", "CLIENT-ID", "#PARTITIONS");
                } else {
                    System.out.printf("\n" + format1, "GROUP", "CONSUMER-ID", "HOST", "CLIENT-ID", "#PARTITIONS");
                }
                if (verbose) {
                    System.out.printf("%s", "ASSIGNMENT");
                }
                System.out.println();
                if (assignments.isPresent()) {
                    for (MemberAssignmentState memberAssignment : (Collection)assignments.get()) {
                        if (includeGroupInstanceId) {
                            System.out.printf(format0, memberAssignment.group, memberAssignment.consumerId, memberAssignment.groupInstanceId, memberAssignment.host, memberAssignment.clientId, memberAssignment.numPartitions);
                        } else {
                            System.out.printf(format1, memberAssignment.group, memberAssignment.consumerId, memberAssignment.host, memberAssignment.clientId, memberAssignment.numPartitions);
                        }
                        if (verbose) {
                            String partitions;
                            if (memberAssignment.assignment.isEmpty()) {
                                partitions = ConsumerGroupCommand.MISSING_COLUMN_VALUE;
                            } else {
                                HashMap grouped = new HashMap();
                                memberAssignment.assignment.forEach(tp -> grouped.computeIfAbsent(tp.topic(), key -> new ArrayList()).add(tp));
                                partitions = grouped.values().stream().map(topicPartitions -> topicPartitions.stream().map(TopicPartition::partition).map(Object::toString).sorted().collect(Collectors.joining(",", "(", ")"))).sorted().collect(Collectors.joining(", "));
                            }
                            System.out.printf("%s", partitions);
                        }
                        System.out.println();
                    }
                }
            });
        }

        private void printStates(Map<String, GroupState> states) {
            states.forEach((groupId, state) -> {
                if (this.shouldPrintMemberState((String)groupId, Optional.of(state.state), Optional.of(1))) {
                    String coordinator = state.coordinator.host() + ":" + state.coordinator.port() + "  (" + state.coordinator.idString() + ")";
                    int coordinatorColLen = Math.max(25, coordinator.length());
                    String format = "\n%" + -coordinatorColLen + "s %-25s %-20s %-15s %s";
                    System.out.printf(format, "GROUP", "COORDINATOR (ID)", "ASSIGNMENT-STRATEGY", "STATE", "#MEMBERS");
                    System.out.printf(format, state.group, coordinator, state.assignmentStrategy, state.state.toString(), state.numMembers);
                    System.out.println();
                }
            });
        }

        void describeGroups() throws Exception {
            List groupIds = this.opts.options.has(this.opts.allGroupsOpt) ? this.listConsumerGroups() : this.opts.options.valuesOf(this.opts.groupOpt);
            boolean membersOptPresent = this.opts.options.has(this.opts.membersOpt);
            boolean stateOptPresent = this.opts.options.has(this.opts.stateOpt);
            boolean offsetsOptPresent = this.opts.options.has(this.opts.offsetsOpt);
            long subActions = Stream.of(membersOptPresent, offsetsOptPresent, stateOptPresent).filter(x -> x).count();
            if (subActions == 0L || offsetsOptPresent) {
                TreeMap<String, Map.Entry<Optional<ConsumerGroupState>, Optional<Collection<PartitionAssignmentState>>>> offsets = this.collectGroupsOffsets(groupIds);
                this.printOffsets(offsets);
            } else if (membersOptPresent) {
                TreeMap<String, Map.Entry<Optional<ConsumerGroupState>, Optional<Collection<MemberAssignmentState>>>> members = this.collectGroupsMembers(groupIds, this.opts.options.has(this.opts.verboseOpt));
                this.printMembers(members, this.opts.options.has(this.opts.verboseOpt));
            } else {
                TreeMap<String, GroupState> states = this.collectGroupsState(groupIds);
                this.printStates(states);
            }
        }

        private Collection<PartitionAssignmentState> collectConsumerAssignment(String group, Optional<Node> coordinator, Collection<TopicPartition> topicPartitions, Function<TopicPartition, Optional<Long>> getPartitionOffset, Optional<String> consumerIdOpt, Optional<String> hostOpt, Optional<String> clientIdOpt) {
            if (topicPartitions.isEmpty()) {
                return Collections.singleton(new PartitionAssignmentState(group, coordinator, Optional.empty(), Optional.empty(), Optional.empty(), this.getLag(Optional.empty(), Optional.empty()), consumerIdOpt, hostOpt, clientIdOpt, Optional.empty()));
            }
            List<TopicPartition> topicPartitionsSorted = topicPartitions.stream().sorted(Comparator.comparingInt(TopicPartition::partition)).collect(Collectors.toList());
            return this.describePartitions(group, coordinator, topicPartitionsSorted, getPartitionOffset, consumerIdOpt, hostOpt, clientIdOpt);
        }

        private Optional<Long> getLag(Optional<Long> offset, Optional<Long> logEndOffset) {
            return offset.filter(o -> o != -1L).flatMap(offset0 -> logEndOffset.map(end -> end - offset0));
        }

        private Collection<PartitionAssignmentState> describePartitions(String group, Optional<Node> coordinator, List<TopicPartition> topicPartitions, Function<TopicPartition, Optional<Long>> getPartitionOffset, Optional<String> consumerIdOpt, Optional<String> hostOpt, Optional<String> clientIdOpt) {
            BiFunction<TopicPartition, Optional, PartitionAssignmentState> getDescribePartitionResult = (topicPartition, logEndOffsetOpt) -> {
                Optional offset = (Optional)getPartitionOffset.apply((TopicPartition)topicPartition);
                return new PartitionAssignmentState(group, coordinator, Optional.of(topicPartition.topic()), Optional.of(topicPartition.partition()), offset, this.getLag(offset, (Optional<Long>)logEndOffsetOpt), consumerIdOpt, hostOpt, clientIdOpt, (Optional<Long>)logEndOffsetOpt);
            };
            return this.getLogEndOffsets(topicPartitions).entrySet().stream().map(logEndOffsetResult -> {
                if (logEndOffsetResult.getValue() instanceof LogOffset) {
                    return (PartitionAssignmentState)getDescribePartitionResult.apply((TopicPartition)logEndOffsetResult.getKey(), Optional.of(((LogOffset)logEndOffsetResult.getValue()).value));
                }
                if (logEndOffsetResult.getValue() instanceof Unknown) {
                    return (PartitionAssignmentState)getDescribePartitionResult.apply((TopicPartition)logEndOffsetResult.getKey(), Optional.empty());
                }
                if (logEndOffsetResult.getValue() instanceof Ignore) {
                    return null;
                }
                throw new IllegalStateException("Unknown LogOffset subclass: " + logEndOffsetResult.getValue());
            }).collect(Collectors.toList());
        }

        Map<String, Map<TopicPartition, OffsetAndMetadata>> resetOffsets() {
            List groupIds = this.opts.options.has(this.opts.allGroupsOpt) ? this.listConsumerGroups() : this.opts.options.valuesOf(this.opts.groupOpt);
            Map consumerGroups = this.adminClient.describeConsumerGroups((Collection)groupIds, this.withTimeoutMs(new DescribeConsumerGroupsOptions())).describedGroups();
            HashMap<String, Map<TopicPartition, OffsetAndMetadata>> result = new HashMap<String, Map<TopicPartition, OffsetAndMetadata>>();
            consumerGroups.forEach((groupId, groupDescription) -> {
                try {
                    String state;
                    switch (state = ((ConsumerGroupDescription)groupDescription.get()).state().toString()) {
                        case "Empty": 
                        case "Dead": {
                            boolean dryRun;
                            Collection<TopicPartition> partitionsToReset = this.getPartitionsToReset((String)groupId);
                            Map<TopicPartition, OffsetAndMetadata> preparedOffsets = this.prepareOffsetsToReset((String)groupId, partitionsToReset);
                            boolean bl = dryRun = this.opts.options.has(this.opts.dryRunOpt) || !this.opts.options.has(this.opts.executeOpt);
                            if (!dryRun) {
                                this.adminClient.alterConsumerGroupOffsets(groupId, preparedOffsets, this.withTimeoutMs(new AlterConsumerGroupOffsetsOptions())).all().get();
                            }
                            result.put((String)groupId, preparedOffsets);
                            break;
                        }
                        default: {
                            ConsumerGroupCommand.printError("Assignments can only be reset if the group '" + groupId + "' is inactive, but the current state is " + state + ".", Optional.empty());
                            result.put((String)groupId, Collections.emptyMap());
                            break;
                        }
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            });
            return result;
        }

        Map.Entry<Errors, Map<TopicPartition, Throwable>> deleteOffsets(String groupId, List<String> topics) {
            HashMap partitionLevelResult = new HashMap();
            HashSet<String> topicWithPartitions = new HashSet<String>();
            HashSet<String> topicWithoutPartitions = new HashSet<String>();
            for (String topic : topics) {
                if (topic.contains(":")) {
                    topicWithPartitions.add(topic);
                    continue;
                }
                topicWithoutPartitions.add(topic);
            }
            List knownPartitions = topicWithPartitions.stream().flatMap(this::parseTopicsWithPartitions).collect(Collectors.toList());
            DescribeTopicsResult describeTopicsResult = this.adminClient.describeTopics(topicWithoutPartitions, this.withTimeoutMs(new DescribeTopicsOptions()));
            Iterator unknownPartitions = describeTopicsResult.topicNameValues().entrySet().stream().flatMap(e -> {
                String topic = (String)e.getKey();
                try {
                    return ((TopicDescription)((KafkaFuture)e.getValue()).get()).partitions().stream().map(partition -> new TopicPartition(topic, partition.partition()));
                }
                catch (InterruptedException | ExecutionException err) {
                    partitionLevelResult.put(new TopicPartition(topic, -1), err);
                    return Stream.empty();
                }
            }).iterator();
            HashSet<TopicPartition> partitions = new HashSet<TopicPartition>(knownPartitions);
            unknownPartitions.forEachRemaining(partitions::add);
            DeleteConsumerGroupOffsetsResult deleteResult = this.adminClient.deleteConsumerGroupOffsets(groupId, partitions, this.withTimeoutMs(new DeleteConsumerGroupOffsetsOptions()));
            Errors topLevelException = Errors.NONE;
            try {
                deleteResult.all().get();
            }
            catch (InterruptedException | ExecutionException e2) {
                topLevelException = Errors.forException((Throwable)e2.getCause());
            }
            partitions.forEach(partition -> {
                try {
                    deleteResult.partitionResult(partition).get();
                    partitionLevelResult.put(partition, null);
                }
                catch (InterruptedException | ExecutionException e) {
                    partitionLevelResult.put(partition, e);
                }
            });
            return new AbstractMap.SimpleImmutableEntry<Errors, Map<TopicPartition, Throwable>>(topLevelException, partitionLevelResult);
        }

        void deleteOffsets() {
            String groupId = (String)this.opts.options.valueOf(this.opts.groupOpt);
            List topics = this.opts.options.valuesOf(this.opts.topicOpt);
            Map.Entry<Errors, Map<TopicPartition, Throwable>> res = this.deleteOffsets(groupId, topics);
            Errors topLevelResult = res.getKey();
            Map<TopicPartition, Throwable> partitionLevelResult = res.getValue();
            switch (topLevelResult) {
                case NONE: {
                    System.out.println("Request succeed for deleting offsets with topic " + String.join((CharSequence)", ", topics) + " group " + groupId);
                    break;
                }
                case INVALID_GROUP_ID: {
                    ConsumerGroupCommand.printError("'" + groupId + "' is not valid.", Optional.empty());
                    break;
                }
                case GROUP_ID_NOT_FOUND: {
                    ConsumerGroupCommand.printError("'" + groupId + "' does not exist.", Optional.empty());
                    break;
                }
                case GROUP_AUTHORIZATION_FAILED: {
                    ConsumerGroupCommand.printError("Access to '" + groupId + "' is not authorized.", Optional.empty());
                    break;
                }
                case NON_EMPTY_GROUP: {
                    ConsumerGroupCommand.printError("Deleting offsets of a consumer group '" + groupId + "' is forbidden if the group is not empty.", Optional.empty());
                    break;
                }
                case GROUP_SUBSCRIBED_TO_TOPIC: 
                case TOPIC_AUTHORIZATION_FAILED: 
                case UNKNOWN_TOPIC_OR_PARTITION: {
                    ConsumerGroupCommand.printError("Encounter some partition level error, see the follow-up details:", Optional.empty());
                    break;
                }
                default: {
                    ConsumerGroupCommand.printError("Encounter some unknown error: " + topLevelResult, Optional.empty());
                }
            }
            String format = "%-30s %-15s %-15s";
            System.out.printf("\n" + format, "TOPIC", "PARTITION", "STATUS");
            partitionLevelResult.entrySet().stream().sorted(Comparator.comparing(e -> ((TopicPartition)e.getKey()).topic() + ((TopicPartition)e.getKey()).partition())).forEach(e -> {
                TopicPartition tp = (TopicPartition)e.getKey();
                Throwable error = (Throwable)e.getValue();
                System.out.printf(format, tp.topic(), tp.partition() >= 0 ? Integer.valueOf(tp.partition()) : "Not Provided", error != null ? "Error: :" + error.getMessage() : "Successful");
            });
        }

        Map<String, ConsumerGroupDescription> describeConsumerGroups(Collection<String> groupIds) throws Exception {
            HashMap<String, ConsumerGroupDescription> res = new HashMap<String, ConsumerGroupDescription>();
            Map stringKafkaFutureMap = this.adminClient.describeConsumerGroups(groupIds, this.withTimeoutMs(new DescribeConsumerGroupsOptions())).describedGroups();
            for (Map.Entry e : stringKafkaFutureMap.entrySet()) {
                res.put((String)e.getKey(), (ConsumerGroupDescription)((KafkaFuture)e.getValue()).get());
            }
            return res;
        }

        Map.Entry<Optional<ConsumerGroupState>, Optional<Collection<PartitionAssignmentState>>> collectGroupOffsets(String groupId) throws Exception {
            return this.collectGroupsOffsets(Collections.singletonList(groupId)).getOrDefault(groupId, new AbstractMap.SimpleImmutableEntry(Optional.empty(), Optional.empty()));
        }

        TreeMap<String, Map.Entry<Optional<ConsumerGroupState>, Optional<Collection<PartitionAssignmentState>>>> collectGroupsOffsets(Collection<String> groupIds) throws Exception {
            Map<String, ConsumerGroupDescription> consumerGroups = this.describeConsumerGroups(groupIds);
            TreeMap<String, Map.Entry<Optional<ConsumerGroupState>, Optional<Collection<PartitionAssignmentState>>>> groupOffsets = new TreeMap<String, Map.Entry<Optional<ConsumerGroupState>, Optional<Collection<PartitionAssignmentState>>>>();
            consumerGroups.forEach((groupId, consumerGroup) -> {
                ConsumerGroupState state = consumerGroup.state();
                Map<TopicPartition, OffsetAndMetadata> committedOffsets = this.getCommittedOffsets((String)groupId);
                Function<TopicPartition, Optional<Long>> getPartitionOffset = tp -> Optional.ofNullable(committedOffsets.get(tp)).map(OffsetAndMetadata::offset);
                ArrayList assignedTopicPartitions = new ArrayList();
                Comparator<MemberDescription> comparator = Comparator.comparingInt(m -> m.assignment().topicPartitions().size()).reversed();
                ArrayList rowsWithConsumer = new ArrayList();
                consumerGroup.members().stream().filter(m -> !m.assignment().topicPartitions().isEmpty()).sorted(comparator).forEach(consumerSummary -> {
                    Set<TopicPartition> topicPartitions = this.getMemberAssignments((MemberDescription)consumerSummary, (String)groupId, committedOffsets);
                    assignedTopicPartitions.addAll(topicPartitions);
                    rowsWithConsumer.addAll(this.collectConsumerAssignment((String)groupId, Optional.of(consumerGroup.coordinator()), (Collection<TopicPartition>)topicPartitions, getPartitionOffset, Optional.of(consumerSummary.consumerId()), Optional.of(consumerSummary.host()), Optional.of(consumerSummary.clientId())));
                });
                HashMap unassignedPartitions = new HashMap();
                committedOffsets.entrySet().stream().filter(e -> !assignedTopicPartitions.contains(e.getKey())).forEach(e -> {
                    OffsetAndMetadata cfr_ignored_0 = (OffsetAndMetadata)unassignedPartitions.put(e.getKey(), e.getValue());
                });
                List rowsWithoutConsumer = !unassignedPartitions.isEmpty() ? this.collectConsumerAssignment((String)groupId, Optional.of(consumerGroup.coordinator()), (Collection<TopicPartition>)unassignedPartitions.keySet(), getPartitionOffset, Optional.of(ConsumerGroupCommand.MISSING_COLUMN_VALUE), Optional.of(ConsumerGroupCommand.MISSING_COLUMN_VALUE), Optional.of(ConsumerGroupCommand.MISSING_COLUMN_VALUE)) : Collections.emptyList();
                rowsWithConsumer.addAll(rowsWithoutConsumer);
                groupOffsets.put((String)groupId, new AbstractMap.SimpleImmutableEntry(Optional.of(state), Optional.of(rowsWithConsumer)));
            });
            return groupOffsets;
        }

        protected Set<TopicPartition> getMemberAssignments(MemberDescription memberDescription, String groupId, Map<TopicPartition, OffsetAndMetadata> committedOffsets) {
            if (TenantHelpers.isTenantPrefixed((String)groupId) && committedOffsets.keySet().stream().allMatch(TenantHelpers::isTenantPrefixed)) {
                String tenantPrefix = TenantHelpers.extractTenantPrefix((String)groupId);
                if (tenantPrefix == null) {
                    throw new IllegalStateException("No prefix found " + groupId);
                }
                return memberDescription.assignment().topicPartitions().stream().map(tp -> TenantHelpers.prefixWithTenant((String)tenantPrefix, (TopicPartition)tp)).collect(Collectors.toSet());
            }
            return memberDescription.assignment().topicPartitions();
        }

        Map.Entry<Optional<ConsumerGroupState>, Optional<Collection<MemberAssignmentState>>> collectGroupMembers(String groupId, boolean verbose) throws Exception {
            return this.collectGroupsMembers(Collections.singleton(groupId), verbose).get(groupId);
        }

        TreeMap<String, Map.Entry<Optional<ConsumerGroupState>, Optional<Collection<MemberAssignmentState>>>> collectGroupsMembers(Collection<String> groupIds, boolean verbose) throws Exception {
            Map<String, ConsumerGroupDescription> consumerGroups = this.describeConsumerGroups(groupIds);
            TreeMap<String, Map.Entry<Optional<ConsumerGroupState>, Optional<Collection<MemberAssignmentState>>>> res = new TreeMap<String, Map.Entry<Optional<ConsumerGroupState>, Optional<Collection<MemberAssignmentState>>>>();
            consumerGroups.forEach((groupId, consumerGroup) -> {
                ConsumerGroupState state = consumerGroup.state();
                List memberAssignmentStates = consumerGroup.members().stream().map(consumer -> new MemberAssignmentState((String)groupId, consumer.consumerId(), consumer.host(), consumer.clientId(), consumer.groupInstanceId().orElse(""), consumer.assignment().topicPartitions().size(), (List<TopicPartition>)new ArrayList<TopicPartition>(verbose ? consumer.assignment().topicPartitions() : Collections.emptySet()))).collect(Collectors.toList());
                res.put((String)groupId, new AbstractMap.SimpleImmutableEntry(Optional.of(state), Optional.of(memberAssignmentStates)));
            });
            return res;
        }

        GroupState collectGroupState(String groupId) throws Exception {
            return this.collectGroupsState(Collections.singleton(groupId)).get(groupId);
        }

        TreeMap<String, GroupState> collectGroupsState(Collection<String> groupIds) throws Exception {
            Map<String, ConsumerGroupDescription> consumerGroups = this.describeConsumerGroups(groupIds);
            TreeMap<String, GroupState> res = new TreeMap<String, GroupState>();
            consumerGroups.forEach((groupId, groupDescription) -> res.put((String)groupId, new GroupState((String)groupId, groupDescription.coordinator(), groupDescription.partitionAssignor(), groupDescription.state(), groupDescription.members().size())));
            return res;
        }

        private Map<TopicPartition, LogOffsetResult> getLogEndOffsets(Collection<TopicPartition> topicPartitions) {
            return this.getLogOffsets(topicPartitions, OffsetSpec.latest());
        }

        private Map<TopicPartition, LogOffsetResult> getLogStartOffsets(Collection<TopicPartition> topicPartitions) {
            return this.getLogOffsets(topicPartitions, OffsetSpec.earliest());
        }

        private Map<TopicPartition, LogOffsetResult> getLogOffsets(Collection<TopicPartition> topicPartitions, OffsetSpec offsetSpec) {
            try {
                Map startOffsets = topicPartitions.stream().collect(Collectors.toMap(Function.identity(), tp -> offsetSpec));
                Map offsets = (Map)this.adminClient.listOffsets(startOffsets, this.withTimeoutMs(new ListOffsetsOptions())).all().get();
                return topicPartitions.stream().collect(Collectors.toMap(Function.identity(), tp -> offsets.containsKey(tp) ? new LogOffset(((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp)).offset()) : new Unknown()));
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        private Map<TopicPartition, LogOffsetResult> getLogTimestampOffsets(Collection<TopicPartition> topicPartitions, long timestamp) {
            try {
                Map timestampOffsets = topicPartitions.stream().collect(Collectors.toMap(Function.identity(), tp -> OffsetSpec.forTimestamp((long)timestamp)));
                Map offsets = (Map)this.adminClient.listOffsets(timestampOffsets, this.withTimeoutMs(new ListOffsetsOptions())).all().get();
                HashMap successfulOffsetsForTimes = new HashMap();
                HashMap<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> unsuccessfulOffsetsForTimes = new HashMap<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo>();
                offsets.forEach((tp, offsetsResultInfo) -> {
                    if (offsetsResultInfo.offset() != -1L) {
                        successfulOffsetsForTimes.put(tp, offsetsResultInfo);
                    } else {
                        unsuccessfulOffsetsForTimes.put((TopicPartition)tp, (ListOffsetsResult.ListOffsetsResultInfo)offsetsResultInfo);
                    }
                });
                Map<TopicPartition, LogOffsetResult> successfulLogTimestampOffsets = successfulOffsetsForTimes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new LogOffset(((ListOffsetsResult.ListOffsetsResultInfo)e.getValue()).offset())));
                unsuccessfulOffsetsForTimes.forEach((tp, offsetResultInfo) -> System.out.println("\nWarn: Partition " + tp.partition() + " from topic " + tp.topic() + " is empty. Falling back to latest known offset."));
                successfulLogTimestampOffsets.putAll(this.getLogEndOffsets(unsuccessfulOffsetsForTimes.keySet()));
                return successfulLogTimestampOffsets;
            }
            catch (InterruptedException | ExecutionException e2) {
                throw new RuntimeException(e2);
            }
        }

        @Override
        public void close() {
            this.adminClient.close();
        }

        protected Admin createAdminClient(Map<String, String> configOverrides) throws IOException {
            Properties props = this.opts.options.has(this.opts.commandConfigOpt) ? Utils.loadProps((String)((String)this.opts.options.valueOf(this.opts.commandConfigOpt))) : new Properties();
            props.put("bootstrap.servers", this.opts.options.valueOf(this.opts.bootstrapServerOpt));
            props.putAll(configOverrides);
            return Admin.create((Properties)props);
        }

        private <T extends AbstractOptions<T>> T withTimeoutMs(T options) {
            int t = ((Long)this.opts.options.valueOf(this.opts.timeoutMsOpt)).intValue();
            return (T)options.timeoutMs(Integer.valueOf(t));
        }

        private Stream<TopicPartition> parseTopicsWithPartitions(String topicArg) {
            ToIntFunction<String> partitionNum = partition -> {
                try {
                    return Integer.parseInt(partition);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid partition '" + partition + "' specified in topic arg '" + topicArg + "''");
                }
            };
            String[] arr = topicArg.split(":");
            if (arr.length != 2) {
                throw new IllegalArgumentException("Invalid topic arg '" + topicArg + "', expected topic name and partitions");
            }
            String topic = arr[0];
            String partitions = arr[1];
            return Arrays.stream(partitions.split(",")).map(partition -> new TopicPartition(topic, partitionNum.applyAsInt((String)partition)));
        }

        private List<TopicPartition> parseTopicPartitionsToReset(List<String> topicArgs) throws ExecutionException, InterruptedException {
            ArrayList topicsWithPartitions = new ArrayList();
            ArrayList topics = new ArrayList();
            topicArgs.forEach(topicArg -> {
                if (topicArg.contains(":")) {
                    topicsWithPartitions.add(topicArg);
                } else {
                    topics.add(topicArg);
                }
            });
            List<TopicPartition> specifiedPartitions = topicsWithPartitions.stream().flatMap(this::parseTopicsWithPartitions).collect(Collectors.toList());
            ArrayList unspecifiedPartitions = new ArrayList();
            if (!topics.isEmpty()) {
                Map descriptionMap = (Map)this.adminClient.describeTopics(topics, this.withTimeoutMs(new DescribeTopicsOptions())).allTopicNames().get();
                descriptionMap.forEach((topic, description) -> description.partitions().forEach(tpInfo -> unspecifiedPartitions.add(new TopicPartition(topic, tpInfo.partition()))));
            }
            specifiedPartitions.addAll(unspecifiedPartitions);
            return specifiedPartitions;
        }

        private Collection<TopicPartition> getPartitionsToReset(String groupId) throws ExecutionException, InterruptedException {
            if (this.opts.options.has(this.opts.allTopicsOpt)) {
                return this.getCommittedOffsets(groupId).keySet();
            }
            if (this.opts.options.has(this.opts.topicOpt)) {
                List topics = this.opts.options.valuesOf(this.opts.topicOpt);
                return this.parseTopicPartitionsToReset(topics);
            }
            if (!this.opts.options.has(this.opts.resetFromFileOpt)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.opts.parser, (String)"One of the reset scopes should be defined: --all-topics, --topic.");
            }
            return Collections.emptyList();
        }

        private Map<TopicPartition, OffsetAndMetadata> getCommittedOffsets(String groupId) {
            try {
                return (Map)this.adminClient.listConsumerGroupOffsets(Collections.singletonMap(groupId, new ListConsumerGroupOffsetsSpec()), this.withTimeoutMs(new ListConsumerGroupOffsetsOptions())).partitionsToOffsetAndMetadata(groupId).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        private Map<String, Map<TopicPartition, OffsetAndMetadata>> parseResetPlan(String resetPlanCsv) {
            ObjectReader csvReader = CsvUtils.readerFor(CsvUtils.CsvRecordNoGroup.class);
            String[] lines = resetPlanCsv.split("\n");
            boolean isSingleGroupQuery = this.opts.options.valuesOf(this.opts.groupOpt).size() == 1;
            boolean isOldCsvFormat = false;
            try {
                if (lines.length > 0) {
                    csvReader.readValue(lines[0], CsvUtils.CsvRecordNoGroup.class);
                    isOldCsvFormat = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            HashMap<String, Map<TopicPartition, OffsetAndMetadata>> dataMap = new HashMap<String, Map<TopicPartition, OffsetAndMetadata>>();
            try {
                if (isSingleGroupQuery && isOldCsvFormat) {
                    String group = (String)this.opts.options.valueOf(this.opts.groupOpt);
                    for (String line : lines) {
                        CsvUtils.CsvRecordNoGroup rec = (CsvUtils.CsvRecordNoGroup)csvReader.readValue(line, CsvUtils.CsvRecordNoGroup.class);
                        dataMap.computeIfAbsent(group, k -> new HashMap()).put(new TopicPartition(rec.getTopic(), rec.getPartition()), new OffsetAndMetadata(rec.getOffset()));
                    }
                } else {
                    csvReader = CsvUtils.readerFor(CsvUtils.CsvRecordWithGroup.class);
                    for (String line : lines) {
                        CsvUtils.CsvRecordWithGroup rec = (CsvUtils.CsvRecordWithGroup)csvReader.readValue(line, CsvUtils.CsvRecordWithGroup.class);
                        dataMap.computeIfAbsent(rec.getGroup(), k -> new HashMap()).put(new TopicPartition(rec.getTopic(), rec.getPartition()), new OffsetAndMetadata(rec.getOffset()));
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return dataMap;
        }

        private Map<TopicPartition, OffsetAndMetadata> prepareOffsetsToReset(String groupId, Collection<TopicPartition> partitionsToReset) {
            if (this.opts.options.has(this.opts.resetToOffsetOpt)) {
                long offset = (Long)this.opts.options.valueOf(this.opts.resetToOffsetOpt);
                return this.checkOffsetsRange(partitionsToReset.stream().collect(Collectors.toMap(Function.identity(), tp -> offset))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new OffsetAndMetadata(((Long)e.getValue()).longValue())));
            }
            if (this.opts.options.has(this.opts.resetToEarliestOpt)) {
                Map<TopicPartition, LogOffsetResult> logStartOffsets = this.getLogStartOffsets(partitionsToReset);
                return partitionsToReset.stream().collect(Collectors.toMap(Function.identity(), topicPartition -> {
                    LogOffsetResult logOffsetResult = (LogOffsetResult)logStartOffsets.get(topicPartition);
                    if (!(logOffsetResult instanceof LogOffset)) {
                        ToolsUtils.printUsageAndExit(this.opts.parser, "Error getting starting offset of topic partition: " + topicPartition);
                        return null;
                    }
                    return new OffsetAndMetadata(((LogOffset)logOffsetResult).value);
                }));
            }
            if (this.opts.options.has(this.opts.resetToLatestOpt)) {
                Map<TopicPartition, LogOffsetResult> logEndOffsets = this.getLogEndOffsets(partitionsToReset);
                return partitionsToReset.stream().collect(Collectors.toMap(Function.identity(), topicPartition -> {
                    LogOffsetResult logOffsetResult = (LogOffsetResult)logEndOffsets.get(topicPartition);
                    if (!(logOffsetResult instanceof LogOffset)) {
                        ToolsUtils.printUsageAndExit(this.opts.parser, "Error getting ending offset of topic partition: " + topicPartition);
                        return null;
                    }
                    return new OffsetAndMetadata(((LogOffset)logOffsetResult).value);
                }));
            }
            if (this.opts.options.has(this.opts.resetShiftByOpt)) {
                Map<TopicPartition, OffsetAndMetadata> currentCommittedOffsets = this.getCommittedOffsets(groupId);
                Map<TopicPartition, Long> requestedOffsets = partitionsToReset.stream().collect(Collectors.toMap(Function.identity(), topicPartition -> {
                    long shiftBy = (Long)this.opts.options.valueOf(this.opts.resetShiftByOpt);
                    OffsetAndMetadata currentOffset = (OffsetAndMetadata)currentCommittedOffsets.get(topicPartition);
                    if (currentOffset == null) {
                        throw new IllegalArgumentException("Cannot shift offset for partition " + topicPartition + " since there is no current committed offset");
                    }
                    return currentOffset.offset() + shiftBy;
                }));
                return this.checkOffsetsRange(requestedOffsets).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new OffsetAndMetadata(((Long)e.getValue()).longValue())));
            }
            if (this.opts.options.has(this.opts.resetToDatetimeOpt)) {
                try {
                    long timestamp = Utils.getDateTime((String)((String)this.opts.options.valueOf(this.opts.resetToDatetimeOpt)));
                    Map<TopicPartition, LogOffsetResult> logTimestampOffsets = this.getLogTimestampOffsets(partitionsToReset, timestamp);
                    return partitionsToReset.stream().collect(Collectors.toMap(Function.identity(), topicPartition -> {
                        LogOffsetResult logTimestampOffset = (LogOffsetResult)logTimestampOffsets.get(topicPartition);
                        if (!(logTimestampOffset instanceof LogOffset)) {
                            ToolsUtils.printUsageAndExit(this.opts.parser, "Error getting offset by timestamp of topic partition: " + topicPartition);
                            return null;
                        }
                        return new OffsetAndMetadata(((LogOffset)logTimestampOffset).value);
                    }));
                }
                catch (ParseException e2) {
                    throw new RuntimeException(e2);
                }
            }
            if (this.opts.options.has(this.opts.resetByDurationOpt)) {
                String duration = (String)this.opts.options.valueOf(this.opts.resetByDurationOpt);
                Duration durationParsed = Duration.parse(duration);
                Instant now = Instant.now();
                durationParsed.negated().addTo(now);
                long timestamp = now.minus(durationParsed).toEpochMilli();
                Map<TopicPartition, LogOffsetResult> logTimestampOffsets = this.getLogTimestampOffsets(partitionsToReset, timestamp);
                return partitionsToReset.stream().collect(Collectors.toMap(Function.identity(), topicPartition -> {
                    LogOffsetResult logTimestampOffset = (LogOffsetResult)logTimestampOffsets.get(topicPartition);
                    if (!(logTimestampOffset instanceof LogOffset)) {
                        ToolsUtils.printUsageAndExit(this.opts.parser, "Error getting offset by timestamp of topic partition: " + topicPartition);
                        return null;
                    }
                    return new OffsetAndMetadata(((LogOffset)logTimestampOffset).value);
                }));
            }
            if (this.resetPlanFromFile().isPresent()) {
                return this.resetPlanFromFile().map(resetPlan -> {
                    Map resetPlanForGroup = (Map)resetPlan.get(groupId);
                    if (resetPlanForGroup == null) {
                        ConsumerGroupCommand.printError("No reset plan for group " + groupId + " found", Optional.empty());
                        return Collections.emptyMap();
                    }
                    Map<TopicPartition, Long> requestedOffsets = resetPlanForGroup.keySet().stream().collect(Collectors.toMap(Function.identity(), topicPartition -> ((OffsetAndMetadata)resetPlanForGroup.get(topicPartition)).offset()));
                    return this.checkOffsetsRange(requestedOffsets).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new OffsetAndMetadata(((Long)e.getValue()).longValue())));
                }).orElseGet(Collections::emptyMap);
            }
            if (this.opts.options.has(this.opts.resetToCurrentOpt)) {
                Map<TopicPartition, OffsetAndMetadata> currentCommittedOffsets = this.getCommittedOffsets(groupId);
                ArrayList<TopicPartition> partitionsToResetWithCommittedOffset = new ArrayList<TopicPartition>();
                ArrayList<TopicPartition> partitionsToResetWithoutCommittedOffset = new ArrayList<TopicPartition>();
                for (TopicPartition topicPartition2 : partitionsToReset) {
                    if (currentCommittedOffsets.containsKey(topicPartition2)) {
                        partitionsToResetWithCommittedOffset.add(topicPartition2);
                        continue;
                    }
                    partitionsToResetWithoutCommittedOffset.add(topicPartition2);
                }
                Map<TopicPartition, OffsetAndMetadata> preparedOffsetsForPartitionsWithCommittedOffset = partitionsToResetWithCommittedOffset.stream().collect(Collectors.toMap(Function.identity(), topicPartition -> {
                    OffsetAndMetadata committedOffset = (OffsetAndMetadata)currentCommittedOffsets.get(topicPartition);
                    if (committedOffset == null) {
                        throw new IllegalStateException("Expected a valid current offset for topic partition: " + topicPartition);
                    }
                    return new OffsetAndMetadata(committedOffset.offset());
                }));
                Map<TopicPartition, OffsetAndMetadata> preparedOffsetsForPartitionsWithoutCommittedOffset = this.getLogEndOffsets(partitionsToResetWithoutCommittedOffset).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
                    if (!(e.getValue() instanceof LogOffset)) {
                        ToolsUtils.printUsageAndExit(this.opts.parser, "Error getting ending offset of topic partition: " + e.getKey());
                        return null;
                    }
                    return new OffsetAndMetadata(((LogOffset)e.getValue()).value);
                }));
                preparedOffsetsForPartitionsWithCommittedOffset.putAll(preparedOffsetsForPartitionsWithoutCommittedOffset);
                return preparedOffsetsForPartitionsWithCommittedOffset;
            }
            ToolsUtils.printUsageAndExit(this.opts.parser, String.format("Option '%s' requires one of the following scenarios: %s", this.opts.resetOffsetsOpt, this.opts.allResetOffsetScenarioOpts));
            return null;
        }

        private Map<TopicPartition, Long> checkOffsetsRange(Map<TopicPartition, Long> requestedOffsets) {
            Map<TopicPartition, LogOffsetResult> logStartOffsets = this.getLogStartOffsets(requestedOffsets.keySet());
            Map<TopicPartition, LogOffsetResult> logEndOffsets = this.getLogEndOffsets(requestedOffsets.keySet());
            HashMap<TopicPartition, Long> res = new HashMap<TopicPartition, Long>();
            requestedOffsets.forEach((topicPartition, offset) -> {
                LogOffsetResult logEndOffset = (LogOffsetResult)logEndOffsets.get(topicPartition);
                if (logEndOffset != null) {
                    if (logEndOffset instanceof LogOffset && offset > ((LogOffset)logEndOffset).value) {
                        long endOffset = ((LogOffset)logEndOffset).value;
                        LOGGER.warn("New offset (" + offset + ") is higher than latest offset for topic partition " + topicPartition + ". Value will be set to " + endOffset);
                        res.put((TopicPartition)topicPartition, endOffset);
                    } else {
                        LogOffsetResult logStartOffset = (LogOffsetResult)logStartOffsets.get(topicPartition);
                        if (logStartOffset instanceof LogOffset && offset < ((LogOffset)logStartOffset).value) {
                            long startOffset = ((LogOffset)logStartOffset).value;
                            LOGGER.warn("New offset (" + offset + ") is lower than earliest offset for topic partition " + topicPartition + ". Value will be set to " + startOffset);
                            res.put((TopicPartition)topicPartition, startOffset);
                        } else {
                            res.put((TopicPartition)topicPartition, (Long)offset);
                        }
                    }
                } else {
                    throw new IllegalStateException("Unexpected non-existing offset value for topic partition " + topicPartition);
                }
            });
            return res;
        }

        String exportOffsetsToCsv(Map<String, Map<TopicPartition, OffsetAndMetadata>> assignments) {
            boolean isSingleGroupQuery = this.opts.options.valuesOf(this.opts.groupOpt).size() == 1;
            ObjectWriter csvWriter = isSingleGroupQuery ? CsvUtils.writerFor(CsvUtils.CsvRecordNoGroup.class) : CsvUtils.writerFor(CsvUtils.CsvRecordWithGroup.class);
            return assignments.entrySet().stream().flatMap(e -> {
                String groupId = (String)e.getKey();
                Map partitionInfo = (Map)e.getValue();
                return partitionInfo.entrySet().stream().map(e1 -> {
                    TopicPartition k = (TopicPartition)e1.getKey();
                    OffsetAndMetadata v = (OffsetAndMetadata)e1.getValue();
                    Object csvRecord = isSingleGroupQuery ? new CsvUtils.CsvRecordNoGroup(k.topic(), k.partition(), v.offset()) : new CsvUtils.CsvRecordWithGroup(groupId, k.topic(), k.partition(), v.offset());
                    try {
                        return csvWriter.writeValueAsString(csvRecord);
                    }
                    catch (JsonProcessingException err) {
                        throw new RuntimeException(err);
                    }
                });
            }).collect(Collectors.joining());
        }

        Map<String, Throwable> deleteGroups() {
            List groupIds = this.opts.options.has(this.opts.allGroupsOpt) ? this.listConsumerGroups() : this.opts.options.valuesOf(this.opts.groupOpt);
            Map groupsToDelete = this.adminClient.deleteConsumerGroups((Collection)groupIds, this.withTimeoutMs(new DeleteConsumerGroupsOptions())).deletedGroups();
            HashMap success = new HashMap();
            HashMap<String, Throwable> failed = new HashMap<String, Throwable>();
            groupsToDelete.forEach((g, f) -> {
                try {
                    f.get();
                    success.put(g, null);
                }
                catch (InterruptedException | ExecutionException e) {
                    failed.put((String)g, e);
                }
            });
            if (failed.isEmpty()) {
                System.out.println("Deletion of requested consumer groups ('" + success.keySet().stream().map(Object::toString).collect(Collectors.joining(", ")) + "') was successful.");
            } else {
                ConsumerGroupCommand.printError("Deletion of some consumer groups failed:", Optional.empty());
                failed.forEach((group, error) -> System.out.println("* Group '" + group + "' could not be deleted due to: " + error));
                if (!success.isEmpty()) {
                    System.out.println("\nThese consumer groups were deleted successfully: '" + success.keySet().stream().map(Object::toString).collect(Collectors.joining("'")) + "', '");
                }
            }
            failed.putAll(success);
            return failed;
        }
    }
}

