/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.completable;

import io.confluent.shaded.io.reactivex.Completable;
import io.confluent.shaded.io.reactivex.CompletableEmitter;
import io.confluent.shaded.io.reactivex.CompletableObserver;
import io.confluent.shaded.io.reactivex.CompletableOnSubscribe;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.functions.Cancellable;
import io.confluent.shaded.io.reactivex.internal.disposables.CancellableDisposable;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

public final class CompletableCreate
extends Completable {
    final CompletableOnSubscribe source;

    public CompletableCreate(CompletableOnSubscribe source) {
        this.source = source;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        Emitter parent = new Emitter(observer);
        observer.onSubscribe(parent);
        try {
            this.source.subscribe(parent);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            parent.onError(ex);
        }
    }

    static final class Emitter
    extends AtomicReference<Disposable>
    implements CompletableEmitter,
    Disposable {
        private static final long serialVersionUID = -2467358622224974244L;
        final CompletableObserver downstream;

        Emitter(CompletableObserver downstream) {
            this.downstream = downstream;
        }

        @Override
        public void onComplete() {
            Disposable d;
            if (this.get() != DisposableHelper.DISPOSED && (d = (Disposable)this.getAndSet(DisposableHelper.DISPOSED)) != DisposableHelper.DISPOSED) {
                try {
                    this.downstream.onComplete();
                }
                finally {
                    if (d != null) {
                        d.dispose();
                    }
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            if (!this.tryOnError(t)) {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public boolean tryOnError(Throwable t) {
            Disposable d;
            if (t == null) {
                t = new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources.");
            }
            if (this.get() != DisposableHelper.DISPOSED && (d = (Disposable)this.getAndSet(DisposableHelper.DISPOSED)) != DisposableHelper.DISPOSED) {
                try {
                    this.downstream.onError(t);
                }
                finally {
                    if (d != null) {
                        d.dispose();
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public void setDisposable(Disposable d) {
            DisposableHelper.set(this, d);
        }

        @Override
        public void setCancellable(Cancellable c) {
            this.setDisposable(new CancellableDisposable(c));
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public String toString() {
            return String.format("%s{%s}", this.getClass().getSimpleName(), super.toString());
        }
    }
}

