/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.org.asynchttpclient.netty.request;

import io.confluent.shaded.org.asynchttpclient.netty.NettyResponseFuture;
import io.confluent.shaded.org.asynchttpclient.netty.request.WriteListener;
import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;

public class WriteProgressListener
extends WriteListener
implements ChannelProgressiveFutureListener {
    private final long expectedTotal;
    private long lastProgress = 0L;

    public WriteProgressListener(NettyResponseFuture<?> future, boolean notifyHeaders, long expectedTotal) {
        super(future, notifyHeaders);
        this.expectedTotal = expectedTotal;
    }

    public void operationComplete(ChannelProgressiveFuture cf) {
        this.operationComplete(cf.channel(), cf.cause());
    }

    public void operationProgressed(ChannelProgressiveFuture f, long progress, long total) {
        this.future.touch();
        if (this.progressAsyncHandler != null && !this.notifyHeaders) {
            long lastLastProgress = this.lastProgress;
            this.lastProgress = progress;
            if (total < 0L) {
                total = this.expectedTotal;
            }
            if (progress != lastLastProgress) {
                this.progressAsyncHandler.onContentWriteProgress(progress - lastLastProgress, progress, total);
            }
        }
    }
}

