/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.org.asynchttpclient.netty.timeout;

import io.confluent.shaded.org.asynchttpclient.netty.NettyResponseFuture;
import io.confluent.shaded.org.asynchttpclient.netty.request.NettyRequestSender;
import io.confluent.shaded.org.asynchttpclient.netty.timeout.TimeoutTimerTask;
import io.confluent.shaded.org.asynchttpclient.netty.timeout.TimeoutsHolder;
import io.confluent.shaded.org.asynchttpclient.util.DateUtils;
import io.confluent.shaded.org.asynchttpclient.util.StringBuilderPool;
import io.netty.util.Timeout;

public class RequestTimeoutTimerTask
extends TimeoutTimerTask {
    private final long requestTimeout;

    RequestTimeoutTimerTask(NettyResponseFuture<?> nettyResponseFuture, NettyRequestSender requestSender, TimeoutsHolder timeoutsHolder, int requestTimeout) {
        super(nettyResponseFuture, requestSender, timeoutsHolder);
        this.requestTimeout = requestTimeout;
    }

    public void run(Timeout timeout) {
        if (this.done.getAndSet(true) || this.requestSender.isClosed()) {
            return;
        }
        this.timeoutsHolder.cancel();
        if (this.nettyResponseFuture.isDone()) {
            return;
        }
        StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder().append("Request timeout to ");
        this.appendRemoteAddress(sb);
        String message = sb.append(" after ").append(this.requestTimeout).append(" ms").toString();
        long age = DateUtils.unpreciseMillisTime() - this.nettyResponseFuture.getStart();
        this.expire(message, age);
    }
}

