/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client;

import com.google.gson.reflect.TypeToken;
import io.confluent.flink.apiserver.client.ApiCallback;
import io.confluent.flink.apiserver.client.ApiClient;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.ApiResponse;
import io.confluent.flink.apiserver.client.Configuration;
import io.confluent.flink.apiserver.client.Pair;
import io.confluent.flink.apiserver.client.model.CoreV1Environment;
import io.confluent.flink.apiserver.client.model.CoreV1EnvironmentList;
import io.confluent.flink.apiserver.client.model.CoreV1Org;
import io.confluent.flink.apiserver.client.model.CoreV1OrgList;
import io.confluent.flink.apiserver.client.model.CoreV1Quota;
import io.confluent.flink.apiserver.client.model.CoreV1QuotaList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class CoreV1Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CoreV1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public CoreV1Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createCoreV1EnvironmentCall(String org, CoreV1Environment coreV1Environment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CoreV1Environment localVarPostBody = coreV1Environment;
        String localVarPath = "/apis/core/v1/orgs/{org}/environments".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCoreV1EnvironmentValidateBeforeCall(String org, CoreV1Environment coreV1Environment, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createCoreV1Environment(Async)");
        }
        if (coreV1Environment == null) {
            throw new ApiException("Missing the required parameter 'coreV1Environment' when calling createCoreV1Environment(Async)");
        }
        return this.createCoreV1EnvironmentCall(org, coreV1Environment, _callback);
    }

    public CoreV1Environment createCoreV1Environment(String org, CoreV1Environment coreV1Environment) throws ApiException {
        ApiResponse<CoreV1Environment> localVarResp = this.createCoreV1EnvironmentWithHttpInfo(org, coreV1Environment);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Environment> createCoreV1EnvironmentWithHttpInfo(String org, CoreV1Environment coreV1Environment) throws ApiException {
        Call localVarCall = this.createCoreV1EnvironmentValidateBeforeCall(org, coreV1Environment, null);
        Type localVarReturnType = new TypeToken<CoreV1Environment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createCoreV1EnvironmentAsync(String org, CoreV1Environment coreV1Environment, ApiCallback<CoreV1Environment> _callback) throws ApiException {
        Call localVarCall = this.createCoreV1EnvironmentValidateBeforeCall(org, coreV1Environment, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Environment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createCoreV1OrgCall(CoreV1Org coreV1Org, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CoreV1Org localVarPostBody = coreV1Org;
        String localVarPath = "/apis/core/v1/orgs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCoreV1OrgValidateBeforeCall(CoreV1Org coreV1Org, ApiCallback _callback) throws ApiException {
        if (coreV1Org == null) {
            throw new ApiException("Missing the required parameter 'coreV1Org' when calling createCoreV1Org(Async)");
        }
        return this.createCoreV1OrgCall(coreV1Org, _callback);
    }

    public CoreV1Org createCoreV1Org(CoreV1Org coreV1Org) throws ApiException {
        ApiResponse<CoreV1Org> localVarResp = this.createCoreV1OrgWithHttpInfo(coreV1Org);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Org> createCoreV1OrgWithHttpInfo(CoreV1Org coreV1Org) throws ApiException {
        Call localVarCall = this.createCoreV1OrgValidateBeforeCall(coreV1Org, null);
        Type localVarReturnType = new TypeToken<CoreV1Org>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createCoreV1OrgAsync(CoreV1Org coreV1Org, ApiCallback<CoreV1Org> _callback) throws ApiException {
        Call localVarCall = this.createCoreV1OrgValidateBeforeCall(coreV1Org, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Org>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createCoreV1QuotaCall(String environment, String org, CoreV1Quota coreV1Quota, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CoreV1Quota localVarPostBody = coreV1Quota;
        String localVarPath = "/apis/core/v1/orgs/{org}/environments/{environment}/quotas".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCoreV1QuotaValidateBeforeCall(String environment, String org, CoreV1Quota coreV1Quota, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createCoreV1Quota(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createCoreV1Quota(Async)");
        }
        if (coreV1Quota == null) {
            throw new ApiException("Missing the required parameter 'coreV1Quota' when calling createCoreV1Quota(Async)");
        }
        return this.createCoreV1QuotaCall(environment, org, coreV1Quota, _callback);
    }

    public CoreV1Quota createCoreV1Quota(String environment, String org, CoreV1Quota coreV1Quota) throws ApiException {
        ApiResponse<CoreV1Quota> localVarResp = this.createCoreV1QuotaWithHttpInfo(environment, org, coreV1Quota);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Quota> createCoreV1QuotaWithHttpInfo(String environment, String org, CoreV1Quota coreV1Quota) throws ApiException {
        Call localVarCall = this.createCoreV1QuotaValidateBeforeCall(environment, org, coreV1Quota, null);
        Type localVarReturnType = new TypeToken<CoreV1Quota>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createCoreV1QuotaAsync(String environment, String org, CoreV1Quota coreV1Quota, ApiCallback<CoreV1Quota> _callback) throws ApiException {
        Call localVarCall = this.createCoreV1QuotaValidateBeforeCall(environment, org, coreV1Quota, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Quota>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCoreV1EnvironmentCall(String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/core/v1/orgs/{org}/environments/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCoreV1EnvironmentValidateBeforeCall(String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteCoreV1Environment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteCoreV1Environment(Async)");
        }
        return this.deleteCoreV1EnvironmentCall(name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public CoreV1Environment deleteCoreV1Environment(String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<CoreV1Environment> localVarResp = this.deleteCoreV1EnvironmentWithHttpInfo(name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Environment> deleteCoreV1EnvironmentWithHttpInfo(String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteCoreV1EnvironmentValidateBeforeCall(name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<CoreV1Environment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteCoreV1EnvironmentAsync(String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<CoreV1Environment> _callback) throws ApiException {
        Call localVarCall = this.deleteCoreV1EnvironmentValidateBeforeCall(name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Environment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCoreV1OrgCall(String name, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/core/v1/orgs/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCoreV1OrgValidateBeforeCall(String name, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteCoreV1Org(Async)");
        }
        return this.deleteCoreV1OrgCall(name, propagationPolicy, resourceVersion, uid, _callback);
    }

    public CoreV1Org deleteCoreV1Org(String name, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<CoreV1Org> localVarResp = this.deleteCoreV1OrgWithHttpInfo(name, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Org> deleteCoreV1OrgWithHttpInfo(String name, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteCoreV1OrgValidateBeforeCall(name, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<CoreV1Org>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteCoreV1OrgAsync(String name, String propagationPolicy, String resourceVersion, String uid, ApiCallback<CoreV1Org> _callback) throws ApiException {
        Call localVarCall = this.deleteCoreV1OrgValidateBeforeCall(name, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Org>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCoreV1QuotaCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/core/v1/orgs/{org}/environments/{environment}/quotas/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCoreV1QuotaValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteCoreV1Quota(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteCoreV1Quota(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteCoreV1Quota(Async)");
        }
        return this.deleteCoreV1QuotaCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public CoreV1Quota deleteCoreV1Quota(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<CoreV1Quota> localVarResp = this.deleteCoreV1QuotaWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Quota> deleteCoreV1QuotaWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteCoreV1QuotaValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<CoreV1Quota>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteCoreV1QuotaAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<CoreV1Quota> _callback) throws ApiException {
        Call localVarCall = this.deleteCoreV1QuotaValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Quota>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listCoreV1EnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/core/v1/orgs/{org}/environments".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCoreV1EnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listCoreV1Environments(Async)");
        }
        return this.listCoreV1EnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public CoreV1EnvironmentList listCoreV1Environments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<CoreV1EnvironmentList> localVarResp = this.listCoreV1EnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1EnvironmentList> listCoreV1EnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listCoreV1EnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<CoreV1EnvironmentList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCoreV1EnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<CoreV1EnvironmentList> _callback) throws ApiException {
        Call localVarCall = this.listCoreV1EnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<CoreV1EnvironmentList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listCoreV1OrgsCall(String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/core/v1/orgs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCoreV1OrgsValidateBeforeCall(String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        return this.listCoreV1OrgsCall(_continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public CoreV1OrgList listCoreV1Orgs(String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<CoreV1OrgList> localVarResp = this.listCoreV1OrgsWithHttpInfo(_continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1OrgList> listCoreV1OrgsWithHttpInfo(String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listCoreV1OrgsValidateBeforeCall(_continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<CoreV1OrgList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCoreV1OrgsAsync(String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<CoreV1OrgList> _callback) throws ApiException {
        Call localVarCall = this.listCoreV1OrgsValidateBeforeCall(_continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<CoreV1OrgList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listCoreV1QuotasCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/core/v1/orgs/{org}/environments/{environment}/quotas".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCoreV1QuotasValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listCoreV1Quotas(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listCoreV1Quotas(Async)");
        }
        return this.listCoreV1QuotasCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public CoreV1QuotaList listCoreV1Quotas(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<CoreV1QuotaList> localVarResp = this.listCoreV1QuotasWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1QuotaList> listCoreV1QuotasWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listCoreV1QuotasValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<CoreV1QuotaList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCoreV1QuotasAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<CoreV1QuotaList> _callback) throws ApiException {
        Call localVarCall = this.listCoreV1QuotasValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<CoreV1QuotaList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listCoreV1QuotasForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/core/v1/orgs/{org}/quotas".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCoreV1QuotasForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listCoreV1QuotasForAllEnvironments(Async)");
        }
        return this.listCoreV1QuotasForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public CoreV1QuotaList listCoreV1QuotasForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<CoreV1QuotaList> localVarResp = this.listCoreV1QuotasForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1QuotaList> listCoreV1QuotasForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listCoreV1QuotasForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<CoreV1QuotaList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCoreV1QuotasForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<CoreV1QuotaList> _callback) throws ApiException {
        Call localVarCall = this.listCoreV1QuotasForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<CoreV1QuotaList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchCoreV1EnvironmentCall(String name, String org, CoreV1Environment coreV1Environment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CoreV1Environment localVarPostBody = coreV1Environment;
        String localVarPath = "/apis/core/v1/orgs/{org}/environments/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchCoreV1EnvironmentValidateBeforeCall(String name, String org, CoreV1Environment coreV1Environment, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchCoreV1Environment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchCoreV1Environment(Async)");
        }
        if (coreV1Environment == null) {
            throw new ApiException("Missing the required parameter 'coreV1Environment' when calling patchCoreV1Environment(Async)");
        }
        return this.patchCoreV1EnvironmentCall(name, org, coreV1Environment, _callback);
    }

    public CoreV1Environment patchCoreV1Environment(String name, String org, CoreV1Environment coreV1Environment) throws ApiException {
        ApiResponse<CoreV1Environment> localVarResp = this.patchCoreV1EnvironmentWithHttpInfo(name, org, coreV1Environment);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Environment> patchCoreV1EnvironmentWithHttpInfo(String name, String org, CoreV1Environment coreV1Environment) throws ApiException {
        Call localVarCall = this.patchCoreV1EnvironmentValidateBeforeCall(name, org, coreV1Environment, null);
        Type localVarReturnType = new TypeToken<CoreV1Environment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchCoreV1EnvironmentAsync(String name, String org, CoreV1Environment coreV1Environment, ApiCallback<CoreV1Environment> _callback) throws ApiException {
        Call localVarCall = this.patchCoreV1EnvironmentValidateBeforeCall(name, org, coreV1Environment, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Environment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchCoreV1EnvironmentFinalizersCall(String name, String org, CoreV1Environment coreV1Environment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CoreV1Environment localVarPostBody = coreV1Environment;
        String localVarPath = "/apis/core/v1/orgs/{org}/environments/{name}/finalizers".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchCoreV1EnvironmentFinalizersValidateBeforeCall(String name, String org, CoreV1Environment coreV1Environment, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchCoreV1EnvironmentFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchCoreV1EnvironmentFinalizers(Async)");
        }
        if (coreV1Environment == null) {
            throw new ApiException("Missing the required parameter 'coreV1Environment' when calling patchCoreV1EnvironmentFinalizers(Async)");
        }
        return this.patchCoreV1EnvironmentFinalizersCall(name, org, coreV1Environment, _callback);
    }

    public CoreV1Environment patchCoreV1EnvironmentFinalizers(String name, String org, CoreV1Environment coreV1Environment) throws ApiException {
        ApiResponse<CoreV1Environment> localVarResp = this.patchCoreV1EnvironmentFinalizersWithHttpInfo(name, org, coreV1Environment);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Environment> patchCoreV1EnvironmentFinalizersWithHttpInfo(String name, String org, CoreV1Environment coreV1Environment) throws ApiException {
        Call localVarCall = this.patchCoreV1EnvironmentFinalizersValidateBeforeCall(name, org, coreV1Environment, null);
        Type localVarReturnType = new TypeToken<CoreV1Environment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchCoreV1EnvironmentFinalizersAsync(String name, String org, CoreV1Environment coreV1Environment, ApiCallback<CoreV1Environment> _callback) throws ApiException {
        Call localVarCall = this.patchCoreV1EnvironmentFinalizersValidateBeforeCall(name, org, coreV1Environment, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Environment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchCoreV1OrgCall(String name, CoreV1Org coreV1Org, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CoreV1Org localVarPostBody = coreV1Org;
        String localVarPath = "/apis/core/v1/orgs/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchCoreV1OrgValidateBeforeCall(String name, CoreV1Org coreV1Org, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchCoreV1Org(Async)");
        }
        if (coreV1Org == null) {
            throw new ApiException("Missing the required parameter 'coreV1Org' when calling patchCoreV1Org(Async)");
        }
        return this.patchCoreV1OrgCall(name, coreV1Org, _callback);
    }

    public CoreV1Org patchCoreV1Org(String name, CoreV1Org coreV1Org) throws ApiException {
        ApiResponse<CoreV1Org> localVarResp = this.patchCoreV1OrgWithHttpInfo(name, coreV1Org);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Org> patchCoreV1OrgWithHttpInfo(String name, CoreV1Org coreV1Org) throws ApiException {
        Call localVarCall = this.patchCoreV1OrgValidateBeforeCall(name, coreV1Org, null);
        Type localVarReturnType = new TypeToken<CoreV1Org>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchCoreV1OrgAsync(String name, CoreV1Org coreV1Org, ApiCallback<CoreV1Org> _callback) throws ApiException {
        Call localVarCall = this.patchCoreV1OrgValidateBeforeCall(name, coreV1Org, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Org>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchCoreV1OrgFinalizersCall(String name, CoreV1Org coreV1Org, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CoreV1Org localVarPostBody = coreV1Org;
        String localVarPath = "/apis/core/v1/orgs/{name}/finalizers".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchCoreV1OrgFinalizersValidateBeforeCall(String name, CoreV1Org coreV1Org, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchCoreV1OrgFinalizers(Async)");
        }
        if (coreV1Org == null) {
            throw new ApiException("Missing the required parameter 'coreV1Org' when calling patchCoreV1OrgFinalizers(Async)");
        }
        return this.patchCoreV1OrgFinalizersCall(name, coreV1Org, _callback);
    }

    public CoreV1Org patchCoreV1OrgFinalizers(String name, CoreV1Org coreV1Org) throws ApiException {
        ApiResponse<CoreV1Org> localVarResp = this.patchCoreV1OrgFinalizersWithHttpInfo(name, coreV1Org);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Org> patchCoreV1OrgFinalizersWithHttpInfo(String name, CoreV1Org coreV1Org) throws ApiException {
        Call localVarCall = this.patchCoreV1OrgFinalizersValidateBeforeCall(name, coreV1Org, null);
        Type localVarReturnType = new TypeToken<CoreV1Org>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchCoreV1OrgFinalizersAsync(String name, CoreV1Org coreV1Org, ApiCallback<CoreV1Org> _callback) throws ApiException {
        Call localVarCall = this.patchCoreV1OrgFinalizersValidateBeforeCall(name, coreV1Org, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Org>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchCoreV1QuotaCall(String environment, String name, String org, CoreV1Quota coreV1Quota, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CoreV1Quota localVarPostBody = coreV1Quota;
        String localVarPath = "/apis/core/v1/orgs/{org}/environments/{environment}/quotas/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchCoreV1QuotaValidateBeforeCall(String environment, String name, String org, CoreV1Quota coreV1Quota, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchCoreV1Quota(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchCoreV1Quota(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchCoreV1Quota(Async)");
        }
        if (coreV1Quota == null) {
            throw new ApiException("Missing the required parameter 'coreV1Quota' when calling patchCoreV1Quota(Async)");
        }
        return this.patchCoreV1QuotaCall(environment, name, org, coreV1Quota, _callback);
    }

    public CoreV1Quota patchCoreV1Quota(String environment, String name, String org, CoreV1Quota coreV1Quota) throws ApiException {
        ApiResponse<CoreV1Quota> localVarResp = this.patchCoreV1QuotaWithHttpInfo(environment, name, org, coreV1Quota);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Quota> patchCoreV1QuotaWithHttpInfo(String environment, String name, String org, CoreV1Quota coreV1Quota) throws ApiException {
        Call localVarCall = this.patchCoreV1QuotaValidateBeforeCall(environment, name, org, coreV1Quota, null);
        Type localVarReturnType = new TypeToken<CoreV1Quota>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchCoreV1QuotaAsync(String environment, String name, String org, CoreV1Quota coreV1Quota, ApiCallback<CoreV1Quota> _callback) throws ApiException {
        Call localVarCall = this.patchCoreV1QuotaValidateBeforeCall(environment, name, org, coreV1Quota, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Quota>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchCoreV1QuotaFinalizersCall(String environment, String name, String org, CoreV1Quota coreV1Quota, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CoreV1Quota localVarPostBody = coreV1Quota;
        String localVarPath = "/apis/core/v1/orgs/{org}/environments/{environment}/quotas/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchCoreV1QuotaFinalizersValidateBeforeCall(String environment, String name, String org, CoreV1Quota coreV1Quota, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchCoreV1QuotaFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchCoreV1QuotaFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchCoreV1QuotaFinalizers(Async)");
        }
        if (coreV1Quota == null) {
            throw new ApiException("Missing the required parameter 'coreV1Quota' when calling patchCoreV1QuotaFinalizers(Async)");
        }
        return this.patchCoreV1QuotaFinalizersCall(environment, name, org, coreV1Quota, _callback);
    }

    public CoreV1Quota patchCoreV1QuotaFinalizers(String environment, String name, String org, CoreV1Quota coreV1Quota) throws ApiException {
        ApiResponse<CoreV1Quota> localVarResp = this.patchCoreV1QuotaFinalizersWithHttpInfo(environment, name, org, coreV1Quota);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Quota> patchCoreV1QuotaFinalizersWithHttpInfo(String environment, String name, String org, CoreV1Quota coreV1Quota) throws ApiException {
        Call localVarCall = this.patchCoreV1QuotaFinalizersValidateBeforeCall(environment, name, org, coreV1Quota, null);
        Type localVarReturnType = new TypeToken<CoreV1Quota>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchCoreV1QuotaFinalizersAsync(String environment, String name, String org, CoreV1Quota coreV1Quota, ApiCallback<CoreV1Quota> _callback) throws ApiException {
        Call localVarCall = this.patchCoreV1QuotaFinalizersValidateBeforeCall(environment, name, org, coreV1Quota, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Quota>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchCoreV1QuotaStatusCall(String environment, String name, String org, CoreV1Quota coreV1Quota, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CoreV1Quota localVarPostBody = coreV1Quota;
        String localVarPath = "/apis/core/v1/orgs/{org}/environments/{environment}/quotas/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchCoreV1QuotaStatusValidateBeforeCall(String environment, String name, String org, CoreV1Quota coreV1Quota, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchCoreV1QuotaStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchCoreV1QuotaStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchCoreV1QuotaStatus(Async)");
        }
        if (coreV1Quota == null) {
            throw new ApiException("Missing the required parameter 'coreV1Quota' when calling patchCoreV1QuotaStatus(Async)");
        }
        return this.patchCoreV1QuotaStatusCall(environment, name, org, coreV1Quota, _callback);
    }

    public CoreV1Quota patchCoreV1QuotaStatus(String environment, String name, String org, CoreV1Quota coreV1Quota) throws ApiException {
        ApiResponse<CoreV1Quota> localVarResp = this.patchCoreV1QuotaStatusWithHttpInfo(environment, name, org, coreV1Quota);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Quota> patchCoreV1QuotaStatusWithHttpInfo(String environment, String name, String org, CoreV1Quota coreV1Quota) throws ApiException {
        Call localVarCall = this.patchCoreV1QuotaStatusValidateBeforeCall(environment, name, org, coreV1Quota, null);
        Type localVarReturnType = new TypeToken<CoreV1Quota>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchCoreV1QuotaStatusAsync(String environment, String name, String org, CoreV1Quota coreV1Quota, ApiCallback<CoreV1Quota> _callback) throws ApiException {
        Call localVarCall = this.patchCoreV1QuotaStatusValidateBeforeCall(environment, name, org, coreV1Quota, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Quota>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readCoreV1EnvironmentCall(String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/core/v1/orgs/{org}/environments/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readCoreV1EnvironmentValidateBeforeCall(String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readCoreV1Environment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readCoreV1Environment(Async)");
        }
        return this.readCoreV1EnvironmentCall(name, org, resourceVersion, _callback);
    }

    public CoreV1Environment readCoreV1Environment(String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<CoreV1Environment> localVarResp = this.readCoreV1EnvironmentWithHttpInfo(name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Environment> readCoreV1EnvironmentWithHttpInfo(String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readCoreV1EnvironmentValidateBeforeCall(name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<CoreV1Environment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readCoreV1EnvironmentAsync(String name, String org, String resourceVersion, ApiCallback<CoreV1Environment> _callback) throws ApiException {
        Call localVarCall = this.readCoreV1EnvironmentValidateBeforeCall(name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Environment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readCoreV1EnvironmentFinalizersCall(String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/core/v1/orgs/{org}/environments/{name}/finalizers".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readCoreV1EnvironmentFinalizersValidateBeforeCall(String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readCoreV1EnvironmentFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readCoreV1EnvironmentFinalizers(Async)");
        }
        return this.readCoreV1EnvironmentFinalizersCall(name, org, resourceVersion, _callback);
    }

    public CoreV1Environment readCoreV1EnvironmentFinalizers(String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<CoreV1Environment> localVarResp = this.readCoreV1EnvironmentFinalizersWithHttpInfo(name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Environment> readCoreV1EnvironmentFinalizersWithHttpInfo(String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readCoreV1EnvironmentFinalizersValidateBeforeCall(name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<CoreV1Environment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readCoreV1EnvironmentFinalizersAsync(String name, String org, String resourceVersion, ApiCallback<CoreV1Environment> _callback) throws ApiException {
        Call localVarCall = this.readCoreV1EnvironmentFinalizersValidateBeforeCall(name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Environment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readCoreV1OrgCall(String name, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/core/v1/orgs/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readCoreV1OrgValidateBeforeCall(String name, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readCoreV1Org(Async)");
        }
        return this.readCoreV1OrgCall(name, resourceVersion, _callback);
    }

    public CoreV1Org readCoreV1Org(String name, String resourceVersion) throws ApiException {
        ApiResponse<CoreV1Org> localVarResp = this.readCoreV1OrgWithHttpInfo(name, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Org> readCoreV1OrgWithHttpInfo(String name, String resourceVersion) throws ApiException {
        Call localVarCall = this.readCoreV1OrgValidateBeforeCall(name, resourceVersion, null);
        Type localVarReturnType = new TypeToken<CoreV1Org>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readCoreV1OrgAsync(String name, String resourceVersion, ApiCallback<CoreV1Org> _callback) throws ApiException {
        Call localVarCall = this.readCoreV1OrgValidateBeforeCall(name, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Org>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readCoreV1OrgFinalizersCall(String name, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/core/v1/orgs/{name}/finalizers".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readCoreV1OrgFinalizersValidateBeforeCall(String name, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readCoreV1OrgFinalizers(Async)");
        }
        return this.readCoreV1OrgFinalizersCall(name, resourceVersion, _callback);
    }

    public CoreV1Org readCoreV1OrgFinalizers(String name, String resourceVersion) throws ApiException {
        ApiResponse<CoreV1Org> localVarResp = this.readCoreV1OrgFinalizersWithHttpInfo(name, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Org> readCoreV1OrgFinalizersWithHttpInfo(String name, String resourceVersion) throws ApiException {
        Call localVarCall = this.readCoreV1OrgFinalizersValidateBeforeCall(name, resourceVersion, null);
        Type localVarReturnType = new TypeToken<CoreV1Org>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readCoreV1OrgFinalizersAsync(String name, String resourceVersion, ApiCallback<CoreV1Org> _callback) throws ApiException {
        Call localVarCall = this.readCoreV1OrgFinalizersValidateBeforeCall(name, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Org>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readCoreV1QuotaCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/core/v1/orgs/{org}/environments/{environment}/quotas/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readCoreV1QuotaValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readCoreV1Quota(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readCoreV1Quota(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readCoreV1Quota(Async)");
        }
        return this.readCoreV1QuotaCall(environment, name, org, resourceVersion, _callback);
    }

    public CoreV1Quota readCoreV1Quota(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<CoreV1Quota> localVarResp = this.readCoreV1QuotaWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Quota> readCoreV1QuotaWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readCoreV1QuotaValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<CoreV1Quota>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readCoreV1QuotaAsync(String environment, String name, String org, String resourceVersion, ApiCallback<CoreV1Quota> _callback) throws ApiException {
        Call localVarCall = this.readCoreV1QuotaValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Quota>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readCoreV1QuotaFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/core/v1/orgs/{org}/environments/{environment}/quotas/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readCoreV1QuotaFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readCoreV1QuotaFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readCoreV1QuotaFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readCoreV1QuotaFinalizers(Async)");
        }
        return this.readCoreV1QuotaFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public CoreV1Quota readCoreV1QuotaFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<CoreV1Quota> localVarResp = this.readCoreV1QuotaFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Quota> readCoreV1QuotaFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readCoreV1QuotaFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<CoreV1Quota>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readCoreV1QuotaFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<CoreV1Quota> _callback) throws ApiException {
        Call localVarCall = this.readCoreV1QuotaFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Quota>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readCoreV1QuotaStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/core/v1/orgs/{org}/environments/{environment}/quotas/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readCoreV1QuotaStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readCoreV1QuotaStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readCoreV1QuotaStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readCoreV1QuotaStatus(Async)");
        }
        return this.readCoreV1QuotaStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public CoreV1Quota readCoreV1QuotaStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<CoreV1Quota> localVarResp = this.readCoreV1QuotaStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Quota> readCoreV1QuotaStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readCoreV1QuotaStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<CoreV1Quota>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readCoreV1QuotaStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<CoreV1Quota> _callback) throws ApiException {
        Call localVarCall = this.readCoreV1QuotaStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Quota>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateCoreV1EnvironmentCall(String name, String org, CoreV1Environment coreV1Environment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CoreV1Environment localVarPostBody = coreV1Environment;
        String localVarPath = "/apis/core/v1/orgs/{org}/environments/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateCoreV1EnvironmentValidateBeforeCall(String name, String org, CoreV1Environment coreV1Environment, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateCoreV1Environment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateCoreV1Environment(Async)");
        }
        if (coreV1Environment == null) {
            throw new ApiException("Missing the required parameter 'coreV1Environment' when calling updateCoreV1Environment(Async)");
        }
        return this.updateCoreV1EnvironmentCall(name, org, coreV1Environment, _callback);
    }

    public CoreV1Environment updateCoreV1Environment(String name, String org, CoreV1Environment coreV1Environment) throws ApiException {
        ApiResponse<CoreV1Environment> localVarResp = this.updateCoreV1EnvironmentWithHttpInfo(name, org, coreV1Environment);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Environment> updateCoreV1EnvironmentWithHttpInfo(String name, String org, CoreV1Environment coreV1Environment) throws ApiException {
        Call localVarCall = this.updateCoreV1EnvironmentValidateBeforeCall(name, org, coreV1Environment, null);
        Type localVarReturnType = new TypeToken<CoreV1Environment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateCoreV1EnvironmentAsync(String name, String org, CoreV1Environment coreV1Environment, ApiCallback<CoreV1Environment> _callback) throws ApiException {
        Call localVarCall = this.updateCoreV1EnvironmentValidateBeforeCall(name, org, coreV1Environment, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Environment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateCoreV1EnvironmentFinalizersCall(String name, String org, CoreV1Environment coreV1Environment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CoreV1Environment localVarPostBody = coreV1Environment;
        String localVarPath = "/apis/core/v1/orgs/{org}/environments/{name}/finalizers".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateCoreV1EnvironmentFinalizersValidateBeforeCall(String name, String org, CoreV1Environment coreV1Environment, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateCoreV1EnvironmentFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateCoreV1EnvironmentFinalizers(Async)");
        }
        if (coreV1Environment == null) {
            throw new ApiException("Missing the required parameter 'coreV1Environment' when calling updateCoreV1EnvironmentFinalizers(Async)");
        }
        return this.updateCoreV1EnvironmentFinalizersCall(name, org, coreV1Environment, _callback);
    }

    public CoreV1Environment updateCoreV1EnvironmentFinalizers(String name, String org, CoreV1Environment coreV1Environment) throws ApiException {
        ApiResponse<CoreV1Environment> localVarResp = this.updateCoreV1EnvironmentFinalizersWithHttpInfo(name, org, coreV1Environment);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Environment> updateCoreV1EnvironmentFinalizersWithHttpInfo(String name, String org, CoreV1Environment coreV1Environment) throws ApiException {
        Call localVarCall = this.updateCoreV1EnvironmentFinalizersValidateBeforeCall(name, org, coreV1Environment, null);
        Type localVarReturnType = new TypeToken<CoreV1Environment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateCoreV1EnvironmentFinalizersAsync(String name, String org, CoreV1Environment coreV1Environment, ApiCallback<CoreV1Environment> _callback) throws ApiException {
        Call localVarCall = this.updateCoreV1EnvironmentFinalizersValidateBeforeCall(name, org, coreV1Environment, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Environment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateCoreV1OrgCall(String name, CoreV1Org coreV1Org, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CoreV1Org localVarPostBody = coreV1Org;
        String localVarPath = "/apis/core/v1/orgs/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateCoreV1OrgValidateBeforeCall(String name, CoreV1Org coreV1Org, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateCoreV1Org(Async)");
        }
        if (coreV1Org == null) {
            throw new ApiException("Missing the required parameter 'coreV1Org' when calling updateCoreV1Org(Async)");
        }
        return this.updateCoreV1OrgCall(name, coreV1Org, _callback);
    }

    public CoreV1Org updateCoreV1Org(String name, CoreV1Org coreV1Org) throws ApiException {
        ApiResponse<CoreV1Org> localVarResp = this.updateCoreV1OrgWithHttpInfo(name, coreV1Org);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Org> updateCoreV1OrgWithHttpInfo(String name, CoreV1Org coreV1Org) throws ApiException {
        Call localVarCall = this.updateCoreV1OrgValidateBeforeCall(name, coreV1Org, null);
        Type localVarReturnType = new TypeToken<CoreV1Org>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateCoreV1OrgAsync(String name, CoreV1Org coreV1Org, ApiCallback<CoreV1Org> _callback) throws ApiException {
        Call localVarCall = this.updateCoreV1OrgValidateBeforeCall(name, coreV1Org, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Org>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateCoreV1OrgFinalizersCall(String name, CoreV1Org coreV1Org, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CoreV1Org localVarPostBody = coreV1Org;
        String localVarPath = "/apis/core/v1/orgs/{name}/finalizers".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateCoreV1OrgFinalizersValidateBeforeCall(String name, CoreV1Org coreV1Org, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateCoreV1OrgFinalizers(Async)");
        }
        if (coreV1Org == null) {
            throw new ApiException("Missing the required parameter 'coreV1Org' when calling updateCoreV1OrgFinalizers(Async)");
        }
        return this.updateCoreV1OrgFinalizersCall(name, coreV1Org, _callback);
    }

    public CoreV1Org updateCoreV1OrgFinalizers(String name, CoreV1Org coreV1Org) throws ApiException {
        ApiResponse<CoreV1Org> localVarResp = this.updateCoreV1OrgFinalizersWithHttpInfo(name, coreV1Org);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Org> updateCoreV1OrgFinalizersWithHttpInfo(String name, CoreV1Org coreV1Org) throws ApiException {
        Call localVarCall = this.updateCoreV1OrgFinalizersValidateBeforeCall(name, coreV1Org, null);
        Type localVarReturnType = new TypeToken<CoreV1Org>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateCoreV1OrgFinalizersAsync(String name, CoreV1Org coreV1Org, ApiCallback<CoreV1Org> _callback) throws ApiException {
        Call localVarCall = this.updateCoreV1OrgFinalizersValidateBeforeCall(name, coreV1Org, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Org>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateCoreV1QuotaCall(String environment, String name, String org, CoreV1Quota coreV1Quota, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CoreV1Quota localVarPostBody = coreV1Quota;
        String localVarPath = "/apis/core/v1/orgs/{org}/environments/{environment}/quotas/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateCoreV1QuotaValidateBeforeCall(String environment, String name, String org, CoreV1Quota coreV1Quota, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateCoreV1Quota(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateCoreV1Quota(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateCoreV1Quota(Async)");
        }
        if (coreV1Quota == null) {
            throw new ApiException("Missing the required parameter 'coreV1Quota' when calling updateCoreV1Quota(Async)");
        }
        return this.updateCoreV1QuotaCall(environment, name, org, coreV1Quota, _callback);
    }

    public CoreV1Quota updateCoreV1Quota(String environment, String name, String org, CoreV1Quota coreV1Quota) throws ApiException {
        ApiResponse<CoreV1Quota> localVarResp = this.updateCoreV1QuotaWithHttpInfo(environment, name, org, coreV1Quota);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Quota> updateCoreV1QuotaWithHttpInfo(String environment, String name, String org, CoreV1Quota coreV1Quota) throws ApiException {
        Call localVarCall = this.updateCoreV1QuotaValidateBeforeCall(environment, name, org, coreV1Quota, null);
        Type localVarReturnType = new TypeToken<CoreV1Quota>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateCoreV1QuotaAsync(String environment, String name, String org, CoreV1Quota coreV1Quota, ApiCallback<CoreV1Quota> _callback) throws ApiException {
        Call localVarCall = this.updateCoreV1QuotaValidateBeforeCall(environment, name, org, coreV1Quota, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Quota>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateCoreV1QuotaFinalizersCall(String environment, String name, String org, CoreV1Quota coreV1Quota, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CoreV1Quota localVarPostBody = coreV1Quota;
        String localVarPath = "/apis/core/v1/orgs/{org}/environments/{environment}/quotas/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateCoreV1QuotaFinalizersValidateBeforeCall(String environment, String name, String org, CoreV1Quota coreV1Quota, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateCoreV1QuotaFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateCoreV1QuotaFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateCoreV1QuotaFinalizers(Async)");
        }
        if (coreV1Quota == null) {
            throw new ApiException("Missing the required parameter 'coreV1Quota' when calling updateCoreV1QuotaFinalizers(Async)");
        }
        return this.updateCoreV1QuotaFinalizersCall(environment, name, org, coreV1Quota, _callback);
    }

    public CoreV1Quota updateCoreV1QuotaFinalizers(String environment, String name, String org, CoreV1Quota coreV1Quota) throws ApiException {
        ApiResponse<CoreV1Quota> localVarResp = this.updateCoreV1QuotaFinalizersWithHttpInfo(environment, name, org, coreV1Quota);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Quota> updateCoreV1QuotaFinalizersWithHttpInfo(String environment, String name, String org, CoreV1Quota coreV1Quota) throws ApiException {
        Call localVarCall = this.updateCoreV1QuotaFinalizersValidateBeforeCall(environment, name, org, coreV1Quota, null);
        Type localVarReturnType = new TypeToken<CoreV1Quota>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateCoreV1QuotaFinalizersAsync(String environment, String name, String org, CoreV1Quota coreV1Quota, ApiCallback<CoreV1Quota> _callback) throws ApiException {
        Call localVarCall = this.updateCoreV1QuotaFinalizersValidateBeforeCall(environment, name, org, coreV1Quota, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Quota>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateCoreV1QuotaStatusCall(String environment, String name, String org, CoreV1Quota coreV1Quota, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CoreV1Quota localVarPostBody = coreV1Quota;
        String localVarPath = "/apis/core/v1/orgs/{org}/environments/{environment}/quotas/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateCoreV1QuotaStatusValidateBeforeCall(String environment, String name, String org, CoreV1Quota coreV1Quota, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateCoreV1QuotaStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateCoreV1QuotaStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateCoreV1QuotaStatus(Async)");
        }
        if (coreV1Quota == null) {
            throw new ApiException("Missing the required parameter 'coreV1Quota' when calling updateCoreV1QuotaStatus(Async)");
        }
        return this.updateCoreV1QuotaStatusCall(environment, name, org, coreV1Quota, _callback);
    }

    public CoreV1Quota updateCoreV1QuotaStatus(String environment, String name, String org, CoreV1Quota coreV1Quota) throws ApiException {
        ApiResponse<CoreV1Quota> localVarResp = this.updateCoreV1QuotaStatusWithHttpInfo(environment, name, org, coreV1Quota);
        return localVarResp.getData();
    }

    public ApiResponse<CoreV1Quota> updateCoreV1QuotaStatusWithHttpInfo(String environment, String name, String org, CoreV1Quota coreV1Quota) throws ApiException {
        Call localVarCall = this.updateCoreV1QuotaStatusValidateBeforeCall(environment, name, org, coreV1Quota, null);
        Type localVarReturnType = new TypeToken<CoreV1Quota>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateCoreV1QuotaStatusAsync(String environment, String name, String org, CoreV1Quota coreV1Quota, ApiCallback<CoreV1Quota> _callback) throws ApiException {
        Call localVarCall = this.updateCoreV1QuotaStatusValidateBeforeCall(environment, name, org, coreV1Quota, _callback);
        Type localVarReturnType = new TypeToken<CoreV1Quota>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

