/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.confluent.flink.apiserver.client.JSON;
import io.confluent.flink.apiserver.client.model.SqlV1Column;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SqlV2ModelSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_COMMENT = "comment";
    @SerializedName(value="comment")
    private String comment;
    public static final String SERIALIZED_NAME_DEFAULT_VERSION = "defaultVersion";
    @SerializedName(value="defaultVersion")
    private String defaultVersion = "";
    public static final String SERIALIZED_NAME_INPUT_SCHEMA = "inputSchema";
    @SerializedName(value="inputSchema")
    private List<SqlV1Column> inputSchema = new ArrayList<SqlV1Column>();
    public static final String SERIALIZED_NAME_MODEL_KIND = "modelKind";
    @SerializedName(value="modelKind")
    private String modelKind = "";
    public static final String SERIALIZED_NAME_MODEL_TASK = "modelTask";
    @SerializedName(value="modelTask")
    private String modelTask = "";
    public static final String SERIALIZED_NAME_MODEL_VERSIONS = "modelVersions";
    @SerializedName(value="modelVersions")
    private Map<String, Map<String, String>> modelVersions = new HashMap<String, Map<String, String>>();
    public static final String SERIALIZED_NAME_OUTPUT_SCHEMA = "outputSchema";
    @SerializedName(value="outputSchema")
    private List<SqlV1Column> outputSchema = new ArrayList<SqlV1Column>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SqlV2ModelSpec comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public SqlV2ModelSpec defaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
        return this;
    }

    @Nonnull
    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    public void setDefaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public SqlV2ModelSpec inputSchema(List<SqlV1Column> inputSchema) {
        this.inputSchema = inputSchema;
        return this;
    }

    public SqlV2ModelSpec addInputSchemaItem(SqlV1Column inputSchemaItem) {
        if (this.inputSchema == null) {
            this.inputSchema = new ArrayList<SqlV1Column>();
        }
        this.inputSchema.add(inputSchemaItem);
        return this;
    }

    @Nullable
    public List<SqlV1Column> getInputSchema() {
        return this.inputSchema;
    }

    public void setInputSchema(List<SqlV1Column> inputSchema) {
        this.inputSchema = inputSchema;
    }

    public SqlV2ModelSpec modelKind(String modelKind) {
        this.modelKind = modelKind;
        return this;
    }

    @Nonnull
    public String getModelKind() {
        return this.modelKind;
    }

    public void setModelKind(String modelKind) {
        this.modelKind = modelKind;
    }

    public SqlV2ModelSpec modelTask(String modelTask) {
        this.modelTask = modelTask;
        return this;
    }

    @Nonnull
    public String getModelTask() {
        return this.modelTask;
    }

    public void setModelTask(String modelTask) {
        this.modelTask = modelTask;
    }

    public SqlV2ModelSpec modelVersions(Map<String, Map<String, String>> modelVersions) {
        this.modelVersions = modelVersions;
        return this;
    }

    public SqlV2ModelSpec putModelVersionsItem(String key, Map<String, String> modelVersionsItem) {
        if (this.modelVersions == null) {
            this.modelVersions = new HashMap<String, Map<String, String>>();
        }
        this.modelVersions.put(key, modelVersionsItem);
        return this;
    }

    @Nonnull
    public Map<String, Map<String, String>> getModelVersions() {
        return this.modelVersions;
    }

    public void setModelVersions(Map<String, Map<String, String>> modelVersions) {
        this.modelVersions = modelVersions;
    }

    public SqlV2ModelSpec outputSchema(List<SqlV1Column> outputSchema) {
        this.outputSchema = outputSchema;
        return this;
    }

    public SqlV2ModelSpec addOutputSchemaItem(SqlV1Column outputSchemaItem) {
        if (this.outputSchema == null) {
            this.outputSchema = new ArrayList<SqlV1Column>();
        }
        this.outputSchema.add(outputSchemaItem);
        return this;
    }

    @Nullable
    public List<SqlV1Column> getOutputSchema() {
        return this.outputSchema;
    }

    public void setOutputSchema(List<SqlV1Column> outputSchema) {
        this.outputSchema = outputSchema;
    }

    public SqlV2ModelSpec putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlV2ModelSpec sqlV2ModelSpec = (SqlV2ModelSpec)o;
        return Objects.equals(this.comment, sqlV2ModelSpec.comment) && Objects.equals(this.defaultVersion, sqlV2ModelSpec.defaultVersion) && Objects.equals(this.inputSchema, sqlV2ModelSpec.inputSchema) && Objects.equals(this.modelKind, sqlV2ModelSpec.modelKind) && Objects.equals(this.modelTask, sqlV2ModelSpec.modelTask) && Objects.equals(this.modelVersions, sqlV2ModelSpec.modelVersions) && Objects.equals(this.outputSchema, sqlV2ModelSpec.outputSchema) && Objects.equals(this.additionalProperties, sqlV2ModelSpec.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.comment, this.defaultVersion, this.inputSchema, this.modelKind, this.modelTask, this.modelVersions, this.outputSchema, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SqlV2ModelSpec {\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    defaultVersion: ").append(this.toIndentedString(this.defaultVersion)).append("\n");
        sb.append("    inputSchema: ").append(this.toIndentedString(this.inputSchema)).append("\n");
        sb.append("    modelKind: ").append(this.toIndentedString(this.modelKind)).append("\n");
        sb.append("    modelTask: ").append(this.toIndentedString(this.modelTask)).append("\n");
        sb.append("    modelVersions: ").append(this.toIndentedString(this.modelVersions)).append("\n");
        sb.append("    outputSchema: ").append(this.toIndentedString(this.outputSchema)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in SqlV2ModelSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_COMMENT) != null && !jsonObj.get(SERIALIZED_NAME_COMMENT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COMMENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `comment` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMENT).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_DEFAULT_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `defaultVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEFAULT_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INPUT_SCHEMA) != null && !jsonObj.get(SERIALIZED_NAME_INPUT_SCHEMA).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INPUT_SCHEMA).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `inputSchema` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INPUT_SCHEMA).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_MODEL_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `modelKind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MODEL_KIND).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_MODEL_TASK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `modelTask` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MODEL_TASK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OUTPUT_SCHEMA) != null && !jsonObj.get(SERIALIZED_NAME_OUTPUT_SCHEMA).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OUTPUT_SCHEMA).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `outputSchema` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OUTPUT_SCHEMA).toString()));
        }
    }

    public static SqlV2ModelSpec fromJson(String jsonString) throws IOException {
        return (SqlV2ModelSpec)JSON.getGson().fromJson(jsonString, SqlV2ModelSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_COMMENT);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_VERSION);
        openapiFields.add(SERIALIZED_NAME_INPUT_SCHEMA);
        openapiFields.add(SERIALIZED_NAME_MODEL_KIND);
        openapiFields.add(SERIALIZED_NAME_MODEL_TASK);
        openapiFields.add(SERIALIZED_NAME_MODEL_VERSIONS);
        openapiFields.add(SERIALIZED_NAME_OUTPUT_SCHEMA);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DEFAULT_VERSION);
        openapiRequiredFields.add(SERIALIZED_NAME_MODEL_KIND);
        openapiRequiredFields.add(SERIALIZED_NAME_MODEL_TASK);
        openapiRequiredFields.add(SERIALIZED_NAME_MODEL_VERSIONS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!SqlV2ModelSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SqlV2ModelSpec.class));
            return new TypeAdapter<SqlV2ModelSpec>(){

                public void write(JsonWriter out, SqlV2ModelSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public SqlV2ModelSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    SqlV2ModelSpec.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    SqlV2ModelSpec instance = (SqlV2ModelSpec)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

