/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.durability.events.controller.serdes;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.IntVector;
import com.google.flatbuffers.Table;
import io.confluent.kafka.durability.events.serdes.BaseInfo;
import io.confluent.kafka.durability.serdes.EpochChain;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class KRaftLeaderChange
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_2_0_0();
    }

    public static KRaftLeaderChange getRootAsKRaftLeaderChange(ByteBuffer _bb) {
        return KRaftLeaderChange.getRootAsKRaftLeaderChange(_bb, new KRaftLeaderChange());
    }

    public static KRaftLeaderChange getRootAsKRaftLeaderChange(ByteBuffer _bb, KRaftLeaderChange obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public KRaftLeaderChange __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public long logEndOffset() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public BaseInfo info() {
        return this.info(new BaseInfo());
    }

    public BaseInfo info(BaseInfo obj) {
        int o = this.__offset(6);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public int newLeaderId() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public EpochChain epochChain(int j) {
        return this.epochChain(new EpochChain(), j);
    }

    public EpochChain epochChain(EpochChain obj, int j) {
        int o = this.__offset(10);
        return o != 0 ? obj.__assign(this.__vector(o) + j * 16, this.bb) : null;
    }

    public int epochChainLength() {
        int o = this.__offset(10);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public EpochChain.Vector epochChainVector() {
        return this.epochChainVector(new EpochChain.Vector());
    }

    public EpochChain.Vector epochChainVector(EpochChain.Vector obj) {
        int o = this.__offset(10);
        return o != 0 ? obj.__assign(this.__vector(o), 16, this.bb) : null;
    }

    public int currentVoters(int j) {
        int o = this.__offset(12);
        return o != 0 ? this.bb.getInt(this.__vector(o) + j * 4) : 0;
    }

    public int currentVotersLength() {
        int o = this.__offset(12);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public IntVector currentVotersVector() {
        return this.currentVotersVector(new IntVector());
    }

    public IntVector currentVotersVector(IntVector obj) {
        int o = this.__offset(12);
        return o != 0 ? obj.__assign(this.__vector(o), this.bb) : null;
    }

    public ByteBuffer currentVotersAsByteBuffer() {
        return this.__vector_as_bytebuffer(12, 4);
    }

    public ByteBuffer currentVotersInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 12, 4);
    }

    public int yesVoters(int j) {
        int o = this.__offset(14);
        return o != 0 ? this.bb.getInt(this.__vector(o) + j * 4) : 0;
    }

    public int yesVotersLength() {
        int o = this.__offset(14);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public IntVector yesVotersVector() {
        return this.yesVotersVector(new IntVector());
    }

    public IntVector yesVotersVector(IntVector obj) {
        int o = this.__offset(14);
        return o != 0 ? obj.__assign(this.__vector(o), this.bb) : null;
    }

    public ByteBuffer yesVotersAsByteBuffer() {
        return this.__vector_as_bytebuffer(14, 4);
    }

    public ByteBuffer yesVotersInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 14, 4);
    }

    public static void startKRaftLeaderChange(FlatBufferBuilder builder) {
        builder.startTable(6);
    }

    public static void addLogEndOffset(FlatBufferBuilder builder, long logEndOffset) {
        builder.addLong(0, logEndOffset, 0L);
    }

    public static void addInfo(FlatBufferBuilder builder, int infoOffset) {
        builder.addStruct(1, infoOffset, 0);
    }

    public static void addNewLeaderId(FlatBufferBuilder builder, int newLeaderId) {
        builder.addInt(2, newLeaderId, 0);
    }

    public static void addEpochChain(FlatBufferBuilder builder, int epochChainOffset) {
        builder.addOffset(3, epochChainOffset, 0);
    }

    public static void startEpochChainVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(16, numElems, 8);
    }

    public static void addCurrentVoters(FlatBufferBuilder builder, int currentVotersOffset) {
        builder.addOffset(4, currentVotersOffset, 0);
    }

    public static int createCurrentVotersVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startCurrentVotersVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addYesVoters(FlatBufferBuilder builder, int yesVotersOffset) {
        builder.addOffset(5, yesVotersOffset, 0);
    }

    public static int createYesVotersVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startYesVotersVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endKRaftLeaderChange(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static void finishKRaftLeaderChangeBuffer(FlatBufferBuilder builder, int offset) {
        builder.finish(offset);
    }

    public static void finishSizePrefixedKRaftLeaderChangeBuffer(FlatBufferBuilder builder, int offset) {
        builder.finishSizePrefixed(offset);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public KRaftLeaderChange get(int j) {
            return this.get(new KRaftLeaderChange(), j);
        }

        public KRaftLeaderChange get(KRaftLeaderChange obj, int j) {
            return obj.__assign(KRaftLeaderChange.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

