/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.checksum;

import io.confluent.kafka.availability.FileChannelWrapper;
import io.confluent.kafka.storage.checksum.ChecksumInfo;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.zip.Checksum;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Checksums;
import org.apache.kafka.common.utils.Crc32C;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class E2EChecksumUtils {
    private static final int READ_CHUNK_SIZE = 262144;
    private static final Logger LOG = LoggerFactory.getLogger(E2EChecksumUtils.class);

    private E2EChecksumUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String convertTo32BitBase64(long value) {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putLong(0, value);
        buf.position(4);
        byte[] bytes = new byte[4];
        buf.get(bytes);
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static Optional<Checksum> getFileChecksum(E2EChecksumStore checksumStore, File file, Map<String, String> metadata) {
        String key = file.getAbsolutePath();
        Optional<ChecksumInfo> optCrc = checksumStore.store().get(key);
        if (!optCrc.isPresent()) {
            LOG.warn("E2E Checksum entry not found for {} :{}", (Object)key, metadata);
            checksumStore.store().metrics().recordEntryNotFound();
            return Optional.empty();
        }
        ChecksumInfo crc = optCrc.get();
        long fileSize = file.length();
        if (file.exists() && crc.sizeInBytes() < fileSize) {
            LOG.error("E2E Checksum entry {} : {}  sizeInBytes < file size({}): {}", new Object[]{key, crc, fileSize, metadata});
            checksumStore.store().metrics().recordSizeInBytesValIsLesser();
        }
        if (file.exists() && crc.sizeInBytes() > fileSize) {
            LOG.error("E2E Checksum entry {} : {} sizeInBytes > file size({}): {}", new Object[]{key, crc, fileSize, metadata});
            checksumStore.store().metrics().recordSizeInBytesValIsGreater();
        }
        return Optional.of(crc.checksum());
    }

    public static Optional<String> getBase64CrcFromStore(E2EChecksumStore checksumStore, File file, Map<String, String> metadata) {
        Optional<Checksum> crcOpt = E2EChecksumUtils.getFileChecksum(checksumStore, file, metadata);
        return crcOpt.map(checksum -> E2EChecksumUtils.convertTo32BitBase64(checksum.getValue()));
    }

    public static String compute32BitBase64Crc32c(ByteBuffer buffer) {
        long crc32c = Crc32C.compute((ByteBuffer)buffer.duplicate(), (int)0, (int)buffer.remaining());
        return E2EChecksumUtils.convertTo32BitBase64(crc32c);
    }

    public static boolean e2eChecksumEnabledForTopic(Optional<E2EChecksumStore> checksumStoreOpt, TopicPartition topicPartition, LogConfig config) {
        return checksumStoreOpt.map(checksumStore -> checksumStore.checksumProtectionEnabledForTopic(topicPartition, config)).orElse(false);
    }

    public static Optional<String> compute32BitBase64Crc32c(File file) {
        return E2EChecksumUtils.compute32BitBase64Crc32c(file, Crc32C.create());
    }

    public static Optional<String> compute32BitBase64Crc32c(File file, Checksum checksum) {
        ByteBuffer bb = ByteBuffer.allocate(262144);
        try {
            FileChannel channel = FileChannelWrapper.open((Path)file.toPath(), (OpenOption[])new OpenOption[]{StandardOpenOption.READ});
            long fileSize = channel.size();
            for (long pos = 0L; pos < fileSize; pos += (long)bb.remaining()) {
                bb.clear();
                Utils.readFully((FileChannel)channel, (ByteBuffer)bb, (long)pos);
                bb.flip();
                Checksums.update((Checksum)checksum, (ByteBuffer)bb, (int)bb.remaining());
            }
            return Optional.of(E2EChecksumUtils.convertTo32BitBase64(checksum.getValue()));
        }
        catch (IOException e) {
            LOG.error("Checksum can't be computed for {}", (Object)file, (Object)e);
            return Optional.empty();
        }
    }
}

