/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.tier.serdes;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class FragmentDescription
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_2_0_0();
    }

    public static FragmentDescription getRootAsFragmentDescription(ByteBuffer _bb) {
        return FragmentDescription.getRootAsFragmentDescription(_bb, new FragmentDescription());
    }

    public static FragmentDescription getRootAsFragmentDescription(ByteBuffer _bb, FragmentDescription obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public FragmentDescription __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public byte fragmentType() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public byte objectType() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public long filePosition() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public int size() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public static int createFragmentDescription(FlatBufferBuilder builder, byte fragment_type, byte object_type, long file_position, int size) {
        builder.startTable(4);
        FragmentDescription.addFilePosition(builder, file_position);
        FragmentDescription.addSize(builder, size);
        FragmentDescription.addObjectType(builder, object_type);
        FragmentDescription.addFragmentType(builder, fragment_type);
        return FragmentDescription.endFragmentDescription(builder);
    }

    public static void startFragmentDescription(FlatBufferBuilder builder) {
        builder.startTable(4);
    }

    public static void addFragmentType(FlatBufferBuilder builder, byte fragmentType) {
        builder.addByte(0, fragmentType, 0);
    }

    public static void addObjectType(FlatBufferBuilder builder, byte objectType) {
        builder.addByte(1, objectType, 0);
    }

    public static void addFilePosition(FlatBufferBuilder builder, long filePosition) {
        builder.addLong(2, filePosition, 0L);
    }

    public static void addSize(FlatBufferBuilder builder, int size) {
        builder.addInt(3, size, 0);
    }

    public static int endFragmentDescription(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static void finishFragmentDescriptionBuffer(FlatBufferBuilder builder, int offset) {
        builder.finish(offset);
    }

    public static void finishSizePrefixedFragmentDescriptionBuffer(FlatBufferBuilder builder, int offset) {
        builder.finishSizePrefixed(offset);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public FragmentDescription get(int j) {
            return this.get(new FragmentDescription(), j);
        }

        public FragmentDescription get(FragmentDescription obj, int j) {
            return obj.__assign(FragmentDescription.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

