/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.checkpoint;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InconsistentTopicIdException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.checkpoint.PartitionMetadata;
import org.apache.kafka.storage.internals.checkpoint.PartitionMetadataReadBuffer;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;

public class PartitionMetadataFile {
    private static final String PARTITION_METADATA_FILE_NAME = "partition.metadata";
    static final int CURRENT_VERSION = 0;
    private final File file;
    private final LogDirFailureChannel logDirFailureChannel;
    private final Object lock = new Object();
    private volatile Optional<Uuid> dirtyTopicIdOpt = Optional.empty();

    public static File newFile(File dir) {
        return new File(dir, PARTITION_METADATA_FILE_NAME);
    }

    public PartitionMetadataFile(File file, LogDirFailureChannel logDirFailureChannel) {
        this.file = file;
        this.logDirFailureChannel = logDirFailureChannel;
    }

    public void record(Uuid topicId) {
        this.dirtyTopicIdOpt.ifPresent(dirtyTopicId -> {
            if (!dirtyTopicId.equals((Object)topicId)) {
                throw new InconsistentTopicIdException("Tried to record topic ID " + topicId + " to file but had already recorded " + dirtyTopicId);
            }
        });
        this.dirtyTopicIdOpt = Optional.of(topicId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeFlush() {
        if (this.dirtyTopicIdOpt.isPresent()) {
            Object object = this.lock;
            synchronized (object) {
                this.dirtyTopicIdOpt.ifPresent(topicId -> {
                    try {
                        try (FileOutputStream fileOutputStream = new FileOutputStream(this.tempPath().toFile());
                             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8));){
                            writer.write(new PartitionMetadata(0, (Uuid)topicId).encode());
                            writer.flush();
                            fileOutputStream.getFD().sync();
                        }
                        Utils.atomicMoveWithFallback((Path)this.tempPath(), (Path)this.path());
                    }
                    catch (IOException e) {
                        String msg = "Error while writing partition metadata file " + this.file.getAbsolutePath();
                        this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir(), msg, e);
                        throw new KafkaStorageException(msg, (Throwable)e);
                    }
                    this.dirtyTopicIdOpt = Optional.empty();
                });
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PartitionMetadata read() {
        Object object = this.lock;
        synchronized (object) {
            try (BufferedReader reader = Files.newBufferedReader(this.path(), StandardCharsets.UTF_8);){
                PartitionMetadataReadBuffer partitionBuffer = new PartitionMetadataReadBuffer(this.file.getAbsolutePath(), reader);
                PartitionMetadata partitionMetadata = partitionBuffer.read();
                return partitionMetadata;
            }
            catch (IOException e) {
                String msg = "Error while reading partition metadata file " + this.file.getAbsolutePath();
                this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir(), msg, e);
                throw new KafkaStorageException(msg, (Throwable)e);
            }
        }
    }

    public boolean exists() {
        return this.file.exists();
    }

    public boolean isEmpty() {
        return this.file.length() == 0L;
    }

    public File file() {
        return this.file;
    }

    public void delete() throws IOException {
        Files.delete(this.file.toPath());
    }

    private Path path() {
        return this.file.toPath().toAbsolutePath();
    }

    private Path tempPath() {
        return Paths.get(this.path() + ".tmp", new String[0]);
    }

    private String logDir() {
        return this.file.getParentFile().getParent();
    }

    public String toString() {
        return "PartitionMetadataFile(path=" + this.path() + ')';
    }
}

