/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.log.metrics;

import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.server.log.remote.storage.RemoteStorageMetrics;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;

public class BrokerTopicMetrics {
    public static final String MESSAGE_IN_PER_SEC = "MessagesInPerSec";
    public static final String BYTES_IN_PER_SEC = "BytesInPerSec";
    public static final String MIRROR_BYTES_IN_PER_SEC = "MirrorBytesInPerSec";
    public static final String BYTES_OUT_PER_SEC = "BytesOutPerSec";
    public static final String BYTES_REJECTED_PER_SEC = "BytesRejectedPerSec";
    public static final String REPLICATION_BYTES_IN_PER_SEC = "ReplicationBytesInPerSec";
    public static final String REPLICATION_BYTES_OUT_PER_SEC = "ReplicationBytesOutPerSec";
    public static final String BYTES_IN_PER_SEC_WITH_COMPRESSION_TYPE = "BytesInPerSecWithCompressionType";
    public static final String FAILED_PRODUCE_REQUESTS_PER_SEC = "FailedProduceRequestsPerSec";
    public static final String FAILED_FETCH_REQUESTS_PER_SEC = "FailedFetchRequestsPerSec";
    public static final String TOTAL_PRODUCE_REQUESTS_PER_SEC = "TotalProduceRequestsPerSec";
    public static final String TOTAL_FETCH_REQUESTS_PER_SEC = "TotalFetchRequestsPerSec";
    public static final String TOTAL_FOLLOWER_FETCH_REQUESTS_PER_SEC = "TotalFollowerFetchRequestsPerSec";
    public static final String FETCH_MESSAGE_CONVERSIONS_PER_SEC = "FetchMessageConversionsPerSec";
    public static final String PRODUCE_MESSAGE_CONVERSIONS_PER_SEC = "ProduceMessageConversionsPerSec";
    public static final String REASSIGNMENT_BYTES_IN_PER_SEC = "ReassignmentBytesInPerSec";
    public static final String REASSIGNMENT_BYTES_OUT_PER_SEC = "ReassignmentBytesOutPerSec";
    public static final String COMPACTED_TOPICS_BYTES_IN_PER_SEC = "CompactedTopicsBytesInPerSec";
    public static final String CONSUMER_FETCH_LAG_TIME_MS = "ConsumerFetchLagTimeMs";
    public static final String LOG_APPEND_LATENCY_MS = "LogAppendLatencyMs";
    public static final String LOG_APPEND_LATENCY_P999 = "LogAppendLatencyMs".concat("Percentile999");
    public static final String LOG_APPEND_DATA_SIZE_IN_BYTES = "LogAppendDataSizeInBytes";
    public static final String LOG_APPEND_PER_SEC = "LogAppendPerSec";
    public static final String LOG_FETCH_LATENCY_MS = "LogFetchLatencyMs";
    public static final String TIER_LOG_FETCH_LATENCY_MS = "TierLogFetchLatencyMs";
    public static final String LOG_FETCH_LATENCY_P999 = "LogFetchLatencyMs".concat("Percentile999");
    public static final String TIER_LOG_FETCH_LATENCY_P999 = "TierLogFetchLatencyMs".concat("Percentile999");
    public static final String TIER_LOG_FETCH_LATENCY_P99 = "TierLogFetchLatencyMs".concat("Percentile99");
    public static final String LOG_FETCH_DATA_SIZE_IN_BYTES = "LogFetchDataSizeInBytes";
    public static final String LOG_FETCH_PER_SEC = "LogFetchPerSec";
    public static final String SEGMENT_READS_PER_SEC = "SegmentReadsPerSec";
    public static final String SEGMENT_SPECULATIVE_PREFETCHES_PER_SEC = "SegmentSpeculativePrefetchesPerSec";
    public static final String SPURIOUS_OFFSET_OUT_OF_RANGE_EXCEPTION_PER_SEC = "SpuriousOffsetOutOfRangeExceptionPerSec";
    public static final String FETCH_FROM_FOLLOWER_BYTES_OUT_PER_SEC = "FetchFromFollowerBytesOutPerSec";
    public static final String FETCH_FROM_FOLLOWER_FETCH_REQUESTS_PER_SEC = "FetchFromFollowerFetchRequestsPerSec";
    public static final String NO_KEY_COMPACTED_TOPIC_RECORDS_PER_SEC = "NoKeyCompactedTopicRecordsPerSec";
    public static final String INVALID_MAGIC_NUMBER_RECORDS_PER_SEC = "InvalidMagicNumberRecordsPerSec";
    public static final String INVALID_MESSAGE_CRC_RECORDS_PER_SEC = "InvalidMessageCrcRecordsPerSec";
    public static final String INVALID_OFFSET_OR_SEQUENCE_RECORDS_PER_SEC = "InvalidOffsetOrSequenceRecordsPerSec";
    public static final String NON_INCREASING_OFFSET_RECORDS_PER_SEC = "NonIncreasingOffsetRecordsPerSec";
    public static final String PAST_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_HOUR_PER_SEC = "PastMessagesWithTimeDiffMoreThanOneHourPerSec";
    public static final String PAST_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_DAY_PER_SEC = "PastMessagesWithTimeDiffMoreThanOneDayPerSec";
    public static final String PAST_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_YEAR_PER_SEC = "PastMessagesWithTimeDiffMoreThanOneYearPerSec";
    public static final String FUTURE_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_HOUR_PER_SEC = "FutureMessagesWithTimeDiffMoreThanOneHourPerSec";
    public static final String FUTURE_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_DAY_PER_SEC = "FutureMessagesWithTimeDiffMoreThanOneDayPerSec";
    public static final String FUTURE_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_YEAR_PER_SEC = "FutureMessagesWithTimeDiffMoreThanOneYearPerSec";
    private final KafkaMetricsGroup metricsGroup = new KafkaMetricsGroup("kafka.server", "BrokerTopicMetrics");
    private final Map<String, String> tags;
    private final Map<String, MeterWrapper> metricTypeMap = new ConcurrentHashMap<String, MeterWrapper>();
    private final Map<String, GaugeWrapper> metricGaugeTypeMap = new ConcurrentHashMap<String, GaugeWrapper>();
    private final Map<CompressionType, MeterWrapper> compressionTypeMetricsMap = new ConcurrentHashMap<CompressionType, MeterWrapper>();
    private final Optional<String> name;
    private final boolean isConfluentCloudOnlyMetric;
    private final Optional<Histogram> consumerFetchLagTimeMs;
    private final Optional<Histogram> logAppendLatencyMs;
    private final Optional<Histogram> logAppendDataSizeInBytes;
    private final Optional<Histogram> localLogFetchLatencyMs;
    private final Optional<Histogram> tierLogFetchLatencyMs;
    private final Optional<Histogram> logFetchDataSizeInBytes;

    public BrokerTopicMetrics() {
        this(Optional.empty(), false, false);
    }

    public BrokerTopicMetrics(boolean remoteStorageEnabled, boolean isConfluentCloudOnlyMetric) {
        this(Optional.empty(), remoteStorageEnabled, isConfluentCloudOnlyMetric);
    }

    public BrokerTopicMetrics(String name, boolean remoteStorageEnabled, boolean isConfluentCloudOnlyMetric) {
        this(Optional.of(name), remoteStorageEnabled, isConfluentCloudOnlyMetric);
    }

    private BrokerTopicMetrics(Optional<String> name, boolean remoteStorageEnabled, boolean isConfluentCloudOnlyMetric) {
        this.name = name;
        this.tags = name.map(s -> Collections.singletonMap("topic", s)).orElse(Collections.emptyMap());
        this.isConfluentCloudOnlyMetric = isConfluentCloudOnlyMetric;
        this.metricTypeMap.put(MESSAGE_IN_PER_SEC, new MeterWrapper(MESSAGE_IN_PER_SEC, "messages"));
        this.metricTypeMap.put(BYTES_IN_PER_SEC, new MeterWrapper(BYTES_IN_PER_SEC, "bytes"));
        this.metricTypeMap.put(MIRROR_BYTES_IN_PER_SEC, new MeterWrapper(MIRROR_BYTES_IN_PER_SEC, "bytes"));
        this.metricTypeMap.put(BYTES_OUT_PER_SEC, new MeterWrapper(BYTES_OUT_PER_SEC, "bytes"));
        this.metricTypeMap.put(BYTES_REJECTED_PER_SEC, new MeterWrapper(BYTES_REJECTED_PER_SEC, "bytes"));
        this.metricTypeMap.put(FAILED_PRODUCE_REQUESTS_PER_SEC, new MeterWrapper(FAILED_PRODUCE_REQUESTS_PER_SEC, "requests"));
        this.metricTypeMap.put(FAILED_FETCH_REQUESTS_PER_SEC, new MeterWrapper(FAILED_FETCH_REQUESTS_PER_SEC, "requests"));
        this.metricTypeMap.put(TOTAL_PRODUCE_REQUESTS_PER_SEC, new MeterWrapper(TOTAL_PRODUCE_REQUESTS_PER_SEC, "requests"));
        this.metricTypeMap.put(TOTAL_FETCH_REQUESTS_PER_SEC, new MeterWrapper(TOTAL_FETCH_REQUESTS_PER_SEC, "requests"));
        this.metricTypeMap.put(TOTAL_FOLLOWER_FETCH_REQUESTS_PER_SEC, new MeterWrapper(TOTAL_FOLLOWER_FETCH_REQUESTS_PER_SEC, "requests"));
        this.metricTypeMap.put(FETCH_MESSAGE_CONVERSIONS_PER_SEC, new MeterWrapper(FETCH_MESSAGE_CONVERSIONS_PER_SEC, "requests"));
        this.metricTypeMap.put(PRODUCE_MESSAGE_CONVERSIONS_PER_SEC, new MeterWrapper(PRODUCE_MESSAGE_CONVERSIONS_PER_SEC, "requests"));
        this.metricTypeMap.put(SPURIOUS_OFFSET_OUT_OF_RANGE_EXCEPTION_PER_SEC, new MeterWrapper(SPURIOUS_OFFSET_OUT_OF_RANGE_EXCEPTION_PER_SEC, "errors"));
        this.metricTypeMap.put(NO_KEY_COMPACTED_TOPIC_RECORDS_PER_SEC, new MeterWrapper(NO_KEY_COMPACTED_TOPIC_RECORDS_PER_SEC, "requests"));
        this.metricTypeMap.put(INVALID_MAGIC_NUMBER_RECORDS_PER_SEC, new MeterWrapper(INVALID_MAGIC_NUMBER_RECORDS_PER_SEC, "requests"));
        this.metricTypeMap.put(INVALID_MESSAGE_CRC_RECORDS_PER_SEC, new MeterWrapper(INVALID_MESSAGE_CRC_RECORDS_PER_SEC, "requests"));
        this.metricTypeMap.put(INVALID_OFFSET_OR_SEQUENCE_RECORDS_PER_SEC, new MeterWrapper(INVALID_OFFSET_OR_SEQUENCE_RECORDS_PER_SEC, "requests"));
        this.metricTypeMap.put(NON_INCREASING_OFFSET_RECORDS_PER_SEC, new MeterWrapper(NON_INCREASING_OFFSET_RECORDS_PER_SEC, "requests"));
        this.metricTypeMap.put(FETCH_FROM_FOLLOWER_BYTES_OUT_PER_SEC, new MeterWrapper(FETCH_FROM_FOLLOWER_BYTES_OUT_PER_SEC, "bytes"));
        this.metricTypeMap.put(FETCH_FROM_FOLLOWER_FETCH_REQUESTS_PER_SEC, new MeterWrapper(FETCH_FROM_FOLLOWER_FETCH_REQUESTS_PER_SEC, "requests"));
        this.metricTypeMap.put(REPLICATION_BYTES_IN_PER_SEC, new MeterWrapper(REPLICATION_BYTES_IN_PER_SEC, "bytes"));
        if (!name.isPresent()) {
            this.metricTypeMap.put(REPLICATION_BYTES_OUT_PER_SEC, new MeterWrapper(REPLICATION_BYTES_OUT_PER_SEC, "bytes"));
            this.metricTypeMap.put(REASSIGNMENT_BYTES_IN_PER_SEC, new MeterWrapper(REASSIGNMENT_BYTES_IN_PER_SEC, "bytes"));
            this.metricTypeMap.put(REASSIGNMENT_BYTES_OUT_PER_SEC, new MeterWrapper(REASSIGNMENT_BYTES_OUT_PER_SEC, "bytes"));
            this.metricTypeMap.put(COMPACTED_TOPICS_BYTES_IN_PER_SEC, new MeterWrapper(COMPACTED_TOPICS_BYTES_IN_PER_SEC, "bytes"));
            this.metricTypeMap.put(SEGMENT_READS_PER_SEC, new MeterWrapper(SEGMENT_READS_PER_SEC, "requests"));
            this.metricTypeMap.put(SEGMENT_SPECULATIVE_PREFETCHES_PER_SEC, new MeterWrapper(SEGMENT_SPECULATIVE_PREFETCHES_PER_SEC, "requests"));
            this.metricTypeMap.put(FUTURE_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_YEAR_PER_SEC, new MeterWrapper(FUTURE_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_YEAR_PER_SEC, "messages"));
            this.metricTypeMap.put(FUTURE_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_DAY_PER_SEC, new MeterWrapper(FUTURE_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_DAY_PER_SEC, "messages"));
            this.metricTypeMap.put(FUTURE_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_HOUR_PER_SEC, new MeterWrapper(FUTURE_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_HOUR_PER_SEC, "messages"));
            this.metricTypeMap.put(PAST_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_YEAR_PER_SEC, new MeterWrapper(PAST_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_YEAR_PER_SEC, "messages"));
            this.metricTypeMap.put(PAST_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_DAY_PER_SEC, new MeterWrapper(PAST_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_DAY_PER_SEC, "messages"));
            this.metricTypeMap.put(PAST_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_HOUR_PER_SEC, new MeterWrapper(PAST_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_HOUR_PER_SEC, "messages"));
            this.metricTypeMap.put(LOG_APPEND_PER_SEC, new MeterWrapper(LOG_APPEND_PER_SEC, "requests"));
            this.metricTypeMap.put(LOG_FETCH_PER_SEC, new MeterWrapper(LOG_FETCH_PER_SEC, "requests"));
            this.consumerFetchLagTimeMs = Optional.ofNullable(this.metricsGroup.newHistogram(CONSUMER_FETCH_LAG_TIME_MS, true, this.tags));
            this.logAppendLatencyMs = Optional.ofNullable(this.metricsGroup.newHistogram(LOG_APPEND_LATENCY_MS, true, this.tags));
            this.logAppendDataSizeInBytes = Optional.ofNullable(this.metricsGroup.newHistogram(LOG_APPEND_DATA_SIZE_IN_BYTES, true, this.tags));
            this.localLogFetchLatencyMs = Optional.ofNullable(this.metricsGroup.newHistogram(LOG_FETCH_LATENCY_MS, true, this.tags));
            this.tierLogFetchLatencyMs = Optional.ofNullable(this.metricsGroup.newHistogram(TIER_LOG_FETCH_LATENCY_MS, true, this.tags));
            this.logFetchDataSizeInBytes = Optional.ofNullable(this.metricsGroup.newHistogram(LOG_FETCH_DATA_SIZE_IN_BYTES, true, this.tags));
            this.metricsGroup.newGauge(LOG_APPEND_LATENCY_P999, () -> this.logAppendLatencyMs.get().getSnapshot().get999thPercentile());
            this.metricsGroup.newGauge(LOG_FETCH_LATENCY_P999, () -> this.localLogFetchLatencyMs.get().getSnapshot().get999thPercentile());
            this.metricsGroup.newGauge(TIER_LOG_FETCH_LATENCY_P999, () -> this.tierLogFetchLatencyMs.get().getSnapshot().get999thPercentile());
            this.metricsGroup.newGauge(TIER_LOG_FETCH_LATENCY_P99, () -> this.tierLogFetchLatencyMs.get().getSnapshot().get99thPercentile());
        } else {
            this.consumerFetchLagTimeMs = Optional.empty();
            this.logAppendLatencyMs = Optional.empty();
            this.logAppendDataSizeInBytes = Optional.empty();
            this.localLogFetchLatencyMs = Optional.empty();
            this.tierLogFetchLatencyMs = Optional.empty();
            this.logFetchDataSizeInBytes = Optional.empty();
        }
        if (remoteStorageEnabled) {
            this.metricTypeMap.put(RemoteStorageMetrics.REMOTE_COPY_BYTES_PER_SEC_METRIC.getName(), new MeterWrapper(RemoteStorageMetrics.REMOTE_COPY_BYTES_PER_SEC_METRIC.getName(), "bytes"));
            this.metricTypeMap.put(RemoteStorageMetrics.REMOTE_FETCH_BYTES_PER_SEC_METRIC.getName(), new MeterWrapper(RemoteStorageMetrics.REMOTE_FETCH_BYTES_PER_SEC_METRIC.getName(), "bytes"));
            this.metricTypeMap.put(RemoteStorageMetrics.REMOTE_FETCH_REQUESTS_PER_SEC_METRIC.getName(), new MeterWrapper(RemoteStorageMetrics.REMOTE_FETCH_REQUESTS_PER_SEC_METRIC.getName(), "requests"));
            this.metricTypeMap.put(RemoteStorageMetrics.REMOTE_COPY_REQUESTS_PER_SEC_METRIC.getName(), new MeterWrapper(RemoteStorageMetrics.REMOTE_COPY_REQUESTS_PER_SEC_METRIC.getName(), "requests"));
            this.metricTypeMap.put(RemoteStorageMetrics.REMOTE_DELETE_REQUESTS_PER_SEC_METRIC.getName(), new MeterWrapper(RemoteStorageMetrics.REMOTE_DELETE_REQUESTS_PER_SEC_METRIC.getName(), "requests"));
            this.metricTypeMap.put(RemoteStorageMetrics.BUILD_REMOTE_LOG_AUX_STATE_REQUESTS_PER_SEC_METRIC.getName(), new MeterWrapper(RemoteStorageMetrics.BUILD_REMOTE_LOG_AUX_STATE_REQUESTS_PER_SEC_METRIC.getName(), "requests"));
            this.metricTypeMap.put(RemoteStorageMetrics.FAILED_REMOTE_FETCH_PER_SEC_METRIC.getName(), new MeterWrapper(RemoteStorageMetrics.FAILED_REMOTE_FETCH_PER_SEC_METRIC.getName(), "requests"));
            this.metricTypeMap.put(RemoteStorageMetrics.FAILED_REMOTE_COPY_PER_SEC_METRIC.getName(), new MeterWrapper(RemoteStorageMetrics.FAILED_REMOTE_COPY_PER_SEC_METRIC.getName(), "requests"));
            this.metricTypeMap.put(RemoteStorageMetrics.FAILED_REMOTE_DELETE_PER_SEC_METRIC.getName(), new MeterWrapper(RemoteStorageMetrics.FAILED_REMOTE_DELETE_PER_SEC_METRIC.getName(), "requests"));
            this.metricTypeMap.put(RemoteStorageMetrics.FAILED_BUILD_REMOTE_LOG_AUX_STATE_PER_SEC_METRIC.getName(), new MeterWrapper(RemoteStorageMetrics.FAILED_BUILD_REMOTE_LOG_AUX_STATE_PER_SEC_METRIC.getName(), "requests"));
            this.metricGaugeTypeMap.put(RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName(), new GaugeWrapper(RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName()));
            this.metricGaugeTypeMap.put(RemoteStorageMetrics.REMOTE_COPY_LAG_SEGMENTS_METRIC.getName(), new GaugeWrapper(RemoteStorageMetrics.REMOTE_COPY_LAG_SEGMENTS_METRIC.getName()));
            this.metricGaugeTypeMap.put(RemoteStorageMetrics.REMOTE_DELETE_LAG_BYTES_METRIC.getName(), new GaugeWrapper(RemoteStorageMetrics.REMOTE_DELETE_LAG_BYTES_METRIC.getName()));
            this.metricGaugeTypeMap.put(RemoteStorageMetrics.REMOTE_DELETE_LAG_SEGMENTS_METRIC.getName(), new GaugeWrapper(RemoteStorageMetrics.REMOTE_DELETE_LAG_SEGMENTS_METRIC.getName()));
            this.metricGaugeTypeMap.put(RemoteStorageMetrics.REMOTE_LOG_METADATA_COUNT_METRIC.getName(), new GaugeWrapper(RemoteStorageMetrics.REMOTE_LOG_METADATA_COUNT_METRIC.getName()));
            this.metricGaugeTypeMap.put(RemoteStorageMetrics.REMOTE_LOG_SIZE_COMPUTATION_TIME_METRIC.getName(), new GaugeWrapper(RemoteStorageMetrics.REMOTE_LOG_SIZE_COMPUTATION_TIME_METRIC.getName()));
            this.metricGaugeTypeMap.put(RemoteStorageMetrics.REMOTE_LOG_SIZE_BYTES_METRIC.getName(), new GaugeWrapper(RemoteStorageMetrics.REMOTE_LOG_SIZE_BYTES_METRIC.getName()));
        }
        if (this.isMetricAtAllTopicsLevelAndCCloudOnly().booleanValue()) {
            for (CompressionType compression : CompressionType.values()) {
                HashMap<String, String> customTags = new HashMap<String, String>();
                customTags.put("compressionType", compression.name);
                this.compressionTypeMetricsMap.put(compression, new MeterWrapper(BYTES_IN_PER_SEC_WITH_COMPRESSION_TYPE, "bytes", customTags));
            }
        }
    }

    public void closeMetric(String metricName) {
        GaugeWrapper mg;
        MeterWrapper mw = this.metricTypeMap.get(metricName);
        if (mw != null) {
            mw.close();
        }
        if ((mg = this.metricGaugeTypeMap.get(metricName)) != null) {
            mg.close();
        }
    }

    public void close() {
        this.metricTypeMap.values().forEach(MeterWrapper::close);
        this.compressionTypeMetricsMap.values().forEach(MeterWrapper::close);
        this.metricsGroup.removeMetric(CONSUMER_FETCH_LAG_TIME_MS, this.tags);
        this.metricsGroup.removeMetric(LOG_APPEND_LATENCY_P999, this.tags);
        this.metricsGroup.removeMetric(LOG_APPEND_LATENCY_MS, this.tags);
        this.metricsGroup.removeMetric(LOG_APPEND_DATA_SIZE_IN_BYTES, this.tags);
        this.metricsGroup.removeMetric(LOG_FETCH_LATENCY_P999, this.tags);
        this.metricsGroup.removeMetric(LOG_FETCH_LATENCY_MS, this.tags);
        this.metricsGroup.removeMetric(TIER_LOG_FETCH_LATENCY_P999, this.tags);
        this.metricsGroup.removeMetric(TIER_LOG_FETCH_LATENCY_P99, this.tags);
        this.metricsGroup.removeMetric(TIER_LOG_FETCH_LATENCY_MS, this.tags);
        this.metricsGroup.removeMetric(LOG_FETCH_DATA_SIZE_IN_BYTES, this.tags);
        this.metricGaugeTypeMap.values().forEach(GaugeWrapper::close);
    }

    public Set<String> metricMapKeySet() {
        return this.metricTypeMap.keySet();
    }

    public Map<String, GaugeWrapper> metricGaugeMap() {
        return this.metricGaugeTypeMap;
    }

    public Meter messagesInRate() {
        return this.metricTypeMap.get(MESSAGE_IN_PER_SEC).meter();
    }

    public Meter bytesInRate() {
        return this.metricTypeMap.get(BYTES_IN_PER_SEC).meter();
    }

    public Meter mirrorBytesInRate() {
        return this.metricTypeMap.get(MIRROR_BYTES_IN_PER_SEC).meter();
    }

    public Meter bytesOutRate() {
        return this.metricTypeMap.get(BYTES_OUT_PER_SEC).meter();
    }

    public Meter bytesRejectedRate() {
        return this.metricTypeMap.get(BYTES_REJECTED_PER_SEC).meter();
    }

    public Meter fetchFromFollowerBytesOutRate() {
        return this.metricTypeMap.get(FETCH_FROM_FOLLOWER_BYTES_OUT_PER_SEC).meter();
    }

    public Meter replicationBytesInRate() {
        return this.metricTypeMap.get(REPLICATION_BYTES_IN_PER_SEC).meter();
    }

    public Optional<Meter> replicationBytesOutRate() {
        if (this.tags.isEmpty()) {
            return Optional.of(this.metricTypeMap.get(REPLICATION_BYTES_OUT_PER_SEC).meter());
        }
        return Optional.empty();
    }

    public Optional<Meter> reassignmentBytesInPerSec() {
        if (this.tags.isEmpty()) {
            return Optional.of(this.metricTypeMap.get(REASSIGNMENT_BYTES_IN_PER_SEC).meter());
        }
        return Optional.empty();
    }

    public Optional<Meter> reassignmentBytesOutPerSec() {
        if (this.tags.isEmpty()) {
            return Optional.of(this.metricTypeMap.get(REASSIGNMENT_BYTES_OUT_PER_SEC).meter());
        }
        return Optional.empty();
    }

    public Optional<Meter> compactedTopicsBytesInPerSec() {
        if (this.tags.isEmpty()) {
            return Optional.of(this.metricTypeMap.get(COMPACTED_TOPICS_BYTES_IN_PER_SEC).meter());
        }
        return Optional.empty();
    }

    public Meter failedProduceRequestRate() {
        return this.metricTypeMap.get(FAILED_PRODUCE_REQUESTS_PER_SEC).meter();
    }

    public Meter failedFetchRequestRate() {
        return this.metricTypeMap.get(FAILED_FETCH_REQUESTS_PER_SEC).meter();
    }

    public Meter totalProduceRequestRate() {
        return this.metricTypeMap.get(TOTAL_PRODUCE_REQUESTS_PER_SEC).meter();
    }

    public Meter totalFetchRequestRate() {
        return this.metricTypeMap.get(TOTAL_FETCH_REQUESTS_PER_SEC).meter();
    }

    public Meter totalFollowerFetchRequestRate() {
        return this.metricTypeMap.get(TOTAL_FOLLOWER_FETCH_REQUESTS_PER_SEC).meter();
    }

    public Meter fetchFromFollowerFetchRequestRate() {
        return this.metricTypeMap.get(FETCH_FROM_FOLLOWER_FETCH_REQUESTS_PER_SEC).meter();
    }

    public Meter fetchMessageConversionsRate() {
        return this.metricTypeMap.get(FETCH_MESSAGE_CONVERSIONS_PER_SEC).meter();
    }

    public Histogram consumerFetchLagTimeMs() {
        return this.consumerFetchLagTimeMs.orElseThrow(() -> new UnsupportedOperationException("Consumer fetch lag time metric is not enabled"));
    }

    public Histogram logAppendLatencyMs() {
        return this.logAppendLatencyMs.orElseThrow(() -> new UnsupportedOperationException("Log append latency metric is not enabled"));
    }

    public Histogram logAppendDataSizeInBytes() {
        return this.logAppendDataSizeInBytes.orElseThrow(() -> new UnsupportedOperationException("Log append data size metric is not enabled"));
    }

    public Meter logAppendRate() {
        return this.metricTypeMap.get(LOG_APPEND_PER_SEC).meter();
    }

    public void recordLogAppend(Long latencyMs, Long dataSizeInBytes) {
        this.logAppendDataSizeInBytes().update(dataSizeInBytes.longValue());
        this.logAppendRate().mark();
        this.logAppendLatencyMs().update(latencyMs.longValue());
    }

    public Histogram localLogFetchLatencyMs() {
        return this.localLogFetchLatencyMs.orElseThrow(() -> new UnsupportedOperationException("Local log fetch latency is not enabled"));
    }

    public Histogram tierLogFetchLatencyMs() {
        return this.tierLogFetchLatencyMs.orElseThrow(() -> new UnsupportedOperationException("Tier log fetch latency is not enabled"));
    }

    public Histogram logFetchDataSizeInBytes() {
        return this.logFetchDataSizeInBytes.orElseThrow(() -> new UnsupportedOperationException("Log fetch data size metric is not enabled"));
    }

    public Meter logFetchRate() {
        return this.metricTypeMap.get(LOG_FETCH_PER_SEC).meter();
    }

    public Optional<Meter> segmentReadRate() {
        if (this.tags.isEmpty()) {
            return Optional.of(this.metricTypeMap.get(SEGMENT_READS_PER_SEC).meter());
        }
        return Optional.empty();
    }

    public Optional<Meter> segmentSpeculativePrefetchRate() {
        if (this.tags.isEmpty()) {
            return Optional.of(this.metricTypeMap.get(SEGMENT_SPECULATIVE_PREFETCHES_PER_SEC).meter());
        }
        return Optional.empty();
    }

    public void recordLogFetch(Long localFetchTimeNanos, Long tierFetchTimeNanos) {
        this.logFetchRate().mark();
        this.localLogFetchLatencyMs().update(TimeUnit.NANOSECONDS.toMillis(localFetchTimeNanos));
        if (tierFetchTimeNanos > 0L) {
            this.tierLogFetchLatencyMs().update(TimeUnit.NANOSECONDS.toMillis(tierFetchTimeNanos));
        }
    }

    public Meter produceMessageConversionsRate() {
        return this.metricTypeMap.get(PRODUCE_MESSAGE_CONVERSIONS_PER_SEC).meter();
    }

    public Meter spuriousOffsetOutOfRangeExceptionRate() {
        return this.metricTypeMap.get(SPURIOUS_OFFSET_OUT_OF_RANGE_EXCEPTION_PER_SEC).meter();
    }

    public Meter noKeyCompactedTopicRecordsPerSec() {
        return this.metricTypeMap.get(NO_KEY_COMPACTED_TOPIC_RECORDS_PER_SEC).meter();
    }

    public Meter invalidMagicNumberRecordsPerSec() {
        return this.metricTypeMap.get(INVALID_MAGIC_NUMBER_RECORDS_PER_SEC).meter();
    }

    public Meter invalidMessageCrcRecordsPerSec() {
        return this.metricTypeMap.get(INVALID_MESSAGE_CRC_RECORDS_PER_SEC).meter();
    }

    public Meter invalidOffsetOrSequenceRecordsPerSec() {
        return this.metricTypeMap.get(INVALID_OFFSET_OR_SEQUENCE_RECORDS_PER_SEC).meter();
    }

    public GaugeWrapper remoteCopyLagBytesAggrMetric() {
        return this.metricGaugeTypeMap.get(RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName());
    }

    public long remoteCopyLagBytes() {
        return this.remoteCopyLagBytesAggrMetric().value();
    }

    public GaugeWrapper remoteCopyLagSegmentsAggrMetric() {
        return this.metricGaugeTypeMap.get(RemoteStorageMetrics.REMOTE_COPY_LAG_SEGMENTS_METRIC.getName());
    }

    public long remoteCopyLagSegments() {
        return this.remoteCopyLagSegmentsAggrMetric().value();
    }

    public GaugeWrapper remoteLogMetadataCountAggrMetric() {
        return this.metricGaugeTypeMap.get(RemoteStorageMetrics.REMOTE_LOG_METADATA_COUNT_METRIC.getName());
    }

    public long remoteLogMetadataCount() {
        return this.remoteLogMetadataCountAggrMetric().value();
    }

    public GaugeWrapper remoteLogSizeBytesAggrMetric() {
        return this.metricGaugeTypeMap.get(RemoteStorageMetrics.REMOTE_LOG_SIZE_BYTES_METRIC.getName());
    }

    public long remoteLogSizeBytes() {
        return this.remoteLogSizeBytesAggrMetric().value();
    }

    public GaugeWrapper remoteLogSizeComputationTimeAggrMetric() {
        return this.metricGaugeTypeMap.get(RemoteStorageMetrics.REMOTE_LOG_SIZE_COMPUTATION_TIME_METRIC.getName());
    }

    public long remoteLogSizeComputationTime() {
        return this.remoteLogSizeComputationTimeAggrMetric().value();
    }

    public GaugeWrapper remoteDeleteLagBytesAggrMetric() {
        return this.metricGaugeTypeMap.get(RemoteStorageMetrics.REMOTE_DELETE_LAG_BYTES_METRIC.getName());
    }

    public long remoteDeleteLagBytes() {
        return this.remoteDeleteLagBytesAggrMetric().value();
    }

    public GaugeWrapper remoteDeleteLagSegmentsAggrMetric() {
        return this.metricGaugeTypeMap.get(RemoteStorageMetrics.REMOTE_DELETE_LAG_SEGMENTS_METRIC.getName());
    }

    public long remoteDeleteLagSegments() {
        return this.remoteDeleteLagSegmentsAggrMetric().value();
    }

    public Meter remoteCopyBytesRate() {
        return this.metricTypeMap.get(RemoteStorageMetrics.REMOTE_COPY_BYTES_PER_SEC_METRIC.getName()).meter();
    }

    public Meter remoteFetchBytesRate() {
        return this.metricTypeMap.get(RemoteStorageMetrics.REMOTE_FETCH_BYTES_PER_SEC_METRIC.getName()).meter();
    }

    public Meter remoteFetchRequestRate() {
        return this.metricTypeMap.get(RemoteStorageMetrics.REMOTE_FETCH_REQUESTS_PER_SEC_METRIC.getName()).meter();
    }

    public Meter remoteCopyRequestRate() {
        return this.metricTypeMap.get(RemoteStorageMetrics.REMOTE_COPY_REQUESTS_PER_SEC_METRIC.getName()).meter();
    }

    public Meter remoteDeleteRequestRate() {
        return this.metricTypeMap.get(RemoteStorageMetrics.REMOTE_DELETE_REQUESTS_PER_SEC_METRIC.getName()).meter();
    }

    public Meter buildRemoteLogAuxStateRequestRate() {
        return this.metricTypeMap.get(RemoteStorageMetrics.BUILD_REMOTE_LOG_AUX_STATE_REQUESTS_PER_SEC_METRIC.getName()).meter();
    }

    public Meter failedRemoteFetchRequestRate() {
        return this.metricTypeMap.get(RemoteStorageMetrics.FAILED_REMOTE_FETCH_PER_SEC_METRIC.getName()).meter();
    }

    public Meter failedRemoteCopyRequestRate() {
        return this.metricTypeMap.get(RemoteStorageMetrics.FAILED_REMOTE_COPY_PER_SEC_METRIC.getName()).meter();
    }

    public Meter nonIncreasingOffsetRecordsPerSec() {
        return this.metricTypeMap.get(NON_INCREASING_OFFSET_RECORDS_PER_SEC).meter();
    }

    public Optional<Meter> pastMessagesWithTimeDiffMoreThanOneHourPerSec() {
        if (this.tags.isEmpty()) {
            return Optional.of(this.metricTypeMap.get(PAST_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_HOUR_PER_SEC).meter());
        }
        return Optional.empty();
    }

    public Optional<Meter> pastMessagesWithTimeDiffMoreThanOneDayPerSec() {
        if (this.tags.isEmpty()) {
            return Optional.of(this.metricTypeMap.get(PAST_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_DAY_PER_SEC).meter());
        }
        return Optional.empty();
    }

    public Optional<Meter> pastMessagesWithTimeDiffMoreThanOneYearPerSec() {
        if (this.tags.isEmpty()) {
            return Optional.of(this.metricTypeMap.get(PAST_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_YEAR_PER_SEC).meter());
        }
        return Optional.empty();
    }

    public Optional<Meter> futureMessagesWithTimeDiffMoreThanOneHourPerSec() {
        if (this.tags.isEmpty()) {
            return Optional.of(this.metricTypeMap.get(FUTURE_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_HOUR_PER_SEC).meter());
        }
        return Optional.empty();
    }

    public Optional<Meter> futureMessagesWithTimeDiffMoreThanOneDayPerSec() {
        if (this.tags.isEmpty()) {
            return Optional.of(this.metricTypeMap.get(FUTURE_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_DAY_PER_SEC).meter());
        }
        return Optional.empty();
    }

    public Optional<Meter> futureMessagesWithTimeDiffMoreThanOneYearPerSec() {
        if (this.tags.isEmpty()) {
            return Optional.of(this.metricTypeMap.get(FUTURE_MESSAGES_WITH_TIME_DIFF_MORE_THAN_ONE_YEAR_PER_SEC).meter());
        }
        return Optional.empty();
    }

    public Optional<Meter> getCompressionTypeMeter(CompressionType compressionType) {
        if (this.isMetricAtAllTopicsLevelAndCCloudOnly().booleanValue()) {
            return Optional.of(this.compressionTypeMetricsMap.get(compressionType).meter());
        }
        return Optional.empty();
    }

    public Meter failedRemoteDeleteRequestRate() {
        return this.metricTypeMap.get(RemoteStorageMetrics.FAILED_REMOTE_DELETE_PER_SEC_METRIC.getName()).meter();
    }

    public Meter failedBuildRemoteLogAuxStateRate() {
        return this.metricTypeMap.get(RemoteStorageMetrics.FAILED_BUILD_REMOTE_LOG_AUX_STATE_PER_SEC_METRIC.getName()).meter();
    }

    private Boolean isMetricAtAllTopicsLevelAndCCloudOnly() {
        return !this.name.isPresent() && this.isConfluentCloudOnlyMetric;
    }

    public class GaugeWrapper {
        private final ConcurrentHashMap<String, Long> metricValues = new ConcurrentHashMap();
        private final String metricType;

        public GaugeWrapper(String metricType) {
            this.metricType = metricType;
            this.newGaugeIfNeed();
        }

        public void setValue(String key, long value) {
            this.newGaugeIfNeed();
            this.metricValues.put(key, value);
        }

        public void removeKey(String key) {
            this.newGaugeIfNeed();
            this.metricValues.remove(key);
        }

        public void close() {
            BrokerTopicMetrics.this.metricsGroup.removeMetric(this.metricType, BrokerTopicMetrics.this.tags);
            this.metricValues.clear();
        }

        public long value() {
            return this.metricValues.values().stream().mapToLong(v -> v).sum();
        }

        private void newGaugeIfNeed() {
            BrokerTopicMetrics.this.metricsGroup.newGauge(this.metricType, () -> this.metricValues.values().stream().mapToLong(v -> v).sum(), BrokerTopicMetrics.this.tags);
        }
    }

    private class MeterWrapper {
        private final String metricType;
        private final String eventType;
        private volatile Meter lazyMeter;
        private final Lock meterLock = new ReentrantLock();
        private final Map<String, String> customTags;

        public MeterWrapper(String metricType, String eventType) {
            this(metricType, eventType, null);
        }

        public MeterWrapper(String metricType, String eventType, Map<String, String> customTags) {
            this.metricType = metricType;
            this.eventType = eventType;
            this.customTags = customTags == null ? BrokerTopicMetrics.this.tags : customTags;
            if (BrokerTopicMetrics.this.tags.isEmpty()) {
                this.meter();
            }
        }

        public Meter meter() {
            Meter meter = this.lazyMeter;
            if (meter == null) {
                this.meterLock.lock();
                try {
                    meter = this.lazyMeter;
                    if (meter == null) {
                        this.lazyMeter = meter = BrokerTopicMetrics.this.metricsGroup.newMeter(this.metricType, this.eventType, TimeUnit.SECONDS, this.customTags);
                    }
                }
                finally {
                    this.meterLock.unlock();
                }
            }
            return meter;
        }

        public void close() {
            this.meterLock.lock();
            try {
                if (this.lazyMeter != null) {
                    BrokerTopicMetrics.this.metricsGroup.removeMetric(this.metricType, BrokerTopicMetrics.this.tags);
                    this.lazyMeter = null;
                }
            }
            finally {
                this.meterLock.unlock();
            }
        }
    }
}

