/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.kafka;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.util.JsonFormat;
import io.confluent.protobuf.events.auditlog.v2.AuditLog;
import io.confluent.protobuf.events.auditlog.v2.Result;
import io.confluent.protobuf.events.auditlog.v2.TypedCloudResourceRef;
import io.confluent.security.audit.AuditLogUtils;
import io.confluent.security.audit.kafka.AuditExtractorOptions;
import io.confluent.security.authorizer.ResourcePattern;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.message.DeleteGroupsRequestData;
import org.apache.kafka.common.message.DeleteGroupsRequestDataJsonConverter;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DeleteGroupsResponseDataJsonConverter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.server.audit.KafkaRequestEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteGroupsRequestAuditExtractor {
    private static final Logger log = LoggerFactory.getLogger(DeleteGroupsRequestAuditExtractor.class);

    public static List<AuditLog> extract(KafkaRequestEvent requestEvent, AuditExtractorOptions extractorOptions) throws Exception {
        ArrayList<AuditLog> extractedAuditLogs = new ArrayList<AuditLog>();
        DeleteGroupsRequestData deleteGroupsRequestData = DeleteGroupsRequestDataJsonConverter.read((JsonNode)requestEvent.requestPayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        DeleteGroupsResponseData deleteGroupsResponseData = DeleteGroupsResponseDataJsonConverter.read((JsonNode)requestEvent.responsePayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        for (String groupName : deleteGroupsRequestData.groupsNames()) {
            DeleteGroupsResponseData.DeletableGroupResult deletableGroupResult = deleteGroupsResponseData.results().find(groupName);
            boolean hasAuthorizationFailure = AuditLogUtils.hasAuthorizationFailure(deletableGroupResult.errorCode());
            Struct requestData = DeleteGroupsRequestAuditExtractor.requestData(groupName);
            Result.Status status = DeleteGroupsRequestAuditExtractor.status(deletableGroupResult);
            Struct resultData = DeleteGroupsRequestAuditExtractor.resultData(deletableGroupResult);
            List<TypedCloudResourceRef> typedCloudResourceRefList = DeleteGroupsRequestAuditExtractor.typedCloudResourceRefList(requestEvent, groupName);
            ResourcePattern resourcePattern = new ResourcePattern("Group", groupName, PatternType.LITERAL);
            String resourceCrn = AuditLogUtils.requestResourceCrn(extractorOptions.crnAuthority(), requestEvent, resourcePattern);
            AuditLog auditLog = AuditLogUtils.auditLog(requestEvent, extractorOptions, hasAuthorizationFailure, false, requestData, status, resultData, typedCloudResourceRefList, resourceCrn);
            extractedAuditLogs.add(auditLog);
        }
        return extractedAuditLogs;
    }

    private static List<TypedCloudResourceRef> typedCloudResourceRefList(KafkaRequestEvent requestEvent, String groupName) {
        List<TypedCloudResourceRef> typedCloudResourceRefList = AuditLogUtils.typedCloudResourceRefList(requestEvent);
        typedCloudResourceRefList.add(TypedCloudResourceRef.newBuilder().setType(TypedCloudResourceRef.ResourceType.GROUP).setResourceId(groupName).build());
        return typedCloudResourceRefList;
    }

    private static Struct requestData(String groupName) throws Exception {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = new ObjectNode(JsonNodeFactory.instance);
        jsonNode.set("groupName", (JsonNode)new TextNode(groupName));
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }

    private static Result.Status status(DeleteGroupsResponseData.DeletableGroupResult deletableGroupResult) {
        if (deletableGroupResult.errorCode() == Errors.NONE.code()) {
            return Result.Status.SUCCESS;
        }
        return Result.Status.FAILURE;
    }

    private static Struct resultData(DeleteGroupsResponseData.DeletableGroupResult deletableGroupResult) throws InvalidProtocolBufferException {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = new ObjectNode(JsonNodeFactory.instance);
        jsonNode.set("message", (JsonNode)new TextNode(""));
        jsonNode.set("errorCode", (JsonNode)new ShortNode(deletableGroupResult.errorCode()));
        jsonNode.set("errorType", (JsonNode)new TextNode(Errors.forCode((short)deletableGroupResult.errorCode()).name()));
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }
}

